/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@splidejs/react-splide/dist/js/react-splide.esm.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@splidejs/react-splide/dist/js/react-splide.esm.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Splide: () => (/* binding */ Splide2),
/* harmony export */   SplideSlide: () => (/* binding */ SplideSlide),
/* harmony export */   SplideTrack: () => (/* binding */ SplideTrack)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// node_modules/@splidejs/splide/dist/js/splide.esm.js
function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", { writable: false });
  return Constructor;
}
var MEDIA_PREFERS_REDUCED_MOTION = "(prefers-reduced-motion: reduce)";
var CREATED = 1;
var MOUNTED = 2;
var IDLE = 3;
var MOVING = 4;
var SCROLLING = 5;
var DRAGGING = 6;
var DESTROYED = 7;
var STATES = {
  CREATED,
  MOUNTED,
  IDLE,
  MOVING,
  SCROLLING,
  DRAGGING,
  DESTROYED
};
function empty(array) {
  array.length = 0;
}
function slice(arrayLike, start, end) {
  return Array.prototype.slice.call(arrayLike, start, end);
}
function apply(func) {
  return func.bind.apply(func, [null].concat(slice(arguments, 1)));
}
var nextTick = setTimeout;
var noop = function noop2() {
};
function raf(func) {
  return requestAnimationFrame(func);
}
function typeOf(type, subject) {
  return typeof subject === type;
}
function isObject(subject) {
  return !isNull(subject) && typeOf("object", subject);
}
var isArray = Array.isArray;
var isFunction = apply(typeOf, "function");
var isString = apply(typeOf, "string");
var isUndefined = apply(typeOf, "undefined");
function isNull(subject) {
  return subject === null;
}
function isHTMLElement(subject) {
  try {
    return subject instanceof (subject.ownerDocument.defaultView || window).HTMLElement;
  } catch (e) {
    return false;
  }
}
function toArray(value) {
  return isArray(value) ? value : [value];
}
function forEach(values, iteratee) {
  toArray(values).forEach(iteratee);
}
function includes(array, value) {
  return array.indexOf(value) > -1;
}
function push(array, items) {
  array.push.apply(array, toArray(items));
  return array;
}
function toggleClass(elm, classes, add) {
  if (elm) {
    forEach(classes, function(name) {
      if (name) {
        elm.classList[add ? "add" : "remove"](name);
      }
    });
  }
}
function addClass(elm, classes) {
  toggleClass(elm, isString(classes) ? classes.split(" ") : classes, true);
}
function append(parent, children2) {
  forEach(children2, parent.appendChild.bind(parent));
}
function before(nodes, ref) {
  forEach(nodes, function(node) {
    var parent = (ref || node).parentNode;
    if (parent) {
      parent.insertBefore(node, ref);
    }
  });
}
function matches(elm, selector) {
  return isHTMLElement(elm) && (elm["msMatchesSelector"] || elm.matches).call(elm, selector);
}
function children(parent, selector) {
  var children2 = parent ? slice(parent.children) : [];
  return selector ? children2.filter(function(child2) {
    return matches(child2, selector);
  }) : children2;
}
function child(parent, selector) {
  return selector ? children(parent, selector)[0] : parent.firstElementChild;
}
var ownKeys = Object.keys;
function forOwn(object, iteratee, right) {
  if (object) {
    (right ? ownKeys(object).reverse() : ownKeys(object)).forEach(function(key) {
      key !== "__proto__" && iteratee(object[key], key);
    });
  }
  return object;
}
function assign(object) {
  slice(arguments, 1).forEach(function(source) {
    forOwn(source, function(value, key) {
      object[key] = source[key];
    });
  });
  return object;
}
function merge(object) {
  slice(arguments, 1).forEach(function(source) {
    forOwn(source, function(value, key) {
      if (isArray(value)) {
        object[key] = value.slice();
      } else if (isObject(value)) {
        object[key] = merge({}, isObject(object[key]) ? object[key] : {}, value);
      } else {
        object[key] = value;
      }
    });
  });
  return object;
}
function omit(object, keys) {
  forEach(keys || ownKeys(object), function(key) {
    delete object[key];
  });
}
function removeAttribute(elms, attrs) {
  forEach(elms, function(elm) {
    forEach(attrs, function(attr) {
      elm && elm.removeAttribute(attr);
    });
  });
}
function setAttribute(elms, attrs, value) {
  if (isObject(attrs)) {
    forOwn(attrs, function(value2, name) {
      setAttribute(elms, name, value2);
    });
  } else {
    forEach(elms, function(elm) {
      isNull(value) || value === "" ? removeAttribute(elm, attrs) : elm.setAttribute(attrs, String(value));
    });
  }
}
function create(tag, attrs, parent) {
  var elm = document.createElement(tag);
  if (attrs) {
    isString(attrs) ? addClass(elm, attrs) : setAttribute(elm, attrs);
  }
  parent && append(parent, elm);
  return elm;
}
function style(elm, prop, value) {
  if (isUndefined(value)) {
    return getComputedStyle(elm)[prop];
  }
  if (!isNull(value)) {
    elm.style[prop] = "" + value;
  }
}
function display(elm, display2) {
  style(elm, "display", display2);
}
function focus(elm) {
  elm["setActive"] && elm["setActive"]() || elm.focus({
    preventScroll: true
  });
}
function getAttribute(elm, attr) {
  return elm.getAttribute(attr);
}
function hasClass(elm, className) {
  return elm && elm.classList.contains(className);
}
function rect(target) {
  return target.getBoundingClientRect();
}
function remove(nodes) {
  forEach(nodes, function(node) {
    if (node && node.parentNode) {
      node.parentNode.removeChild(node);
    }
  });
}
function parseHtml(html) {
  return child(new DOMParser().parseFromString(html, "text/html").body);
}
function prevent(e, stopPropagation) {
  e.preventDefault();
  if (stopPropagation) {
    e.stopPropagation();
    e.stopImmediatePropagation();
  }
}
function query(parent, selector) {
  return parent && parent.querySelector(selector);
}
function queryAll(parent, selector) {
  return selector ? slice(parent.querySelectorAll(selector)) : [];
}
function removeClass(elm, classes) {
  toggleClass(elm, classes, false);
}
function timeOf(e) {
  return e.timeStamp;
}
function unit(value) {
  return isString(value) ? value : value ? value + "px" : "";
}
var PROJECT_CODE = "splide";
var DATA_ATTRIBUTE = "data-" + PROJECT_CODE;
function assert(condition, message) {
  if (!condition) {
    throw new Error("[" + PROJECT_CODE + "] " + (message || ""));
  }
}
var min = Math.min;
var max = Math.max;
var floor = Math.floor;
var ceil = Math.ceil;
var abs = Math.abs;
function approximatelyEqual(x, y, epsilon) {
  return abs(x - y) < epsilon;
}
function between(number, x, y, exclusive) {
  var minimum = min(x, y);
  var maximum = max(x, y);
  return exclusive ? minimum < number && number < maximum : minimum <= number && number <= maximum;
}
function clamp(number, x, y) {
  var minimum = min(x, y);
  var maximum = max(x, y);
  return min(max(minimum, number), maximum);
}
function sign(x) {
  return +(x > 0) - +(x < 0);
}
function format(string, replacements) {
  forEach(replacements, function(replacement) {
    string = string.replace("%s", "" + replacement);
  });
  return string;
}
function pad(number) {
  return number < 10 ? "0" + number : "" + number;
}
var ids = {};
function uniqueId(prefix) {
  return "" + prefix + pad(ids[prefix] = (ids[prefix] || 0) + 1);
}
function EventBinder() {
  var listeners = [];
  function bind(targets, events, callback, options) {
    forEachEvent(targets, events, function(target, event, namespace) {
      var isEventTarget = "addEventListener" in target;
      var remover = isEventTarget ? target.removeEventListener.bind(target, event, callback, options) : target["removeListener"].bind(target, callback);
      isEventTarget ? target.addEventListener(event, callback, options) : target["addListener"](callback);
      listeners.push([target, event, namespace, callback, remover]);
    });
  }
  function unbind(targets, events, callback) {
    forEachEvent(targets, events, function(target, event, namespace) {
      listeners = listeners.filter(function(listener) {
        if (listener[0] === target && listener[1] === event && listener[2] === namespace && (!callback || listener[3] === callback)) {
          listener[4]();
          return false;
        }
        return true;
      });
    });
  }
  function dispatch(target, type, detail) {
    var e;
    var bubbles = true;
    if (typeof CustomEvent === "function") {
      e = new CustomEvent(type, {
        bubbles,
        detail
      });
    } else {
      e = document.createEvent("CustomEvent");
      e.initCustomEvent(type, bubbles, false, detail);
    }
    target.dispatchEvent(e);
    return e;
  }
  function forEachEvent(targets, events, iteratee) {
    forEach(targets, function(target) {
      target && forEach(events, function(events2) {
        events2.split(" ").forEach(function(eventNS) {
          var fragment = eventNS.split(".");
          iteratee(target, fragment[0], fragment[1]);
        });
      });
    });
  }
  function destroy() {
    listeners.forEach(function(data) {
      data[4]();
    });
    empty(listeners);
  }
  return {
    bind,
    unbind,
    dispatch,
    destroy
  };
}
var EVENT_MOUNTED = "mounted";
var EVENT_READY = "ready";
var EVENT_MOVE = "move";
var EVENT_MOVED = "moved";
var EVENT_CLICK = "click";
var EVENT_ACTIVE = "active";
var EVENT_INACTIVE = "inactive";
var EVENT_VISIBLE = "visible";
var EVENT_HIDDEN = "hidden";
var EVENT_REFRESH = "refresh";
var EVENT_UPDATED = "updated";
var EVENT_RESIZE = "resize";
var EVENT_RESIZED = "resized";
var EVENT_DRAG = "drag";
var EVENT_DRAGGING = "dragging";
var EVENT_DRAGGED = "dragged";
var EVENT_SCROLL = "scroll";
var EVENT_SCROLLED = "scrolled";
var EVENT_OVERFLOW = "overflow";
var EVENT_DESTROY = "destroy";
var EVENT_ARROWS_MOUNTED = "arrows:mounted";
var EVENT_ARROWS_UPDATED = "arrows:updated";
var EVENT_PAGINATION_MOUNTED = "pagination:mounted";
var EVENT_PAGINATION_UPDATED = "pagination:updated";
var EVENT_NAVIGATION_MOUNTED = "navigation:mounted";
var EVENT_AUTOPLAY_PLAY = "autoplay:play";
var EVENT_AUTOPLAY_PLAYING = "autoplay:playing";
var EVENT_AUTOPLAY_PAUSE = "autoplay:pause";
var EVENT_LAZYLOAD_LOADED = "lazyload:loaded";
var EVENT_SLIDE_KEYDOWN = "sk";
var EVENT_SHIFTED = "sh";
var EVENT_END_INDEX_CHANGED = "ei";
function EventInterface(Splide22) {
  var bus = Splide22 ? Splide22.event.bus : document.createDocumentFragment();
  var binder = EventBinder();
  function on(events, callback) {
    binder.bind(bus, toArray(events).join(" "), function(e) {
      callback.apply(callback, isArray(e.detail) ? e.detail : []);
    });
  }
  function emit(event) {
    binder.dispatch(bus, event, slice(arguments, 1));
  }
  if (Splide22) {
    Splide22.event.on(EVENT_DESTROY, binder.destroy);
  }
  return assign(binder, {
    bus,
    on,
    off: apply(binder.unbind, bus),
    emit
  });
}
function RequestInterval(interval, onInterval, onUpdate, limit) {
  var now = Date.now;
  var startTime;
  var rate = 0;
  var id;
  var paused = true;
  var count = 0;
  function update() {
    if (!paused) {
      rate = interval ? min((now() - startTime) / interval, 1) : 1;
      onUpdate && onUpdate(rate);
      if (rate >= 1) {
        onInterval();
        startTime = now();
        if (limit && ++count >= limit) {
          return pause();
        }
      }
      id = raf(update);
    }
  }
  function start(resume) {
    resume || cancel();
    startTime = now() - (resume ? rate * interval : 0);
    paused = false;
    id = raf(update);
  }
  function pause() {
    paused = true;
  }
  function rewind() {
    startTime = now();
    rate = 0;
    if (onUpdate) {
      onUpdate(rate);
    }
  }
  function cancel() {
    id && cancelAnimationFrame(id);
    rate = 0;
    id = 0;
    paused = true;
  }
  function set(time) {
    interval = time;
  }
  function isPaused() {
    return paused;
  }
  return {
    start,
    rewind,
    pause,
    cancel,
    set,
    isPaused
  };
}
function State(initialState) {
  var state = initialState;
  function set(value) {
    state = value;
  }
  function is(states) {
    return includes(toArray(states), state);
  }
  return {
    set,
    is
  };
}
function Throttle(func, duration) {
  var interval = RequestInterval(duration || 0, func, null, 1);
  return function() {
    interval.isPaused() && interval.start();
  };
}
function Media(Splide22, Components2, options) {
  var state = Splide22.state;
  var breakpoints = options.breakpoints || {};
  var reducedMotion = options.reducedMotion || {};
  var binder = EventBinder();
  var queries = [];
  function setup() {
    var isMin = options.mediaQuery === "min";
    ownKeys(breakpoints).sort(function(n, m) {
      return isMin ? +n - +m : +m - +n;
    }).forEach(function(key) {
      register(breakpoints[key], "(" + (isMin ? "min" : "max") + "-width:" + key + "px)");
    });
    register(reducedMotion, MEDIA_PREFERS_REDUCED_MOTION);
    update();
  }
  function destroy(completely) {
    if (completely) {
      binder.destroy();
    }
  }
  function register(options2, query2) {
    var queryList = matchMedia(query2);
    binder.bind(queryList, "change", update);
    queries.push([options2, queryList]);
  }
  function update() {
    var destroyed = state.is(DESTROYED);
    var direction = options.direction;
    var merged = queries.reduce(function(merged2, entry) {
      return merge(merged2, entry[1].matches ? entry[0] : {});
    }, {});
    omit(options);
    set(merged);
    if (options.destroy) {
      Splide22.destroy(options.destroy === "completely");
    } else if (destroyed) {
      destroy(true);
      Splide22.mount();
    } else {
      direction !== options.direction && Splide22.refresh();
    }
  }
  function reduce(enable) {
    if (matchMedia(MEDIA_PREFERS_REDUCED_MOTION).matches) {
      enable ? merge(options, reducedMotion) : omit(options, ownKeys(reducedMotion));
    }
  }
  function set(opts, base, notify) {
    merge(options, opts);
    base && merge(Object.getPrototypeOf(options), opts);
    if (notify || !state.is(CREATED)) {
      Splide22.emit(EVENT_UPDATED, options);
    }
  }
  return {
    setup,
    destroy,
    reduce,
    set
  };
}
var ARROW = "Arrow";
var ARROW_LEFT = ARROW + "Left";
var ARROW_RIGHT = ARROW + "Right";
var ARROW_UP = ARROW + "Up";
var ARROW_DOWN = ARROW + "Down";
var RTL = "rtl";
var TTB = "ttb";
var ORIENTATION_MAP = {
  width: ["height"],
  left: ["top", "right"],
  right: ["bottom", "left"],
  x: ["y"],
  X: ["Y"],
  Y: ["X"],
  ArrowLeft: [ARROW_UP, ARROW_RIGHT],
  ArrowRight: [ARROW_DOWN, ARROW_LEFT]
};
function Direction(Splide22, Components2, options) {
  function resolve(prop, axisOnly, direction) {
    direction = direction || options.direction;
    var index = direction === RTL && !axisOnly ? 1 : direction === TTB ? 0 : -1;
    return ORIENTATION_MAP[prop] && ORIENTATION_MAP[prop][index] || prop.replace(/width|left|right/i, function(match, offset) {
      var replacement = ORIENTATION_MAP[match.toLowerCase()][index] || match;
      return offset > 0 ? replacement.charAt(0).toUpperCase() + replacement.slice(1) : replacement;
    });
  }
  function orient(value) {
    return value * (options.direction === RTL ? 1 : -1);
  }
  return {
    resolve,
    orient
  };
}
var ROLE = "role";
var TAB_INDEX = "tabindex";
var DISABLED = "disabled";
var ARIA_PREFIX = "aria-";
var ARIA_CONTROLS = ARIA_PREFIX + "controls";
var ARIA_CURRENT = ARIA_PREFIX + "current";
var ARIA_SELECTED = ARIA_PREFIX + "selected";
var ARIA_LABEL = ARIA_PREFIX + "label";
var ARIA_LABELLEDBY = ARIA_PREFIX + "labelledby";
var ARIA_HIDDEN = ARIA_PREFIX + "hidden";
var ARIA_ORIENTATION = ARIA_PREFIX + "orientation";
var ARIA_ROLEDESCRIPTION = ARIA_PREFIX + "roledescription";
var ARIA_LIVE = ARIA_PREFIX + "live";
var ARIA_BUSY = ARIA_PREFIX + "busy";
var ARIA_ATOMIC = ARIA_PREFIX + "atomic";
var ALL_ATTRIBUTES = [ROLE, TAB_INDEX, DISABLED, ARIA_CONTROLS, ARIA_CURRENT, ARIA_LABEL, ARIA_LABELLEDBY, ARIA_HIDDEN, ARIA_ORIENTATION, ARIA_ROLEDESCRIPTION];
var CLASS_PREFIX = PROJECT_CODE + "__";
var STATUS_CLASS_PREFIX = "is-";
var CLASS_ROOT = PROJECT_CODE;
var CLASS_TRACK = CLASS_PREFIX + "track";
var CLASS_LIST = CLASS_PREFIX + "list";
var CLASS_SLIDE = CLASS_PREFIX + "slide";
var CLASS_CLONE = CLASS_SLIDE + "--clone";
var CLASS_CONTAINER = CLASS_SLIDE + "__container";
var CLASS_ARROWS = CLASS_PREFIX + "arrows";
var CLASS_ARROW = CLASS_PREFIX + "arrow";
var CLASS_ARROW_PREV = CLASS_ARROW + "--prev";
var CLASS_ARROW_NEXT = CLASS_ARROW + "--next";
var CLASS_PAGINATION = CLASS_PREFIX + "pagination";
var CLASS_PAGINATION_PAGE = CLASS_PAGINATION + "__page";
var CLASS_PROGRESS = CLASS_PREFIX + "progress";
var CLASS_PROGRESS_BAR = CLASS_PROGRESS + "__bar";
var CLASS_TOGGLE = CLASS_PREFIX + "toggle";
var CLASS_TOGGLE_PLAY = CLASS_TOGGLE + "__play";
var CLASS_TOGGLE_PAUSE = CLASS_TOGGLE + "__pause";
var CLASS_SPINNER = CLASS_PREFIX + "spinner";
var CLASS_SR = CLASS_PREFIX + "sr";
var CLASS_INITIALIZED = STATUS_CLASS_PREFIX + "initialized";
var CLASS_ACTIVE = STATUS_CLASS_PREFIX + "active";
var CLASS_PREV = STATUS_CLASS_PREFIX + "prev";
var CLASS_NEXT = STATUS_CLASS_PREFIX + "next";
var CLASS_VISIBLE = STATUS_CLASS_PREFIX + "visible";
var CLASS_LOADING = STATUS_CLASS_PREFIX + "loading";
var CLASS_FOCUS_IN = STATUS_CLASS_PREFIX + "focus-in";
var CLASS_OVERFLOW = STATUS_CLASS_PREFIX + "overflow";
var STATUS_CLASSES = [CLASS_ACTIVE, CLASS_VISIBLE, CLASS_PREV, CLASS_NEXT, CLASS_LOADING, CLASS_FOCUS_IN, CLASS_OVERFLOW];
var CLASSES = {
  slide: CLASS_SLIDE,
  clone: CLASS_CLONE,
  arrows: CLASS_ARROWS,
  arrow: CLASS_ARROW,
  prev: CLASS_ARROW_PREV,
  next: CLASS_ARROW_NEXT,
  pagination: CLASS_PAGINATION,
  page: CLASS_PAGINATION_PAGE,
  spinner: CLASS_SPINNER
};
function closest(from, selector) {
  if (isFunction(from.closest)) {
    return from.closest(selector);
  }
  var elm = from;
  while (elm && elm.nodeType === 1) {
    if (matches(elm, selector)) {
      break;
    }
    elm = elm.parentElement;
  }
  return elm;
}
var FRICTION = 5;
var LOG_INTERVAL = 200;
var POINTER_DOWN_EVENTS = "touchstart mousedown";
var POINTER_MOVE_EVENTS = "touchmove mousemove";
var POINTER_UP_EVENTS = "touchend touchcancel mouseup click";
function Elements(Splide22, Components2, options) {
  var _EventInterface = EventInterface(Splide22), on = _EventInterface.on, bind = _EventInterface.bind;
  var root = Splide22.root;
  var i18n = options.i18n;
  var elements = {};
  var slides = [];
  var rootClasses = [];
  var trackClasses = [];
  var track;
  var list;
  var isUsingKey;
  function setup() {
    collect();
    init();
    update();
  }
  function mount() {
    on(EVENT_REFRESH, destroy);
    on(EVENT_REFRESH, setup);
    on(EVENT_UPDATED, update);
    bind(document, POINTER_DOWN_EVENTS + " keydown", function(e) {
      isUsingKey = e.type === "keydown";
    }, {
      capture: true
    });
    bind(root, "focusin", function() {
      toggleClass(root, CLASS_FOCUS_IN, !!isUsingKey);
    });
  }
  function destroy(completely) {
    var attrs = ALL_ATTRIBUTES.concat("style");
    empty(slides);
    removeClass(root, rootClasses);
    removeClass(track, trackClasses);
    removeAttribute([track, list], attrs);
    removeAttribute(root, completely ? attrs : ["style", ARIA_ROLEDESCRIPTION]);
  }
  function update() {
    removeClass(root, rootClasses);
    removeClass(track, trackClasses);
    rootClasses = getClasses(CLASS_ROOT);
    trackClasses = getClasses(CLASS_TRACK);
    addClass(root, rootClasses);
    addClass(track, trackClasses);
    setAttribute(root, ARIA_LABEL, options.label);
    setAttribute(root, ARIA_LABELLEDBY, options.labelledby);
  }
  function collect() {
    track = find("." + CLASS_TRACK);
    list = child(track, "." + CLASS_LIST);
    assert(track && list, "A track/list element is missing.");
    push(slides, children(list, "." + CLASS_SLIDE + ":not(." + CLASS_CLONE + ")"));
    forOwn({
      arrows: CLASS_ARROWS,
      pagination: CLASS_PAGINATION,
      prev: CLASS_ARROW_PREV,
      next: CLASS_ARROW_NEXT,
      bar: CLASS_PROGRESS_BAR,
      toggle: CLASS_TOGGLE
    }, function(className, key) {
      elements[key] = find("." + className);
    });
    assign(elements, {
      root,
      track,
      list,
      slides
    });
  }
  function init() {
    var id = root.id || uniqueId(PROJECT_CODE);
    var role = options.role;
    root.id = id;
    track.id = track.id || id + "-track";
    list.id = list.id || id + "-list";
    if (!getAttribute(root, ROLE) && root.tagName !== "SECTION" && role) {
      setAttribute(root, ROLE, role);
    }
    setAttribute(root, ARIA_ROLEDESCRIPTION, i18n.carousel);
    setAttribute(list, ROLE, "presentation");
  }
  function find(selector) {
    var elm = query(root, selector);
    return elm && closest(elm, "." + CLASS_ROOT) === root ? elm : void 0;
  }
  function getClasses(base) {
    return [base + "--" + options.type, base + "--" + options.direction, options.drag && base + "--draggable", options.isNavigation && base + "--nav", base === CLASS_ROOT && CLASS_ACTIVE];
  }
  return assign(elements, {
    setup,
    mount,
    destroy
  });
}
var SLIDE = "slide";
var LOOP = "loop";
var FADE = "fade";
function Slide$1(Splide22, index, slideIndex, slide) {
  var event = EventInterface(Splide22);
  var on = event.on, emit = event.emit, bind = event.bind;
  var Components = Splide22.Components, root = Splide22.root, options = Splide22.options;
  var isNavigation = options.isNavigation, updateOnMove = options.updateOnMove, i18n = options.i18n, pagination = options.pagination, slideFocus = options.slideFocus;
  var resolve = Components.Direction.resolve;
  var styles = getAttribute(slide, "style");
  var label = getAttribute(slide, ARIA_LABEL);
  var isClone = slideIndex > -1;
  var container = child(slide, "." + CLASS_CONTAINER);
  var destroyed;
  function mount() {
    if (!isClone) {
      slide.id = root.id + "-slide" + pad(index + 1);
      setAttribute(slide, ROLE, pagination ? "tabpanel" : "group");
      setAttribute(slide, ARIA_ROLEDESCRIPTION, i18n.slide);
      setAttribute(slide, ARIA_LABEL, label || format(i18n.slideLabel, [index + 1, Splide22.length]));
    }
    listen();
  }
  function listen() {
    bind(slide, "click", apply(emit, EVENT_CLICK, self));
    bind(slide, "keydown", apply(emit, EVENT_SLIDE_KEYDOWN, self));
    on([EVENT_MOVED, EVENT_SHIFTED, EVENT_SCROLLED], update);
    on(EVENT_NAVIGATION_MOUNTED, initNavigation);
    if (updateOnMove) {
      on(EVENT_MOVE, onMove);
    }
  }
  function destroy() {
    destroyed = true;
    event.destroy();
    removeClass(slide, STATUS_CLASSES);
    removeAttribute(slide, ALL_ATTRIBUTES);
    setAttribute(slide, "style", styles);
    setAttribute(slide, ARIA_LABEL, label || "");
  }
  function initNavigation() {
    var controls = Splide22.splides.map(function(target) {
      var Slide2 = target.splide.Components.Slides.getAt(index);
      return Slide2 ? Slide2.slide.id : "";
    }).join(" ");
    setAttribute(slide, ARIA_LABEL, format(i18n.slideX, (isClone ? slideIndex : index) + 1));
    setAttribute(slide, ARIA_CONTROLS, controls);
    setAttribute(slide, ROLE, slideFocus ? "button" : "");
    slideFocus && removeAttribute(slide, ARIA_ROLEDESCRIPTION);
  }
  function onMove() {
    if (!destroyed) {
      update();
    }
  }
  function update() {
    if (!destroyed) {
      var curr = Splide22.index;
      updateActivity();
      updateVisibility();
      toggleClass(slide, CLASS_PREV, index === curr - 1);
      toggleClass(slide, CLASS_NEXT, index === curr + 1);
    }
  }
  function updateActivity() {
    var active = isActive();
    if (active !== hasClass(slide, CLASS_ACTIVE)) {
      toggleClass(slide, CLASS_ACTIVE, active);
      setAttribute(slide, ARIA_CURRENT, isNavigation && active || "");
      emit(active ? EVENT_ACTIVE : EVENT_INACTIVE, self);
    }
  }
  function updateVisibility() {
    var visible = isVisible();
    var hidden = !visible && (!isActive() || isClone);
    if (!Splide22.state.is([MOVING, SCROLLING])) {
      setAttribute(slide, ARIA_HIDDEN, hidden || "");
    }
    setAttribute(queryAll(slide, options.focusableNodes || ""), TAB_INDEX, hidden ? -1 : "");
    if (slideFocus) {
      setAttribute(slide, TAB_INDEX, hidden ? -1 : 0);
    }
    if (visible !== hasClass(slide, CLASS_VISIBLE)) {
      toggleClass(slide, CLASS_VISIBLE, visible);
      emit(visible ? EVENT_VISIBLE : EVENT_HIDDEN, self);
    }
    if (!visible && document.activeElement === slide) {
      var Slide2 = Components.Slides.getAt(Splide22.index);
      Slide2 && focus(Slide2.slide);
    }
  }
  function style$1(prop, value, useContainer) {
    style(useContainer && container || slide, prop, value);
  }
  function isActive() {
    var curr = Splide22.index;
    return curr === index || options.cloneStatus && curr === slideIndex;
  }
  function isVisible() {
    if (Splide22.is(FADE)) {
      return isActive();
    }
    var trackRect = rect(Components.Elements.track);
    var slideRect = rect(slide);
    var left = resolve("left", true);
    var right = resolve("right", true);
    return floor(trackRect[left]) <= ceil(slideRect[left]) && floor(slideRect[right]) <= ceil(trackRect[right]);
  }
  function isWithin(from, distance) {
    var diff = abs(from - index);
    if (!isClone && (options.rewind || Splide22.is(LOOP))) {
      diff = min(diff, Splide22.length - diff);
    }
    return diff <= distance;
  }
  var self = {
    index,
    slideIndex,
    slide,
    container,
    isClone,
    mount,
    destroy,
    update,
    style: style$1,
    isWithin
  };
  return self;
}
function Slides(Splide22, Components2, options) {
  var _EventInterface2 = EventInterface(Splide22), on = _EventInterface2.on, emit = _EventInterface2.emit, bind = _EventInterface2.bind;
  var _Components2$Elements = Components2.Elements, slides = _Components2$Elements.slides, list = _Components2$Elements.list;
  var Slides2 = [];
  function mount() {
    init();
    on(EVENT_REFRESH, destroy);
    on(EVENT_REFRESH, init);
  }
  function init() {
    slides.forEach(function(slide, index) {
      register(slide, index, -1);
    });
  }
  function destroy() {
    forEach$1(function(Slide2) {
      Slide2.destroy();
    });
    empty(Slides2);
  }
  function update() {
    forEach$1(function(Slide2) {
      Slide2.update();
    });
  }
  function register(slide, index, slideIndex) {
    var object = Slide$1(Splide22, index, slideIndex, slide);
    object.mount();
    Slides2.push(object);
    Slides2.sort(function(Slide1, Slide2) {
      return Slide1.index - Slide2.index;
    });
  }
  function get(excludeClones) {
    return excludeClones ? filter(function(Slide2) {
      return !Slide2.isClone;
    }) : Slides2;
  }
  function getIn(page) {
    var Controller2 = Components2.Controller;
    var index = Controller2.toIndex(page);
    var max2 = Controller2.hasFocus() ? 1 : options.perPage;
    return filter(function(Slide2) {
      return between(Slide2.index, index, index + max2 - 1);
    });
  }
  function getAt(index) {
    return filter(index)[0];
  }
  function add(items, index) {
    forEach(items, function(slide) {
      if (isString(slide)) {
        slide = parseHtml(slide);
      }
      if (isHTMLElement(slide)) {
        var ref = slides[index];
        ref ? before(slide, ref) : append(list, slide);
        addClass(slide, options.classes.slide);
        observeImages(slide, apply(emit, EVENT_RESIZE));
      }
    });
    emit(EVENT_REFRESH);
  }
  function remove$1(matcher) {
    remove(filter(matcher).map(function(Slide2) {
      return Slide2.slide;
    }));
    emit(EVENT_REFRESH);
  }
  function forEach$1(iteratee, excludeClones) {
    get(excludeClones).forEach(iteratee);
  }
  function filter(matcher) {
    return Slides2.filter(isFunction(matcher) ? matcher : function(Slide2) {
      return isString(matcher) ? matches(Slide2.slide, matcher) : includes(toArray(matcher), Slide2.index);
    });
  }
  function style2(prop, value, useContainer) {
    forEach$1(function(Slide2) {
      Slide2.style(prop, value, useContainer);
    });
  }
  function observeImages(elm, callback) {
    var images = queryAll(elm, "img");
    var length = images.length;
    if (length) {
      images.forEach(function(img) {
        bind(img, "load error", function() {
          if (!--length) {
            callback();
          }
        });
      });
    } else {
      callback();
    }
  }
  function getLength(excludeClones) {
    return excludeClones ? slides.length : Slides2.length;
  }
  function isEnough() {
    return Slides2.length > options.perPage;
  }
  return {
    mount,
    destroy,
    update,
    register,
    get,
    getIn,
    getAt,
    add,
    remove: remove$1,
    forEach: forEach$1,
    filter,
    style: style2,
    getLength,
    isEnough
  };
}
function Layout(Splide22, Components2, options) {
  var _EventInterface3 = EventInterface(Splide22), on = _EventInterface3.on, bind = _EventInterface3.bind, emit = _EventInterface3.emit;
  var Slides2 = Components2.Slides;
  var resolve = Components2.Direction.resolve;
  var _Components2$Elements2 = Components2.Elements, root = _Components2$Elements2.root, track = _Components2$Elements2.track, list = _Components2$Elements2.list;
  var getAt = Slides2.getAt, styleSlides = Slides2.style;
  var vertical;
  var rootRect;
  var overflow;
  function mount() {
    init();
    bind(window, "resize load", Throttle(apply(emit, EVENT_RESIZE)));
    on([EVENT_UPDATED, EVENT_REFRESH], init);
    on(EVENT_RESIZE, resize);
  }
  function init() {
    vertical = options.direction === TTB;
    style(root, "maxWidth", unit(options.width));
    style(track, resolve("paddingLeft"), cssPadding(false));
    style(track, resolve("paddingRight"), cssPadding(true));
    resize(true);
  }
  function resize(force) {
    var newRect = rect(root);
    if (force || rootRect.width !== newRect.width || rootRect.height !== newRect.height) {
      style(track, "height", cssTrackHeight());
      styleSlides(resolve("marginRight"), unit(options.gap));
      styleSlides("width", cssSlideWidth());
      styleSlides("height", cssSlideHeight(), true);
      rootRect = newRect;
      emit(EVENT_RESIZED);
      if (overflow !== (overflow = isOverflow())) {
        toggleClass(root, CLASS_OVERFLOW, overflow);
        emit(EVENT_OVERFLOW, overflow);
      }
    }
  }
  function cssPadding(right) {
    var padding = options.padding;
    var prop = resolve(right ? "right" : "left");
    return padding && unit(padding[prop] || (isObject(padding) ? 0 : padding)) || "0px";
  }
  function cssTrackHeight() {
    var height = "";
    if (vertical) {
      height = cssHeight();
      assert(height, "height or heightRatio is missing.");
      height = "calc(" + height + " - " + cssPadding(false) + " - " + cssPadding(true) + ")";
    }
    return height;
  }
  function cssHeight() {
    return unit(options.height || rect(list).width * options.heightRatio);
  }
  function cssSlideWidth() {
    return options.autoWidth ? null : unit(options.fixedWidth) || (vertical ? "" : cssSlideSize());
  }
  function cssSlideHeight() {
    return unit(options.fixedHeight) || (vertical ? options.autoHeight ? null : cssSlideSize() : cssHeight());
  }
  function cssSlideSize() {
    var gap = unit(options.gap);
    return "calc((100%" + (gap && " + " + gap) + ")/" + (options.perPage || 1) + (gap && " - " + gap) + ")";
  }
  function listSize() {
    return rect(list)[resolve("width")];
  }
  function slideSize(index, withoutGap) {
    var Slide2 = getAt(index || 0);
    return Slide2 ? rect(Slide2.slide)[resolve("width")] + (withoutGap ? 0 : getGap()) : 0;
  }
  function totalSize(index, withoutGap) {
    var Slide2 = getAt(index);
    if (Slide2) {
      var right = rect(Slide2.slide)[resolve("right")];
      var left = rect(list)[resolve("left")];
      return abs(right - left) + (withoutGap ? 0 : getGap());
    }
    return 0;
  }
  function sliderSize(withoutGap) {
    return totalSize(Splide22.length - 1) - totalSize(0) + slideSize(0, withoutGap);
  }
  function getGap() {
    var Slide2 = getAt(0);
    return Slide2 && parseFloat(style(Slide2.slide, resolve("marginRight"))) || 0;
  }
  function getPadding(right) {
    return parseFloat(style(track, resolve("padding" + (right ? "Right" : "Left")))) || 0;
  }
  function isOverflow() {
    return Splide22.is(FADE) || sliderSize(true) > listSize();
  }
  return {
    mount,
    resize,
    listSize,
    slideSize,
    sliderSize,
    totalSize,
    getPadding,
    isOverflow
  };
}
var MULTIPLIER = 2;
function Clones(Splide22, Components2, options) {
  var event = EventInterface(Splide22);
  var on = event.on;
  var Elements2 = Components2.Elements, Slides2 = Components2.Slides;
  var resolve = Components2.Direction.resolve;
  var clones = [];
  var cloneCount;
  function mount() {
    on(EVENT_REFRESH, remount);
    on([EVENT_UPDATED, EVENT_RESIZE], observe);
    if (cloneCount = computeCloneCount()) {
      generate(cloneCount);
      Components2.Layout.resize(true);
    }
  }
  function remount() {
    destroy();
    mount();
  }
  function destroy() {
    remove(clones);
    empty(clones);
    event.destroy();
  }
  function observe() {
    var count = computeCloneCount();
    if (cloneCount !== count) {
      if (cloneCount < count || !count) {
        event.emit(EVENT_REFRESH);
      }
    }
  }
  function generate(count) {
    var slides = Slides2.get().slice();
    var length = slides.length;
    if (length) {
      while (slides.length < count) {
        push(slides, slides);
      }
      push(slides.slice(-count), slides.slice(0, count)).forEach(function(Slide2, index) {
        var isHead = index < count;
        var clone = cloneDeep(Slide2.slide, index);
        isHead ? before(clone, slides[0].slide) : append(Elements2.list, clone);
        push(clones, clone);
        Slides2.register(clone, index - count + (isHead ? 0 : length), Slide2.index);
      });
    }
  }
  function cloneDeep(elm, index) {
    var clone = elm.cloneNode(true);
    addClass(clone, options.classes.clone);
    clone.id = Splide22.root.id + "-clone" + pad(index + 1);
    return clone;
  }
  function computeCloneCount() {
    var clones2 = options.clones;
    if (!Splide22.is(LOOP)) {
      clones2 = 0;
    } else if (isUndefined(clones2)) {
      var fixedSize = options[resolve("fixedWidth")] && Components2.Layout.slideSize(0);
      var fixedCount = fixedSize && ceil(rect(Elements2.track)[resolve("width")] / fixedSize);
      clones2 = fixedCount || options[resolve("autoWidth")] && Splide22.length || options.perPage * MULTIPLIER;
    }
    return clones2;
  }
  return {
    mount,
    destroy
  };
}
function Move(Splide22, Components2, options) {
  var _EventInterface4 = EventInterface(Splide22), on = _EventInterface4.on, emit = _EventInterface4.emit;
  var set = Splide22.state.set;
  var _Components2$Layout = Components2.Layout, slideSize = _Components2$Layout.slideSize, getPadding = _Components2$Layout.getPadding, totalSize = _Components2$Layout.totalSize, listSize = _Components2$Layout.listSize, sliderSize = _Components2$Layout.sliderSize;
  var _Components2$Directio = Components2.Direction, resolve = _Components2$Directio.resolve, orient = _Components2$Directio.orient;
  var _Components2$Elements3 = Components2.Elements, list = _Components2$Elements3.list, track = _Components2$Elements3.track;
  var Transition;
  function mount() {
    Transition = Components2.Transition;
    on([EVENT_MOUNTED, EVENT_RESIZED, EVENT_UPDATED, EVENT_REFRESH], reposition);
  }
  function reposition() {
    if (!Components2.Controller.isBusy()) {
      Components2.Scroll.cancel();
      jump(Splide22.index);
      Components2.Slides.update();
    }
  }
  function move(dest, index, prev, callback) {
    if (dest !== index && canShift(dest > prev)) {
      cancel();
      translate(shift(getPosition(), dest > prev), true);
    }
    set(MOVING);
    emit(EVENT_MOVE, index, prev, dest);
    Transition.start(index, function() {
      set(IDLE);
      emit(EVENT_MOVED, index, prev, dest);
      callback && callback();
    });
  }
  function jump(index) {
    translate(toPosition(index, true));
  }
  function translate(position, preventLoop) {
    if (!Splide22.is(FADE)) {
      var destination = preventLoop ? position : loop(position);
      style(list, "transform", "translate" + resolve("X") + "(" + destination + "px)");
      position !== destination && emit(EVENT_SHIFTED);
    }
  }
  function loop(position) {
    if (Splide22.is(LOOP)) {
      var index = toIndex(position);
      var exceededMax = index > Components2.Controller.getEnd();
      var exceededMin = index < 0;
      if (exceededMin || exceededMax) {
        position = shift(position, exceededMax);
      }
    }
    return position;
  }
  function shift(position, backwards) {
    var excess = position - getLimit(backwards);
    var size = sliderSize();
    position -= orient(size * (ceil(abs(excess) / size) || 1)) * (backwards ? 1 : -1);
    return position;
  }
  function cancel() {
    translate(getPosition(), true);
    Transition.cancel();
  }
  function toIndex(position) {
    var Slides2 = Components2.Slides.get();
    var index = 0;
    var minDistance = Infinity;
    for (var i = 0; i < Slides2.length; i++) {
      var slideIndex = Slides2[i].index;
      var distance = abs(toPosition(slideIndex, true) - position);
      if (distance <= minDistance) {
        minDistance = distance;
        index = slideIndex;
      } else {
        break;
      }
    }
    return index;
  }
  function toPosition(index, trimming) {
    var position = orient(totalSize(index - 1) - offset(index));
    return trimming ? trim(position) : position;
  }
  function getPosition() {
    var left = resolve("left");
    return rect(list)[left] - rect(track)[left] + orient(getPadding(false));
  }
  function trim(position) {
    if (options.trimSpace && Splide22.is(SLIDE)) {
      position = clamp(position, 0, orient(sliderSize(true) - listSize()));
    }
    return position;
  }
  function offset(index) {
    var focus2 = options.focus;
    return focus2 === "center" ? (listSize() - slideSize(index, true)) / 2 : +focus2 * slideSize(index) || 0;
  }
  function getLimit(max2) {
    return toPosition(max2 ? Components2.Controller.getEnd() : 0, !!options.trimSpace);
  }
  function canShift(backwards) {
    var shifted = orient(shift(getPosition(), backwards));
    return backwards ? shifted >= 0 : shifted <= list[resolve("scrollWidth")] - rect(track)[resolve("width")];
  }
  function exceededLimit(max2, position) {
    position = isUndefined(position) ? getPosition() : position;
    var exceededMin = max2 !== true && orient(position) < orient(getLimit(false));
    var exceededMax = max2 !== false && orient(position) > orient(getLimit(true));
    return exceededMin || exceededMax;
  }
  return {
    mount,
    move,
    jump,
    translate,
    shift,
    cancel,
    toIndex,
    toPosition,
    getPosition,
    getLimit,
    exceededLimit,
    reposition
  };
}
function Controller(Splide22, Components2, options) {
  var _EventInterface5 = EventInterface(Splide22), on = _EventInterface5.on, emit = _EventInterface5.emit;
  var Move2 = Components2.Move;
  var getPosition = Move2.getPosition, getLimit = Move2.getLimit, toPosition = Move2.toPosition;
  var _Components2$Slides = Components2.Slides, isEnough = _Components2$Slides.isEnough, getLength = _Components2$Slides.getLength;
  var omitEnd = options.omitEnd;
  var isLoop = Splide22.is(LOOP);
  var isSlide = Splide22.is(SLIDE);
  var getNext = apply(getAdjacent, false);
  var getPrev = apply(getAdjacent, true);
  var currIndex = options.start || 0;
  var endIndex;
  var prevIndex = currIndex;
  var slideCount;
  var perMove;
  var perPage;
  function mount() {
    init();
    on([EVENT_UPDATED, EVENT_REFRESH, EVENT_END_INDEX_CHANGED], init);
    on(EVENT_RESIZED, onResized);
  }
  function init() {
    slideCount = getLength(true);
    perMove = options.perMove;
    perPage = options.perPage;
    endIndex = getEnd();
    var index = clamp(currIndex, 0, omitEnd ? endIndex : slideCount - 1);
    if (index !== currIndex) {
      currIndex = index;
      Move2.reposition();
    }
  }
  function onResized() {
    if (endIndex !== getEnd()) {
      emit(EVENT_END_INDEX_CHANGED);
    }
  }
  function go(control, allowSameIndex, callback) {
    if (!isBusy()) {
      var dest = parse(control);
      var index = loop(dest);
      if (index > -1 && (allowSameIndex || index !== currIndex)) {
        setIndex(index);
        Move2.move(dest, index, prevIndex, callback);
      }
    }
  }
  function scroll(destination, duration, snap, callback) {
    Components2.Scroll.scroll(destination, duration, snap, function() {
      var index = loop(Move2.toIndex(getPosition()));
      setIndex(omitEnd ? min(index, endIndex) : index);
      callback && callback();
    });
  }
  function parse(control) {
    var index = currIndex;
    if (isString(control)) {
      var _ref = control.match(/([+\-<>])(\d+)?/) || [], indicator = _ref[1], number = _ref[2];
      if (indicator === "+" || indicator === "-") {
        index = computeDestIndex(currIndex + +("" + indicator + (+number || 1)), currIndex);
      } else if (indicator === ">") {
        index = number ? toIndex(+number) : getNext(true);
      } else if (indicator === "<") {
        index = getPrev(true);
      }
    } else {
      index = isLoop ? control : clamp(control, 0, endIndex);
    }
    return index;
  }
  function getAdjacent(prev, destination) {
    var number = perMove || (hasFocus() ? 1 : perPage);
    var dest = computeDestIndex(currIndex + number * (prev ? -1 : 1), currIndex, !(perMove || hasFocus()));
    if (dest === -1 && isSlide) {
      if (!approximatelyEqual(getPosition(), getLimit(!prev), 1)) {
        return prev ? 0 : endIndex;
      }
    }
    return destination ? dest : loop(dest);
  }
  function computeDestIndex(dest, from, snapPage) {
    if (isEnough() || hasFocus()) {
      var index = computeMovableDestIndex(dest);
      if (index !== dest) {
        from = dest;
        dest = index;
        snapPage = false;
      }
      if (dest < 0 || dest > endIndex) {
        if (!perMove && (between(0, dest, from, true) || between(endIndex, from, dest, true))) {
          dest = toIndex(toPage(dest));
        } else {
          if (isLoop) {
            dest = snapPage ? dest < 0 ? -(slideCount % perPage || perPage) : slideCount : dest;
          } else if (options.rewind) {
            dest = dest < 0 ? endIndex : 0;
          } else {
            dest = -1;
          }
        }
      } else {
        if (snapPage && dest !== from) {
          dest = toIndex(toPage(from) + (dest < from ? -1 : 1));
        }
      }
    } else {
      dest = -1;
    }
    return dest;
  }
  function computeMovableDestIndex(dest) {
    if (isSlide && options.trimSpace === "move" && dest !== currIndex) {
      var position = getPosition();
      while (position === toPosition(dest, true) && between(dest, 0, Splide22.length - 1, !options.rewind)) {
        dest < currIndex ? --dest : ++dest;
      }
    }
    return dest;
  }
  function loop(index) {
    return isLoop ? (index + slideCount) % slideCount || 0 : index;
  }
  function getEnd() {
    var end = slideCount - (hasFocus() || isLoop && perMove ? 1 : perPage);
    while (omitEnd && end-- > 0) {
      if (toPosition(slideCount - 1, true) !== toPosition(end, true)) {
        end++;
        break;
      }
    }
    return clamp(end, 0, slideCount - 1);
  }
  function toIndex(page) {
    return clamp(hasFocus() ? page : perPage * page, 0, endIndex);
  }
  function toPage(index) {
    return hasFocus() ? min(index, endIndex) : floor((index >= endIndex ? slideCount - 1 : index) / perPage);
  }
  function toDest(destination) {
    var closest2 = Move2.toIndex(destination);
    return isSlide ? clamp(closest2, 0, endIndex) : closest2;
  }
  function setIndex(index) {
    if (index !== currIndex) {
      prevIndex = currIndex;
      currIndex = index;
    }
  }
  function getIndex(prev) {
    return prev ? prevIndex : currIndex;
  }
  function hasFocus() {
    return !isUndefined(options.focus) || options.isNavigation;
  }
  function isBusy() {
    return Splide22.state.is([MOVING, SCROLLING]) && !!options.waitForTransition;
  }
  return {
    mount,
    go,
    scroll,
    getNext,
    getPrev,
    getAdjacent,
    getEnd,
    setIndex,
    getIndex,
    toIndex,
    toPage,
    toDest,
    hasFocus,
    isBusy
  };
}
var XML_NAME_SPACE = "http://www.w3.org/2000/svg";
var PATH = "m15.5 0.932-4.3 4.38 14.5 14.6-14.5 14.5 4.3 4.4 14.6-14.6 4.4-4.3-4.4-4.4-14.6-14.6z";
var SIZE = 40;
function Arrows(Splide22, Components2, options) {
  var event = EventInterface(Splide22);
  var on = event.on, bind = event.bind, emit = event.emit;
  var classes = options.classes, i18n = options.i18n;
  var Elements2 = Components2.Elements, Controller2 = Components2.Controller;
  var placeholder = Elements2.arrows, track = Elements2.track;
  var wrapper = placeholder;
  var prev = Elements2.prev;
  var next = Elements2.next;
  var created;
  var wrapperClasses;
  var arrows = {};
  function mount() {
    init();
    on(EVENT_UPDATED, remount);
  }
  function remount() {
    destroy();
    mount();
  }
  function init() {
    var enabled = options.arrows;
    if (enabled && !(prev && next)) {
      createArrows();
    }
    if (prev && next) {
      assign(arrows, {
        prev,
        next
      });
      display(wrapper, enabled ? "" : "none");
      addClass(wrapper, wrapperClasses = CLASS_ARROWS + "--" + options.direction);
      if (enabled) {
        listen();
        update();
        setAttribute([prev, next], ARIA_CONTROLS, track.id);
        emit(EVENT_ARROWS_MOUNTED, prev, next);
      }
    }
  }
  function destroy() {
    event.destroy();
    removeClass(wrapper, wrapperClasses);
    if (created) {
      remove(placeholder ? [prev, next] : wrapper);
      prev = next = null;
    } else {
      removeAttribute([prev, next], ALL_ATTRIBUTES);
    }
  }
  function listen() {
    on([EVENT_MOUNTED, EVENT_MOVED, EVENT_REFRESH, EVENT_SCROLLED, EVENT_END_INDEX_CHANGED], update);
    bind(next, "click", apply(go, ">"));
    bind(prev, "click", apply(go, "<"));
  }
  function go(control) {
    Controller2.go(control, true);
  }
  function createArrows() {
    wrapper = placeholder || create("div", classes.arrows);
    prev = createArrow(true);
    next = createArrow(false);
    created = true;
    append(wrapper, [prev, next]);
    !placeholder && before(wrapper, track);
  }
  function createArrow(prev2) {
    var arrow = '<button class="' + classes.arrow + " " + (prev2 ? classes.prev : classes.next) + '" type="button"><svg xmlns="' + XML_NAME_SPACE + '" viewBox="0 0 ' + SIZE + " " + SIZE + '" width="' + SIZE + '" height="' + SIZE + '" focusable="false"><path d="' + (options.arrowPath || PATH) + '" />';
    return parseHtml(arrow);
  }
  function update() {
    if (prev && next) {
      var index = Splide22.index;
      var prevIndex = Controller2.getPrev();
      var nextIndex = Controller2.getNext();
      var prevLabel = prevIndex > -1 && index < prevIndex ? i18n.last : i18n.prev;
      var nextLabel = nextIndex > -1 && index > nextIndex ? i18n.first : i18n.next;
      prev.disabled = prevIndex < 0;
      next.disabled = nextIndex < 0;
      setAttribute(prev, ARIA_LABEL, prevLabel);
      setAttribute(next, ARIA_LABEL, nextLabel);
      emit(EVENT_ARROWS_UPDATED, prev, next, prevIndex, nextIndex);
    }
  }
  return {
    arrows,
    mount,
    destroy,
    update
  };
}
var INTERVAL_DATA_ATTRIBUTE = DATA_ATTRIBUTE + "-interval";
function Autoplay(Splide22, Components2, options) {
  var _EventInterface6 = EventInterface(Splide22), on = _EventInterface6.on, bind = _EventInterface6.bind, emit = _EventInterface6.emit;
  var interval = RequestInterval(options.interval, Splide22.go.bind(Splide22, ">"), onAnimationFrame);
  var isPaused = interval.isPaused;
  var Elements2 = Components2.Elements, _Components2$Elements4 = Components2.Elements, root = _Components2$Elements4.root, toggle = _Components2$Elements4.toggle;
  var autoplay = options.autoplay;
  var hovered;
  var focused;
  var stopped = autoplay === "pause";
  function mount() {
    if (autoplay) {
      listen();
      toggle && setAttribute(toggle, ARIA_CONTROLS, Elements2.track.id);
      stopped || play();
      update();
    }
  }
  function listen() {
    if (options.pauseOnHover) {
      bind(root, "mouseenter mouseleave", function(e) {
        hovered = e.type === "mouseenter";
        autoToggle();
      });
    }
    if (options.pauseOnFocus) {
      bind(root, "focusin focusout", function(e) {
        focused = e.type === "focusin";
        autoToggle();
      });
    }
    if (toggle) {
      bind(toggle, "click", function() {
        stopped ? play() : pause(true);
      });
    }
    on([EVENT_MOVE, EVENT_SCROLL, EVENT_REFRESH], interval.rewind);
    on(EVENT_MOVE, onMove);
  }
  function play() {
    if (isPaused() && Components2.Slides.isEnough()) {
      interval.start(!options.resetProgress);
      focused = hovered = stopped = false;
      update();
      emit(EVENT_AUTOPLAY_PLAY);
    }
  }
  function pause(stop) {
    if (stop === void 0) {
      stop = true;
    }
    stopped = !!stop;
    update();
    if (!isPaused()) {
      interval.pause();
      emit(EVENT_AUTOPLAY_PAUSE);
    }
  }
  function autoToggle() {
    if (!stopped) {
      hovered || focused ? pause(false) : play();
    }
  }
  function update() {
    if (toggle) {
      toggleClass(toggle, CLASS_ACTIVE, !stopped);
      setAttribute(toggle, ARIA_LABEL, options.i18n[stopped ? "play" : "pause"]);
    }
  }
  function onAnimationFrame(rate) {
    var bar = Elements2.bar;
    bar && style(bar, "width", rate * 100 + "%");
    emit(EVENT_AUTOPLAY_PLAYING, rate);
  }
  function onMove(index) {
    var Slide2 = Components2.Slides.getAt(index);
    interval.set(Slide2 && +getAttribute(Slide2.slide, INTERVAL_DATA_ATTRIBUTE) || options.interval);
  }
  return {
    mount,
    destroy: interval.cancel,
    play,
    pause,
    isPaused
  };
}
function Cover(Splide22, Components2, options) {
  var _EventInterface7 = EventInterface(Splide22), on = _EventInterface7.on;
  function mount() {
    if (options.cover) {
      on(EVENT_LAZYLOAD_LOADED, apply(toggle, true));
      on([EVENT_MOUNTED, EVENT_UPDATED, EVENT_REFRESH], apply(cover, true));
    }
  }
  function cover(cover2) {
    Components2.Slides.forEach(function(Slide2) {
      var img = child(Slide2.container || Slide2.slide, "img");
      if (img && img.src) {
        toggle(cover2, img, Slide2);
      }
    });
  }
  function toggle(cover2, img, Slide2) {
    Slide2.style("background", cover2 ? 'center/cover no-repeat url("' + img.src + '")' : "", true);
    display(img, cover2 ? "none" : "");
  }
  return {
    mount,
    destroy: apply(cover, false)
  };
}
var BOUNCE_DIFF_THRESHOLD = 10;
var BOUNCE_DURATION = 600;
var FRICTION_FACTOR = 0.6;
var BASE_VELOCITY = 1.5;
var MIN_DURATION = 800;
function Scroll(Splide22, Components2, options) {
  var _EventInterface8 = EventInterface(Splide22), on = _EventInterface8.on, emit = _EventInterface8.emit;
  var set = Splide22.state.set;
  var Move2 = Components2.Move;
  var getPosition = Move2.getPosition, getLimit = Move2.getLimit, exceededLimit = Move2.exceededLimit, translate = Move2.translate;
  var isSlide = Splide22.is(SLIDE);
  var interval;
  var callback;
  var friction = 1;
  function mount() {
    on(EVENT_MOVE, clear);
    on([EVENT_UPDATED, EVENT_REFRESH], cancel);
  }
  function scroll(destination, duration, snap, onScrolled, noConstrain) {
    var from = getPosition();
    clear();
    if (snap && (!isSlide || !exceededLimit())) {
      var size = Components2.Layout.sliderSize();
      var offset = sign(destination) * size * floor(abs(destination) / size) || 0;
      destination = Move2.toPosition(Components2.Controller.toDest(destination % size)) + offset;
    }
    var noDistance = approximatelyEqual(from, destination, 1);
    friction = 1;
    duration = noDistance ? 0 : duration || max(abs(destination - from) / BASE_VELOCITY, MIN_DURATION);
    callback = onScrolled;
    interval = RequestInterval(duration, onEnd, apply(update, from, destination, noConstrain), 1);
    set(SCROLLING);
    emit(EVENT_SCROLL);
    interval.start();
  }
  function onEnd() {
    set(IDLE);
    callback && callback();
    emit(EVENT_SCROLLED);
  }
  function update(from, to, noConstrain, rate) {
    var position = getPosition();
    var target = from + (to - from) * easing(rate);
    var diff = (target - position) * friction;
    translate(position + diff);
    if (isSlide && !noConstrain && exceededLimit()) {
      friction *= FRICTION_FACTOR;
      if (abs(diff) < BOUNCE_DIFF_THRESHOLD) {
        scroll(getLimit(exceededLimit(true)), BOUNCE_DURATION, false, callback, true);
      }
    }
  }
  function clear() {
    if (interval) {
      interval.cancel();
    }
  }
  function cancel() {
    if (interval && !interval.isPaused()) {
      clear();
      onEnd();
    }
  }
  function easing(t) {
    var easingFunc = options.easingFunc;
    return easingFunc ? easingFunc(t) : 1 - Math.pow(1 - t, 4);
  }
  return {
    mount,
    destroy: clear,
    scroll,
    cancel
  };
}
var SCROLL_LISTENER_OPTIONS = {
  passive: false,
  capture: true
};
function Drag(Splide22, Components2, options) {
  var _EventInterface9 = EventInterface(Splide22), on = _EventInterface9.on, emit = _EventInterface9.emit, bind = _EventInterface9.bind, unbind = _EventInterface9.unbind;
  var state = Splide22.state;
  var Move2 = Components2.Move, Scroll2 = Components2.Scroll, Controller2 = Components2.Controller, track = Components2.Elements.track, reduce = Components2.Media.reduce;
  var _Components2$Directio2 = Components2.Direction, resolve = _Components2$Directio2.resolve, orient = _Components2$Directio2.orient;
  var getPosition = Move2.getPosition, exceededLimit = Move2.exceededLimit;
  var basePosition;
  var baseEvent;
  var prevBaseEvent;
  var isFree;
  var dragging;
  var exceeded = false;
  var clickPrevented;
  var disabled;
  var target;
  function mount() {
    bind(track, POINTER_MOVE_EVENTS, noop, SCROLL_LISTENER_OPTIONS);
    bind(track, POINTER_UP_EVENTS, noop, SCROLL_LISTENER_OPTIONS);
    bind(track, POINTER_DOWN_EVENTS, onPointerDown, SCROLL_LISTENER_OPTIONS);
    bind(track, "click", onClick, {
      capture: true
    });
    bind(track, "dragstart", prevent);
    on([EVENT_MOUNTED, EVENT_UPDATED], init);
  }
  function init() {
    var drag = options.drag;
    disable(!drag);
    isFree = drag === "free";
  }
  function onPointerDown(e) {
    clickPrevented = false;
    if (!disabled) {
      var isTouch = isTouchEvent(e);
      if (isDraggable(e.target) && (isTouch || !e.button)) {
        if (!Controller2.isBusy()) {
          target = isTouch ? track : window;
          dragging = state.is([MOVING, SCROLLING]);
          prevBaseEvent = null;
          bind(target, POINTER_MOVE_EVENTS, onPointerMove, SCROLL_LISTENER_OPTIONS);
          bind(target, POINTER_UP_EVENTS, onPointerUp, SCROLL_LISTENER_OPTIONS);
          Move2.cancel();
          Scroll2.cancel();
          save(e);
        } else {
          prevent(e, true);
        }
      }
    }
  }
  function onPointerMove(e) {
    if (!state.is(DRAGGING)) {
      state.set(DRAGGING);
      emit(EVENT_DRAG);
    }
    if (e.cancelable) {
      if (dragging) {
        Move2.translate(basePosition + constrain(diffCoord(e)));
        var expired = diffTime(e) > LOG_INTERVAL;
        var hasExceeded = exceeded !== (exceeded = exceededLimit());
        if (expired || hasExceeded) {
          save(e);
        }
        clickPrevented = true;
        emit(EVENT_DRAGGING);
        prevent(e);
      } else if (isSliderDirection(e)) {
        dragging = shouldStart(e);
        prevent(e);
      }
    }
  }
  function onPointerUp(e) {
    if (state.is(DRAGGING)) {
      state.set(IDLE);
      emit(EVENT_DRAGGED);
    }
    if (dragging) {
      move(e);
      prevent(e);
    }
    unbind(target, POINTER_MOVE_EVENTS, onPointerMove);
    unbind(target, POINTER_UP_EVENTS, onPointerUp);
    dragging = false;
  }
  function onClick(e) {
    if (!disabled && clickPrevented) {
      prevent(e, true);
    }
  }
  function save(e) {
    prevBaseEvent = baseEvent;
    baseEvent = e;
    basePosition = getPosition();
  }
  function move(e) {
    var velocity = computeVelocity(e);
    var destination = computeDestination(velocity);
    var rewind = options.rewind && options.rewindByDrag;
    reduce(false);
    if (isFree) {
      Controller2.scroll(destination, 0, options.snap);
    } else if (Splide22.is(FADE)) {
      Controller2.go(orient(sign(velocity)) < 0 ? rewind ? "<" : "-" : rewind ? ">" : "+");
    } else if (Splide22.is(SLIDE) && exceeded && rewind) {
      Controller2.go(exceededLimit(true) ? ">" : "<");
    } else {
      Controller2.go(Controller2.toDest(destination), true);
    }
    reduce(true);
  }
  function shouldStart(e) {
    var thresholds = options.dragMinThreshold;
    var isObj = isObject(thresholds);
    var mouse = isObj && thresholds.mouse || 0;
    var touch = (isObj ? thresholds.touch : +thresholds) || 10;
    return abs(diffCoord(e)) > (isTouchEvent(e) ? touch : mouse);
  }
  function isSliderDirection(e) {
    return abs(diffCoord(e)) > abs(diffCoord(e, true));
  }
  function computeVelocity(e) {
    if (Splide22.is(LOOP) || !exceeded) {
      var time = diffTime(e);
      if (time && time < LOG_INTERVAL) {
        return diffCoord(e) / time;
      }
    }
    return 0;
  }
  function computeDestination(velocity) {
    return getPosition() + sign(velocity) * min(abs(velocity) * (options.flickPower || 600), isFree ? Infinity : Components2.Layout.listSize() * (options.flickMaxPages || 1));
  }
  function diffCoord(e, orthogonal) {
    return coordOf(e, orthogonal) - coordOf(getBaseEvent(e), orthogonal);
  }
  function diffTime(e) {
    return timeOf(e) - timeOf(getBaseEvent(e));
  }
  function getBaseEvent(e) {
    return baseEvent === e && prevBaseEvent || baseEvent;
  }
  function coordOf(e, orthogonal) {
    return (isTouchEvent(e) ? e.changedTouches[0] : e)["page" + resolve(orthogonal ? "Y" : "X")];
  }
  function constrain(diff) {
    return diff / (exceeded && Splide22.is(SLIDE) ? FRICTION : 1);
  }
  function isDraggable(target2) {
    var noDrag = options.noDrag;
    return !matches(target2, "." + CLASS_PAGINATION_PAGE + ", ." + CLASS_ARROW) && (!noDrag || !matches(target2, noDrag));
  }
  function isTouchEvent(e) {
    return typeof TouchEvent !== "undefined" && e instanceof TouchEvent;
  }
  function isDragging() {
    return dragging;
  }
  function disable(value) {
    disabled = value;
  }
  return {
    mount,
    disable,
    isDragging
  };
}
var NORMALIZATION_MAP = {
  Spacebar: " ",
  Right: ARROW_RIGHT,
  Left: ARROW_LEFT,
  Up: ARROW_UP,
  Down: ARROW_DOWN
};
function normalizeKey(key) {
  key = isString(key) ? key : key.key;
  return NORMALIZATION_MAP[key] || key;
}
var KEYBOARD_EVENT = "keydown";
function Keyboard(Splide22, Components2, options) {
  var _EventInterface10 = EventInterface(Splide22), on = _EventInterface10.on, bind = _EventInterface10.bind, unbind = _EventInterface10.unbind;
  var root = Splide22.root;
  var resolve = Components2.Direction.resolve;
  var target;
  var disabled;
  function mount() {
    init();
    on(EVENT_UPDATED, destroy);
    on(EVENT_UPDATED, init);
    on(EVENT_MOVE, onMove);
  }
  function init() {
    var keyboard = options.keyboard;
    if (keyboard) {
      target = keyboard === "global" ? window : root;
      bind(target, KEYBOARD_EVENT, onKeydown);
    }
  }
  function destroy() {
    unbind(target, KEYBOARD_EVENT);
  }
  function disable(value) {
    disabled = value;
  }
  function onMove() {
    var _disabled = disabled;
    disabled = true;
    nextTick(function() {
      disabled = _disabled;
    });
  }
  function onKeydown(e) {
    if (!disabled) {
      var key = normalizeKey(e);
      if (key === resolve(ARROW_LEFT)) {
        Splide22.go("<");
      } else if (key === resolve(ARROW_RIGHT)) {
        Splide22.go(">");
      }
    }
  }
  return {
    mount,
    destroy,
    disable
  };
}
var SRC_DATA_ATTRIBUTE = DATA_ATTRIBUTE + "-lazy";
var SRCSET_DATA_ATTRIBUTE = SRC_DATA_ATTRIBUTE + "-srcset";
var IMAGE_SELECTOR = "[" + SRC_DATA_ATTRIBUTE + "], [" + SRCSET_DATA_ATTRIBUTE + "]";
function LazyLoad(Splide22, Components2, options) {
  var _EventInterface11 = EventInterface(Splide22), on = _EventInterface11.on, off = _EventInterface11.off, bind = _EventInterface11.bind, emit = _EventInterface11.emit;
  var isSequential = options.lazyLoad === "sequential";
  var events = [EVENT_MOVED, EVENT_SCROLLED];
  var entries = [];
  function mount() {
    if (options.lazyLoad) {
      init();
      on(EVENT_REFRESH, init);
    }
  }
  function init() {
    empty(entries);
    register();
    if (isSequential) {
      loadNext();
    } else {
      off(events);
      on(events, check);
      check();
    }
  }
  function register() {
    Components2.Slides.forEach(function(Slide2) {
      queryAll(Slide2.slide, IMAGE_SELECTOR).forEach(function(img) {
        var src = getAttribute(img, SRC_DATA_ATTRIBUTE);
        var srcset = getAttribute(img, SRCSET_DATA_ATTRIBUTE);
        if (src !== img.src || srcset !== img.srcset) {
          var className = options.classes.spinner;
          var parent = img.parentElement;
          var spinner = child(parent, "." + className) || create("span", className, parent);
          entries.push([img, Slide2, spinner]);
          img.src || display(img, "none");
        }
      });
    });
  }
  function check() {
    entries = entries.filter(function(data) {
      var distance = options.perPage * ((options.preloadPages || 1) + 1) - 1;
      return data[1].isWithin(Splide22.index, distance) ? load(data) : true;
    });
    entries.length || off(events);
  }
  function load(data) {
    var img = data[0];
    addClass(data[1].slide, CLASS_LOADING);
    bind(img, "load error", apply(onLoad, data));
    setAttribute(img, "src", getAttribute(img, SRC_DATA_ATTRIBUTE));
    setAttribute(img, "srcset", getAttribute(img, SRCSET_DATA_ATTRIBUTE));
    removeAttribute(img, SRC_DATA_ATTRIBUTE);
    removeAttribute(img, SRCSET_DATA_ATTRIBUTE);
  }
  function onLoad(data, e) {
    var img = data[0], Slide2 = data[1];
    removeClass(Slide2.slide, CLASS_LOADING);
    if (e.type !== "error") {
      remove(data[2]);
      display(img, "");
      emit(EVENT_LAZYLOAD_LOADED, img, Slide2);
      emit(EVENT_RESIZE);
    }
    isSequential && loadNext();
  }
  function loadNext() {
    entries.length && load(entries.shift());
  }
  return {
    mount,
    destroy: apply(empty, entries),
    check
  };
}
function Pagination(Splide22, Components2, options) {
  var event = EventInterface(Splide22);
  var on = event.on, emit = event.emit, bind = event.bind;
  var Slides2 = Components2.Slides, Elements2 = Components2.Elements, Controller2 = Components2.Controller;
  var hasFocus = Controller2.hasFocus, getIndex = Controller2.getIndex, go = Controller2.go;
  var resolve = Components2.Direction.resolve;
  var placeholder = Elements2.pagination;
  var items = [];
  var list;
  var paginationClasses;
  function mount() {
    destroy();
    on([EVENT_UPDATED, EVENT_REFRESH, EVENT_END_INDEX_CHANGED], mount);
    var enabled = options.pagination;
    placeholder && display(placeholder, enabled ? "" : "none");
    if (enabled) {
      on([EVENT_MOVE, EVENT_SCROLL, EVENT_SCROLLED], update);
      createPagination();
      update();
      emit(EVENT_PAGINATION_MOUNTED, {
        list,
        items
      }, getAt(Splide22.index));
    }
  }
  function destroy() {
    if (list) {
      remove(placeholder ? slice(list.children) : list);
      removeClass(list, paginationClasses);
      empty(items);
      list = null;
    }
    event.destroy();
  }
  function createPagination() {
    var length = Splide22.length;
    var classes = options.classes, i18n = options.i18n, perPage = options.perPage;
    var max2 = hasFocus() ? Controller2.getEnd() + 1 : ceil(length / perPage);
    list = placeholder || create("ul", classes.pagination, Elements2.track.parentElement);
    addClass(list, paginationClasses = CLASS_PAGINATION + "--" + getDirection());
    setAttribute(list, ROLE, "tablist");
    setAttribute(list, ARIA_LABEL, i18n.select);
    setAttribute(list, ARIA_ORIENTATION, getDirection() === TTB ? "vertical" : "");
    for (var i = 0; i < max2; i++) {
      var li = create("li", null, list);
      var button = create("button", {
        class: classes.page,
        type: "button"
      }, li);
      var controls = Slides2.getIn(i).map(function(Slide2) {
        return Slide2.slide.id;
      });
      var text = !hasFocus() && perPage > 1 ? i18n.pageX : i18n.slideX;
      bind(button, "click", apply(onClick, i));
      if (options.paginationKeyboard) {
        bind(button, "keydown", apply(onKeydown, i));
      }
      setAttribute(li, ROLE, "presentation");
      setAttribute(button, ROLE, "tab");
      setAttribute(button, ARIA_CONTROLS, controls.join(" "));
      setAttribute(button, ARIA_LABEL, format(text, i + 1));
      setAttribute(button, TAB_INDEX, -1);
      items.push({
        li,
        button,
        page: i
      });
    }
  }
  function onClick(page) {
    go(">" + page, true);
  }
  function onKeydown(page, e) {
    var length = items.length;
    var key = normalizeKey(e);
    var dir = getDirection();
    var nextPage = -1;
    if (key === resolve(ARROW_RIGHT, false, dir)) {
      nextPage = ++page % length;
    } else if (key === resolve(ARROW_LEFT, false, dir)) {
      nextPage = (--page + length) % length;
    } else if (key === "Home") {
      nextPage = 0;
    } else if (key === "End") {
      nextPage = length - 1;
    }
    var item = items[nextPage];
    if (item) {
      focus(item.button);
      go(">" + nextPage);
      prevent(e, true);
    }
  }
  function getDirection() {
    return options.paginationDirection || options.direction;
  }
  function getAt(index) {
    return items[Controller2.toPage(index)];
  }
  function update() {
    var prev = getAt(getIndex(true));
    var curr = getAt(getIndex());
    if (prev) {
      var button = prev.button;
      removeClass(button, CLASS_ACTIVE);
      removeAttribute(button, ARIA_SELECTED);
      setAttribute(button, TAB_INDEX, -1);
    }
    if (curr) {
      var _button = curr.button;
      addClass(_button, CLASS_ACTIVE);
      setAttribute(_button, ARIA_SELECTED, true);
      setAttribute(_button, TAB_INDEX, "");
    }
    emit(EVENT_PAGINATION_UPDATED, {
      list,
      items
    }, prev, curr);
  }
  return {
    items,
    mount,
    destroy,
    getAt,
    update
  };
}
var TRIGGER_KEYS = [" ", "Enter"];
function Sync(Splide22, Components2, options) {
  var isNavigation = options.isNavigation, slideFocus = options.slideFocus;
  var events = [];
  function mount() {
    Splide22.splides.forEach(function(target) {
      if (!target.isParent) {
        sync(Splide22, target.splide);
        sync(target.splide, Splide22);
      }
    });
    if (isNavigation) {
      navigate();
    }
  }
  function destroy() {
    events.forEach(function(event) {
      event.destroy();
    });
    empty(events);
  }
  function remount() {
    destroy();
    mount();
  }
  function sync(splide, target) {
    var event = EventInterface(splide);
    event.on(EVENT_MOVE, function(index, prev, dest) {
      target.go(target.is(LOOP) ? dest : index);
    });
    events.push(event);
  }
  function navigate() {
    var event = EventInterface(Splide22);
    var on = event.on;
    on(EVENT_CLICK, onClick);
    on(EVENT_SLIDE_KEYDOWN, onKeydown);
    on([EVENT_MOUNTED, EVENT_UPDATED], update);
    events.push(event);
    event.emit(EVENT_NAVIGATION_MOUNTED, Splide22.splides);
  }
  function update() {
    setAttribute(Components2.Elements.list, ARIA_ORIENTATION, options.direction === TTB ? "vertical" : "");
  }
  function onClick(Slide2) {
    Splide22.go(Slide2.index);
  }
  function onKeydown(Slide2, e) {
    if (includes(TRIGGER_KEYS, normalizeKey(e))) {
      onClick(Slide2);
      prevent(e);
    }
  }
  return {
    setup: apply(Components2.Media.set, {
      slideFocus: isUndefined(slideFocus) ? isNavigation : slideFocus
    }, true),
    mount,
    destroy,
    remount
  };
}
function Wheel(Splide22, Components2, options) {
  var _EventInterface12 = EventInterface(Splide22), bind = _EventInterface12.bind;
  var lastTime = 0;
  function mount() {
    if (options.wheel) {
      bind(Components2.Elements.track, "wheel", onWheel, SCROLL_LISTENER_OPTIONS);
    }
  }
  function onWheel(e) {
    if (e.cancelable) {
      var deltaY = e.deltaY;
      var backwards = deltaY < 0;
      var timeStamp = timeOf(e);
      var _min = options.wheelMinThreshold || 0;
      var sleep = options.wheelSleep || 0;
      if (abs(deltaY) > _min && timeStamp - lastTime > sleep) {
        Splide22.go(backwards ? "<" : ">");
        lastTime = timeStamp;
      }
      shouldPrevent(backwards) && prevent(e);
    }
  }
  function shouldPrevent(backwards) {
    return !options.releaseWheel || Splide22.state.is(MOVING) || Components2.Controller.getAdjacent(backwards) !== -1;
  }
  return {
    mount
  };
}
var SR_REMOVAL_DELAY = 90;
function Live(Splide22, Components2, options) {
  var _EventInterface13 = EventInterface(Splide22), on = _EventInterface13.on;
  var track = Components2.Elements.track;
  var enabled = options.live && !options.isNavigation;
  var sr = create("span", CLASS_SR);
  var interval = RequestInterval(SR_REMOVAL_DELAY, apply(toggle, false));
  function mount() {
    if (enabled) {
      disable(!Components2.Autoplay.isPaused());
      setAttribute(track, ARIA_ATOMIC, true);
      sr.textContent = "\u2026";
      on(EVENT_AUTOPLAY_PLAY, apply(disable, true));
      on(EVENT_AUTOPLAY_PAUSE, apply(disable, false));
      on([EVENT_MOVED, EVENT_SCROLLED], apply(toggle, true));
    }
  }
  function toggle(active) {
    setAttribute(track, ARIA_BUSY, active);
    if (active) {
      append(track, sr);
      interval.start();
    } else {
      remove(sr);
      interval.cancel();
    }
  }
  function destroy() {
    removeAttribute(track, [ARIA_LIVE, ARIA_ATOMIC, ARIA_BUSY]);
    remove(sr);
  }
  function disable(disabled) {
    if (enabled) {
      setAttribute(track, ARIA_LIVE, disabled ? "off" : "polite");
    }
  }
  return {
    mount,
    disable,
    destroy
  };
}
var ComponentConstructors = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  Media,
  Direction,
  Elements,
  Slides,
  Layout,
  Clones,
  Move,
  Controller,
  Arrows,
  Autoplay,
  Cover,
  Scroll,
  Drag,
  Keyboard,
  LazyLoad,
  Pagination,
  Sync,
  Wheel,
  Live
});
var I18N = {
  prev: "Previous slide",
  next: "Next slide",
  first: "Go to first slide",
  last: "Go to last slide",
  slideX: "Go to slide %s",
  pageX: "Go to page %s",
  play: "Start autoplay",
  pause: "Pause autoplay",
  carousel: "carousel",
  slide: "slide",
  select: "Select a slide to show",
  slideLabel: "%s of %s"
};
var DEFAULTS = {
  type: "slide",
  role: "region",
  speed: 400,
  perPage: 1,
  cloneStatus: true,
  arrows: true,
  pagination: true,
  paginationKeyboard: true,
  interval: 5e3,
  pauseOnHover: true,
  pauseOnFocus: true,
  resetProgress: true,
  easing: "cubic-bezier(0.25, 1, 0.5, 1)",
  drag: true,
  direction: "ltr",
  trimSpace: true,
  focusableNodes: "a, button, textarea, input, select, iframe",
  live: true,
  classes: CLASSES,
  i18n: I18N,
  reducedMotion: {
    speed: 0,
    rewindSpeed: 0,
    autoplay: "pause"
  }
};
function Fade(Splide22, Components2, options) {
  var Slides2 = Components2.Slides;
  function mount() {
    EventInterface(Splide22).on([EVENT_MOUNTED, EVENT_REFRESH], init);
  }
  function init() {
    Slides2.forEach(function(Slide2) {
      Slide2.style("transform", "translateX(-" + 100 * Slide2.index + "%)");
    });
  }
  function start(index, done) {
    Slides2.style("transition", "opacity " + options.speed + "ms " + options.easing);
    nextTick(done);
  }
  return {
    mount,
    start,
    cancel: noop
  };
}
function Slide(Splide22, Components2, options) {
  var Move2 = Components2.Move, Controller2 = Components2.Controller, Scroll2 = Components2.Scroll;
  var list = Components2.Elements.list;
  var transition = apply(style, list, "transition");
  var endCallback;
  function mount() {
    EventInterface(Splide22).bind(list, "transitionend", function(e) {
      if (e.target === list && endCallback) {
        cancel();
        endCallback();
      }
    });
  }
  function start(index, done) {
    var destination = Move2.toPosition(index, true);
    var position = Move2.getPosition();
    var speed = getSpeed(index);
    if (abs(destination - position) >= 1 && speed >= 1) {
      if (options.useScroll) {
        Scroll2.scroll(destination, speed, false, done);
      } else {
        transition("transform " + speed + "ms " + options.easing);
        Move2.translate(destination, true);
        endCallback = done;
      }
    } else {
      Move2.jump(index);
      done();
    }
  }
  function cancel() {
    transition("");
    Scroll2.cancel();
  }
  function getSpeed(index) {
    var rewindSpeed = options.rewindSpeed;
    if (Splide22.is(SLIDE) && rewindSpeed) {
      var prev = Controller2.getIndex(true);
      var end = Controller2.getEnd();
      if (prev === 0 && index >= end || prev >= end && index === 0) {
        return rewindSpeed;
      }
    }
    return options.speed;
  }
  return {
    mount,
    start,
    cancel
  };
}
var _Splide = /* @__PURE__ */ function() {
  function _Splide2(target, options) {
    this.event = EventInterface();
    this.Components = {};
    this.state = State(CREATED);
    this.splides = [];
    this._o = {};
    this._E = {};
    var root = isString(target) ? query(document, target) : target;
    assert(root, root + " is invalid.");
    this.root = root;
    options = merge({
      label: getAttribute(root, ARIA_LABEL) || "",
      labelledby: getAttribute(root, ARIA_LABELLEDBY) || ""
    }, DEFAULTS, _Splide2.defaults, options || {});
    try {
      merge(options, JSON.parse(getAttribute(root, DATA_ATTRIBUTE)));
    } catch (e) {
      assert(false, "Invalid JSON");
    }
    this._o = Object.create(merge({}, options));
  }
  var _proto = _Splide2.prototype;
  _proto.mount = function mount(Extensions, Transition) {
    var _this = this;
    var state = this.state, Components2 = this.Components;
    assert(state.is([CREATED, DESTROYED]), "Already mounted!");
    state.set(CREATED);
    this._C = Components2;
    this._T = Transition || this._T || (this.is(FADE) ? Fade : Slide);
    this._E = Extensions || this._E;
    var Constructors = assign({}, ComponentConstructors, this._E, {
      Transition: this._T
    });
    forOwn(Constructors, function(Component, key) {
      var component = Component(_this, Components2, _this._o);
      Components2[key] = component;
      component.setup && component.setup();
    });
    forOwn(Components2, function(component) {
      component.mount && component.mount();
    });
    this.emit(EVENT_MOUNTED);
    addClass(this.root, CLASS_INITIALIZED);
    state.set(IDLE);
    this.emit(EVENT_READY);
    return this;
  };
  _proto.sync = function sync(splide) {
    this.splides.push({
      splide
    });
    splide.splides.push({
      splide: this,
      isParent: true
    });
    if (this.state.is(IDLE)) {
      this._C.Sync.remount();
      splide.Components.Sync.remount();
    }
    return this;
  };
  _proto.go = function go(control) {
    this._C.Controller.go(control);
    return this;
  };
  _proto.on = function on(events, callback) {
    this.event.on(events, callback);
    return this;
  };
  _proto.off = function off(events) {
    this.event.off(events);
    return this;
  };
  _proto.emit = function emit(event) {
    var _this$event;
    (_this$event = this.event).emit.apply(_this$event, [event].concat(slice(arguments, 1)));
    return this;
  };
  _proto.add = function add(slides, index) {
    this._C.Slides.add(slides, index);
    return this;
  };
  _proto.remove = function remove2(matcher) {
    this._C.Slides.remove(matcher);
    return this;
  };
  _proto.is = function is(type) {
    return this._o.type === type;
  };
  _proto.refresh = function refresh() {
    this.emit(EVENT_REFRESH);
    return this;
  };
  _proto.destroy = function destroy(completely) {
    if (completely === void 0) {
      completely = true;
    }
    var event = this.event, state = this.state;
    if (state.is(CREATED)) {
      EventInterface(this).on(EVENT_READY, this.destroy.bind(this, completely));
    } else {
      forOwn(this._C, function(component) {
        component.destroy && component.destroy(completely);
      }, true);
      event.emit(EVENT_DESTROY);
      event.destroy();
      completely && empty(this.splides);
      state.set(DESTROYED);
    }
    return this;
  };
  _createClass(_Splide2, [{
    key: "options",
    get: function get() {
      return this._o;
    },
    set: function set(options) {
      this._C.Media.set(options, true, true);
    }
  }, {
    key: "length",
    get: function get() {
      return this._C.Slides.getLength(true);
    }
  }, {
    key: "index",
    get: function get() {
      return this._C.Controller.getIndex();
    }
  }]);
  return _Splide2;
}();
var Splide = _Splide;
Splide.defaults = {};
Splide.STATES = STATES;

// src/js/components/Splide/Splide.tsx


// src/js/constants/events.ts
var EVENTS = [
  [EVENT_MOUNTED, "onMounted"],
  [EVENT_READY, "onReady"],
  [EVENT_MOVE, "onMove"],
  [EVENT_MOVED, "onMoved"],
  [EVENT_CLICK, "onClick"],
  [EVENT_ACTIVE, "onActive"],
  [EVENT_INACTIVE, "onInactive"],
  [EVENT_VISIBLE, "onVisible"],
  [EVENT_HIDDEN, "onHidden"],
  [EVENT_REFRESH, "onRefresh"],
  [EVENT_UPDATED, "onUpdated"],
  [EVENT_RESIZE, "onResize"],
  [EVENT_RESIZED, "onResized"],
  [EVENT_DRAG, "onDrag"],
  [EVENT_DRAGGING, "onDragging"],
  [EVENT_DRAGGED, "onDragged"],
  [EVENT_SCROLL, "onScroll"],
  [EVENT_SCROLLED, "onScrolled"],
  [EVENT_DESTROY, "onDestroy"],
  [EVENT_ARROWS_MOUNTED, "onArrowsMounted"],
  [EVENT_ARROWS_UPDATED, "onArrowsUpdated"],
  [EVENT_PAGINATION_MOUNTED, "onPaginationMounted"],
  [EVENT_PAGINATION_UPDATED, "onPaginationUpdated"],
  [EVENT_NAVIGATION_MOUNTED, "onNavigationMounted"],
  [EVENT_AUTOPLAY_PLAY, "onAutoplayPlay"],
  [EVENT_AUTOPLAY_PLAYING, "onAutoplayPlaying"],
  [EVENT_AUTOPLAY_PAUSE, "onAutoplayPause"],
  [EVENT_LAZYLOAD_LOADED, "onLazyLoadLoaded"]
];

// src/js/utils/classNames/classNames.ts
function classNames(...classes) {
  return classes.filter(Boolean).join(" ");
}

// src/js/utils/isObject/isObject.ts
function isObject2(subject) {
  return subject !== null && typeof subject === "object";
}

// src/js/utils/isEqualDeep/isEqualDeep.ts
function isEqualDeep(subject1, subject2) {
  if (Array.isArray(subject1) && Array.isArray(subject2)) {
    return subject1.length === subject2.length && !subject1.some((elm, index) => !isEqualDeep(elm, subject2[index]));
  }
  if (isObject2(subject1) && isObject2(subject2)) {
    const keys1 = Object.keys(subject1);
    const keys2 = Object.keys(subject2);
    return keys1.length === keys2.length && !keys1.some((key) => {
      return !Object.prototype.hasOwnProperty.call(subject2, key) || !isEqualDeep(subject1[key], subject2[key]);
    });
  }
  return subject1 === subject2;
}

// src/js/utils/isEqualShallow/isEqualShallow.ts
function isEqualShallow(array1, array2) {
  return array1.length === array2.length && !array1.some((elm, index) => elm !== array2[index]);
}

// src/js/utils/forOwn/forOwn.ts
function forOwn2(object, iteratee) {
  if (object) {
    const keys = Object.keys(object);
    for (let i = 0; i < keys.length; i++) {
      const key = keys[i];
      if (key !== "__proto__") {
        if (iteratee(object[key], key) === false) {
          break;
        }
      }
    }
  }
  return object;
}

// src/js/utils/merge/merge.ts
function merge2(object, source) {
  const merged = object;
  forOwn2(source, (value, key) => {
    if (Array.isArray(value)) {
      merged[key] = value.slice();
    } else if (isObject2(value)) {
      merged[key] = merge2(isObject2(merged[key]) ? merged[key] : {}, value);
    } else {
      merged[key] = value;
    }
  });
  return merged;
}

// src/js/components/SplideTrack/SplideTrack.tsx

var SplideTrack = ({ children: children2, className, ...props }) => {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: classNames("splide__track", className),
    ...props
  }, /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", {
    className: "splide__list"
  }, children2));
};

// src/js/components/Splide/Splide.tsx
var Splide2 = class extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
  constructor() {
    super(...arguments);
    this.splideRef = react__WEBPACK_IMPORTED_MODULE_0___default().createRef();
    this.slides = [];
  }
  componentDidMount() {
    const { options, extensions, transition } = this.props;
    const { current } = this.splideRef;
    if (current) {
      this.splide = new Splide(current, options);
      this.bind(this.splide);
      this.splide.mount(extensions, transition);
      this.options = merge2({}, options || {});
      this.slides = this.getSlides();
    }
  }
  componentWillUnmount() {
    if (this.splide) {
      this.splide.destroy();
      this.splide = void 0;
    }
    this.options = void 0;
    this.slides.length = 0;
  }
  componentDidUpdate() {
    if (!this.splide) {
      return;
    }
    const { options } = this.props;
    if (options && !isEqualDeep(this.options, options)) {
      this.splide.options = options;
      this.options = merge2({}, options);
    }
    const newSlides = this.getSlides();
    if (!isEqualShallow(this.slides, newSlides)) {
      this.splide.refresh();
      this.slides = newSlides;
    }
  }
  sync(splide) {
    var _a;
    (_a = this.splide) == null ? void 0 : _a.sync(splide);
  }
  go(control) {
    var _a;
    (_a = this.splide) == null ? void 0 : _a.go(control);
  }
  getSlides() {
    var _a;
    if (this.splide) {
      const children2 = (_a = this.splide.Components.Elements) == null ? void 0 : _a.list.children;
      return children2 && Array.prototype.slice.call(children2) || [];
    }
    return [];
  }
  bind(splide) {
    EVENTS.forEach(([event, name]) => {
      const handler = this.props[name];
      if (typeof handler === "function") {
        splide.on(event, (...args) => {
          handler(splide, ...args);
        });
      }
    });
  }
  omit(props, keys) {
    keys.forEach((key) => {
      if (Object.prototype.hasOwnProperty.call(props, key)) {
        delete props[key];
      }
    });
    return props;
  }
  render() {
    const { className, tag: Root = "div", hasTrack = true, children: children2, ...props } = this.props;
    return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Root, {
      className: classNames("splide", className),
      ref: this.splideRef,
      ...this.omit(props, ["options", ...EVENTS.map((event) => event[1])])
    }, hasTrack ? /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement(SplideTrack, null, children2) : children2);
  }
};

// src/js/components/SplideSlide/SplideSlide.tsx

var SplideSlide = ({ children: children2, className, ...props }) => {
  return /* @__PURE__ */ react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", {
    className: classNames("splide__slide", className),
    ...props
  }, children2);
};

/*!
 * Splide.js
 * Version  : 4.1.3
 * License  : MIT
 * Copyright: 2022 Naotoshi Fujita
 */


/***/ }),

/***/ "./node_modules/@splidejs/splide-extension-auto-scroll/dist/js/splide-extension-auto-scroll.esm.js":
/*!*********************************************************************************************************!*\
  !*** ./node_modules/@splidejs/splide-extension-auto-scroll/dist/js/splide-extension-auto-scroll.esm.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AutoScroll: () => (/* binding */ AutoScroll)
/* harmony export */ });
/*!
 * @splidejs/splide-extension-auto-scroll
 * Version  : 0.5.3
 * License  : MIT
 * Copyright: 2022 Naotoshi Fujita
 */
function empty(array) {
  array.length = 0;
}

function slice$1(arrayLike, start, end) {
  return Array.prototype.slice.call(arrayLike, start, end);
}

function apply$1(func) {
  return func.bind.apply(func, [null].concat(slice$1(arguments, 1)));
}

function raf(func) {
  return requestAnimationFrame(func);
}

function typeOf$1(type, subject) {
  return typeof subject === type;
}

var isArray$1 = Array.isArray;
apply$1(typeOf$1, "function");
apply$1(typeOf$1, "string");
apply$1(typeOf$1, "undefined");

function toArray$1(value) {
  return isArray$1(value) ? value : [value];
}

function forEach$1(values, iteratee) {
  toArray$1(values).forEach(iteratee);
}

var ownKeys$1 = Object.keys;

function forOwn$1(object, iteratee, right) {
  if (object) {
    var keys = ownKeys$1(object);
    keys = right ? keys.reverse() : keys;

    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];

      if (key !== "__proto__") {
        if (iteratee(object[key], key) === false) {
          break;
        }
      }
    }
  }

  return object;
}

function assign$1(object) {
  slice$1(arguments, 1).forEach(function (source) {
    forOwn$1(source, function (value, key) {
      object[key] = source[key];
    });
  });
  return object;
}

var min$1 = Math.min;

function EventBinder() {
  var listeners = [];

  function bind(targets, events, callback, options) {
    forEachEvent(targets, events, function (target, event, namespace) {
      var isEventTarget = ("addEventListener" in target);
      var remover = isEventTarget ? target.removeEventListener.bind(target, event, callback, options) : target["removeListener"].bind(target, callback);
      isEventTarget ? target.addEventListener(event, callback, options) : target["addListener"](callback);
      listeners.push([target, event, namespace, callback, remover]);
    });
  }

  function unbind(targets, events, callback) {
    forEachEvent(targets, events, function (target, event, namespace) {
      listeners = listeners.filter(function (listener) {
        if (listener[0] === target && listener[1] === event && listener[2] === namespace && (!callback || listener[3] === callback)) {
          listener[4]();
          return false;
        }

        return true;
      });
    });
  }

  function dispatch(target, type, detail) {
    var e;
    var bubbles = true;

    if (typeof CustomEvent === "function") {
      e = new CustomEvent(type, {
        bubbles: bubbles,
        detail: detail
      });
    } else {
      e = document.createEvent("CustomEvent");
      e.initCustomEvent(type, bubbles, false, detail);
    }

    target.dispatchEvent(e);
    return e;
  }

  function forEachEvent(targets, events, iteratee) {
    forEach$1(targets, function (target) {
      target && forEach$1(events, function (events2) {
        events2.split(" ").forEach(function (eventNS) {
          var fragment = eventNS.split(".");
          iteratee(target, fragment[0], fragment[1]);
        });
      });
    });
  }

  function destroy() {
    listeners.forEach(function (data) {
      data[4]();
    });
    empty(listeners);
  }

  return {
    bind: bind,
    unbind: unbind,
    dispatch: dispatch,
    destroy: destroy
  };
}
var EVENT_MOVE = "move";
var EVENT_MOVED = "moved";
var EVENT_UPDATED = "updated";
var EVENT_DRAG = "drag";
var EVENT_DRAGGED = "dragged";
var EVENT_SCROLL = "scroll";
var EVENT_SCROLLED = "scrolled";
var EVENT_DESTROY = "destroy";

function EventInterface(Splide2) {
  var bus = Splide2 ? Splide2.event.bus : document.createDocumentFragment();
  var binder = EventBinder();

  function on(events, callback) {
    binder.bind(bus, toArray$1(events).join(" "), function (e) {
      callback.apply(callback, isArray$1(e.detail) ? e.detail : []);
    });
  }

  function emit(event) {
    binder.dispatch(bus, event, slice$1(arguments, 1));
  }

  if (Splide2) {
    Splide2.event.on(EVENT_DESTROY, binder.destroy);
  }

  return assign$1(binder, {
    bus: bus,
    on: on,
    off: apply$1(binder.unbind, bus),
    emit: emit
  });
}

function RequestInterval(interval, onInterval, onUpdate, limit) {
  var now = Date.now;
  var startTime;
  var rate = 0;
  var id;
  var paused = true;
  var count = 0;

  function update() {
    if (!paused) {
      rate = interval ? min$1((now() - startTime) / interval, 1) : 1;
      onUpdate && onUpdate(rate);

      if (rate >= 1) {
        onInterval();
        startTime = now();

        if (limit && ++count >= limit) {
          return pause();
        }
      }

      raf(update);
    }
  }

  function start(resume) {
    !resume && cancel();
    startTime = now() - (resume ? rate * interval : 0);
    paused = false;
    raf(update);
  }

  function pause() {
    paused = true;
  }

  function rewind() {
    startTime = now();
    rate = 0;

    if (onUpdate) {
      onUpdate(rate);
    }
  }

  function cancel() {
    id && cancelAnimationFrame(id);
    rate = 0;
    id = 0;
    paused = true;
  }

  function set(time) {
    interval = time;
  }

  function isPaused() {
    return paused;
  }

  return {
    start: start,
    rewind: rewind,
    pause: pause,
    cancel: cancel,
    set: set,
    isPaused: isPaused
  };
}

function Throttle(func, duration) {
  var interval;

  function throttled() {
    if (!interval) {
      interval = RequestInterval(duration || 0, function () {
        func();
        interval = null;
      }, null, 1);
      interval.start();
    }
  }

  return throttled;
}
var CLASS_ACTIVE = "is-active";

var SLIDE = "slide";
var FADE = "fade";

function slice(arrayLike, start, end) {
  return Array.prototype.slice.call(arrayLike, start, end);
}

function apply(func) {
  return func.bind(null, ...slice(arguments, 1));
}

function typeOf(type, subject) {
  return typeof subject === type;
}
function isObject(subject) {
  return !isNull(subject) && typeOf("object", subject);
}
const isArray = Array.isArray;
apply(typeOf, "function");
apply(typeOf, "string");
const isUndefined = apply(typeOf, "undefined");
function isNull(subject) {
  return subject === null;
}

function toArray(value) {
  return isArray(value) ? value : [value];
}

function forEach(values, iteratee) {
  toArray(values).forEach(iteratee);
}

function toggleClass(elm, classes, add) {
  if (elm) {
    forEach(classes, (name) => {
      if (name) {
        elm.classList[add ? "add" : "remove"](name);
      }
    });
  }
}

const ownKeys = Object.keys;

function forOwn(object, iteratee, right) {
  if (object) {
    let keys = ownKeys(object);
    keys = right ? keys.reverse() : keys;
    for (let i = 0; i < keys.length; i++) {
      const key = keys[i];
      if (key !== "__proto__") {
        if (iteratee(object[key], key) === false) {
          break;
        }
      }
    }
  }
  return object;
}

function assign(object) {
  slice(arguments, 1).forEach((source) => {
    forOwn(source, (value, key) => {
      object[key] = source[key];
    });
  });
  return object;
}

function removeAttribute(elms, attrs) {
  forEach(elms, (elm) => {
    forEach(attrs, (attr) => {
      elm && elm.removeAttribute(attr);
    });
  });
}

function setAttribute(elms, attrs, value) {
  if (isObject(attrs)) {
    forOwn(attrs, (value2, name) => {
      setAttribute(elms, name, value2);
    });
  } else {
    forEach(elms, (elm) => {
      isNull(value) || value === "" ? removeAttribute(elm, attrs) : elm.setAttribute(attrs, String(value));
    });
  }
}

const { min, max, floor, ceil, abs } = Math;

function clamp(number, x, y) {
  const minimum = min(x, y);
  const maximum = max(x, y);
  return min(max(minimum, number), maximum);
}

const DEFAULTS = {
  speed: 1,
  autoStart: true,
  pauseOnHover: true,
  pauseOnFocus: true
};

const I18N = {
  startScroll: "Start auto scroll",
  pauseScroll: "Pause auto scroll"
};

function AutoScroll(Splide2, Components2, options) {
  const { on, off, bind, unbind } = EventInterface(Splide2);
  const { translate, getPosition, toIndex, getLimit } = Components2.Move;
  const { setIndex, getIndex } = Components2.Controller;
  const { orient } = Components2.Direction;
  const { toggle } = Components2.Elements;
  const { Live } = Components2;
  const { root } = Splide2;
  const throttledUpdateArrows = Throttle(Components2.Arrows.update, 500);
  let autoScrollOptions = {};
  let interval;
  let stopped;
  let hovered;
  let focused;
  let busy;
  let currPosition;
  function setup() {
    const { autoScroll } = options;
    autoScrollOptions = assign({}, DEFAULTS, isObject(autoScroll) ? autoScroll : {});
  }
  function mount() {
    if (!Splide2.is(FADE)) {
      if (!interval && options.autoScroll !== false) {
        interval = RequestInterval(0, move);
        listen();
        autoStart();
      }
    }
  }
  function destroy() {
    if (interval) {
      interval.cancel();
      interval = null;
      currPosition = void 0;
      off([EVENT_MOVE, EVENT_DRAG, EVENT_SCROLL, EVENT_MOVED, EVENT_SCROLLED]);
      unbind(root, "mouseenter mouseleave focusin focusout");
      unbind(toggle, "click");
    }
  }
  function listen() {
    if (autoScrollOptions.pauseOnHover) {
      bind(root, "mouseenter mouseleave", (e) => {
        hovered = e.type === "mouseenter";
        autoToggle();
      });
    }
    if (autoScrollOptions.pauseOnFocus) {
      bind(root, "focusin focusout", (e) => {
        focused = e.type === "focusin";
        autoToggle();
      });
    }
    if (autoScrollOptions.useToggleButton) {
      bind(toggle, "click", () => {
        stopped ? play() : pause();
      });
    }
    on(EVENT_UPDATED, update);
    on([EVENT_MOVE, EVENT_DRAG, EVENT_SCROLL], () => {
      busy = true;
      pause(false);
    });
    on([EVENT_MOVED, EVENT_DRAGGED, EVENT_SCROLLED], () => {
      busy = false;
      autoToggle();
    });
  }
  function update() {
    const { autoScroll } = options;
    if (autoScroll !== false) {
      autoScrollOptions = assign({}, autoScrollOptions, isObject(autoScroll) ? autoScroll : {});
      mount();
    } else {
      destroy();
    }
    if (interval && !isUndefined(currPosition)) {
      translate(currPosition);
    }
  }
  function autoStart() {
    if (autoScrollOptions.autoStart) {
      if (document.readyState === "complete") {
        play();
      } else {
        bind(window, "load", play);
      }
    }
  }
  function play() {
    if (isPaused()) {
      interval.start(true);
      Live.disable(true);
      focused = hovered = stopped = false;
      updateButton();
    }
  }
  function pause(stop = true) {
    if (!stopped) {
      stopped = stop;
      updateButton();
      if (!isPaused()) {
        interval.pause();
        Live.disable(false);
      }
    }
  }
  function autoToggle() {
    if (!stopped) {
      hovered || focused || busy ? pause(false) : play();
    }
  }
  function move() {
    const position = getPosition();
    const destination = computeDestination(position);
    if (position !== destination) {
      translate(destination);
      updateIndex(currPosition = getPosition());
    } else {
      pause(false);
      if (autoScrollOptions.rewind) {
        Splide2.go(autoScrollOptions.speed > 0 ? 0 : Components2.Controller.getEnd());
      }
    }
    throttledUpdateArrows();
  }
  function computeDestination(position) {
    const speed = autoScrollOptions.speed || 1;
    position += orient(speed);
    if (Splide2.is(SLIDE)) {
      position = clamp(position, getLimit(false), getLimit(true));
    }
    return position;
  }
  function updateIndex(position) {
    const { length } = Splide2;
    const index = (toIndex(position) + length) % length;
    if (index !== getIndex()) {
      setIndex(index);
      Components2.Slides.update();
      Components2.Pagination.update();
      options.lazyLoad === "nearby" && Components2.LazyLoad.check();
    }
  }
  function updateButton() {
    if (toggle) {
      const key = stopped ? "startScroll" : "pauseScroll";
      toggleClass(toggle, CLASS_ACTIVE, !stopped);
      setAttribute(toggle, "aria-label", options.i18n[key] || I18N[key]);
    }
  }
  function isPaused() {
    return !interval || interval.isPaused();
  }
  return {
    setup,
    mount,
    destroy,
    play,
    pause,
    isPaused
  };
}




/***/ }),

/***/ "./node_modules/@splidejs/splide-extension-grid/dist/js/splide-extension-grid.esm.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@splidejs/splide-extension-grid/dist/js/splide-extension-grid.esm.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Grid: () => (/* binding */ Grid)
/* harmony export */ });
/*!
 * @splidejs/splide-extension-grid
 * Version  : 0.4.1
 * License  : MIT
 * Copyright: 2022 Naotoshi Fujita
 */
function empty$1(array) {
  array.length = 0;
}

function slice$1(arrayLike, start, end) {
  return Array.prototype.slice.call(arrayLike, start, end);
}

function apply$1(func) {
  return func.bind.apply(func, [null].concat(slice$1(arguments, 1)));
}

function typeOf$1(type, subject) {
  return typeof subject === type;
}

var isArray$1 = Array.isArray;
apply$1(typeOf$1, "function");
apply$1(typeOf$1, "string");
apply$1(typeOf$1, "undefined");

function toArray$1(value) {
  return isArray$1(value) ? value : [value];
}

function forEach$1(values, iteratee) {
  toArray$1(values).forEach(iteratee);
}

var ownKeys$1 = Object.keys;

function forOwn$1(object, iteratee, right) {
  if (object) {
    var keys = ownKeys$1(object);
    keys = right ? keys.reverse() : keys;

    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];

      if (key !== "__proto__") {
        if (iteratee(object[key], key) === false) {
          break;
        }
      }
    }
  }

  return object;
}

function assign$1(object) {
  slice$1(arguments, 1).forEach(function (source) {
    forOwn$1(source, function (value, key) {
      object[key] = source[key];
    });
  });
  return object;
}

var PROJECT_CODE$1 = "splide";

function EventBinder() {
  var listeners = [];

  function bind(targets, events, callback, options) {
    forEachEvent(targets, events, function (target, event, namespace) {
      var isEventTarget = ("addEventListener" in target);
      var remover = isEventTarget ? target.removeEventListener.bind(target, event, callback, options) : target["removeListener"].bind(target, callback);
      isEventTarget ? target.addEventListener(event, callback, options) : target["addListener"](callback);
      listeners.push([target, event, namespace, callback, remover]);
    });
  }

  function unbind(targets, events, callback) {
    forEachEvent(targets, events, function (target, event, namespace) {
      listeners = listeners.filter(function (listener) {
        if (listener[0] === target && listener[1] === event && listener[2] === namespace && (!callback || listener[3] === callback)) {
          listener[4]();
          return false;
        }

        return true;
      });
    });
  }

  function dispatch(target, type, detail) {
    var e;
    var bubbles = true;

    if (typeof CustomEvent === "function") {
      e = new CustomEvent(type, {
        bubbles: bubbles,
        detail: detail
      });
    } else {
      e = document.createEvent("CustomEvent");
      e.initCustomEvent(type, bubbles, false, detail);
    }

    target.dispatchEvent(e);
    return e;
  }

  function forEachEvent(targets, events, iteratee) {
    forEach$1(targets, function (target) {
      target && forEach$1(events, function (events2) {
        events2.split(" ").forEach(function (eventNS) {
          var fragment = eventNS.split(".");
          iteratee(target, fragment[0], fragment[1]);
        });
      });
    });
  }

  function destroy() {
    listeners.forEach(function (data) {
      data[4]();
    });
    empty$1(listeners);
  }

  return {
    bind: bind,
    unbind: unbind,
    dispatch: dispatch,
    destroy: destroy
  };
}
var EVENT_VISIBLE = "visible";
var EVENT_HIDDEN = "hidden";
var EVENT_REFRESH = "refresh";
var EVENT_UPDATED = "updated";
var EVENT_DESTROY = "destroy";

function EventInterface(Splide2) {
  var bus = Splide2 ? Splide2.event.bus : document.createDocumentFragment();
  var binder = EventBinder();

  function on(events, callback) {
    binder.bind(bus, toArray$1(events).join(" "), function (e) {
      callback.apply(callback, isArray$1(e.detail) ? e.detail : []);
    });
  }

  function emit(event) {
    binder.dispatch(bus, event, slice$1(arguments, 1));
  }

  if (Splide2) {
    Splide2.event.on(EVENT_DESTROY, binder.destroy);
  }

  return assign$1(binder, {
    bus: bus,
    on: on,
    off: apply$1(binder.unbind, bus),
    emit: emit
  });
}
var CLASS_ROOT = PROJECT_CODE$1;
var CLASS_SLIDE = PROJECT_CODE$1 + "__slide";
var CLASS_CONTAINER = CLASS_SLIDE + "__container";

function empty(array) {
  array.length = 0;
}

function slice(arrayLike, start, end) {
  return Array.prototype.slice.call(arrayLike, start, end);
}

function apply(func) {
  return func.bind(null, ...slice(arguments, 1));
}

function typeOf(type, subject) {
  return typeof subject === type;
}
function isObject(subject) {
  return !isNull(subject) && typeOf("object", subject);
}
const isArray = Array.isArray;
apply(typeOf, "function");
const isString = apply(typeOf, "string");
const isUndefined = apply(typeOf, "undefined");
function isNull(subject) {
  return subject === null;
}
function isHTMLElement(subject) {
  return subject instanceof HTMLElement;
}

function toArray(value) {
  return isArray(value) ? value : [value];
}

function forEach(values, iteratee) {
  toArray(values).forEach(iteratee);
}

function push(array, items) {
  array.push(...toArray(items));
  return array;
}

function toggleClass(elm, classes, add) {
  if (elm) {
    forEach(classes, (name) => {
      if (name) {
        elm.classList[add ? "add" : "remove"](name);
      }
    });
  }
}

function addClass(elm, classes) {
  toggleClass(elm, isString(classes) ? classes.split(" ") : classes, true);
}

function append(parent, children) {
  forEach(children, parent.appendChild.bind(parent));
}

function matches(elm, selector) {
  return isHTMLElement(elm) && (elm["msMatchesSelector"] || elm.matches).call(elm, selector);
}

function children(parent, selector) {
  const children2 = parent ? slice(parent.children) : [];
  return selector ? children2.filter((child) => matches(child, selector)) : children2;
}

function child(parent, selector) {
  return selector ? children(parent, selector)[0] : parent.firstElementChild;
}

const ownKeys = Object.keys;

function forOwn(object, iteratee, right) {
  if (object) {
    let keys = ownKeys(object);
    keys = right ? keys.reverse() : keys;
    for (let i = 0; i < keys.length; i++) {
      const key = keys[i];
      if (key !== "__proto__") {
        if (iteratee(object[key], key) === false) {
          break;
        }
      }
    }
  }
  return object;
}

function assign(object) {
  slice(arguments, 1).forEach((source) => {
    forOwn(source, (value, key) => {
      object[key] = source[key];
    });
  });
  return object;
}

function omit(object, keys) {
  toArray(keys || ownKeys(object)).forEach((key) => {
    delete object[key];
  });
}

function removeAttribute(elms, attrs) {
  forEach(elms, (elm) => {
    forEach(attrs, (attr) => {
      elm && elm.removeAttribute(attr);
    });
  });
}

function setAttribute(elms, attrs, value) {
  if (isObject(attrs)) {
    forOwn(attrs, (value2, name) => {
      setAttribute(elms, name, value2);
    });
  } else {
    forEach(elms, (elm) => {
      isNull(value) || value === "" ? removeAttribute(elm, attrs) : elm.setAttribute(attrs, String(value));
    });
  }
}

function create(tag, attrs, parent) {
  const elm = document.createElement(tag);
  if (attrs) {
    isString(attrs) ? addClass(elm, attrs) : setAttribute(elm, attrs);
  }
  parent && append(parent, elm);
  return elm;
}

function style(elm, prop, value) {
  if (isUndefined(value)) {
    return getComputedStyle(elm)[prop];
  }
  if (!isNull(value)) {
    elm.style[prop] = `${value}`;
  }
}

function hasClass(elm, className) {
  return elm && elm.classList.contains(className);
}

function remove(nodes) {
  forEach(nodes, (node) => {
    if (node && node.parentNode) {
      node.parentNode.removeChild(node);
    }
  });
}

function queryAll(parent, selector) {
  return selector ? slice(parent.querySelectorAll(selector)) : [];
}

function removeClass(elm, classes) {
  toggleClass(elm, classes, false);
}

function unit(value) {
  return isString(value) ? value : value ? `${value}px` : "";
}

const PROJECT_CODE = "splide";

function assert(condition, message) {
  if (!condition) {
    throw new Error(`[${PROJECT_CODE}] ${message || ""}`);
  }
}

const { min, max, floor, ceil, abs } = Math;

function pad(number) {
  return number < 10 ? `0${number}` : `${number}`;
}

const CLASS_SLIDE_ROW = `${CLASS_SLIDE}__row`;
const CLASS_SLIDE_COL = `${CLASS_SLIDE}--col`;

const DEFAULTS = {
  rows: 1,
  cols: 1,
  dimensions: [],
  gap: {}
};

function Dimension(options) {
  function normalize() {
    const { rows, cols, dimensions } = options;
    return isArray(dimensions) && dimensions.length ? dimensions : [[rows, cols]];
  }
  function get(index) {
    const dimensions = normalize();
    return dimensions[min(index, dimensions.length - 1)];
  }
  function getAt(index) {
    const dimensions = normalize();
    let rows, cols, aggregator = 0;
    for (let i = 0; i < dimensions.length; i++) {
      const dimension = dimensions[i];
      rows = dimension[0] || 1;
      cols = dimension[1] || 1;
      aggregator += rows * cols;
      if (index < aggregator) {
        break;
      }
    }
    assert(rows && cols, "Invalid dimension");
    return [rows, cols];
  }
  return {
    get,
    getAt
  };
}

function Layout(Splide2, gridOptions, Dimension) {
  const { on, destroy: destroyEvent } = EventInterface(Splide2);
  const { Components, options } = Splide2;
  const { resolve } = Components.Direction;
  const { forEach } = Components.Slides;
  function mount() {
    layout();
    if (options.slideFocus) {
      on(EVENT_VISIBLE, onVisible);
      on(EVENT_HIDDEN, onHidden);
    }
  }
  function destroy() {
    forEach((Slide) => {
      const { slide } = Slide;
      toggleTabIndex(slide, false);
      getRowsIn(slide).forEach((cell) => {
        removeAttribute(cell, "style");
      });
      getColsIn(slide).forEach((colSlide) => {
        cover(colSlide, true);
        removeAttribute(colSlide, "style");
      });
    });
    destroyEvent();
  }
  function layout() {
    forEach((Slide) => {
      const { slide } = Slide;
      const [rows, cols] = Dimension.get(Slide.isClone ? Slide.slideIndex : Slide.index);
      layoutRow(rows, slide);
      layoutCol(cols, slide);
      getColsIn(Slide.slide).forEach((colSlide, index) => {
        colSlide.id = `${Slide.slide.id}-col${pad(index + 1)}`;
        if (Splide2.options.cover) {
          cover(colSlide);
        }
      });
    });
  }
  function layoutRow(rows, slide) {
    const { row: rowGap } = gridOptions.gap;
    const height = `calc(${100 / rows}%${rowGap ? ` - ${unit(rowGap)} * ${(rows - 1) / rows}` : ""})`;
    getRowsIn(slide).forEach((rowElm, index, rowElms) => {
      style(rowElm, "height", height);
      style(rowElm, "display", "flex");
      style(rowElm, "margin", `0 0 ${unit(rowGap)} 0`);
      style(rowElm, "padding", 0);
      if (index === rowElms.length - 1) {
        style(rowElm, "marginBottom", 0);
      }
    });
  }
  function layoutCol(cols, slide) {
    const { col: colGap } = gridOptions.gap;
    const width = `calc(${100 / cols}%${colGap ? ` - ${unit(colGap)} * ${(cols - 1) / cols}` : ""})`;
    getColsIn(slide).forEach((colElm, index, colElms) => {
      style(colElm, "width", width);
      if (index !== colElms.length - 1) {
        style(colElm, resolve("marginRight"), unit(colGap));
      }
    });
  }
  function cover(colSlide, uncover) {
    const container = child(colSlide, `.${CLASS_CONTAINER}`);
    const img = child(container || colSlide, "img");
    if (img && img.src) {
      style(container || colSlide, "background", uncover ? "" : `center/cover no-repeat url("${img.src}")`);
      style(img, "display", uncover ? "" : "none");
    }
  }
  function getRowsIn(slide) {
    return queryAll(slide, `.${CLASS_SLIDE_ROW}`);
  }
  function getColsIn(slide) {
    return queryAll(slide, `.${CLASS_SLIDE_COL}`);
  }
  function toggleTabIndex(slide, add) {
    getColsIn(slide).forEach((colSlide) => {
      setAttribute(colSlide, "tabindex", add ? 0 : null);
    });
  }
  function onVisible(Slide) {
    toggleTabIndex(Slide.slide, true);
  }
  function onHidden(Slide) {
    toggleTabIndex(Slide.slide, false);
  }
  return {
    mount,
    destroy
  };
}

function Grid(Splide2, Components2, options) {
  const { on, off } = EventInterface(Splide2);
  const { Elements } = Components2;
  const gridOptions = {};
  const Dimension$1 = Dimension(gridOptions);
  const Layout$1 = Layout(Splide2, gridOptions, Dimension$1);
  const modifier = `${CLASS_ROOT}--grid`;
  const originalSlides = [];
  function mount() {
    init();
    on(EVENT_UPDATED, init);
  }
  function init() {
    omit(gridOptions);
    assign(gridOptions, DEFAULTS, options.grid || {});
    if (shouldBuild()) {
      destroy();
      push(originalSlides, Elements.slides);
      addClass(Splide2.root, modifier);
      append(Elements.list, build());
      off(EVENT_REFRESH);
      on(EVENT_REFRESH, layout);
      refresh();
    } else if (isActive()) {
      destroy();
      refresh();
    }
  }
  function destroy() {
    if (isActive()) {
      const { slides } = Elements;
      Layout$1.destroy();
      originalSlides.forEach((slide) => {
        removeClass(slide, CLASS_SLIDE_COL);
        append(Elements.list, slide);
      });
      remove(slides);
      removeClass(Splide2.root, modifier);
      empty(slides);
      push(slides, originalSlides);
      empty(originalSlides);
      off(EVENT_REFRESH);
    }
  }
  function refresh() {
    Splide2.refresh();
  }
  function layout() {
    if (isActive()) {
      Layout$1.mount();
    }
  }
  function build() {
    const outerSlides = [];
    let row = 0, col = 0;
    let outerSlide, rowSlide;
    originalSlides.forEach((slide, index) => {
      const [rows, cols] = Dimension$1.getAt(index);
      if (!col) {
        if (!row) {
          outerSlide = create(slide.tagName, CLASS_SLIDE);
          outerSlides.push(outerSlide);
        }
        rowSlide = buildRow(rows, slide, outerSlide);
      }
      buildCol(cols, slide, rowSlide);
      if (++col >= cols) {
        col = 0;
        row = ++row >= rows ? 0 : row;
      }
    });
    return outerSlides;
  }
  function buildRow(rows, slide, outerSlide) {
    const tag = slide.tagName.toLowerCase() === "li" ? "ul" : "div";
    return create(tag, CLASS_SLIDE_ROW, outerSlide);
  }
  function buildCol(cols, slide, rowSlide) {
    addClass(slide, CLASS_SLIDE_COL);
    append(rowSlide, slide);
    return slide;
  }
  function shouldBuild() {
    if (options.grid) {
      const { rows, cols, dimensions } = gridOptions;
      return rows > 1 || cols > 1 || isArray(dimensions) && dimensions.length > 0;
    }
    return false;
  }
  function isActive() {
    return hasClass(Splide2.root, modifier);
  }
  return {
    mount,
    destroy
  };
}




/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/icon/index.js":
/*!******************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/icon/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/**
 * WordPress dependencies
 */


/** @typedef {{icon: JSX.Element, size?: number} & import('@wordpress/primitives').SVGProps} IconProps */

/**
 * Return an SVG icon.
 *
 * @param {IconProps}                                 props icon is the SVG component to render
 *                                                          size is a number specifiying the icon size in pixels
 *                                                          Other props will be passed to wrapped SVG component
 * @param {import('react').ForwardedRef<HTMLElement>} ref   The forwarded ref to the SVG element.
 *
 * @return {JSX.Element}  Icon component
 */
function Icon({
  icon,
  size = 24,
  ...props
}, ref) {
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.cloneElement)(icon, {
    width: size,
    height: size,
    ...props,
    ref
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(Icon));
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/add-card.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/add-card.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const addCard = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M18.5 5.5V8H20V5.5h2.5V4H20V1.5h-1.5V4H16v1.5h2.5zM12 4H6a2 2 0 00-2 2v12a2 2 0 002 2h12a2 2 0 002-2v-6h-1.5v6a.5.5 0 01-.5.5H6a.5.5 0 01-.5-.5V6a.5.5 0 01.5-.5h6V4z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (addCard);
//# sourceMappingURL=add-card.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/arrow-right.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/arrow-right.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const arrowRight = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "m14.5 6.5-1 1 3.7 3.7H4v1.6h13.2l-3.7 3.7 1 1 5.6-5.5z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (arrowRight);
//# sourceMappingURL=arrow-right.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/brush.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/brush.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const brush = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M4 20h8v-1.5H4V20zM18.9 3.5c-.6-.6-1.5-.6-2.1 0l-7.2 7.2c-.4-.1-.7 0-1.1.1-.5.2-1.5.7-1.9 2.2-.4 1.7-.8 2.2-1.1 2.7-.1.1-.2.3-.3.4l-.6 1.1H6c2 0 3.4-.4 4.7-1.4.8-.6 1.2-1.4 1.3-2.3 0-.3 0-.5-.1-.7L19 5.7c.5-.6.5-1.6-.1-2.2zM9.7 14.7c-.7.5-1.5.8-2.4 1 .2-.5.5-1.2.8-2.3.2-.6.4-1 .8-1.1.5-.1 1 .1 1.3.3.2.2.3.5.2.8 0 .3-.1.9-.7 1.3z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (brush);
//# sourceMappingURL=brush.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/calendar.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/calendar.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const calendar = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm.5 16c0 .3-.2.5-.5.5H5c-.3 0-.5-.2-.5-.5V7h15v12zM9 10H7v2h2v-2zm0 4H7v2h2v-2zm4-4h-2v2h2v-2zm4 0h-2v2h2v-2zm-4 4h-2v2h2v-2zm4 0h-2v2h2v-2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (calendar);
//# sourceMappingURL=calendar.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/category.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/category.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const category = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M6 5.5h3a.5.5 0 01.5.5v3a.5.5 0 01-.5.5H6a.5.5 0 01-.5-.5V6a.5.5 0 01.5-.5zM4 6a2 2 0 012-2h3a2 2 0 012 2v3a2 2 0 01-2 2H6a2 2 0 01-2-2V6zm11-.5h3a.5.5 0 01.5.5v3a.5.5 0 01-.5.5h-3a.5.5 0 01-.5-.5V6a.5.5 0 01.5-.5zM13 6a2 2 0 012-2h3a2 2 0 012 2v3a2 2 0 01-2 2h-3a2 2 0 01-2-2V6zm5 8.5h-3a.5.5 0 00-.5.5v3a.5.5 0 00.5.5h3a.5.5 0 00.5-.5v-3a.5.5 0 00-.5-.5zM15 13a2 2 0 00-2 2v3a2 2 0 002 2h3a2 2 0 002-2v-3a2 2 0 00-2-2h-3zm-9 1.5h3a.5.5 0 01.5.5v3a.5.5 0 01-.5.5H6a.5.5 0 01-.5-.5v-3a.5.5 0 01.5-.5zM4 15a2 2 0 012-2h3a2 2 0 012 2v3a2 2 0 01-2 2H6a2 2 0 01-2-2v-3z",
  fillRule: "evenodd",
  clipRule: "evenodd"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (category);
//# sourceMappingURL=category.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/check.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/check.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const check = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M16.7 7.1l-6.3 8.5-3.3-2.5-.9 1.2 4.5 3.4L17.9 8z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (check);
//# sourceMappingURL=check.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/chevron-down.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/chevron-down.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const chevronDown = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M17.5 11.6L12 16l-5.5-4.4.9-1.2L12 14l4.5-3.6 1 1.2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (chevronDown);
//# sourceMappingURL=chevron-down.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/chevron-up.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/chevron-up.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const chevronUp = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M6.5 12.4L12 8l5.5 4.4-.9 1.2L12 10l-4.5 3.6-1-1.2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (chevronUp);
//# sourceMappingURL=chevron-up.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/close-small.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/close-small.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const closeSmall = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M12 13.06l3.712 3.713 1.061-1.06L13.061 12l3.712-3.712-1.06-1.06L12 10.938 8.288 7.227l-1.061 1.06L10.939 12l-3.712 3.712 1.06 1.061L12 13.061z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (closeSmall);
//# sourceMappingURL=close-small.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/close.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/close.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const close = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M13 11.8l6.1-6.3-1-1-6.1 6.2-6.1-6.2-1 1 6.1 6.3-6.5 6.7 1 1 6.5-6.6 6.5 6.6 1-1z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (close);
//# sourceMappingURL=close.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/cog.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/cog.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const cog = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  fillRule: "evenodd",
  d: "M10.289 4.836A1 1 0 0111.275 4h1.306a1 1 0 01.987.836l.244 1.466c.787.26 1.503.679 2.108 1.218l1.393-.522a1 1 0 011.216.437l.653 1.13a1 1 0 01-.23 1.273l-1.148.944a6.025 6.025 0 010 2.435l1.149.946a1 1 0 01.23 1.272l-.653 1.13a1 1 0 01-1.216.437l-1.394-.522c-.605.54-1.32.958-2.108 1.218l-.244 1.466a1 1 0 01-.987.836h-1.306a1 1 0 01-.986-.836l-.244-1.466a5.995 5.995 0 01-2.108-1.218l-1.394.522a1 1 0 01-1.217-.436l-.653-1.131a1 1 0 01.23-1.272l1.149-.946a6.026 6.026 0 010-2.435l-1.148-.944a1 1 0 01-.23-1.272l.653-1.131a1 1 0 011.217-.437l1.393.522a5.994 5.994 0 012.108-1.218l.244-1.466zM14.929 12a3 3 0 11-6 0 3 3 0 016 0z",
  clipRule: "evenodd"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (cog);
//# sourceMappingURL=cog.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/columns.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/columns.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const columns = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M15 7.5h-5v10h5v-10Zm1.5 0v10H19a.5.5 0 0 0 .5-.5V8a.5.5 0 0 0-.5-.5h-2.5ZM6 7.5h2.5v10H6a.5.5 0 0 1-.5-.5V8a.5.5 0 0 1 .5-.5ZM6 6h13a2 2 0 0 1 2 2v9a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (columns);
//# sourceMappingURL=columns.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/copy-small.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/copy-small.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const copySmall = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M5.625 5.5h9.75c.069 0 .125.056.125.125v9.75a.125.125 0 0 1-.125.125h-9.75a.125.125 0 0 1-.125-.125v-9.75c0-.069.056-.125.125-.125ZM4 5.625C4 4.728 4.728 4 5.625 4h9.75C16.273 4 17 4.728 17 5.625v9.75c0 .898-.727 1.625-1.625 1.625h-9.75A1.625 1.625 0 0 1 4 15.375v-9.75Zm14.5 11.656v-9H20v9C20 18.8 18.77 20 17.251 20H6.25v-1.5h11.001c.69 0 1.249-.528 1.249-1.219Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (copySmall);
//# sourceMappingURL=copy-small.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/copy.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/copy.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const copy = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M5 4.5h11a.5.5 0 0 1 .5.5v11a.5.5 0 0 1-.5.5H5a.5.5 0 0 1-.5-.5V5a.5.5 0 0 1 .5-.5ZM3 5a2 2 0 0 1 2-2h11a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5Zm17 3v10.75c0 .69-.56 1.25-1.25 1.25H6v1.5h12.75a2.75 2.75 0 0 0 2.75-2.75V8H20Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (copy);
//# sourceMappingURL=copy.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/format-capitalize.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/format-capitalize.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const formatCapitalize = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M7.1 6.8L3.1 18h1.6l1.1-3h4.3l1.1 3h1.6l-4-11.2H7.1zm-.8 6.8L8 8.9l1.7 4.7H6.3zm14.5-1.5c-.3-.6-.7-1.1-1.2-1.5-.6-.4-1.2-.6-1.9-.6-.5 0-.9.1-1.4.3-.4.2-.8.5-1.1.8V6h-1.4v12h1.3l.2-1c.2.4.6.6 1 .8.4.2.9.3 1.4.3.7 0 1.2-.2 1.8-.5.5-.4 1-.9 1.3-1.5.3-.6.5-1.3.5-2.1-.1-.6-.2-1.3-.5-1.9zm-1.7 4c-.4.5-.9.8-1.6.8s-1.2-.2-1.7-.7c-.4-.5-.7-1.2-.7-2.1 0-.9.2-1.6.7-2.1.4-.5 1-.7 1.7-.7s1.2.3 1.6.8c.4.5.6 1.2.6 2 .1.8-.2 1.4-.6 2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (formatCapitalize);
//# sourceMappingURL=format-capitalize.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/format-lowercase.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/format-lowercase.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const formatLowercase = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M11 16.8c-.1-.1-.2-.3-.3-.5v-2.6c0-.9-.1-1.7-.3-2.2-.2-.5-.5-.9-.9-1.2-.4-.2-.9-.3-1.6-.3-.5 0-1 .1-1.5.2s-.9.3-1.2.6l.2 1.2c.4-.3.7-.4 1.1-.5.3-.1.7-.2 1-.2.6 0 1 .1 1.3.4.3.2.4.7.4 1.4-1.2 0-2.3.2-3.3.7s-1.4 1.1-1.4 2.1c0 .7.2 1.2.7 1.6.4.4 1 .6 1.8.6.9 0 1.7-.4 2.4-1.2.1.3.2.5.4.7.1.2.3.3.6.4.3.1.6.1 1.1.1h.1l.2-1.2h-.1c-.4.1-.6 0-.7-.1zM9.2 16c-.2.3-.5.6-.9.8-.3.1-.7.2-1.1.2-.4 0-.7-.1-.9-.3-.2-.2-.3-.5-.3-.9 0-.6.2-1 .7-1.3.5-.3 1.3-.4 2.5-.5v2zm10.6-3.9c-.3-.6-.7-1.1-1.2-1.5-.6-.4-1.2-.6-1.9-.6-.5 0-.9.1-1.4.3-.4.2-.8.5-1.1.8V6h-1.4v12h1.3l.2-1c.2.4.6.6 1 .8.4.2.9.3 1.4.3.7 0 1.2-.2 1.8-.5.5-.4 1-.9 1.3-1.5.3-.6.5-1.3.5-2.1-.1-.6-.2-1.3-.5-1.9zm-1.7 4c-.4.5-.9.8-1.6.8s-1.2-.2-1.7-.7c-.4-.5-.7-1.2-.7-2.1 0-.9.2-1.6.7-2.1.4-.5 1-.7 1.7-.7s1.2.3 1.6.8c.4.5.6 1.2.6 2s-.2 1.4-.6 2z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (formatLowercase);
//# sourceMappingURL=format-lowercase.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/format-uppercase.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/format-uppercase.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const formatUppercase = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M6.1 6.8L2.1 18h1.6l1.1-3h4.3l1.1 3h1.6l-4-11.2H6.1zm-.8 6.8L7 8.9l1.7 4.7H5.3zm15.1-.7c-.4-.5-.9-.8-1.6-1 .4-.2.7-.5.8-.9.2-.4.3-.9.3-1.4 0-.9-.3-1.6-.8-2-.6-.5-1.3-.7-2.4-.7h-3.5V18h4.2c1.1 0 2-.3 2.6-.8.6-.6 1-1.4 1-2.4-.1-.8-.3-1.4-.6-1.9zm-5.7-4.7h1.8c.6 0 1.1.1 1.4.4.3.2.5.7.5 1.3 0 .6-.2 1.1-.5 1.3-.3.2-.8.4-1.4.4h-1.8V8.2zm4 8c-.4.3-.9.5-1.5.5h-2.6v-3.8h2.6c1.4 0 2 .6 2 1.9.1.6-.1 1-.5 1.4z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (formatUppercase);
//# sourceMappingURL=format-uppercase.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/help.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/help.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const help = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M12 4.75a7.25 7.25 0 100 14.5 7.25 7.25 0 000-14.5zM3.25 12a8.75 8.75 0 1117.5 0 8.75 8.75 0 01-17.5 0zM12 8.75a1.5 1.5 0 01.167 2.99c-.465.052-.917.44-.917 1.01V14h1.5v-.845A3 3 0 109 10.25h1.5a1.5 1.5 0 011.5-1.5zM11.25 15v1.5h1.5V15h-1.5z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (help);
//# sourceMappingURL=help.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/link.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/link.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const link = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M10 17.389H8.444A5.194 5.194 0 1 1 8.444 7H10v1.5H8.444a3.694 3.694 0 0 0 0 7.389H10v1.5ZM14 7h1.556a5.194 5.194 0 0 1 0 10.39H14v-1.5h1.556a3.694 3.694 0 0 0 0-7.39H14V7Zm-4.5 6h5v-1.5h-5V13Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (link);
//# sourceMappingURL=link.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/menu.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/menu.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const menu = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M5 5v1.5h14V5H5zm0 7.8h14v-1.5H5v1.5zM5 19h14v-1.5H5V19z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (menu);
//# sourceMappingURL=menu.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/page.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/page.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const page = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M15.5 7.5h-7V9h7V7.5Zm-7 3.5h7v1.5h-7V11Zm7 3.5h-7V16h7v-1.5Z"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M17 4H7a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2ZM7 5.5h10a.5.5 0 0 1 .5.5v12a.5.5 0 0 1-.5.5H7a.5.5 0 0 1-.5-.5V6a.5.5 0 0 1 .5-.5Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (page);
//# sourceMappingURL=page.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/pages.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/pages.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const pages = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M14.5 5.5h-7V7h7V5.5ZM7.5 9h7v1.5h-7V9Zm7 3.5h-7V14h7v-1.5Z"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M16 2H6a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2ZM6 3.5h10a.5.5 0 0 1 .5.5v12a.5.5 0 0 1-.5.5H6a.5.5 0 0 1-.5-.5V4a.5.5 0 0 1 .5-.5Z"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M20 8v11c0 .69-.31 1-.999 1H6v1.5h13.001c1.52 0 2.499-.982 2.499-2.5V8H20Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (pages);
//# sourceMappingURL=pages.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/pencil.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/pencil.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const pencil = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "m19 7-3-3-8.5 8.5-1 4 4-1L19 7Zm-7 11.5H5V20h7v-1.5Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (pencil);
//# sourceMappingURL=pencil.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/plus.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/plus.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const plus = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M11 12.5V17.5H12.5V12.5H17.5V11H12.5V6H11V11H6V12.5H11Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (plus);
//# sourceMappingURL=plus.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/post-comments.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/post-comments.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const postComments = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M14 10.1V4c0-.6-.4-1-1-1H5c-.6 0-1 .4-1 1v8.3c0 .3.2.7.6.8.1.1.2.1.3.1.2 0 .5-.1.6-.3l1.8-1.8H13c.6 0 1-.4 1-1zm-1.5-.5H6.7l-1.2 1.2V4.5h7v5.1zM19 12h-8c-.6 0-1 .4-1 1v6.1c0 .6.4 1 1 1h5.7l1.8 1.8c.1.2.4.3.6.3.1 0 .2 0 .3-.1.4-.1.6-.5.6-.8V13c0-.6-.4-1-1-1zm-.5 7.8l-1.2-1.2h-5.8v-5.1h7v6.3z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (postComments);
//# sourceMappingURL=post-comments.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/settings.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/settings.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const settings = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "m19 7.5h-7.628c-.3089-.87389-1.1423-1.5-2.122-1.5-.97966 0-1.81309.62611-2.12197 1.5h-2.12803v1.5h2.12803c.30888.87389 1.14231 1.5 2.12197 1.5.9797 0 1.8131-.62611 2.122-1.5h7.628z"
}), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "m19 15h-2.128c-.3089-.8739-1.1423-1.5-2.122-1.5s-1.8131.6261-2.122 1.5h-7.628v1.5h7.628c.3089.8739 1.1423 1.5 2.122 1.5s1.8131-.6261 2.122-1.5h2.128z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (settings);
//# sourceMappingURL=settings.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/star-empty.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/star-empty.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const starEmpty = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  fillRule: "evenodd",
  d: "M9.706 8.646a.25.25 0 01-.188.137l-4.626.672a.25.25 0 00-.139.427l3.348 3.262a.25.25 0 01.072.222l-.79 4.607a.25.25 0 00.362.264l4.138-2.176a.25.25 0 01.233 0l4.137 2.175a.25.25 0 00.363-.263l-.79-4.607a.25.25 0 01.072-.222l3.347-3.262a.25.25 0 00-.139-.427l-4.626-.672a.25.25 0 01-.188-.137l-2.069-4.192a.25.25 0 00-.448 0L9.706 8.646zM12 7.39l-.948 1.921a1.75 1.75 0 01-1.317.957l-2.12.308 1.534 1.495c.412.402.6.982.503 1.55l-.362 2.11 1.896-.997a1.75 1.75 0 011.629 0l1.895.997-.362-2.11a1.75 1.75 0 01.504-1.55l1.533-1.495-2.12-.308a1.75 1.75 0 01-1.317-.957L12 7.39z",
  clipRule: "evenodd"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (starEmpty);
//# sourceMappingURL=star-empty.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/star-filled.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/star-filled.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const starFilled = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M11.776 4.454a.25.25 0 01.448 0l2.069 4.192a.25.25 0 00.188.137l4.626.672a.25.25 0 01.139.426l-3.348 3.263a.25.25 0 00-.072.222l.79 4.607a.25.25 0 01-.362.263l-4.138-2.175a.25.25 0 00-.232 0l-4.138 2.175a.25.25 0 01-.363-.263l.79-4.607a.25.25 0 00-.071-.222L4.754 9.881a.25.25 0 01.139-.426l4.626-.672a.25.25 0 00.188-.137l2.069-4.192z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (starFilled);
//# sourceMappingURL=star-filled.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/store.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/store.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const store = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  fillRule: "evenodd",
  d: "M19.75 11H21V8.667L19.875 4H4.125L3 8.667V11h1.25v8.75h15.5V11zm-1.5 0H5.75v7.25H10V13h4v5.25h4.25V11zm-5.5-5.5h2.067l.486 3.24.028.76H12.75v-4zm-3.567 0h2.067v4H8.669l.028-.76.486-3.24zm7.615 3.1l-.464-3.1h2.36l.806 3.345V9.5h-2.668l-.034-.9zM7.666 5.5h-2.36L4.5 8.845V9.5h2.668l.034-.9.464-3.1z",
  clipRule: "evenodd"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);
//# sourceMappingURL=store.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/styles.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/styles.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   styles: () => (/* binding */ styles)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const styles = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  d: "M12 4c-4.4 0-8 3.6-8 8v.1c0 4.1 3.2 7.5 7.2 7.9h.8c4.4 0 8-3.6 8-8s-3.6-8-8-8zm0 15V5c3.9 0 7 3.1 7 7s-3.1 7-7 7z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (styles);
//# sourceMappingURL=styles.js.map

/***/ }),

/***/ "./node_modules/@wordpress/icons/build-module/library/trash.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/icons/build-module/library/trash.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/primitives */ "@wordpress/primitives");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);

/**
 * WordPress dependencies
 */

const trash = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__.Path, {
  fillRule: "evenodd",
  clipRule: "evenodd",
  d: "M12 5.5A2.25 2.25 0 0 0 9.878 7h4.244A2.251 2.251 0 0 0 12 5.5ZM12 4a3.751 3.751 0 0 0-3.675 3H5v1.5h1.27l.818 8.997a2.75 2.75 0 0 0 2.739 2.501h4.347a2.75 2.75 0 0 0 2.738-2.5L17.73 8.5H19V7h-3.325A3.751 3.751 0 0 0 12 4Zm4.224 4.5H7.776l.806 8.861a1.25 1.25 0 0 0 1.245 1.137h4.347a1.25 1.25 0 0 0 1.245-1.137l.805-8.861Z"
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (trash);
//# sourceMappingURL=trash.js.map

/***/ }),

/***/ "./src/app.js":
/*!********************!*\
  !*** ./src/app.js ***!
  \********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _components_Builder__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./components/Builder */ "./src/components/Builder/index.js");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);



document.addEventListener("DOMContentLoaded", DOMContentLoadedImport);
function DOMContentLoadedImport() {
  var appData = {
    name: "Product Slider for WooCommerce ",
    version: "1.0.0",
    demoUrl: "https://demo.pickplugins.com/woocommerce-products-slider/",
    reviewsUrl: "https://wordpress.org/support/plugin/woocommerce-products-slider/reviews/#new-post/"
  };
  window.PostGrid = {};
  window.PostGrid = appData;
  _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_1___default()({
    path: "/wcps/v2/get_options",
    method: "POST",
    data: {
      option: "wcps_settings"
    }
  }).then(res => {
    if (res.length != 0) {
      var resX = {
        ...res
      };
      var license_key = resX?.license_key;
      window.PostGrid = {
        ...appData,
        license_key: license_key
      };
    }
  });

  // console.log(window.PostGrid)

  setTimeout(() => {
    var builderWrap = document.querySelector('#builder');
    if (builderWrap != null) {
      wp.element.render(/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_components_Builder__WEBPACK_IMPORTED_MODULE_0__["default"], {
        appData: appData
      }), builderWrap);
    }
  }, 2000);
}

/***/ }),

/***/ "./src/breakpoints.js":
/*!****************************!*\
  !*** ./src/breakpoints.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const breakPoints = {
  Mobile: {
    name: "Mobile",
    id: "Mobile",
    icon: '<span class="dashicons dashicons-smartphone">',
    min: 0,
    max: 767
  },
  Tablet: {
    name: "Tablet",
    id: "Tablet",
    icon: '<span class="dashicons dashicons-tablet"></span>',
    min: 768,
    max: 991
  },
  Desktop: {
    name: "Desktop",
    id: "Desktop",
    icon: '<span class="dashicons dashicons-desktop"></span>',
    min: 992,
    max: 1280
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (breakPoints);

/***/ }),

/***/ "./src/colors-presets.js":
/*!*******************************!*\
  !*** ./src/colors-presets.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const colorsPresets = [{
  name: '9DD6DF',
  color: '#9DD6DF'
}, {
  name: '18978F',
  color: '#18978F'
}, {
  name: 'A084CF',
  color: '#A084CF'
}, {
  name: 'DFBB9D',
  color: '#DFBB9D'
}, {
  name: '774360',
  color: '#774360'
}, {
  name: '3AB0FF',
  color: '#3AB0FF'
}, {
  name: '51557E',
  color: '#51557E'
}];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (colorsPresets);

/***/ }),

/***/ "./src/components/BuilderView/LoopItems.js":
/*!*************************************************!*\
  !*** ./src/components/BuilderView/LoopItems.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





function Html(props) {
  if (!props.warn) {
    return null;
  }
  var loopLayout = props.loopLayout;
  var itemData = props.itemData;
  const LoopItemsNode = ({
    node,
    itemData
  }) => {
    var nodeType = node.type;
    if (nodeType == "root" || nodeType == "container" || nodeType == "layer") {
      var animateOn = node?.options?.animateOn;
      var animateOnRules = animateOn?.rules;
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        id: `element-${node.id}`,
        className: `${node.type}`,
        "data-animateon": animateOnRules?.length > 0 ? JSON.stringify(animateOnRules) : null,
        children: node.children && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
          children: node.children.map(child => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(LoopItemsNode, {
            node: child,
            itemData: itemData
          }, child?.id))
        })
      });
    } else {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(GenerateNodeHtml, {
        node: node,
        itemData: itemData
      });
    }
  };
  const GenerateNodeHtml = ({
    node,
    itemData
  }) => {
    var nodeType = node.type;
    var html = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.applyFilters)("PostGridElementHtml" + nodeType, '', itemData, node);
    return html;
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
    children: loopLayout.map(node => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(LoopItemsNode, {
        node: node,
        itemData: itemData
      }, node.id)
    }))
  });
}
class LoopItems extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      loopLayout,
      itemData
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      loopLayout: loopLayout,
      itemData: itemData,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LoopItems);

/***/ }),

/***/ "./src/components/BuilderView/dummy-posts.js":
/*!***************************************************!*\
  !*** ./src/components/BuilderView/dummy-posts.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   dummyPosts: () => (/* binding */ dummyPosts)
/* harmony export */ });
const dummyPosts = [{
  "postTitle": {
    "titleText": "How to Get the Best Deals on Email Verification Services"
  },
  "postId": {
    "id": 101
  },
  "postDate": {
    "date": "12/05/2025"
  },
  "postAuthor": {
    "authorName": "PickPlugins"
  },
  "commentsCount": {
    "count": 123
  },
  "postThumbnail": {
    "srcUrl": "https://demo.pickplugins.com/post-grid/wp-content/uploads/sites/2/2024/07/pexels-lastly-772803.jpg"
  },
  "postAuthorAvatar": {
    "srcUrl": "https://pickplugins.com/wp-content/litespeed/avatar/60b037d2fe05ceb39acb7f02dbd29bd8.jpg?ver=1744938018"
  },
  "postExcerpt": {
    "excerptText": "In todays digital landscape, email marketing remains one of the most effective ways to engage customers and drive conversions..."
  }
}, {
  "postTitle": {
    "titleText": "10 Tips to Improve Email Deliverability Instantly"
  },
  "postId": {
    "id": 102
  },
  "postDate": {
    "date": "10/04/2025"
  },
  "postAuthor": {
    "authorName": "PickPlugins"
  },
  "commentsCount": {
    "count": 85
  },
  "postThumbnail": {
    "srcUrl": "https://demo.pickplugins.com/post-grid/wp-content/uploads/sites/2/2024/08/email-marketing.jpg"
  },
  "postAuthorAvatar": {
    "srcUrl": "https://pickplugins.com/wp-content/litespeed/avatar/avatar2.jpg?ver=1744938018"
  },
  "postExcerpt": {
    "excerptText": "Struggling with low open rates? Your emails might not be landing in inboxes at all..."
  }
}, {
  "postTitle": {
    "titleText": "Top 5 Email Verification Tools in 2025 Compared"
  },
  "postId": {
    "id": 103
  },
  "postDate": {
    "date": "05/03/2025"
  },
  "postAuthor": {
    "authorName": "PickPlugins"
  },
  "commentsCount": {
    "count": 67
  },
  "postThumbnail": {
    "srcUrl": "https://demo.pickplugins.com/post-grid/wp-content/uploads/sites/2/2024/09/email-tools.jpg"
  },
  "postAuthorAvatar": {
    "srcUrl": "https://pickplugins.com/wp-content/litespeed/avatar/avatar3.jpg?ver=1744938018"
  },
  "postExcerpt": {
    "excerptText": "Choosing the right email verification service can be overwhelming. In this post, we break down the top 5 tools..."
  }
}, {
  "postTitle": {
    "titleText": "Why Your Emails Are Going to Spam (And How to Fix It)"
  },
  "postId": {
    "id": 104
  },
  "postDate": {
    "date": "22/02/2025"
  },
  "postAuthor": {
    "authorName": "PickPlugins"
  },
  "commentsCount": {
    "count": 98
  },
  "postThumbnail": {
    "srcUrl": "https://demo.pickplugins.com/post-grid/wp-content/uploads/sites/2/2024/10/spam-folder.jpg"
  },
  "postAuthorAvatar": {
    "srcUrl": "https://pickplugins.com/wp-content/litespeed/avatar/avatar4.jpg?ver=1744938018"
  },
  "postExcerpt": {
    "excerptText": "If your carefully crafted emails are ending up in spam, you're not alone. Here's how to solve it..."
  }
}, {
  "postTitle": {
    "titleText": "Best Practices for Maintaining a Clean Email List"
  },
  "postId": {
    "id": 105
  },
  "postDate": {
    "date": "15/01/2025"
  },
  "postAuthor": {
    "authorName": "PickPlugins"
  },
  "commentsCount": {
    "count": 56
  },
  "postThumbnail": {
    "srcUrl": "https://demo.pickplugins.com/post-grid/wp-content/uploads/sites/2/2024/11/clean-list.jpg"
  },
  "postAuthorAvatar": {
    "srcUrl": "https://pickplugins.com/wp-content/litespeed/avatar/avatar5.jpg?ver=1744938018"
  },
  "postExcerpt": {
    "excerptText": "Cleaning your email list regularly improves your deliverability and engagement. Here's how to do it right..."
  }
}, {
  "postTitle": {
    "titleText": "The Role of AI in Modern Email Marketing"
  },
  "postId": {
    "id": 106
  },
  "postDate": {
    "date": "01/01/2025"
  },
  "postAuthor": {
    "authorName": "PickPlugins"
  },
  "commentsCount": {
    "count": 72
  },
  "postThumbnail": {
    "srcUrl": "https://demo.pickplugins.com/post-grid/wp-content/uploads/sites/2/2024/12/ai-email.jpg"
  },
  "postAuthorAvatar": {
    "srcUrl": "https://pickplugins.com/wp-content/litespeed/avatar/avatar6.jpg?ver=1744938018"
  },
  "postExcerpt": {
    "excerptText": "Artificial intelligence is revolutionizing email marketing. Discover the latest trends and tools powered by AI..."
  }
}, {
  "postTitle": {
    "titleText": "How to Reduce Email Bounce Rates Effectively"
  },
  "postId": {
    "id": 107
  },
  "postDate": {
    "date": "20/12/2024"
  },
  "postAuthor": {
    "authorName": "PickPlugins"
  },
  "commentsCount": {
    "count": 40
  },
  "postThumbnail": {
    "srcUrl": "https://demo.pickplugins.com/post-grid/wp-content/uploads/sites/2/2024/12/bounce-rate.jpg"
  },
  "postAuthorAvatar": {
    "srcUrl": "https://pickplugins.com/wp-content/litespeed/avatar/avatar7.jpg?ver=1744938018"
  },
  "postExcerpt": {
    "excerptText": "High bounce rates can damage your sender reputation. Learn practical ways to keep your bounce rates low..."
  }
}, {
  "postTitle": {
    "titleText": "Email List Hygiene: Why It Matters More Than Ever"
  },
  "postId": {
    "id": 108
  },
  "postDate": {
    "date": "05/12/2024"
  },
  "postAuthor": {
    "authorName": "PickPlugins"
  },
  "commentsCount": {
    "count": 66
  },
  "postThumbnail": {
    "srcUrl": "https://demo.pickplugins.com/post-grid/wp-content/uploads/sites/2/2024/11/hygiene.jpg"
  },
  "postAuthorAvatar": {
    "srcUrl": "https://pickplugins.com/wp-content/litespeed/avatar/avatar8.jpg?ver=1744938018"
  },
  "postExcerpt": {
    "excerptText": "A clean email list isn't just best practice—it's essential. Here's why your email hygiene matters..."
  }
}, {
  "postTitle": {
    "titleText": "Beginner’s Guide to Email Verification APIs"
  },
  "postId": {
    "id": 109
  },
  "postDate": {
    "date": "25/11/2024"
  },
  "postAuthor": {
    "authorName": "PickPlugins"
  },
  "commentsCount": {
    "count": 50
  },
  "postThumbnail": {
    "srcUrl": "https://demo.pickplugins.com/post-grid/wp-content/uploads/sites/2/2024/10/api-guide.jpg"
  },
  "postAuthorAvatar": {
    "srcUrl": "https://pickplugins.com/wp-content/litespeed/avatar/avatar9.jpg?ver=1744938018"
  },
  "postExcerpt": {
    "excerptText": "If you're integrating email verification into your app or platform, this beginner's guide is the perfect place to start..."
  }
}];

/***/ }),

/***/ "./src/components/BuilderView/elements-view.js":
/*!*****************************************************!*\
  !*** ./src/components/BuilderView/elements-view.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component
} = wp.element;





/*postTitle*/

(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlpostTitle', 'wcps/element', PostGridElementHtmlpostTitle, 10);
function PostGridElementHtmlpostTitle(html, itemData, element) {
  var options = element?.options;
  var linkTo = options?.linkTo;
  var target = options?.target;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: [linkTo?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
      href: "#",
      target: target,
      onClick: ev => {
        ev.preventDefault();
      },
      children: itemData.postTitle.titleText
    }), linkTo?.length == 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
      children: itemData.postTitle.titleText
    })]
  });
}

/*postId*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlpostId', 'wcps/element', PostGridElementHtmlpostId, 10);
function PostGridElementHtmlpostId(html, itemData, element) {
  var options = element?.options;
  var linkTo = options?.linkTo;
  var target = options?.target;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: [linkTo?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("a", {
      href: "#",
      target: target,
      onClick: ev => {
        ev.preventDefault();
      },
      children: [itemData.ID, itemData.postId.id]
    }), linkTo?.length == 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
      children: [itemData.ID, itemData.postId.id]
    })]
  });
}

/*readMore*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlreadMore', 'wcps/element', PostGridElementHtmlreadMore, 10);
function PostGridElementHtmlreadMore(html, itemData, element) {
  var options = element.options;
  var target = options?.target;
  var readMoreText = options?.readMoreText;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    target: target,
    href: "#",
    onClick: ev => {
      ev.preventDefault();
    },
    children: readMoreText
  });
}
/*customText*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlcustomText', 'wcps/element', PostGridElementHtmlcustomText, 10);
function PostGridElementHtmlcustomText(html, itemData, element) {
  var options = element.options;
  var content = options?.content;
  var customTag = options?.customTag;
  const CustomTagWrapper = `${customTag}`;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(CustomTagWrapper, {
    id: `element-${element.id}`,
    className: `${element.type}`,
    onClick: ev => {
      ev.preventDefault();
    },
    children: content
  });
}

/*postExcerpt*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlpostExcerpt', 'wcps/element', PostGridElementHtmlpostExcerpt, 10);
function PostGridElementHtmlpostExcerpt(html, itemData, element) {
  var options = element.options;
  var limitBy = options?.limitBy;
  var limitCount = options?.limitCount;
  var target = options?.target;
  var readMoreText = options?.readMoreText;
  var excerptText = itemData.postExcerpt.excerptText;
  var count = limitCount > 0 ? limitCount : 999;
  if (limitBy == "character") {
    excerptText = excerptText.substring(0, count);
  } else if (limitBy == "word") {
    setPostExcerptEdited(excerptText = excerptText.split(" ").splice(0, count).join(" "));
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
      className: "excerpt-text",
      children: excerptText
    }), readMoreText?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
      href: "#",
      target: target,
      className: "redmore",
      onClick: ev => {
        ev.preventDefault();
      },
      children: readMoreText
    })]
  });
}

/*postDate*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlpostDate', 'wcps/element', PostGridElementHtmlpostDate, 10);
function PostGridElementHtmlpostDate(html, itemData, element) {
  var options = element.options;
  var prefixText = options?.prefixText;
  var postfixText = options?.postfixText;
  var linkTo = options?.linkTo;
  var target = options?.target;
  var format = options?.format;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: [prefixText?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "prefix",
      children: prefixText
    }), linkTo?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
      href: "#",
      target: target,
      className: "post-date-label",
      onClick: ev => {
        ev.preventDefault();
      },
      children: itemData.postDate.date
    }), linkTo?.length == 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "post-date-label",
      children: itemData.postDate.date
    }), postfixText?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "prefix",
      children: postfixText
    })]
  });
}

/*postAuthor*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlpostAuthor', 'wcps/element', PostGridElementHtmlpostAuthor, 10);
function PostGridElementHtmlpostAuthor(html, itemData, element) {
  var options = element.options;
  var prefixText = options?.prefixText;
  var postfixText = options?.postfixText;
  var linkTo = options?.linkTo;
  var target = options?.target;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "prefix",
      children: prefixText
    }), linkTo?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
      href: "#",
      target: target,
      className: "author-name",
      onClick: ev => {
        ev.preventDefault();
      },
      children: itemData.postAuthor.authorName
    }), linkTo?.length == 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "author-name",
      children: itemData.postAuthor.authorName
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "postfix",
      children: postfixText
    })]
  });
}

/*postAuthorAvatar*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlpostAuthorAvatar', 'wcps/element', PostGridElementHtmlpostAuthorAvatar, 10);
function PostGridElementHtmlpostAuthorAvatar(html, itemData, element) {
  var options = element.options;
  var prefixText = options.prefixText;
  var postfixText = options.postfixText;
  var linkTo = options.linkTo;
  var target = options.target;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "prefix",
      children: prefixText
    }), linkTo.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
      href: "#",
      target: target,
      className: "author-link",
      onClick: ev => {
        ev.preventDefault();
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("img", {
        className: "avatar",
        src: itemData.postAuthorAvatar.srcUrl,
        alt: ""
      })
    }), linkTo.length == 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("img", {
      className: "avatar",
      src: itemData.postAuthorAvatar.srcUrl,
      alt: ""
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "postfix",
      children: postfixText
    })]
  });
}

/*postCategories*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlpostCategories', 'wcps/element', PostGridElementHtmlpostCategories, 10);
function PostGridElementHtmlpostCategories(html, itemData, element) {
  var options = element.options;
  var maxCount = options?.maxCount;
  var prefixText = options?.prefixText;
  var postfixText = options?.postfixText;
  var target = options?.target;
  var postCount = options?.postCount;
  var separator = options?.separator;
  var categories = [{
    title: 'Category 1',
    count: 123
  }, {
    title: 'Category 2',
    count: 124
  }, {
    title: 'Category 3',
    count: 125
  }, {
    title: 'Category 4',
    count: 126
  }, {
    title: 'Category 5',
    count: 127
  }];
  var MaxCategories = categories.slice(0, maxCount);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "prefix",
      children: prefixText
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "terms-items",
      children: MaxCategories.map((category, index) => {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "term-item",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("a", {
            className: "term-link",
            href: "#",
            target: target,
            onClick: ev => {
              ev.preventDefault();
            },
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
              className: "term-title",
              children: category.title
            }), postCount && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
              className: "post-count",
              children: `(${category.count})`
            })]
          }), MaxCategories.length > index + 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
            className: "separator",
            children: separator
          })]
        });
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "postfix",
      children: postfixText
    })]
  });
}

/*postTags*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlpostTags', 'wcps/element', PostGridElementHtmlpostTags, 10);
function PostGridElementHtmlpostTags(html, itemData, element) {
  var options = element.options;
  var maxCount = options?.maxCount;
  var prefixText = options?.prefixText;
  var postfixText = options?.postfixText;
  var target = options?.target;
  var postCount = options?.postCount;
  var separator = options?.separator;
  var tags = [{
    title: 'Tag 1',
    count: 123
  }, {
    title: 'Tag 2',
    count: 124
  }, {
    title: 'Tag 3',
    count: 125
  }, {
    title: 'Tag 4',
    count: 126
  }, {
    title: 'Tag 5',
    count: 127
  }];
  var MaxTags = tags.slice(0, maxCount);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "prefix",
      children: prefixText
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "terms-items",
      children: MaxTags.map((tag, index) => {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "item",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("a", {
            className: "term-link",
            href: "#",
            target: target,
            onClick: ev => {
              ev.preventDefault();
            },
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
              className: "term-title",
              children: tag.title
            }), postCount && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
              className: "post-count",
              children: `(${tag.count})`
            })]
          }), MaxTags.length > index + 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
            className: "separator",
            children: separator
          })]
        });
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "postfix",
      children: postfixText
    })]
  });
}

/*commentsCount*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlcommentsCount', 'wcps/element', PostGridElementHtmlcommentsCount, 10);
function PostGridElementHtmlcommentsCount(html, itemData, element) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: itemData.commentsCount.count
  });
}

/*shareButton*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlshareButton', 'wcps/element', PostGridElementHtmlshareButton, 10);
function PostGridElementHtmlshareButton(html, itemData, element) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: "shareButton"
  });
}

/*postContent*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlpostContent', 'wcps/element', PostGridElementHtmlpostContent, 10);
function PostGridElementHtmlpostContent(html, itemData, element) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: "Affiliate marketers depend heavily on email marketing to drive sales and connect with leads. However, when email lists are not verified, they can lead to higher bounce rates, spam complaints, and even blacklisting by email providers. This section will introduce\u2026"
  });
}

/*postThumbnail*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlpostThumbnail', 'wcps/element', PostGridElementHtmlpostThumbnail, 10);
function PostGridElementHtmlpostThumbnail(html, itemData, element) {
  var elementOptions = element.options;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("img", {
      src: elementOptions.defaultSrcUrl,
      alt: ""
    })
  });
}

/*postMeta*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlpostMeta', 'wcps/element', PostGridElementHtmlpostMeta, 10);
function PostGridElementHtmlpostMeta(html, itemData, element) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: "Post Meta"
  });
}

/*wooPrice*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlwooPrice', 'wcps/element', PostGridElementHtmlwooPrice, 10);
function PostGridElementHtmlwooPrice(html, itemData, element) {
  var options = element?.options;
  var currencySymbole = options.currencySymbole;
  var currencyPosition = options.currencyPosition;
  var separatorText = options.separatorText;
  var prefixText = options.prefixText;
  var postfixText = options.postfixText;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: [prefixText?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "prefix",
      children: prefixText
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "regular",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
        className: "currency",
        children: currencySymbole
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
        className: "price-value",
        children: "123"
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "separator",
      children: separatorText
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "sale-price",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
        className: "currency",
        children: currencySymbole
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
        className: "price-value",
        children: "250"
      })]
    }), postfixText?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "postfix",
      children: postfixText
    })]
  });
}

/*wooSaleBadge*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlwooSaleBadge', 'wcps/element', PostGridElementHtmlwooSaleBadge, 10);
function PostGridElementHtmlwooSaleBadge(html, itemData, element) {
  var options = element?.options;
  var onSaleText = options.onSaleText;
  var prefixText = options.prefixText;
  var postfixText = options.postfixText;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: [prefixText?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "prefix",
      children: prefixText
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "on-sale-badge",
      children: onSaleText
    }), postfixText?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "postfix",
      children: postfixText
    })]
  });
}

/*wooSKU*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlwooSKU', 'wcps/element', PostGridElementHtmlwooSKU, 10);
function PostGridElementHtmlwooSKU(html, itemData, element) {
  var options = element?.options;
  var dafaultSKUText = options.dafaultSKUText;
  var prefixText = options.prefixText;
  var postfixText = options.postfixText;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: [prefixText?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "prefix",
      children: prefixText
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "sku",
      children: dafaultSKUText
    }), postfixText?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "postfix",
      children: postfixText
    })]
  });
}

/*wooStockQuantity*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlwooStockQuantity', 'wcps/element', PostGridElementHtmlwooStockQuantity, 10);
function PostGridElementHtmlwooStockQuantity(html, itemData, element) {
  var options = element?.options;
  var dafultQuantity = options.dafultQuantity;
  var prefixText = options.prefixText;
  var postfixText = options.postfixText;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: [prefixText?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "prefix",
      children: prefixText
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "stock-quantity",
      children: dafultQuantity
    }), postfixText?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "postfix",
      children: postfixText
    })]
  });
}

/*wooInStock*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlwooInStock', 'wcps/element', PostGridElementHtmlwooInStock, 10);
function PostGridElementHtmlwooInStock(html, itemData, element) {
  var options = element?.options;
  var inStockText = options.inStockText;
  var outOfStockText = options.outOfStockText;
  var backOrderText = options.backOrderText;
  var prefixText = options.prefixText;
  var postfixText = options.postfixText;
  var previewFor = options.previewFor;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: [prefixText?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "prefix",
      children: prefixText
    }), previewFor == 'inStockText' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "instock",
      children: inStockText
    }), previewFor == 'outOfStockText' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "outofstock",
      children: inStockText
    }), previewFor == 'backOrderText' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "onbackorder",
      children: inStockText
    }), postfixText?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "postfix",
      children: postfixText
    })]
  });
}

/*wooTotalSales*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlwooTotalSales', 'wcps/element', PostGridElementHtmlwooTotalSales, 10);
function PostGridElementHtmlwooTotalSales(html, itemData, element) {
  var options = element?.options;
  var defaultSaleCount = options.defaultSaleCount;
  var prefixText = options.prefixText;
  var postfixText = options.postfixText;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: [prefixText?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "prefix",
      children: prefixText
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "sale-count",
      children: defaultSaleCount
    }), postfixText?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "postfix",
      children: postfixText
    })]
  });
}

/*wooProductRatings*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlwooProductRatings', 'wcps/element', PostGridElementHtmlwooProductRatings, 10);
function PostGridElementHtmlwooProductRatings(html, itemData, element) {
  var options = element?.options;
  var iconsIdle = options.iconsIdle;
  var iconsFilled = options.iconsFilled;
  var defaultRating = options.defaultRating;
  var summaryType = options.summaryType;
  var summaryTypeCustom = options.summaryTypeCustom;
  var summaryLinkTo = options.summaryLinkTo;
  var prefixText = options.prefixText;
  var postfixText = options.postfixText;
  var iconsIdleHtml = `<span class="${iconsIdle.iconSrc}"></span>`;
  var iconsFilledHtml = `<span class="${iconsFilled.iconSrc}"></span>`;
  function replaceAll(str, correction) {
    Object.keys(correction).forEach(key => {
      str = str.replaceAll(key, correction[key]);
    });
    return str;
  }
  var map = {
    "{rating_count}": "",
    "{review_count}": "",
    "{average_rating}": "",
    "{product_title}": ""
  };
  const [ratingMap, setratingMap] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(map);
  var filledStyles = {
    width: "60%"
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: [prefixText?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "prefix",
      children: prefixText
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "icons-wrap",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
        className: "icons-idle",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
          className: ``,
          dangerouslySetInnerHTML: {
            __html: iconsIdleHtml
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
          className: ``,
          dangerouslySetInnerHTML: {
            __html: iconsIdleHtml
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
          className: ``,
          dangerouslySetInnerHTML: {
            __html: iconsIdleHtml
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
          className: ``,
          dangerouslySetInnerHTML: {
            __html: iconsIdleHtml
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
          className: ``,
          dangerouslySetInnerHTML: {
            __html: iconsIdleHtml
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "icons-filled",
          style: filledStyles,
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
            className: ``,
            dangerouslySetInnerHTML: {
              __html: iconsFilledHtml
            }
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
            className: ``,
            dangerouslySetInnerHTML: {
              __html: iconsFilledHtml
            }
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
            className: ``,
            dangerouslySetInnerHTML: {
              __html: iconsFilledHtml
            }
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
            className: ``,
            dangerouslySetInnerHTML: {
              __html: iconsFilledHtml
            }
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
            className: ``,
            dangerouslySetInnerHTML: {
              __html: iconsFilledHtml
            }
          })]
        })]
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "summary",
      children: [summaryType !== "custom" && summaryType !== null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
        children: replaceAll(summaryType, ratingMap)
      }), summaryType == "custom" && summaryTypeCustom.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
        children: replaceAll(summaryTypeCustom, ratingMap)
      })]
    }), postfixText?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "postfix",
      children: postfixText
    })]
  });
}

/*wooAddToCart*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementHtmlwooAddToCart', 'wcps/element', PostGridElementHtmlwooAddToCart, 10);
function PostGridElementHtmlwooAddToCart(html, itemData, element) {
  var options = element?.options;
  var addToCartText = options.addToCartText;
  var quantityEnable = options.quantityEnable;
  var icon = options.icon;
  var iconPosition = options.iconPosition;
  var prefixText = options.prefixText;
  var postfixText = options.postfixText;
  var iconSrc = icon?.iconSrc;
  var iconHtml = `<span class="${iconSrc}"></span>`;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    id: `element-${element.id}`,
    className: `${element.type}`,
    children: [iconPosition == "beforePrefix" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      className: `icon-wrap`,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), prefixText?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "prefix",
      children: prefixText
    }), iconPosition == "afterPrefix" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      className: `icon-wrap`,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("a", {
      className: "cartBtn",
      onClick: ev => {
        ev.preventDefault();
      },
      href: "?add-to-cart=1399",
      "data-quantity": "1",
      "data-product_id": "1399",
      "data-product_sku": "woo-polo",
      "aria-label": "Add \u201CPolo\u201D to your cart",
      "aria-describedby": "",
      rel: "nofollow",
      children: [iconPosition == "beforeCartText" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
        className: "icon-wrap",
        dangerouslySetInnerHTML: {
          __html: iconHtml
        }
      }), addToCartText, iconPosition == "afterCartText" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
        className: "icon-wrap",
        dangerouslySetInnerHTML: {
          __html: iconHtml
        }
      })]
    }), quantityEnable && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "quantityWrap",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "quantityIncrease",
        children: "+"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("input", {
        size: "3",
        type: "text",
        inputMode: "numeric",
        className: "quantityInput",
        placeholder: "1",
        value: '3'
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "quantityDecrease",
        children: "-"
      })]
    }), iconPosition == "beforePostfix" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      className: `icon-wrap`,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    }), postfixText?.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "postfix",
      children: postfixText
    }), iconPosition == "afterPostfix" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      className: `icon-wrap`,
      dangerouslySetInnerHTML: {
        __html: iconHtml
      }
    })]
  });
}

/***/ }),

/***/ "./src/components/BuilderView/index.js":
/*!*********************************************!*\
  !*** ./src/components/BuilderView/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/help.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _input_select__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../input-select */ "./src/components/input-select/index.js");
/* harmony import */ var _input_text__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../input-text */ "./src/components/input-text/index.js");
/* harmony import */ var _preview_grid__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./preview-grid */ "./src/components/BuilderView/preview-grid.js");
/* harmony import */ var _preview_carousel__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./preview-carousel */ "./src/components/BuilderView/preview-carousel.js");
/* harmony import */ var _preview_masonry__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./preview-masonry */ "./src/components/BuilderView/preview-masonry.js");
/* harmony import */ var _preview_filterable__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./preview-filterable */ "./src/components/BuilderView/preview-filterable.js");
/* harmony import */ var _elements_view__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./elements-view */ "./src/components/BuilderView/elements-view.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;













var myStore = wp.data.select("PostGridStore");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var id = props.id;
  var customerData = props.customerData;
  var onChangePostGrid = props.onChangePostGrid;
  var addNotifications = props.addNotifications;
  var settoggleSettings = props.settoggleSettings;
  var setHelp = props.setHelp;
  var isLoading = props.isLoading;
  var onSavePostGrid = props.onSavePostGrid;
  var pleaseUpdate = props.pleaseUpdate;
  if (props.postData.post_content == null) {
    return null;
  }
  var [pleaseUpdateX, setpleaseUpdateX] = useState(props.pleaseUpdate);
  var [postData, setpostData] = useState(props.postData);
  var [PostGridData, setPostGridData] = useState(postData.post_content);
  var [globalOptions, setglobalOptions] = useState(PostGridData.globalOptions);
  const copyData = data => {
    navigator.clipboard.writeText(data).then(() => {
      addNotifications({
        title: "Copied to clipboard!",
        content: "Use the shortcode in page or post content where you want to display.",
        type: "success"
      });
    }).catch(err => {});
  };
  useEffect(() => {
    setpostData(props.postData);
  }, [props.postData]);
  useEffect(() => {
    setPostGridData(postData.post_content);
  }, [postData]);
  useEffect(() => {
    setglobalOptions(PostGridData.globalOptions);
  }, [PostGridData]);
  useEffect(() => {
    setpleaseUpdateX(pleaseUpdate);
  }, [pleaseUpdate]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
    className: "ml-5",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
      className: "flex items-center justify-between align-middle bg-white py-2 px-5  mb-5",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
        className: "flex items-center gap-5",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
          className: "",
          children: [postData?.post_title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "flex items-center gap-3 text-base font-bold",
            children: ["You are editing:", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
              children: postData.post_title
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("span", {
              className: "text-gray-300",
              children: [`(#${postData.ID})`, " "]
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "flex gap-4 items-center my-3",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cursor-pointer",
              onClick: ev => {
                settoggleSettings('overview');
              },
              children: "Overview"
            }), !customerData.isPro && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
                className: "cursor-pointer",
                onClick: ev => {
                  settoggleSettings('freeVsPro');
                },
                children: "Free Vs Pro"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("a", {
                href: "https://pickplugins.com/woocommerce-products-slider/",
                target: "_blank",
                className: "cursor-pointer px-3 py-1 bg-amber-600 rounded text-white",
                children: "Buy Now"
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: "cursor-pointer",
              onClick: ev => {
                settoggleSettings('sendFeedback');
              },
              children: "Send Feedbacks"
            })]
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
        className: "flex items-center align-middle gap-3",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
          className: "flex items-center align-middle gap-2",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
            className: "cursor-pointer",
            title: "Click to know more",
            onClick: () => {
              setHelp({
                id: "useShortcodes",
                enable: true
              });
            },
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_12__["default"], {
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_13__["default"]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("input", {
            type: "text",
            className: "w-72 !bg-slate-200 !rounded-none !border-2 !border-solid border-slate-400 text-sm !py-1 !px-2 font-mono",
            value: `[wcps_builder id="${id}"]`,
            onClick: () => {
              var str = `[wcps_builder id="${id}"]`;
              copyData(str);
            }
          })]
        }), pleaseUpdateX && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
          className: "bg-slate-700 text-white px-5 py-2 rounded-sm cursor-pointer hover:bg-slate-600",
          onClick: ev => {
            onSavePostGrid(true);
          },
          children: "Save"
        })]
      })]
    }), globalOptions?.viewType == "viewGrid" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_preview_grid__WEBPACK_IMPORTED_MODULE_6__["default"], {
      postData: postData,
      id: id
    }), globalOptions?.viewType == "viewSlider" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_preview_carousel__WEBPACK_IMPORTED_MODULE_7__["default"], {
      postData: postData,
      id: id
    }), globalOptions?.viewType == "viewMasonry" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_preview_masonry__WEBPACK_IMPORTED_MODULE_8__["default"], {
      postData: postData,
      id: id
    }), globalOptions?.viewType == "viewFilterable" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_preview_filterable__WEBPACK_IMPORTED_MODULE_9__["default"], {
      postData: postData,
      id: id
    })]
  });
}
class BuilderView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      postData,
      id,
      isLoading,
      onChangePostGrid,
      pleaseUpdate,
      onSavePostGrid,
      addNotifications,
      settoggleSettings,
      customerData,
      setHelp
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(Html, {
      isLoading: isLoading,
      postData: postData,
      id: id,
      onSavePostGrid: onSavePostGrid,
      pleaseUpdate: pleaseUpdate,
      onChangePostGrid: onChangePostGrid,
      addNotifications: addNotifications,
      settoggleSettings: settoggleSettings,
      customerData: customerData,
      setHelp: setHelp,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BuilderView);

/***/ }),

/***/ "./src/components/BuilderView/preview-carousel.js":
/*!********************************************************!*\
  !*** ./src/components/BuilderView/preview-carousel.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _input_select__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../input-select */ "./src/components/input-select/index.js");
/* harmony import */ var _input_text__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../input-text */ "./src/components/input-text/index.js");
/* harmony import */ var _splidejs_react_splide__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @splidejs/react-splide */ "./node_modules/@splidejs/react-splide/dist/js/react-splide.esm.js");
/* harmony import */ var _splidejs_splide_extension_auto_scroll__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @splidejs/splide-extension-auto-scroll */ "./node_modules/@splidejs/splide-extension-auto-scroll/dist/js/splide-extension-auto-scroll.esm.js");
/* harmony import */ var _splidejs_splide_extension_grid__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @splidejs/splide-extension-grid */ "./node_modules/@splidejs/splide-extension-grid/dist/js/splide-extension-grid.esm.js");
/* harmony import */ var _LoopItems__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./LoopItems */ "./src/components/BuilderView/LoopItems.js");
/* harmony import */ var _dummy_posts__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./dummy-posts */ "./src/components/BuilderView/dummy-posts.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;













var myStore = wp.data.select("PostGridStore");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var id = props.id;
  if (props.postData.post_content == null) {
    return null;
  }
  var [postData, setpostData] = useState(props.postData);
  var [PostGridData, setPostGridData] = useState(postData.post_content);
  var [globalOptions, setglobalOptions] = useState(PostGridData.globalOptions);
  var [loopLayout, setloopLayout] = useState(PostGridData.loopLayout);
  var [wrapper, setwrapper] = useState(PostGridData.wrapper);
  var [items, setitems] = useState(PostGridData.items);
  var [navsWrap, setnavsWrap] = useState(PostGridData?.navsWrap);
  var [navItem, setnavItem] = useState(PostGridData?.navItem);
  useEffect(() => {
    setpostData(props.postData);
  }, [props.postData]);
  useEffect(() => {
    setPostGridData(postData.post_content);
    //setitems(postData.post_content.items);
  }, [postData]);
  useEffect(() => {
    setglobalOptions(PostGridData.globalOptions);
    setwrapper(PostGridData.wrapper);
    setloopLayout(PostGridData.loopLayout);
    setitems(PostGridData.items);
    setnavsWrap(PostGridData.navsWrap);
    setnavItem(PostGridData.navItem);
  }, [PostGridData]);
  function unescapeHTML(str) {
    const map = {
      '&amp;': '&',
      '&lt;': '<',
      '&gt;': '>',
      '&quot;': '"',
      '&#039;': "'"
    };
    return str.replace(/&amp;|&lt;|&gt;|&quot;|&#039;/g, function (match) {
      return map[match];
    });
  }
  var loopLayout = PostGridData.loopLayout;
  var itemWrap = PostGridData?.itemWrap;
  var sliderOptions = PostGridData?.sliderOptions;
  var prev = PostGridData?.prev;
  var next = PostGridData?.next;
  var prevIcon = PostGridData?.prevIcon;
  var nextIcon = PostGridData?.nextIcon;
  const [prevIconHtml, setPrevIconHtml] = useState("");
  const [nextIconHtml, setNextIconHtml] = useState("");
  useEffect(() => {
    var iconSrc = nextIcon?.options?.iconSrc;
    var iconHtml = `<span class="${iconSrc}"></span>`;
    setNextIconHtml(iconHtml);
  }, [nextIcon?.options]);
  useEffect(() => {
    var iconSrc = prevIcon?.options?.iconSrc;
    var iconHtml = `<span class="${iconSrc}"></span>`;
    setPrevIconHtml(iconHtml);
  }, [prevIcon?.options]);
  const GenerateNodeHtml = ({
    node,
    itemData
  }) => {
    var nodeType = node.type;
    var nodeId = node.id;
    var html = applyFilters("PostGridElementHtml" + nodeType, '', itemData, node);
    return html;
  };
  const TreeNode = ({
    node,
    itemData
  }) => {
    var nodeType = node.type;
    if (nodeType == "root" || nodeType == "container") {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
        id: `element-${node.id}`,
        className: `${node.type}`,
        children: node.children && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
          children: node.children.map(child => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(TreeNode, {
            node: child,
            itemData: itemData
          }, child?.id))
        })
      });
    } else {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(GenerateNodeHtml, {
        node: node,
        itemData: itemData
      });
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
    className: "px-10 py-10",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
      id: `wcps-${id}`,
      className: `${wrapper?.options?.class} `,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_splidejs_react_splide__WEBPACK_IMPORTED_MODULE_6__.Splide, {
        hasTrack: false,
        options: sliderOptions,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_splidejs_react_splide__WEBPACK_IMPORTED_MODULE_6__.SplideTrack, {
          className: "items",
          children: _dummy_posts__WEBPACK_IMPORTED_MODULE_10__.dummyPosts?.map((item, loopIndex) => {
            var children = PostGridData.loopLayout[0]?.children ? PostGridData.loopLayout[0]?.children : [];
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
              className: `${itemWrap?.options?.class} splide__slide item`,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_LoopItems__WEBPACK_IMPORTED_MODULE_9__["default"], {
                loopLayout: children,
                itemData: item
              })
            }, loopIndex);
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
          className: "splide__arrows ",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "prev nav-item splide__arrow splide__arrow--prev",
            children: [prevIcon?.options.position == "before" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
              className: "icon",
              dangerouslySetInnerHTML: {
                __html: prevIconHtml
              }
            }), prev?.options.text.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("span", {
              children: [" ", prev.options.text, " "]
            }), prevIcon?.options.position == "after" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
              className: "icon",
              dangerouslySetInnerHTML: {
                __html: prevIconHtml
              }
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "next nav-item splide__arrow splide__arrow--next",
            children: [nextIcon?.options.position == "before" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
              className: "icon",
              dangerouslySetInnerHTML: {
                __html: nextIconHtml
              }
            }), next?.options.text.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("span", {
              children: [" ", next.options.text, " "]
            }), nextIcon?.options.position == "after" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("span", {
              className: "icon",
              dangerouslySetInnerHTML: {
                __html: nextIconHtml
              }
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("ul", {
          className: "splide__pagination "
        })]
      })
    })
  });
}
class PreviewCarousel extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      postData,
      id,
      onChangeStyleObj
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(Html, {
      postData: postData,
      id: id,
      onChangeStyleObj: onChangeStyleObj,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreviewCarousel);

/***/ }),

/***/ "./src/components/BuilderView/preview-filterable.js":
/*!**********************************************************!*\
  !*** ./src/components/BuilderView/preview-filterable.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _LoopItems__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./LoopItems */ "./src/components/BuilderView/LoopItems.js");
/* harmony import */ var _dummy_posts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./dummy-posts */ "./src/components/BuilderView/dummy-posts.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;




var myStore = wp.data.select("PostGridStore");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var id = props.id;
  if (props.postData.post_content == null) {
    return null;
  }
  var [postData, setpostData] = useState(props.postData);
  var [PostGridData, setPostGridData] = useState(postData.post_content);

  /*Selectors*/
  var [globalOptions, setglobalOptions] = useState(PostGridData.globalOptions);
  var [wrapper, setwrapper] = useState(PostGridData.wrapper);
  var [items, setitems] = useState([{}, {}, {}]);
  var [itemsWrap, setitemsWrap] = useState(PostGridData.itemsWrap);
  var [itemWrap, setitemWrap] = useState(PostGridData.itemWrap);
  var [loopLayout, setloopLayout] = useState(PostGridData.loopLayout);
  var [activeFilter, setactiveFilter] = useState(PostGridData.activeFilter);
  var [pagination, setpagination] = useState(PostGridData.pagination);
  const [previousIconHtml, setpreviousIconHtml] = useState("");
  const [nextIconHtml, setnextIconHtml] = useState("");
  var dummyFilters = [{
    "groupTitle": "News",
    "type": "",
    "logic": "",
    "showPostCount": "",
    "items": [{
      "id": 0,
      "slug": "email-marketing",
      "title": "Email Marketing",
      "count": "123"
    }, {
      "id": 0,
      "slug": "email-verification",
      "title": "Email Verification",
      "count": "124"
    }, {
      "id": 0,
      "slug": "email-list",
      "title": "Email List",
      "count": "125"
    }]
  }];
  useEffect(() => {
    var iconSrc = PostGridData.pagination?.previousIcon?.iconSrc;
    var previousIconHtml = `<span class="${iconSrc}"></span>`;
    setpreviousIconHtml(previousIconHtml);
    var iconSrc = PostGridData.pagination?.nextIcon?.iconSrc;
    var nextIconHtml = `<span class="${iconSrc}"></span>`;
    setnextIconHtml(nextIconHtml);
    setpagination(PostGridData.globalOptions.pagination);
  }, [PostGridData.globalOptions.pagination]);
  useEffect(() => {
    setpostData(props.postData);
  }, [props.postData]);
  useEffect(() => {
    setglobalOptions(PostGridData.globalOptions);
  }, [PostGridData]);
  useEffect(() => {}, [loopLayout, PostGridData.loopLayout]);
  useEffect(() => {
    setPostGridData(postData.post_content);
  }, [postData]);
  const GenerateNodeHtml = ({
    node,
    itemData
  }) => {
    var nodeType = node.type;
    var nodeId = node.id;
    var html = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_0__.applyFilters)("PostGridElementHtml" + nodeType, '', itemData, node);
    return html;
  };
  const TreeNode = ({
    node,
    itemData
  }) => {
    var nodeType = node.type;
    if (nodeType == "root" || nodeType == "container") {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        id: `element-${node.id}`,
        className: `${node.type}`,
        children: node.children && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
          children: node.children.map(child => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(TreeNode, {
            node: child,
            itemData: itemData
          }, child?.id))
        })
      });
    } else {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(GenerateNodeHtml, {
        node: node,
        itemData: itemData
      });
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
    className: "px-10 py-10",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      id: `wcps-${id}`,
      className: `${wrapper?.options?.class} `,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
        className: "filterable-group-wrap",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
          className: "filterable-group",
          children: globalOptions?.showAll == "yes" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "pg-filter mixitup-control-active    filter-34534",
              "data-filter": "all",
              children: "All"
            })
          })
        }), globalOptions.filters?.length > 0 && globalOptions.filters.map(x => {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "filterable-group ",
            "data-logic": x.logic,
            children: [globalOptions.multifilter && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.groupTitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                className: "filterable-group-title ",
                children: x.groupTitle
              })
            }), x.items.map(y => {
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                className: [activeFilter.options.slug == y.slug ? "mixitup-control-active pg-filter cursor-pointer" : "pg-filter cursor-pointer"],
                "terms-id": y.id,
                "data-filter": "." + y.slug,
                children: [y.title, x.showPostCount == "yes" ? "(" + y.count + ")" : ""]
              });
            })]
          });
        }), globalOptions.filters?.length == 0 && dummyFilters.map(x => {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "filterable-group ",
            "data-logic": x.logic,
            children: [globalOptions.multifilter && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
              children: x.groupTitle && globalOptions.multifilter && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
                className: "filterable-group-title ",
                children: x.groupTitle
              })
            }), x.items.map(y => {
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
                className: [activeFilter.options.slug == y.slug ? "mixitup-control-active pg-filter cursor-pointer" : "pg-filter cursor-pointer"],
                "terms-id": y.id,
                "data-filter": "." + y.slug,
                children: [y.title, x.showPostCount == "yes" ? "(" + y.count + ")" : ""]
              });
            })]
          });
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "filterable-group",
          children: [globalOptions?.showSort == "yes" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "pg-filter mixitup-control-active   filter-34534",
              "data-filter": "",
              children: "ASC"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "pg-filter    filter-34534",
              "data-filter": "",
              children: "DESC"
            })]
          }), globalOptions?.showRandom == "yes" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "pg-filter   filter-34534",
              "data-filter": "",
              children: "Random"
            })
          }), globalOptions?.showClear == "yes" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
              className: "pg-filter  filter-34534",
              "data-filter": "",
              children: "Clear"
            })
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: `${itemsWrap?.options?.class} `,
        children: _dummy_posts__WEBPACK_IMPORTED_MODULE_2__.dummyPosts?.map((item, loopIndex) => {
          var children = PostGridData.loopLayout[0]?.children ? PostGridData.loopLayout[0]?.children : [];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: `${itemWrap?.options?.class} `,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_LoopItems__WEBPACK_IMPORTED_MODULE_1__["default"], {
              loopLayout: children,
              itemData: item
            })
          }, loopIndex);
        })
      }), PostGridData.globalOptions.itemSource == "posts" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        class: "pagination ",
        children: PostGridData.globalOptions?.pagination?.type == 'filterable' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
            class: "prev page-numbers",
            href: "#1",
            onClick: ev => {
              ev.preventDefault();
            },
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("span", {
              class: "previous ",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
                className: "",
                dangerouslySetInnerHTML: {
                  __html: previousIconHtml
                }
              }), pagination?.previousText]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
            class: "page-numbers",
            href: "#1",
            onClick: ev => {
              ev.preventDefault();
            },
            children: "1"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
            "aria-current": "page",
            class: "page-numbers mixitup-control-active",
            children: "2"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
            class: "page-numbers",
            href: "#3",
            onClick: ev => {
              ev.preventDefault();
            },
            children: "3"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
            class: "page-numbers",
            href: "#4",
            onClick: ev => {
              ev.preventDefault();
            },
            children: "4"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
            class: "page-numbers dots",
            children: "\u2026"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
            class: "page-numbers",
            href: "#6",
            children: "6"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
            class: "next page-numbers",
            href: "#3",
            onClick: ev => {
              ev.preventDefault();
            },
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("span", {
              class: "next ",
              children: [pagination?.nextText, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
                className: "",
                dangerouslySetInnerHTML: {
                  __html: nextIconHtml
                }
              })]
            })
          })]
        })
      })]
    })
  });
}
class PreviewGrid extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      postData,
      id
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      postData: postData,
      id: id,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreviewGrid);

/***/ }),

/***/ "./src/components/BuilderView/preview-grid.js":
/*!****************************************************!*\
  !*** ./src/components/BuilderView/preview-grid.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _LoopItems__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./LoopItems */ "./src/components/BuilderView/LoopItems.js");
/* harmony import */ var _dummy_posts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./dummy-posts */ "./src/components/BuilderView/dummy-posts.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;




var myStore = wp.data.select("PostGridStore");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var id = props.id;
  if (props.postData.post_content == null) {
    return null;
  }
  var [postData, setpostData] = useState(props.postData);
  var [PostGridData, setPostGridData] = useState(postData.post_content);

  /*Selectors*/
  var [wrapper, setwrapper] = useState(PostGridData.wrapper);
  var [items, setitems] = useState([{}, {}, {}]);
  var [itemsWrap, setitemsWrap] = useState(PostGridData.itemsWrap);
  var [itemWrap, setitemWrap] = useState(PostGridData.itemWrap);
  var [loopLayout, setloopLayout] = useState(PostGridData.loopLayout);
  var [pagination, setpagination] = useState(PostGridData.pagination);
  var [dummyPostsX, setdummyPostsX] = useState(_dummy_posts__WEBPACK_IMPORTED_MODULE_2__.dummyPosts);
  const [loadingIconHtml, setloadingIconHtml] = useState("");
  const [loadMoreIconHtml, setloadMoreIconHtml] = useState("");
  const [previousIconHtml, setpreviousIconHtml] = useState("");
  const [nextIconHtml, setnextIconHtml] = useState("");
  useEffect(() => {
    var iconSrc = PostGridData.pagination?.loadingIcon?.iconSrc;
    var loadingIconHtml = `<span class="${iconSrc}"></span>`;
    setloadingIconHtml(loadingIconHtml);
    var iconSrc = PostGridData.pagination?.loadMoreIcon?.iconSrc;
    var loadMoreIconHtml = `<span class="${iconSrc}"></span>`;
    setloadMoreIconHtml(loadMoreIconHtml);
    var iconSrc = PostGridData.pagination?.previousIcon?.iconSrc;
    var previousIconHtml = `<span class="${iconSrc}"></span>`;
    setpreviousIconHtml(previousIconHtml);
    var iconSrc = PostGridData.pagination?.nextIcon?.iconSrc;
    var nextIconHtml = `<span class="${iconSrc}"></span>`;
    setnextIconHtml(nextIconHtml);
    setpagination(PostGridData.globalOptions.pagination);
  }, [PostGridData.globalOptions.pagination]);
  useEffect(() => {
    setpostData(props.postData);
  }, [props.postData]);
  useEffect(() => {}, [loopLayout, PostGridData.loopLayout]);
  useEffect(() => {
    setPostGridData(postData.post_content);
  }, [postData]);
  useEffect(() => {
    var count = parseInt(PostGridData?.itemQueryArgs?.postsPerPage?.value);
    var result = _dummy_posts__WEBPACK_IMPORTED_MODULE_2__.dummyPosts.slice(0, count); // Returns the first 3 elements
    setdummyPostsX(result);
  }, [PostGridData.itemQueryArgs]);
  const GenerateNodeHtml = ({
    node,
    itemData
  }) => {
    var nodeType = node.type;
    var nodeId = node.id;
    var html = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_0__.applyFilters)("PostGridElementHtml" + nodeType, '', itemData, node);
    return html;
  };
  const TreeNode = ({
    node,
    itemData
  }) => {
    var nodeType = node.type;
    if (nodeType == "root" || nodeType == "container") {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        id: `element-${node.id}`,
        className: `${node.type}`,
        children: node.children && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
          children: node.children.map(child => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(TreeNode, {
            node: child,
            itemData: itemData
          }, child?.id))
        })
      });
    } else {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(GenerateNodeHtml, {
        node: node,
        itemData: itemData
      });
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
    className: "px-10 py-10",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      id: `wcps-${id}`,
      className: `${wrapper?.options?.class} `,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: `${itemsWrap?.options?.class} `,
        children: dummyPostsX?.map((item, loopIndex) => {
          var children = PostGridData.loopLayout[0]?.children ? PostGridData.loopLayout[0]?.children : [];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: `${itemWrap?.options?.class} loop-item-${loopIndex}`,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_LoopItems__WEBPACK_IMPORTED_MODULE_1__["default"], {
              loopLayout: children,
              itemData: item
            })
          }, loopIndex);
        })
      }), PostGridData.globalOptions.itemSource == "posts" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
        class: "pagination ",
        children: [PostGridData.globalOptions?.pagination?.type == "next_previous" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("span", {
            className: "page-numbers prev",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
              className: "",
              dangerouslySetInnerHTML: {
                __html: previousIconHtml
              }
            }), pagination?.previousText]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("span", {
            className: "page-numbers next",
            children: [pagination?.nextText, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
              className: "",
              dangerouslySetInnerHTML: {
                __html: nextIconHtml
              }
            })]
          })]
        }), PostGridData.globalOptions?.pagination?.type == "loadmore" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "page-numbers",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
              dangerouslySetInnerHTML: {
                __html: loadMoreIconHtml
              }
            }), pagination?.loadMoreText]
          })
        }), PostGridData.globalOptions?.pagination?.type == "infinite" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "page-numbers",
          children: [pagination.loadMoreText, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
            dangerouslySetInnerHTML: {
              __html: loadingIconHtml
            }
          })]
        }), (PostGridData.globalOptions?.pagination?.type == 'normal' || PostGridData.globalOptions?.pagination?.type == 'ajax') && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
            class: "prev page-numbers",
            href: "#1",
            onClick: ev => {
              ev.preventDefault();
            },
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("span", {
              class: "previous ",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
                className: "",
                dangerouslySetInnerHTML: {
                  __html: previousIconHtml
                }
              }), pagination?.previousText]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
            class: "page-numbers",
            href: "#1",
            onClick: ev => {
              ev.preventDefault();
            },
            children: "1"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
            "aria-current": "page",
            class: "page-numbers current",
            children: "2"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
            class: "page-numbers",
            href: "#3",
            onClick: ev => {
              ev.preventDefault();
            },
            children: "3"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
            class: "page-numbers",
            href: "#4",
            onClick: ev => {
              ev.preventDefault();
            },
            children: "4"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
            class: "page-numbers dots",
            children: "\u2026"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
            class: "page-numbers",
            href: "#6",
            children: "6"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
            class: "next page-numbers",
            href: "#3",
            onClick: ev => {
              ev.preventDefault();
            },
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("span", {
              class: "next ",
              children: [pagination?.nextText, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
                className: "",
                dangerouslySetInnerHTML: {
                  __html: nextIconHtml
                }
              })]
            })
          })]
        })]
      })]
    })
  });
}
class PreviewGrid extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      postData,
      id
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      postData: postData,
      id: id,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreviewGrid);

/***/ }),

/***/ "./src/components/BuilderView/preview-masonry.js":
/*!*******************************************************!*\
  !*** ./src/components/BuilderView/preview-masonry.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var masonry_layout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! masonry-layout */ "./node_modules/masonry-layout/masonry.js");
/* harmony import */ var masonry_layout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(masonry_layout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _LoopItems__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./LoopItems */ "./src/components/BuilderView/LoopItems.js");
/* harmony import */ var _dummy_posts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./dummy-posts */ "./src/components/BuilderView/dummy-posts.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;




var myStore = wp.data.select("PostGridStore");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var id = props.id;
  if (props.postData.post_content == null) {
    return null;
  }
  var [postData, setpostData] = useState(props.postData);
  var [PostGridData, setPostGridData] = useState(postData.post_content);
  var [globalOptions, setglobalOptions] = useState(PostGridData.globalOptions);
  var [wrapper, setwrapper] = useState(PostGridData.wrapper);
  var [itemsWrap, setitemsWrap] = useState(PostGridData.itemsWrap);
  var [itemWrap, setitemWrap] = useState(PostGridData.itemWrap);
  var [items, setitems] = useState(PostGridData.items);
  var [loopLayout, setloopLayout] = useState(PostGridData.loopLayout);
  var [masonryOptions, setmasonryOptions] = useState(PostGridData.masonryOptions);
  var [pagination, setpagination] = useState(PostGridData.pagination);
  const [loadingIconHtml, setloadingIconHtml] = useState("");
  const [loadMoreIconHtml, setloadMoreIconHtml] = useState("");
  const [previousIconHtml, setpreviousIconHtml] = useState("");
  const [nextIconHtml, setnextIconHtml] = useState("");
  useEffect(() => {
    var iconSrc = PostGridData.pagination?.loadingIcon?.iconSrc;
    var loadingIconHtml = `<span class="${iconSrc}"></span>`;
    setloadingIconHtml(loadingIconHtml);
    var iconSrc = PostGridData.pagination?.loadMoreIcon?.iconSrc;
    var loadMoreIconHtml = `<span class="${iconSrc}"></span>`;
    setloadMoreIconHtml(loadMoreIconHtml);
    var iconSrc = PostGridData.pagination?.previousIcon?.iconSrc;
    console.log(iconSrc);
    var previousIconHtml = `<span class="${iconSrc}"></span>`;
    setpreviousIconHtml(previousIconHtml);
    var iconSrc = PostGridData.pagination?.nextIcon?.iconSrc;
    var nextIconHtml = `<span class="${iconSrc}"></span>`;
    setnextIconHtml(nextIconHtml);
    setpagination(PostGridData.globalOptions.pagination);
  }, [PostGridData.globalOptions.pagination]);
  useEffect(() => {
    setpostData(props.postData);
  }, [props.postData]);
  useEffect(() => {
    setPostGridData(postData.post_content);
    //setitems(postData.post_content.items);
  }, [postData]);
  useEffect(() => {
    setglobalOptions(PostGridData.globalOptions);
    setwrapper(PostGridData.wrapper);
    setitemsWrap(PostGridData.itemsWrap);
    setitemWrap(PostGridData.itemWrap);
    setitems(PostGridData.items);
    setloopLayout(PostGridData.loopLayout);
    setmasonryOptions(PostGridData.masonryOptions);
    setTimeout(() => {
      loadMasonry();
    }, 2000);
  }, [PostGridData]);
  function unescapeHTML(str) {
    const map = {
      "&amp;": "&",
      "&lt;": "<",
      "&gt;": ">",
      "&quot;": '"',
      "&#039;": "'"
    };
    return str.replace(/&amp;|&lt;|&gt;|&quot;|&#039;/g, function (match) {
      return map[match];
    });
  }
  var blockClass = "#wcps-" + postData.ID;
  function loadMasonry() {
    // var elemX = document.querySelectorAll("." + blockId);
    var elemX = document.querySelector(blockClass + " > .items");
    console.log(elemX);
    if (elemX != null) {
      // elemX.forEach((arg) => {
      // imagesLoaded(elemX, function () {
      var msnry = new (masonry_layout__WEBPACK_IMPORTED_MODULE_0___default())(elemX, masonryOptions);
      // });
      // });
    }
  }
  useEffect(() => {
    setTimeout(() => {
      loadMasonry();
    }, 2000);
  }, [masonryOptions]);
  const Tree = ({
    loopLayout,
    itemData
  }) => {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      children: loopLayout.map(node => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(TreeNode, {
        node: node,
        itemData: itemData
      }, node.id))
    });
  };
  const GenerateNodeHtml = ({
    node,
    itemData
  }) => {
    var nodeType = node.type;
    var nodeId = node.id;
    var html = applyFilters("PostGridElementHtml" + nodeType, '', itemData, node);
    return html;
  };
  const TreeNode = ({
    node,
    itemData
  }) => {
    var nodeType = node.type;
    if (nodeType == "root" || nodeType == "container") {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        id: `element-${node.id}`,
        className: `${node.type}`,
        children: node.children && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
          children: node.children.map(child => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(TreeNode, {
            node: child,
            itemData: itemData
          }, child?.id))
        })
      });
    } else {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(GenerateNodeHtml, {
        node: node,
        itemData: itemData
      });
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
    className: "px-10 py-10",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      id: `wcps-${id}`,
      className: `${wrapper?.options?.class} `,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: `items ${itemsWrap?.options?.class} `,
        children: _dummy_posts__WEBPACK_IMPORTED_MODULE_2__.dummyPosts?.map((item, loopIndex) => {
          var children = PostGridData.loopLayout[0]?.children ? PostGridData.loopLayout[0]?.children : [];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
            className: `${itemWrap?.options?.class} item`,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_LoopItems__WEBPACK_IMPORTED_MODULE_1__["default"], {
              loopLayout: children,
              itemData: item
            })
          }, loopIndex);
        })
      }), PostGridData.globalOptions.itemSource == "posts" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
        class: "pagination ",
        children: [PostGridData.globalOptions?.pagination?.type == "next_previous" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("span", {
            className: "page-numbers prev",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
              className: "",
              dangerouslySetInnerHTML: {
                __html: previousIconHtml
              }
            }), pagination?.previousText]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("span", {
            className: "page-numbers next",
            children: [pagination?.nextText, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
              className: "",
              dangerouslySetInnerHTML: {
                __html: nextIconHtml
              }
            })]
          })]
        }), PostGridData.globalOptions?.pagination?.type == "loadmore" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
            className: "page-numbers",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
              dangerouslySetInnerHTML: {
                __html: loadMoreIconHtml
              }
            }), pagination?.loadMoreText]
          })
        }), PostGridData.globalOptions?.pagination?.type == "infinite" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
          className: "page-numbers",
          children: [pagination.loadMoreText, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
            dangerouslySetInnerHTML: {
              __html: loadingIconHtml
            }
          })]
        }), (PostGridData.globalOptions?.pagination?.type == 'normal' || PostGridData.globalOptions?.pagination?.type == 'ajax') && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
            class: "prev page-numbers",
            href: "#1",
            onClick: ev => {
              ev.preventDefault();
            },
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("span", {
              class: "previous ",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
                className: "",
                dangerouslySetInnerHTML: {
                  __html: previousIconHtml
                }
              }), pagination?.previousText]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
            class: "page-numbers",
            href: "#1",
            onClick: ev => {
              ev.preventDefault();
            },
            children: "1"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
            "aria-current": "page",
            class: "page-numbers current",
            children: "2"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
            class: "page-numbers",
            href: "#3",
            onClick: ev => {
              ev.preventDefault();
            },
            children: "3"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
            class: "page-numbers",
            href: "#4",
            onClick: ev => {
              ev.preventDefault();
            },
            children: "4"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
            class: "page-numbers dots",
            children: "\u2026"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
            class: "page-numbers",
            href: "#6",
            children: "6"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("a", {
            class: "next page-numbers",
            href: "#3",
            onClick: ev => {
              ev.preventDefault();
            },
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("span", {
              class: "next ",
              children: [pagination?.nextText, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
                className: "",
                dangerouslySetInnerHTML: {
                  __html: nextIconHtml
                }
              })]
            })
          })]
        })]
      })]
    })
  });
}
class PreviewMasonry extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      postData,
      id
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Html, {
      postData: postData,
      id: id,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreviewMasonry);

/***/ }),

/***/ "./src/components/BuilderWelcome/PricingTable.js":
/*!*******************************************************!*\
  !*** ./src/components/BuilderWelcome/PricingTable.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


const PricingTable = ({
  data
}) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: "bg-white rounded-md",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "flex items-center justify-center gap-2 py-5",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
        className: "text-gray-700 line-through text-xl font-medium",
        children: data.price
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
        className: "text-gray-700 text-3xl font-bold",
        children: data.salePrice
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "bg-blue-700 py-4 text-center text-white text-xl font-bold",
      children: data.title
    }), data.features.map((item, i) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "py-4 text-center font-medium ",
      children: item
    })), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "flex  items-center justify-center p-4",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("a", {
        href: data.link,
        target: "_blank",
        className: "px-8 py-3 no-underline bg-blue-700 text-white cursor-pointer rounded-md",
        children: ["Buy Now ", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("i", {
          className: "fas fa-cart-plus"
        })]
      })
    })]
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PricingTable);

/***/ }),

/***/ "./src/components/BuilderWelcome/index.js":
/*!************************************************!*\
  !*** ./src/components/BuilderWelcome/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/columns.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/store.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/post-comments.js");
/* harmony import */ var _components_support_ticket__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../components/support-ticket */ "./src/components/support-ticket/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _pricingData__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./pricingData */ "./src/components/BuilderWelcome/pricingData.js");
/* harmony import */ var _PricingTable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./PricingTable */ "./src/components/BuilderWelcome/PricingTable.js");
/* harmony import */ var _plugin_reviews__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./plugin-reviews */ "./src/components/BuilderWelcome/plugin-reviews.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;








var myStore = wp.data.select("PostGridStore");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var [postData, setpostData] = useState(props.postData);
  var addNotifications = props.addNotifications;
  var customerData = props.customerData;
  var appData = props.appData;
  const freeVsProArgs = [{
    feature: "View Type - Grid",
    free: true,
    pro: true
  }, {
    feature: "View Type - Slider",
    free: true,
    pro: true
  }, {
    feature: "View Type - Masonry",
    free: false,
    pro: true
  }, {
    feature: "View Type - Filterable",
    free: false,
    pro: true
  }, {
    feature: "Preloader - Hide WCPS until page load",
    free: true,
    pro: true
  }, {
    feature: "Item Source",
    isHeading: true
  }, {
    feature: "Item Source - Posts",
    free: false,
    pro: true,
    new: true
  }, {
    feature: "Layout Editor",
    isHeading: true
  }, {
    feature: "Tree View",
    free: true,
    pro: true
  }, {
    feature: "Live Preview",
    free: true,
    pro: true
  }, {
    feature: "Advanced Style Component",
    free: true,
    pro: true
  }, {
    feature: "Copy-Paste Layout",
    free: true,
    pro: true
  }, {
    feature: "Duplicate Elements",
    free: true,
    pro: true
  }, {
    feature: "Remove All Elements",
    free: true,
    pro: true
  }, {
    feature: "Element - Post Title",
    free: true,
    pro: true
  }, {
    feature: "Element - Post Excerpt",
    free: true,
    pro: true
  }, {
    feature: "Element - Post Date",
    free: true,
    pro: true
  }, {
    feature: "Element - Post Author",
    free: true,
    pro: true
  }, {
    feature: "Element - Post Author Avatar",
    free: true,
    pro: true
  }, {
    feature: "Element - Post Categories",
    free: true,
    pro: true
  }, {
    feature: "Element - Post Tags",
    free: true,
    pro: true
  }, {
    feature: "Element - Read More",
    free: false,
    pro: true
  }, {
    feature: "Element - Post Thumbnail",
    free: true,
    pro: true
  }, {
    feature: "Element - Custom Text",
    free: false,
    pro: true
  }, {
    feature: "Element - Container",
    free: true,
    pro: true
  }, {
    feature: "Element - Product Price",
    free: false,
    pro: true
  }, {
    feature: "Element - Add To Cart Button",
    free: false,
    pro: true
  }, {
    feature: "Element - Product Sale Badge",
    free: false,
    pro: true
  }, {
    feature: "Element - Total Sales",
    free: false,
    pro: true
  }, {
    feature: "Element - Product SKU",
    free: false,
    pro: true
  }, {
    feature: "Element - Product Stock Quantity",
    free: false,
    pro: true
  }, {
    feature: "Element - Product In Stock",
    free: false,
    pro: true
  }, {
    feature: "Element - Product Ratings",
    free: false,
    pro: true
  }, {
    feature: "Element - Product",
    free: false,
    pro: true
  }];
  const ourPlugins = [{
    name: "Plugin Name 1",
    description: "At  LLC, we have been looking for the best way to create FAQ pages or sections on WordPress sites.",
    logo: "https://upload.wikimedia.org/wikipedia/commons/thumb/9/98/WordPress_blue_logo.svg/512px-WordPress_blue_logo.svg.png",
    link: "https://example.com"
  }, {
    name: "Plugin Name 2",
    description: "At  LLC, we have been looking for the best way to create FAQ pages or sections on WordPress sites.",
    logo: "https://upload.wikimedia.org/wikipedia/commons/thumb/9/98/WordPress_blue_logo.svg/512px-WordPress_blue_logo.svg.png",
    link: "https://example.com"
  }, {
    name: "Plugin Name 3",
    description: "At  LLC, we have been looking for the best way to create FAQ pages or sections on WordPress sites.",
    logo: "https://upload.wikimedia.org/wikipedia/commons/thumb/9/98/WordPress_blue_logo.svg/512px-WordPress_blue_logo.svg.png",
    link: "https://example.com"
  }, {
    name: "Plugin Name 4",
    description: "At  LLC, we have been looking for the best way to create FAQ pages or sections on WordPress sites.",
    logo: "https://upload.wikimedia.org/wikipedia/commons/thumb/9/98/WordPress_blue_logo.svg/512px-WordPress_blue_logo.svg.png",
    link: "https://example.com"
  }, {
    name: "Plugin Name 5",
    description: "At  LLC, we have been looking for the best way to create FAQ pages or sections on WordPress sites.",
    logo: "https://upload.wikimedia.org/wikipedia/commons/thumb/9/98/WordPress_blue_logo.svg/512px-WordPress_blue_logo.svg.png",
    link: "https://example.com"
  }, {
    name: "Plugin Name 6",
    description: "At  LLC, we have been looking for the best way to create FAQ pages or sections on WordPress sites.",
    logo: "https://upload.wikimedia.org/wikipedia/commons/thumb/9/98/WordPress_blue_logo.svg/512px-WordPress_blue_logo.svg.png",
    link: "https://example.com"
  }];
  const copyData = data => {
    navigator.clipboard.writeText(data).then(() => {
      addNotifications({
        title: "Coupon Code Copied!",
        content: "Please use coupon code on checkout page.",
        type: "success"
      });
    }).catch(err => {});
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
    className: "ml-5",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "flex justify-between items-center p-5 pb-20 bg-white ",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          className: "flex justify-between items-center gap-3",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
            className: "text-4xl font-extrabold",
            children: appData.name
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
            className: "text-base",
            children: "By PickPlugins"
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          className: "my-3 flex items-center gap-3",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("a", {
            className: " ",
            href: appData.demoUrl,
            target: "_blank",
            children: "Live Demo"
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          className: "my-4 max-w-52",
          children: "Help us by providing your feedbacks and five star reviews on wordpress.org \uD83C\uDF1F\uD83C\uDF1F\uD83C\uDF1F\uD83C\uDF1F\uD83C\uDF1F"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("a", {
          className: " bg-amber-500 text-white no-underline font-medium px-[16px] py-[8px]  hover:bg-amber-700 hover:text-white rounded-md w-max transition-colors duration-300",
          href: appData.reviewsUrl,
          target: "_blank",
          children: "Submit Reviews"
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_components_tabs__WEBPACK_IMPORTED_MODULE_2__["default"], {
      activeTab: "overview",
      orientation: "",
      tabsWrapperClass: "mt-[-50px] ",
      contentClass: " w-full",
      navItemsWrapClass: "gap-3 px-10",
      navItemClass: " px-5 py-3 gap-2 rounded-t-md",
      navItemSelectedClass: "!bg-white border-2  border-b-0 border-solid  border-blue-700",
      activeClass: "active-tab",
      onSelect: tabName => {},
      tabs: [{
        name: "overview",
        title: "Overview",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__["default"],
        className: "tab-disable-blocks"
      }, {
        name: "edit",
        title: "Free Vs Pro",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__["default"],
        className: "tab-disable-blocks"
      },
      // {
      // 	name: "templates",
      // 	title: "About Us",
      // 	icon: postAuthor,
      // 	className: "tab-disable-blocks",
      // },
      {
        name: "buyNow",
        title: "Buy Now",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_9__["default"],
        className: "tab-disable-blocks"
      }, {
        name: "supportTicket",
        title: "Send Feedbacks",
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_10__["default"],
        className: "tab-disable-blocks"
      }],
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_components_tab__WEBPACK_IMPORTED_MODULE_1__["default"], {
        name: "overview",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          className: "flex gap-4 items-start flex-wrap mt-10 px-10",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            className: "flex-1 flex flex-col gap-3 p-[40px] max-w-[70%] bg-white rounded-md shadow-md",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("h2", {
              className: "text-[32px] font-semibold text-gray-800",
              children: "Super Excited to See you!"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
              className: "text-gray-500 text-[14px]",
              children: "Thanks for installing WCPS plugin! Watch this video to get started."
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("iframe", {
              width: "100%",
              height: "400",
              src: "https://www.youtube.com/embed/GMCnyCbc9Mc?si=j6ioIYBOT6DiWpjR",
              title: "YouTube video player",
              className: "rounded-md overflow-hidden",
              frameborder: "0",
              allow: "accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share",
              referrerpolicy: "strict-origin-when-cross-origin",
              allowfullscreen: true
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            className: "grid md:grid-cols-1 grid-cols-3 content-between md:max-w-[30%] max-w-full gap-3 text-gray-800",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              className: "flex flex-col gap-3 bg-white p-[20px] rounded-md shadow-md",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
                className: "text-[18px] font-semibold flex items-center gap-2",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  children: "\uD83C\uDF1F"
                }), "Videos"]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
                children: "Watch our videos to see how the WCPS works in real-world projects!"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("a", {
                target: "_blank",
                href: "https://www.youtube.com/watch?v=GMCnyCbc9Mc&list=PL0QP7T2SN94Yut5Y0MSVg1wqmqWz0UYpt&index=2",
                className: "inline-block no-underline font-medium px-[16px] py-[8px] border border-solid border-gray-700 text-gray-700 hover:bg-gray-700 hover:text-white rounded-md w-max transition-colors duration-300",
                children: "Watch on YouTube"
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              className: "flex flex-col gap-3 bg-white p-[20px] rounded-md shadow-md",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
                className: "text-[18px] font-semibold flex items-center gap-2",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  children: "\uD83C\uDF1F"
                }), "Documentation"]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
                children: "Check out our detailed documentation to learn what the WCPS plugin can do!"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("a", {
                target: "_blank",
                href: "#",
                className: "inline-block no-underline font-medium px-[16px] py-[8px] border border-solid border-gray-700 text-gray-700 hover:bg-gray-700 hover:text-white rounded-md w-max transition-colors duration-300",
                children: "Check Documentation"
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              className: "flex flex-col gap-3 bg-white p-[20px] rounded-md shadow-md",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
                className: "text-[18px] font-semibold flex items-center gap-2",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                  children: "\uD83C\uDF1F"
                }), "Need Help?"]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
                children: "Contact our friendly support team for quick and personalized help!"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("a", {
                target: "_blank",
                href: "https://pickplugins.com/create-support-ticket/",
                className: "inline-block no-underline font-medium px-[16px] py-[8px] border border-solid border-gray-700 text-gray-700 hover:bg-gray-700 hover:text-white rounded-md w-max transition-colors duration-300",
                children: "Create Support Ticket"
              })]
            })]
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_components_tab__WEBPACK_IMPORTED_MODULE_1__["default"], {
        name: "edit",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          className: " rounded-md   mt-10 px-10",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("table", {
            className: "table-auto w-full text-left",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("thead", {
              className: "bg-gray-700 text-white",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("tr", {
                className: "",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("th", {
                  className: "min-w-[550px] py-4 px-8",
                  children: "FEATURES"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("th", {
                  className: "min-w-[100px] py-4 px-8 text-center",
                  children: "Free"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("th", {
                  className: "min-w-[100px] py-4 px-8 text-center",
                  children: "\uD83D\uDC51PRO"
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("tbody", {
              className: "bg-gray-100 text-gray-800",
              children: freeVsProArgs.map((item, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
                children: [item.isHeading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("tr", {
                  className: "bg-gray-400 last:rounded-b-md last:overflow-hidden",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("td", {
                    className: "py-3 px-8",
                    colSpan: "3",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
                      className: "flex gap-2 items-center ",
                      children: [item.feature && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                        className: "text-base",
                        children: item.feature
                      }), item.new && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                        className: "text-emerald-100 inline-block text-[12px] leading-none px-2 py-1 bg-emerald-500 rounded-full",
                        children: "NEW"
                      }), item.hot && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                        className: "text-red-100 inline-block text-[12px] leading-none px-2 py-1 bg-orange-400 rounded-full",
                        children: "HOT"
                      })]
                    })
                  })
                }, index), !item?.isHeading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("tr", {
                  className: "even:bg-gray-200 last:rounded-b-md last:overflow-hidden",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("td", {
                    className: "py-3 px-8",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
                      className: "flex gap-2 items-center",
                      children: [item.feature && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                        children: item.feature
                      }), item.new && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                        className: "text-emerald-100 inline-block text-[12px] leading-none px-2 py-1 bg-emerald-500 rounded-full",
                        children: "NEW"
                      }), item.hot && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                        className: "text-red-100 inline-block text-[12px] leading-none px-2 py-1 bg-orange-400 rounded-full",
                        children: "HOT"
                      })]
                    })
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("td", {
                    className: "py-3 px-8  text-center",
                    children: [item.free && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                      children: "\u2714\uFE0F"
                    }), !item.free && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                      children: "\u274C"
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("td", {
                    className: "py-3 px-8 text-center",
                    children: [item.pro && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                      children: "\u2714\uFE0F"
                    }), !item.pro && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                      children: "\u274C"
                    })]
                  })]
                }, index)]
              }))
            })]
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_components_tab__WEBPACK_IMPORTED_MODULE_1__["default"], {
        name: "templates",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          className: "grid grid-cols-2 gap-4 w-full p-7 bg-white mt-10",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
            className: "self-center",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("figure", {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("img", {
                src: "https://images.pexels.com/photos/1595385/pexels-photo-1595385.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1",
                alt: "",
                className: "w-full rounded-lg shadow-sm object-contain"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("figcaption", {
                className: "text-sm text-center mt-2",
                children: "Team"
              })]
            })
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("h3", {
            className: "text-2xl font-medium my-8",
            children: "Improve your website with our top-notch plugins!"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
            className: "grid grid-cols-3 gap-4",
            children: ourPlugins.map(plugin => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              className: "bg-gray-200 hover:bg-gray-300 shadow-sm p-8 rounded-lg relative",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("h4", {
                className: "font-medium text-lg mb-4",
                children: plugin.name
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
                className: "text-[14px]",
                children: plugin.description
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("a", {
                target: "_blank",
                href: plugin.link,
                className: "absolute inset-0 "
              })]
            }))
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_components_tab__WEBPACK_IMPORTED_MODULE_1__["default"], {
        name: "supportTicket",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          className: " mx-10 p-5 my-10 bg-white rounded-sm",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_components_support_ticket__WEBPACK_IMPORTED_MODULE_0__["default"], {})
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_components_tab__WEBPACK_IMPORTED_MODULE_1__["default"], {
        name: "buyNow",
        children: [customerData.isPro && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          className: "mx-10 p-5 my-10  rounded-sm text-center bg-orange-200",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("h3", {
            className: "text-2xl ",
            children: "You already purchased, Want to Buy Again!"
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          className: "flex items-center justify-between mx-10 p-5 my-10 bg-white rounded-sm",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("h3", {
              className: "text-2xl ",
              children: "Unlock Pro Features"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
              className: "text-base",
              children: "Get 25% off today by using our exclusive coupon code!"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
              className: "p-2 px-4 border-2 border-blue-600 border-dashed cursor-pointer text-xl",
              onClick: () => {
                var str = `BUILDER25`;
                copyData(str);
              },
              children: "BUILDER25"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
              className: "text-center p-3",
              children: "Click To Copy"
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_components_tabs__WEBPACK_IMPORTED_MODULE_2__["default"], {
          activeTab: "yearly",
          orientation: "",
          tabsWrapperClass: "mt-[50px] ",
          contentClass: " w-full",
          navItemsWrapClass: "gap-3 px-10 justify-center",
          navItemClass: " px-5 py-3 gap-2 rounded-md",
          navItemSelectedClass: "!bg-white border-2  border-solid  border-blue-700",
          activeClass: "active-tab",
          onSelect: tabName => {},
          tabs: [{
            name: "yearly",
            title: "Yearly",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__["default"],
            className: "tab-yearly"
          }, {
            name: "lifetime",
            title: "Lifetime",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__["default"],
            className: "tab-lifetime"
          }
          // {
          // 	name: "freeTrail",
          // 	title: "Free Trail",
          // 	icon: columns,
          // 	className: "tab-yearly",
          // },
          ],
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_components_tab__WEBPACK_IMPORTED_MODULE_1__["default"], {
            name: "yearly",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
              className: "grid grid-cols-3 gap-6 mt-10 px-10",
              children: _pricingData__WEBPACK_IMPORTED_MODULE_3__.pricingData.yearly.map((item, i) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_PricingTable__WEBPACK_IMPORTED_MODULE_4__["default"], {
                data: item
              }, i))
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_components_tab__WEBPACK_IMPORTED_MODULE_1__["default"], {
            name: "lifetime",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
              className: "grid grid-cols-3 gap-6 mt-10 px-10",
              children: _pricingData__WEBPACK_IMPORTED_MODULE_3__.pricingData.lifetime.map((item, i) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_PricingTable__WEBPACK_IMPORTED_MODULE_4__["default"], {
                data: item
              }, i))
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_components_tab__WEBPACK_IMPORTED_MODULE_1__["default"], {
            name: "freeTrail",
            children: "freeTrail"
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
          className: "flex items-center justify-between mx-10 p-5 my-10 bg-white rounded-sm",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("h3", {
              className: "text-2xl ",
              children: "Enjoy a 14-Day Money-Back Guarantee\u2014No Questions Asked!"
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
              className: "text-base",
              children: "We are committed to ensuring 100% satisfaction with our plugin and support. If, for any reason, our plugin doesn't meet your expectations, simply let us know. We'll provide a full refund within 14 days of your purchase\u2014no questions asked. Learn more in our refund policy."
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
              className: "p-2 px-4 ",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("svg", {
                width: "212",
                height: "28",
                viewBox: "0 0 212 28",
                fill: "none",
                xmlns: "http://www.w3.org/2000/svg",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M42.5847 13.8542H48.8882C48.4685 12.2528 47.3185 11.6035 45.9179 11.6035C44.3778 11.6035 43.1437 12.4429 42.5847 13.8542M52.5864 16.5927H42.3611C42.7808 18.6553 44.517 19.4153 46.0296 19.4153C47.9346 19.4153 48.749 18.2756 48.749 18.2756H52.2783C51.213 20.9877 48.6646 22.4787 45.9179 22.4787C42.1353 22.4787 38.8297 19.6848 38.8297 15.4551C38.8297 11.25 42.1078 8.646 45.8059 8.646C49.3924 8.646 53.0358 11.0598 52.5864 16.5927",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M87.3226 15.5633C87.3226 13.4474 86.0337 11.7932 83.905 11.7932C81.7745 11.7932 80.346 13.4474 80.346 15.5633C80.346 17.6792 81.7745 19.3333 83.905 19.3333C86.0337 19.3333 87.3226 17.6792 87.3226 15.5633M76.6754 15.5896C76.6754 11.25 80.1499 8.646 83.905 8.646C87.6876 8.646 90.9932 11.2764 90.9932 15.5345C90.9932 19.848 87.5735 22.4784 83.7912 22.4784C79.9811 22.4784 76.6754 19.848 76.6754 15.5896",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M105.991 14.9937V22.3439H102.263V15.8064C102.263 15.3449 102.601 11.9279 99.9113 11.7935C98.5927 11.7117 96.2403 12.416 96.2403 15.9699V22.3439H92.5425V8.78076H95.9372L95.9482 10.6636C95.9482 10.6636 97.4788 8.646 100.333 8.646C103.947 8.646 105.991 11.25 105.991 14.9937",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M119.618 11.5216C118.441 11.5216 117.936 12.0914 117.936 12.6613C117.936 13.5824 119.198 13.854 120.038 14.0175C122.533 14.5319 125.054 15.2653 125.054 18.1385C125.054 20.9326 122.673 22.4787 119.787 22.4787C116.565 22.4787 114.072 20.5814 113.903 17.7058H117.348C117.432 18.5185 117.993 19.5764 119.702 19.5764C121.13 19.5764 121.468 18.8455 121.468 18.2756C121.468 17.2707 120.487 16.9724 119.533 16.7559C117.882 16.4026 114.323 15.7534 114.323 12.6613C114.323 10.0022 116.958 8.646 119.675 8.646C122.812 8.646 124.885 10.4903 125.054 12.7694H121.607C121.495 12.3079 121.048 11.5216 119.618 11.5216",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M136.381 15.5633C136.381 13.3106 135.12 11.9831 133.299 11.9831C131.59 11.9831 129.879 13.1758 129.879 15.5633C129.879 17.9487 131.59 19.1435 133.299 19.1435C135.12 19.1435 136.381 17.814 136.381 15.5633V15.5633ZM139.883 8.78076V27.7681H136.381V21.0141C135.485 21.9903 134.223 22.4784 132.765 22.4784C129.209 22.4784 126.238 19.6582 126.238 15.5632C126.238 11.4662 129.209 8.646 132.765 8.646C135.561 8.646 136.608 10.4625 136.608 10.4625L136.603 8.78076H139.883Z",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M159.905 13.8542H166.208C165.788 12.2528 164.638 11.6035 163.238 11.6035C161.698 11.6035 160.464 12.4429 159.905 13.8542M169.906 16.5927H159.679C160.101 18.6553 161.837 19.4153 163.349 19.4153C165.254 19.4153 166.069 18.2756 166.069 18.2756H169.598C168.533 20.9877 165.984 22.4787 163.238 22.4787C159.455 22.4787 156.15 19.6848 156.15 15.4551C156.15 11.25 159.428 8.646 163.126 8.646C166.712 8.646 170.356 11.0598 169.906 16.5927",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M174.791 13.8542H181.094C180.674 12.2528 179.524 11.6035 178.124 11.6035C176.584 11.6035 175.35 12.4429 174.791 13.8542M184.792 16.5927H174.567C174.987 18.6553 176.723 19.4153 178.235 19.4153C180.141 19.4153 180.955 18.2756 180.955 18.2756H184.484C183.419 20.9877 180.87 22.4787 178.124 22.4787C174.341 22.4787 171.036 19.6848 171.036 15.4551C171.036 11.25 174.314 8.646 178.012 8.646C181.598 8.646 185.242 11.0598 184.792 16.5927",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M197.267 19.3069V22.3436H185.36V20.5527L192.113 11.8198H185.641V8.78076H196.988V10.5717L190.235 19.3069H197.267Z",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M211.845 8.78076V20.7161V20.9877C211.845 24.6497 209.91 27.9053 205.119 27.9053C200.636 27.9053 198.2 25.056 198.2 22.9138H201.702C201.702 22.9138 202.233 24.7314 205.007 24.7314C207.362 24.7314 208.343 23.4282 208.343 21.5309V20.9611C207.724 21.6393 206.55 22.4787 204.448 22.4787C200.778 22.4787 198.48 19.9034 198.48 16.1331L198.451 8.78076H202.094V15.3183C202.094 17.1623 202.767 19.3336 205.092 19.3336C206.296 19.3336 208.286 18.7637 208.286 15.1548V8.78076H211.845Z",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M36.1626 18.2723C36.1626 19.1181 36.4958 19.467 37.1141 19.467C37.5497 19.467 37.8327 19.4164 38.2454 19.2926L38.4761 22.0799C37.7048 22.3272 36.959 22.4774 36.0075 22.4774C33.8244 22.4774 32.4874 21.7817 32.4874 18.7693V3.35645H36.1626V18.2723Z",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M75.0944 14.9937V22.3439H71.3665V15.8064C71.3665 13.9357 71.563 11.5749 68.9848 11.7935C68.3142 11.8465 66.4639 12.1444 66.4639 15.9699V22.3439H62.7658V15.8064C62.7658 13.9357 62.9619 11.5749 60.3841 11.7935C59.711 11.8465 57.8632 12.1444 57.8632 15.9699V22.3439H54.165V8.78075H57.56L57.5631 10.6636C57.5631 10.6636 58.8605 8.64599 61.2805 8.64599C64.1966 8.64599 65.3412 10.8424 65.3412 10.8424C65.3412 10.8424 66.5967 8.61963 69.7992 8.61963C73.4405 8.61963 75.0944 11.2236 75.0944 14.9937",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M141.455 16.131V8.78076H145.183V15.3183C145.183 15.7797 144.845 19.1967 147.535 19.3312C148.853 19.413 151.205 18.7086 151.205 15.1548V8.78076H154.904V22.3439H151.513L151.498 20.4611C151.498 20.4611 149.967 22.4787 147.113 22.4787C143.499 22.4787 141.455 19.8747 141.455 16.131",
                  fill: "#121217"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M6.92836 17.1856L14.4397 20.6583C15.3706 21.0889 16.0278 21.8116 16.3827 22.6406C17.2803 24.7399 16.0535 26.8869 14.1276 27.6591C12.2015 28.4309 10.1486 27.9342 9.21523 25.7511L5.94631 18.0866C5.693 17.4925 6.32934 16.9087 6.92836 17.1856",
                  fill: "#FFC233"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M7.37953 14.9376L15.1332 12.0066C17.71 11.0325 20.525 12.8756 20.487 15.5536C20.4864 15.5886 20.4858 15.6235 20.4849 15.6588C20.4292 18.2666 17.6926 20.0194 15.1723 19.0968L7.38688 16.2473C6.76583 16.0201 6.76124 15.1713 7.37953 14.9376",
                  fill: "#FFC233"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M6.9449 13.9224L14.567 10.6837C17.0998 9.60736 17.7426 6.37695 15.7589 4.51043C15.7329 4.48585 15.7069 4.46156 15.6806 4.43728C13.7357 2.63207 10.5207 3.26767 9.41349 5.64539L5.99314 12.9915C5.72024 13.5773 6.33701 14.1806 6.9449 13.9224",
                  fill: "#FFC233"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("path", {
                  "fill-rule": "evenodd",
                  "clip-rule": "evenodd",
                  d: "M4.98349 12.6426L7.75465 5.04415C8.09822 4.102 8.03458 3.1412 7.67939 2.3122C6.77994 0.21378 4.34409 -0.463579 2.41853 0.309741C0.493284 1.08336 -0.594621 2.84029 0.340622 5.02253L3.63095 12.6787C3.8861 13.272 4.76261 13.2486 4.98349 12.6426",
                  fill: "#FFC233"
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              className: "text-center p-3",
              children: ["Secure Payment by", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                className: "font-bold",
                children: "Lemon Squeezy"
              })]
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          className: "grid grid-cols-3 gap-5 mx-10",
          children: _plugin_reviews__WEBPACK_IMPORTED_MODULE_5__.pluginReviews.map((item, i) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
            className: " flex flex-col text-center",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
              className: "bg-white shadow-lg rounded-lg p-6 text-left text-gray-600",
              children: item.comment
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
              className: "flex items-center gap-6",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("img", {
                src: item.profileImage,
                alt: `${name}'s profile`,
                className: "w-12 h-12 rounded-full border border-gray-300"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("a", {
                  href: item.profileLink,
                  target: "_blank",
                  rel: "noopener noreferrer",
                  className: "flex flex-col",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("p", {
                    className: "font-bold text-gray-700 text-xl my-2 mb-1",
                    children: item.name
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
                  className: "flex items-center text-2xl",
                  children: [...Array(item.stars)].map((_, i) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
                    className: "text-yellow-500",
                    children: "\u2605"
                  }, i))
                })]
              })]
            })]
          }, i))
        })]
      })]
    })]
  });
}
class BuilderWelcome extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      postData,
      appData,
      addNotifications,
      customerData
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(Html, {
      postData: postData,
      addNotifications: addNotifications,
      customerData: customerData,
      appData: appData,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BuilderWelcome);

/***/ }),

/***/ "./src/components/BuilderWelcome/plugin-reviews.js":
/*!*********************************************************!*\
  !*** ./src/components/BuilderWelcome/plugin-reviews.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   pluginReviews: () => (/* binding */ pluginReviews)
/* harmony export */ });
const pluginReviews = [{
  title: "Great plugin and support",
  comment: "The support is excellent and that is what gives extra points to this great plugin!",
  name: "nadine7486",
  profileLink: "https://wordpress.org/support/users/nadine7486/",
  profileImage: "https://secure.gravatar.com/avatar/deec2d560e674e83b393044424ac7d6572baa186f12a875438dd8db0d3cfc36b?s=100&d=retro&r=g",
  link: "https://wordpress.org/support/topic/great-plugin-and-support-555/",
  stars: 5
}, {
  title: "The perfect plugin for WooCommerce Product slider",
  comment: "It has so many customization options! Thanks a lot! Amazing work.",
  name: "Creative Andrew ",
  profileLink: "https://wordpress.org/support/users/geisthanen/",
  profileImage: "https://secure.gravatar.com/avatar/be37c38b5463d12443cb7fab8d3f1dacadc663bca1e938e05b9a9a95e743e3de?s=100&d=retro&r=g",
  link: "https://wordpress.org/support/topic/the-perfect-plugin-for-woocommerce-product-slider/",
  stars: 5
}, {
  title: "Beautiful clean product slider and great support",
  comment: "I tried numerous plugins to achieve a clean look and nice user interface for a laterally sliding product image slider for woocommerce. There is only one that gives the options for customization and really clean appearance. Once you know how to work the settings for product or category query and style settings, operation is very simple. When I have needed some customizing support, I paid the fair price for pro version and got all issues resolved with the knowledgable and kind support at Pick Plugins. Its rare to find a plugin that will do exactly what you want it to do…. I love this plugin!",
  name: "jdougherty2282",
  profileLink: "https://wordpress.org/support/users/jdougherty2282/",
  profileImage: "https://secure.gravatar.com/avatar/6aca2800708efd511dfd8238827bdcfe7291df1dc9a035c48c64bed5b1c8ed1e?s=100&d=retro&r=g",
  link: "https://wordpress.org/support/topic/beautiful-clean-product-slider-and-great-support/",
  stars: 5
}, {
  title: "Wonderful!!",
  comment: "I have been able to do most of what I need to do with the free option of the plugin because there are so many wonderful customization options. I plan to buy the plugin just to spice it up even more!",
  name: "SaraStJohn ",
  profileLink: "https://wordpress.org/support/users/sarastjohn/",
  profileImage: "https://secure.gravatar.com/avatar/3b314ce2e5186e4ece33cf91ff5d076fc23aae45506a4fab34b51d68e4d47721?s=100&d=retro&r=g",
  link: "https://wordpress.org/support/topic/wonderful-466/",
  stars: 5
}, {
  title: "Awesome plugin!",
  comment: "Great job! This plugin works perfect! Thank you.",
  name: "davidzupec",
  profileLink: "https://wordpress.org/support/users/davidzupec/",
  profileImage: "https://secure.gravatar.com/avatar/ff9a15b1f61f559b3c8bfb8960d02b942a68b8e7769e4ae0227d46ec59dd421b?s=100&d=retro&r=g",
  link: "https://wordpress.org/support/topic/awesome-plugin-1882/",
  stars: 5
}, {
  title: "Excellent",
  comment: "Works a treat and painless to use.",
  name: "robgs",
  profileLink: "https://wordpress.org/support/users/robgs/",
  profileImage: "https://secure.gravatar.com/avatar/256edf46bac1000520c31e365e1ff95cec4da037447963fdc94b51d63f2982c3?s=100&d=retro&r=g",
  link: "https://wordpress.org/support/topic/excellent-3579/",
  stars: 5
}, {
  title: "its great!!! easy and comfy",
  comment: "its great !! easy to use, and hebrew support!!.",
  name: "galirimon",
  profileLink: "https://wordpress.org/support/users/galirimon/",
  profileImage: "https://secure.gravatar.com/avatar/c5a98c5e1b81e07217276cde923012577db95ed14125b56da19c88daf16b6fd8?s=100&d=retro&r=g",
  link: "https://wordpress.org/support/topic/its-great-easy-and-comfy/",
  stars: 5
}];

/***/ }),

/***/ "./src/components/BuilderWelcome/pricingData.js":
/*!******************************************************!*\
  !*** ./src/components/BuilderWelcome/pricingData.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   pricingData: () => (/* binding */ pricingData)
/* harmony export */ });
const pricingData = {
  yearly: [{
    title: "Personal",
    features: ["Up to 3 Sites", "1 Year of Updates", "1 Year Free Support", "Access to All PRO Features"],
    price: "$29",
    salePrice: "$19",
    link: "https://pickplugins.lemonsqueezy.com/buy/0ae63e9a-ce87-4683-9514-9626ae4c38b9?enabled=294490"
  }, {
    title: "Plus",
    features: ["Up to 10 Sites", "1 Year of Updates", "1 Year Free Support", "Access to All PRO Features"],
    price: "$75",
    salePrice: "$49",
    link: "https://pickplugins.lemonsqueezy.com/buy/751c5c9a-eb92-48df-b41c-cf02c0afe9f2?enabled=294492"
  }, {
    title: "Agency",
    features: ["Up to 500 Sites", "1 Year of Updates", "1 Year Free Support", "Access to All PRO Features"],
    price: "$149",
    salePrice: "$99",
    link: "https://pickplugins.lemonsqueezy.com/buy/dc476d99-f2fe-499d-9f5c-25c1b56136fa?enabled=294496"
  }],
  lifetime: [{
    title: "Personal",
    features: ["Up to 3 Sites", "Lifetime Free Updates", "Lifetime Support", "Access to All PRO Features"],
    price: "$99",
    salePrice: "$49",
    link: "https://pickplugins.lemonsqueezy.com/buy/ca27a51c-5da2-459d-82d0-ba61bb82878e?enabled=294491"
  }, {
    title: "Plus",
    features: ["Up to 10 Sites", "Lifetime Free Updates", "Lifetime Support", "Access to All PRO Features"],
    price: "$149",
    salePrice: "$99",
    link: "https://pickplugins.lemonsqueezy.com/buy/1e500b1d-727f-45f7-8ee1-86fe8cec8cf7?enabled=294493"
  }, {
    title: "Agency",
    features: ["Up to 500 Sites", "Lifetime Free Updates", "Lifetime Support", "Access to All PRO Features"],
    price: "$199",
    salePrice: "$149",
    link: "https://pickplugins.lemonsqueezy.com/buy/54071a32-bce5-4e55-afcf-9fa66223ab07?enabled=294497"
  }]
};

/***/ }),

/***/ "./src/components/Builder/default-data-carousel.js":
/*!*********************************************************!*\
  !*** ./src/components/Builder/default-data-carousel.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var SliderDefaultData = {
  globalOptions: {
    viewType: "viewSlider",
    itemSource: "posts",
    search: true
  },
  itemQueryArgs: {
    "postType": {
      "id": "postType",
      "value": ["post"]
    },
    "order": {
      "id": "order",
      "value": "DESC"
    },
    "orderby": {
      "id": "orderby",
      "value": ["date"]
    },
    "postStatus": {
      "id": "postStatus",
      "value": ["publish"]
    },
    "postsPerPage": {
      "id": "postsPerPage",
      "value": "5"
    }
  },
  items: [],
  loopLayout: [{
    "id": 1,
    "type": "root",
    "children": [{
      "id": 2,
      "type": "layer",
      "children": [{
        "id": 5,
        "type": "postThumbnail",
        "content": "",
        "parent_id": 2,
        "options": {
          "thumbnailSize": "full",
          "srcId": "",
          "srcUrl": "",
          "defaultSrcUrl": "https://comboblocks.com/server/wp-content/uploads/2024/11/da41bd7c-7420-3c0a-b169-d2d87acba187.jpg",
          "linkTo": "postUrl"
        },
        "cssSelectors": {
          "wrapper": {
            "handle": "",
            "label": "Featured Image Wrapper",
            "styles": {}
          },
          "img": {
            "handle": "img",
            "label": "Image",
            "styles": {
              "width": {
                "Desktop": "100%"
              }
            }
          },
          "a": {
            "handle": "a",
            "label": "Link",
            "styles": {}
          }
        },
        "chosen": false,
        "selected": false
      }, {
        "id": 3,
        "type": "postTitle",
        "content": "Dummy Title",
        "parent_id": 2,
        "options": {
          "linkTo": "postUrl",
          "target": "_blank"
        },
        "cssSelectors": {
          "wrapper": {
            "handle": "",
            "label": "Post Title Wrapper",
            "styles": {
              "fontSize": {
                "Desktop": "16px"
              }
            }
          },
          "a": {
            "handle": "a",
            "label": "Post Title Link",
            "styles": {}
          }
        },
        "chosen": false,
        "selected": false
      }, {
        "id": 4,
        "type": "postExcerpt",
        "parent_id": 2,
        "options": {
          "limitBy": "",
          "limitCount": 20,
          "readMoreText": "Read More"
        },
        "cssSelectors": {
          "wrapper": {
            "handle": "",
            "label": "Excerpt Wrapper",
            "styles": {}
          },
          "excerpt-text": {
            "handle": ".excerpt-text",
            "label": "Excerpt Text",
            "styles": {
              "fontSize": {
                "Desktop": "16px"
              }
            }
          },
          "redmore": {
            "handle": ".redmore",
            "label": "Redmore Text",
            "styles": {
              "fontSize": {
                "Desktop": "18px"
              }
            }
          }
        },
        "chosen": false,
        "selected": false
      }],
      "parent_id": 1,
      "styles": {},
      "options": {
        "animateOn": ""
      },
      "chosen": false,
      "selected": false
    }],
    "parent_id": null,
    "styles": {},
    "chosen": false,
    "selected": false
  }],
  wrapper: {
    options: {
      content: "",
      tag: "div",
      class: "wcps-wrapper"
    },
    styles: {}
  },
  itemsWrap: {
    options: {
      class: "items"
    },
    styles: {}
  },
  itemWrap: {
    options: {
      class: "item"
    },
    styles: {}
  },
  navsWrap: {
    options: {
      class: "nav-wrap"
    },
    styles: {
      "display": {
        "Desktop": "flex"
      },
      "width": {
        "Desktop": "100%"
      },
      "alignItems": {
        "Desktop": "center"
      },
      "position": {
        "Desktop": "absolute !important"
      },
      "top": {
        "Desktop": "-50px"
      },
      "left": {
        "Desktop": "20px"
      },
      "gap": {
        "Desktop": "20px"
      },
      "justifyContent": {
        "Desktop": "right"
      }
    }
  },
  navItem: {
    options: {
      class: "nav-item"
    },
    styles: {
      "fontSize": {
        "Desktop": "18px"
      },
      "fontStyle": {
        "Desktop": "normal"
      },
      "fontWeight": {
        "Desktop": "400"
      },
      "textAlign": {
        "Desktop": "left"
      },
      "color": {
        "Desktop": "#ffffff"
      },
      "backgroundColor": {
        "Desktop": "#1F2E45"
      },
      "borderRadius": {
        "Desktop": "50px"
      },
      "padding": {
        "Desktop": "5px 20px 5px 20px"
      }
    }
  },
  prev: {
    options: {
      text: "Prev",
      class: ""
    },
    styles: {}
  },
  prevIcon: {
    options: {
      position: "before",
      class: "",
      library: "fontAwesome",
      srcType: "class",
      iconSrc: "fas fa-chevron-left"
    },
    styles: {}
  },
  next: {
    options: {
      text: "Next",
      class: ""
    },
    styles: {}
  },
  nextIcon: {
    options: {
      position: "after",
      class: "",
      library: "fontAwesome",
      srcType: "class",
      iconSrc: "fas fa-chevron-right"
    },
    styles: {}
  },
  paginationWrap: {
    options: {
      type: "",
      tag: "",
      class: ""
    },
    styles: {
      "display": {
        "Desktop": "flex"
      },
      "justifyContent": {
        "Desktop": "center"
      },
      "paddingTop": {
        "Desktop": "30px"
      }
    }
  },
  paginationItem: {
    options: {
      tag: "",
      class: ""
    },
    styles: {
      "backgroundColor": {
        "Desktop": "#f1f7f9"
      },
      "width": {
        "Desktop": "15px"
      },
      "height": {
        "Desktop": "15px"
      },
      "margin": {
        "Desktop": "0px 10px 0px 0px"
      },
      "borderRadius": {
        "Desktop": " 20px 20px 20px 20px"
      },
      "border": {
        "Desktop": "1px solid #1f2937"
      }
    }
  },
  paginationItemActive: {
    options: {
      class: ""
    },
    styles: {
      "backgroundColor": {
        "Desktop": "#1f2e45"
      }
    }
  },
  sliderOptions: {
    perPage: "3",
    perMove: "1",
    autoplay: "1",
    gap: "1em",
    pagination: "1",
    drag: "1",
    arrows: "1",
    pauseOnHover: "1",
    speed: "400"
  },
  sliderOptionsRes: {}
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SliderDefaultData);

/***/ }),

/***/ "./src/components/Builder/default-data-fliterable.js":
/*!***********************************************************!*\
  !*** ./src/components/Builder/default-data-fliterable.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var FilterableDefaultData = {
  globalOptions: {
    viewType: "viewFilterable",
    itemSource: "posts",
    search: true,
    allText: "All",
    logicWithinGroup: "",
    logicBetweenGroups: "",
    multifilter: false,
    showSort: "",
    filterToggle: "no",
    showRandom: "",
    showAll: "yes",
    showClear: "",
    activeFilter: "",
    perPage: 6,
    filters: [],
    pagination: {
      type: 'filterable',
      nextText: "Next",
      previousText: "Previous",
      loadMoreText: "Load More",
      loadingText: "Loading...",
      noPostText: "No More Posts",
      "nextIcon": {
        "library": "fontAwesome",
        "srcType": "class",
        "iconSrc": "",
        "class": "load-more"
      },
      "previousIcon": {
        "library": "fontAwesome",
        "srcType": "class",
        "iconSrc": "",
        "class": "load-more"
      },
      "loadingIcon": {
        "library": "fontAwesome",
        "srcType": "class",
        "iconSrc": "",
        "class": "load-more"
      },
      "loadMoreIcon": {
        "library": "fontAwesome",
        "srcType": "class",
        "iconSrc": "",
        "class": "load-more"
      }
    }
  },
  itemQueryArgs: {
    "postType": {
      "id": "postType",
      "value": ["post"]
    },
    "order": {
      "id": "order",
      "value": "DESC"
    },
    "orderby": {
      "id": "orderby",
      "value": ["date"]
    },
    "postStatus": {
      "id": "postStatus",
      "value": ["publish"]
    },
    "postsPerPage": {
      "id": "postsPerPage",
      "value": "5"
    }
  },
  items: [],
  loopLayout: [{
    "id": 1,
    "type": "root",
    "children": [{
      "id": 2,
      "type": "layer",
      "children": [{
        "id": 5,
        "type": "postThumbnail",
        "content": "",
        "parent_id": 2,
        "options": {
          "thumbnailSize": "full",
          "srcId": "",
          "srcUrl": "",
          "defaultSrcUrl": "https://comboblocks.com/server/wp-content/uploads/2024/11/da41bd7c-7420-3c0a-b169-d2d87acba187.jpg",
          "linkTo": "postUrl"
        },
        "cssSelectors": {
          "wrapper": {
            "handle": "",
            "label": "Featured Image Wrapper",
            "styles": {}
          },
          "img": {
            "handle": "img",
            "label": "Image",
            "styles": {
              "width": {
                "Desktop": "100%"
              }
            }
          },
          "a": {
            "handle": "a",
            "label": "Link",
            "styles": {}
          }
        },
        "chosen": false,
        "selected": false
      }, {
        "id": 3,
        "type": "postTitle",
        "content": "Dummy Title",
        "parent_id": 2,
        "options": {
          "linkTo": "postUrl",
          "target": "_blank"
        },
        "cssSelectors": {
          "wrapper": {
            "handle": "",
            "label": "Post Title Wrapper",
            "styles": {
              "fontSize": {
                "Desktop": "16px"
              }
            }
          },
          "a": {
            "handle": "a",
            "label": "Post Title Link",
            "styles": {}
          }
        },
        "chosen": false,
        "selected": false
      }, {
        "id": 4,
        "type": "postExcerpt",
        "parent_id": 2,
        "options": {
          "limitBy": "",
          "limitCount": 20,
          "readMoreText": "Read More"
        },
        "cssSelectors": {
          "wrapper": {
            "handle": "",
            "label": "Excerpt Wrapper",
            "styles": {}
          },
          "excerpt-text": {
            "handle": ".excerpt-text",
            "label": "Excerpt Text",
            "styles": {
              "fontSize": {
                "Desktop": "16px"
              }
            }
          },
          "redmore": {
            "handle": ".redmore",
            "label": "Redmore Text",
            "styles": {
              "fontSize": {
                "Desktop": "18px"
              }
            }
          }
        },
        "chosen": false,
        "selected": false
      }],
      "parent_id": 1,
      "styles": {},
      "options": {
        "animateOn": ""
      },
      "chosen": false,
      "selected": false
    }],
    "parent_id": null,
    "styles": {},
    "chosen": false,
    "selected": false
  }],
  wrapper: {
    options: {
      content: "",
      tag: "div",
      class: "wcps-wrapper"
    },
    styles: {}
  },
  itemsWrap: {
    "options": {
      "class": "items"
    },
    "styles": {
      "display": {
        "Desktop": "grid"
      },
      "gap": {
        "Desktop": "1em"
      },
      "gridTemplateColumns": {
        "Desktop": "1fr 1fr 1fr"
      }
    }
  },
  itemWrap: {
    options: {
      class: "item"
    },
    styles: {}
  },
  filterItem: {
    "styles": {
      "backgroundColor": {
        "Desktop": "#18978F"
      },
      "padding": {
        "Desktop": "5px 15px 5px 15px"
      },
      "borderRadius": {
        "Desktop": "3px 3px 3px 3px"
      },
      "color": {
        "Desktop": "#ffffff"
      },
      "fontSize": {
        "Desktop": "16px"
      },
      "textDecoration": {
        "Desktop": "none #000000 wavy 1px !important"
      }
    }
  },
  activeFilter: {
    "options": {
      "slug": "all"
    },
    "styles": {
      "backgroundColor": {
        "Desktop": "#7d7d7d"
      }
    }
  },
  filterGroupWrap: {
    "options": [],
    "styles": {
      "display": {
        "Desktop": "flex"
      },
      "gap": {
        "Desktop": "1em"
      },
      "justifyContent": {
        "Desktop": "center"
      },
      "margin": {
        "Desktop": "50px 0px 0px 0px"
      },
      "alignItems": {
        "Desktop": "center"
      },
      "marginBottom": {
        "Desktop": "30px"
      }
    }
  },
  filterGroup: {
    "options": [],
    "styles": {
      "display": {
        "Desktop": "flex"
      },
      "gap": {
        "Desktop": "1em"
      },
      "justifyContent": {
        "Desktop": "center"
      },
      "alignItems": {
        "Desktop": "center"
      }
    }
  },
  filterGroupTitle: {
    options: {},
    styles: {}
  },
  paginationWrap: {
    "options": {
      "tag": "ul",
      "class": ""
    },
    "styles": {
      "display": {
        "Desktop": "flex"
      },
      "gap": {
        "Desktop": "1em"
      },
      "justifyContent": {
        "Desktop": "center"
      },
      "margin": {
        "Desktop": "50px 0px 0px 0px"
      }
    }
  },
  paginationItem: {
    "options": {
      "tag": "span",
      "class": ""
    },
    "styles": {
      "backgroundColor": {
        "Desktop": "#18978F"
      },
      "padding": {
        "Desktop": "5px 15px 5px 15px"
      },
      "borderRadius": {
        "Desktop": "3px 3px 3px 3px"
      },
      "color": {
        "Desktop": "#ffffff"
      },
      "fontSize": {
        "Desktop": "16px"
      },
      "textDecoration": {
        "Desktop": "none #000000 wavy 1px !important"
      }
    }
  },
  paginationItemActive: {
    "options": {
      "class": ""
    },
    "styles": {
      "backgroundColor": {
        "Desktop": "#0d5a55"
      }
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FilterableDefaultData);

/***/ }),

/***/ "./src/components/Builder/default-data-grid.js":
/*!*****************************************************!*\
  !*** ./src/components/Builder/default-data-grid.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var GridDefaultData = {
  globalOptions: {
    viewType: "viewGrid",
    itemSource: "posts",
    search: true,
    pagination: {
      type: 'normal',
      nextText: "Next",
      previousText: "Previous",
      loadMoreText: "Load More",
      loadingText: "Loading...",
      noPostText: "No More Posts",
      "nextIcon": {
        "library": "fontAwesome",
        "srcType": "class",
        "iconSrc": "",
        "class": "load-more"
      },
      "previousIcon": {
        "library": "fontAwesome",
        "srcType": "class",
        "iconSrc": "",
        "class": "load-more"
      },
      "loadingIcon": {
        "library": "fontAwesome",
        "srcType": "class",
        "iconSrc": "",
        "class": "load-more"
      },
      "loadMoreIcon": {
        "library": "fontAwesome",
        "srcType": "class",
        "iconSrc": "",
        "class": "load-more"
      }
    }
  },
  reponsiveCss: "",
  itemQueryArgs: {
    "postType": {
      "id": "postType",
      "value": ["post"]
    },
    "order": {
      "id": "order",
      "value": "DESC"
    },
    "orderby": {
      "id": "orderby",
      "value": ["date"]
    },
    "postStatus": {
      "id": "postStatus",
      "value": ["publish"]
    },
    "postsPerPage": {
      "id": "postsPerPage",
      "value": "5"
    }
  },
  items: [],
  nthItemStyle: [],
  loopLayout: [{
    "id": 1,
    "type": "root",
    "children": [{
      "id": 2,
      "type": "layer",
      "children": [{
        "id": 5,
        "type": "postThumbnail",
        "content": "",
        "parent_id": 2,
        "options": {
          "thumbnailSize": "full",
          "srcId": "",
          "srcUrl": "",
          "defaultSrcUrl": "https://comboblocks.com/server/wp-content/uploads/2024/11/da41bd7c-7420-3c0a-b169-d2d87acba187.jpg",
          "linkTo": "postUrl"
        },
        "cssSelectors": {
          "wrapper": {
            "handle": "",
            "label": "Featured Image Wrapper",
            "styles": {}
          },
          "img": {
            "handle": "img",
            "label": "Image",
            "styles": {
              "width": {
                "Desktop": "100%"
              }
            }
          },
          "a": {
            "handle": "a",
            "label": "Link",
            "styles": {}
          }
        },
        "chosen": false,
        "selected": false
      }, {
        "id": 3,
        "type": "postTitle",
        "content": "Dummy Title",
        "parent_id": 2,
        "options": {
          "linkTo": "postUrl",
          "target": "_blank"
        },
        "cssSelectors": {
          "wrapper": {
            "handle": "",
            "label": "Post Title Wrapper",
            "styles": {
              "fontSize": {
                "Desktop": "16px"
              }
            }
          },
          "a": {
            "handle": "a",
            "label": "Post Title Link",
            "styles": {}
          }
        },
        "chosen": false,
        "selected": false
      }, {
        "id": 4,
        "type": "postExcerpt",
        "parent_id": 2,
        "options": {
          "limitBy": "",
          "limitCount": 20,
          "readMoreText": "Read More"
        },
        "cssSelectors": {
          "wrapper": {
            "handle": "",
            "label": "Excerpt Wrapper",
            "styles": {}
          },
          "excerpt-text": {
            "handle": ".excerpt-text",
            "label": "Excerpt Text",
            "styles": {
              "fontSize": {
                "Desktop": "16px"
              }
            }
          },
          "redmore": {
            "handle": ".redmore",
            "label": "Redmore Text",
            "styles": {
              "fontSize": {
                "Desktop": "18px"
              }
            }
          }
        },
        "chosen": false,
        "selected": false
      }],
      "parent_id": 1,
      "styles": {},
      "options": {
        "animateOn": ""
      },
      "chosen": false,
      "selected": false
    }],
    "parent_id": null,
    "styles": {},
    "chosen": false,
    "selected": false
  }],
  wrapper: {
    options: {
      content: "",
      tag: "div",
      class: "wcps-wrapper"
    },
    styles: {}
  },
  itemsWrap: {
    options: {
      class: "items"
    },
    styles: {
      "display": {
        "Desktop": "grid"
      },
      "gap": {
        "Desktop": "1em"
      },
      "gridTemplateColumns": {
        "Desktop": "1fr 1fr 1fr"
      }
    }
  },
  itemWrap: {
    options: {
      class: "item"
    },
    styles: {}
  },
  paginationWrap: {
    options: {
      type: "",
      class: ""
    },
    styles: {
      "display": {
        "Desktop": "flex"
      },
      "gap": {
        "Desktop": "1em"
      },
      "justifyContent": {
        "Desktop": "center"
      },
      "margin": {
        "Desktop": "50px 0px 0px 0px"
      }
    }
  },
  paginationItem: {
    options: {
      class: ""
    },
    styles: {
      "backgroundColor": {
        "Desktop": "#18978F"
      },
      "padding": {
        "Desktop": "10px 15px 10px 15px"
      },
      "borderRadius": {
        "Desktop": "3px 3px 3px 3px"
      },
      "color": {
        "Desktop": "#ffffff"
      },
      "fontSize": {
        "Desktop": "16px"
      },
      "textDecoration": {
        "Desktop": "none #000000 wavy 1px !important"
      }
    }
  },
  paginationItemActive: {
    options: {
      class: ""
    },
    styles: {
      "backgroundColor": {
        "Desktop": "#0e6761"
      }
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (GridDefaultData);

/***/ }),

/***/ "./src/components/Builder/default-data-masonry.js":
/*!********************************************************!*\
  !*** ./src/components/Builder/default-data-masonry.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var MasonryDefaultData = {
  globalOptions: {
    viewType: "viewMasonry",
    itemSource: "posts",
    search: true,
    pagination: {
      type: 'normal',
      nextText: "Next",
      previousText: "Previous",
      loadMoreText: "Load More",
      loadingText: "Loading...",
      noPostText: "No More Posts",
      "nextIcon": {
        "library": "fontAwesome",
        "srcType": "class",
        "iconSrc": "",
        "class": "load-more"
      },
      "previousIcon": {
        "library": "fontAwesome",
        "srcType": "class",
        "iconSrc": "",
        "class": "load-more"
      },
      "loadingIcon": {
        "library": "fontAwesome",
        "srcType": "class",
        "iconSrc": "",
        "class": "load-more"
      },
      "loadMoreIcon": {
        "library": "fontAwesome",
        "srcType": "class",
        "iconSrc": "",
        "class": "load-more"
      }
    }
  },
  itemQueryArgs: {
    "postType": {
      "id": "postType",
      "value": ["post"]
    },
    "order": {
      "id": "order",
      "value": "DESC"
    },
    "orderby": {
      "id": "orderby",
      "value": ["date"]
    },
    "postStatus": {
      "id": "postStatus",
      "value": ["publish"]
    },
    "postsPerPage": {
      "id": "postsPerPage",
      "value": "5"
    }
  },
  items: [],
  loopLayout: [{
    "id": 1,
    "type": "root",
    "children": [{
      "id": 2,
      "type": "layer",
      "children": [{
        "id": 5,
        "type": "postThumbnail",
        "content": "",
        "parent_id": 2,
        "options": {
          "thumbnailSize": "full",
          "srcId": "",
          "srcUrl": "",
          "defaultSrcUrl": "https://comboblocks.com/server/wp-content/uploads/2024/11/da41bd7c-7420-3c0a-b169-d2d87acba187.jpg",
          "linkTo": "postUrl"
        },
        "cssSelectors": {
          "wrapper": {
            "handle": "",
            "label": "Featured Image Wrapper",
            "styles": {}
          },
          "img": {
            "handle": "img",
            "label": "Image",
            "styles": {
              "width": {
                "Desktop": "100%"
              }
            }
          },
          "a": {
            "handle": "a",
            "label": "Link",
            "styles": {}
          }
        },
        "chosen": false,
        "selected": false
      }, {
        "id": 3,
        "type": "postTitle",
        "content": "Dummy Title",
        "parent_id": 2,
        "options": {
          "linkTo": "postUrl",
          "target": "_blank"
        },
        "cssSelectors": {
          "wrapper": {
            "handle": "",
            "label": "Post Title Wrapper",
            "styles": {
              "fontSize": {
                "Desktop": "16px"
              }
            }
          },
          "a": {
            "handle": "a",
            "label": "Post Title Link",
            "styles": {}
          }
        },
        "chosen": false,
        "selected": false
      }, {
        "id": 4,
        "type": "postExcerpt",
        "parent_id": 2,
        "options": {
          "limitBy": "",
          "limitCount": 20,
          "readMoreText": "Read More"
        },
        "cssSelectors": {
          "wrapper": {
            "handle": "",
            "label": "Excerpt Wrapper",
            "styles": {}
          },
          "excerpt-text": {
            "handle": ".excerpt-text",
            "label": "Excerpt Text",
            "styles": {
              "fontSize": {
                "Desktop": "16px"
              }
            }
          },
          "redmore": {
            "handle": ".redmore",
            "label": "Redmore Text",
            "styles": {
              "fontSize": {
                "Desktop": "18px"
              }
            }
          }
        },
        "chosen": false,
        "selected": false
      }],
      "parent_id": 1,
      "styles": {},
      "options": {
        "animateOn": ""
      },
      "chosen": false,
      "selected": false
    }],
    "parent_id": null,
    "styles": {},
    "chosen": false,
    "selected": false
  }],
  wrapper: {
    options: {
      content: "",
      tag: "div",
      class: "wcps-wrapper"
    },
    styles: {}
  },
  itemsWrap: {
    options: {
      class: ""
    },
    styles: {}
  },
  itemWrap: {
    options: {
      class: ""
    },
    styles: {
      "width": {
        "Desktop": "calc((100% - 60px) / 4)"
      },
      "marginBottom": {
        "Desktop": "20px"
      },
      "backgroundColor": {
        "Desktop": "#ffffff"
      },
      "padding": {
        "Desktop": "10px 10px 10px 10px"
      }
    }
  },
  masonryOptions: {
    gutter: 20,
    numberOfColumns: 4,
    itemSelector: ".item",
    columnWidth: ".item"
  },
  paginationWrap: {
    options: {
      type: "",
      class: ""
    },
    styles: {}
  },
  paginationItem: {
    options: {
      class: ""
    },
    styles: {}
  },
  paginationItemActive: {
    options: {
      class: ""
    },
    styles: {}
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MasonryDefaultData);

/***/ }),

/***/ "./src/components/Builder/dotsStyles.js":
/*!**********************************************!*\
  !*** ./src/components/Builder/dotsStyles.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   dotsStyles: () => (/* binding */ dotsStyles)
/* harmony export */ });
var dotsStyles = [{
  thumb: "",
  data: {
    "paginationWrap": {
      "options": {
        "type": "",
        "tag": "",
        "class": ""
      },
      "styles": {
        "display": {
          "Desktop": "flex"
        },
        "justifyContent": {
          "Desktop": "center"
        },
        "paddingTop": {
          "Desktop": "30px"
        }
      }
    },
    "paginationItem": {
      "options": {
        "tag": "",
        "class": ""
      },
      "styles": {
        "backgroundColor": {
          "Desktop": "#f1f7f9"
        },
        "width": {
          "Desktop": "15px"
        },
        "height": {
          "Desktop": "15px"
        },
        "margin": {
          "Desktop": "0px 10px 0px 0px"
        },
        "borderRadius": {
          "Desktop": " 20px 20px 20px 20px"
        },
        "border": {
          "Desktop": "1px solid #1f2937"
        }
      }
    },
    "paginationItemActive": {
      "options": {
        "class": ""
      },
      "styles": {
        "backgroundColor": {
          "Desktop": "#1f2e45"
        }
      }
    }
  }
}, {
  thumb: "",
  data: {
    "paginationWrap": {
      "options": {
        "type": "",
        "tag": "",
        "class": ""
      },
      "styles": {
        "display": {
          "Desktop": "flex"
        },
        "justifyContent": {
          "Desktop": "center"
        },
        "paddingTop": {
          "Desktop": "30px"
        }
      }
    },
    "paginationItem": {
      "options": {
        "tag": "",
        "class": ""
      },
      "styles": {
        "backgroundColor": {
          "Desktop": "#7958ff"
        },
        "margin": {
          "Desktop": "0px 10px 0px 0px"
        },
        "borderRadius": {
          "Desktop": "6px 6px 6px 6px"
        },
        "border": {
          "Desktop": "0px solid #201556"
        },
        "padding": {
          "Desktop": "10px 10px 10px 10px"
        },
        "transform": {
          "Desktop": "rotate(-45deg) "
        }
      }
    },
    "paginationItemActive": {
      "options": {
        "class": ""
      },
      "styles": {
        "backgroundColor": {
          "Desktop": "#1f2e45"
        }
      }
    }
  }
}, {
  thumb: "",
  data: {
    "paginationWrap": {
      "options": {
        "type": "",
        "tag": "",
        "class": ""
      },
      "styles": {
        "display": {
          "Desktop": "flex"
        },
        "justifyContent": {
          "Desktop": "center"
        },
        "paddingTop": {
          "Desktop": "30px"
        }
      }
    },
    "paginationItem": {
      "options": {
        "tag": "",
        "class": ""
      },
      "styles": {
        "backgroundColor": {
          "Desktop": "#7958ff"
        },
        "margin": {
          "Desktop": "0px 10px 0px 0px"
        },
        "borderRadius": {
          "Desktop": "6px 6px 6px 6px"
        },
        "border": {
          "Desktop": "2px solid #201556"
        },
        "padding": {
          "Desktop": "10px 10px 10px 10px"
        },
        "transform": {
          "Desktop": "rotate(-45deg) "
        }
      }
    },
    "paginationItemActive": {
      "options": {
        "class": ""
      },
      "styles": {
        "backgroundColor": {
          "Desktop": "#1f2e45"
        }
      }
    }
  }
}];

/***/ }),

/***/ "./src/components/Builder/edit-carousel.js":
/*!*************************************************!*\
  !*** ./src/components/Builder/edit-carousel.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-sortablejs */ "./node_modules/react-sortablejs/dist/index.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_sortablejs__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/help.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/styles.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/copy.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/pages.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/page.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/brush.js");
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _inAnimation__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../inAnimation */ "./src/inAnimation.js");
/* harmony import */ var _outAnimation__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../outAnimation */ "./src/outAnimation.js");
/* harmony import */ var _dropdown__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _icon_picker__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _input_select__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../input-select */ "./src/components/input-select/index.js");
/* harmony import */ var _input_text__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../input-text */ "./src/components/input-text/index.js");
/* harmony import */ var _input_toggle__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../input-toggle */ "./src/components/input-toggle/index.js");
/* harmony import */ var _input_wp_editor__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../input-wp-editor */ "./src/components/input-wp-editor/index.js");
/* harmony import */ var _styles__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../styles */ "./src/components/styles/index.js");
/* harmony import */ var _tab__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../tab */ "./src/components/tab/index.js");
/* harmony import */ var _tabs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _icon_toggle__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../icon-toggle */ "./src/components/icon-toggle/index.js");
/* harmony import */ var _LayoutGenerator__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../LayoutGenerator */ "./src/components/LayoutGenerator/index.js");
/* harmony import */ var _items__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../items */ "./src/components/items/index.js");
/* harmony import */ var _layouts__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./layouts */ "./src/components/Builder/layouts.js");
/* harmony import */ var _dotsStyles__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./dotsStyles */ "./src/components/Builder/dotsStyles.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;


























var myStore = wp.data.select("PostGridStore");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var onChange = props.onChange;
  var onChangeStyleObj = props.onChangeStyleObj;
  var addNotifications = props.addNotifications;
  var setHelp = props.setHelp;
  var onApplyTemplate = props.onApplyTemplate;
  var postData = props.postData;
  if (postData.post_content == null) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("div", {
      className: "p-3 my-5 bg-orange-400",
      children: "Please choose an WCPS first."
    });
  }
  var breakPointX = "Desktop";
  var [PostGridData, setPostGridData] = useState(postData.post_content);
  var [globalOptions, setglobalOptions] = useState(PostGridData.globalOptions);
  var [itemQueryArgs, setitemQueryArgs] = useState(PostGridData.itemQueryArgs);
  var [loopLayout, setloopLayout] = useState(PostGridData.loopLayout);
  var [wrapper, setwrapper] = useState(PostGridData.wrapper);
  var [items, setitems] = useState(PostGridData.items);
  var [itemsWrap, setitemsWrap] = useState(PostGridData.itemsWrap);
  var [itemWrap, setitemWrap] = useState(PostGridData.itemWrap);
  var [paginationWrap, setpaginationWrap] = useState(PostGridData.paginationWrap);
  var [paginationItem, setpaginationItem] = useState(PostGridData.paginationItem);
  var [paginationItemActive, setpaginationItemActive] = useState(PostGridData.paginationItemActive);
  var [prev, setprev] = useState(PostGridData?.prev);
  var [prevIcon, setprevIcon] = useState(PostGridData?.prevIcon);
  var [next, setnext] = useState(PostGridData?.next);
  var [nextIcon, setnextIcon] = useState(PostGridData?.nextIcon);
  var [sliderOptions, setsliderOptions] = useState(PostGridData?.sliderOptions);
  var [sliderOptionsRes, setsliderOptionsRes] = useState(PostGridData?.sliderOptionsRes);
  var [navsWrap, setnavsWrap] = useState(PostGridData?.navsWrap);
  var [navItem, setnavItem] = useState(PostGridData?.navItem);
  var [styleObj, setstyleObj] = useState({});
  var [customerData, setcustomerData] = useState(props.customerData);
  var [datePicker, setdatePicker] = useState(9999999);
  var [isProFeature, setisProFeature] = useState(true);
  var [editLayouts, seteditLayouts] = useState(false);
  const gapValue = sliderOptions?.gap || "0px";
  const [number, setNumber] = useState(parseInt(gapValue));
  const [unit, setUnit] = useState(gapValue.replace(number, ""));
  const [itemActive, setitemActive] = useState(99999);
  const [AIautoUpdate, setAIautoUpdate] = useState(false);
  var wrapperSelector = "#wcps-" + postData.ID;
  var itemsWrapSelector = wrapperSelector + " .splide__list";
  var itemWrapSelector = wrapperSelector + " .splide__list > .item";
  var navsWrapSelector = wrapperSelector + " .splide__arrows";
  var navItemSelector = wrapperSelector + " .splide__arrows > .splide__arrow";
  var prevSelector = wrapperSelector + " .splide__arrows > .prev";
  var prevIconSelector = wrapperSelector + "  .splide__arrows > .prev .icon";
  var nextSelector = wrapperSelector + " .splide__arrows > .next";
  var nextIconSelector = wrapperSelector + " .splide__arrows > .next .icon";
  var paginationWrapSelector = wrapperSelector + "  .splide__pagination";
  var paginationItemSelector = wrapperSelector + "  .splide__pagination .splide__pagination__page";
  var paginationItemActiveSelector = wrapperSelector + "  .splide__pagination .splide__pagination__page.is-active";
  var breakPointList = [{
    label: "Select..",
    icon: "",
    value: ""
  }];
  for (var x in _breakpoints__WEBPACK_IMPORTED_MODULE_7__["default"]) {
    var breakPointItem = _breakpoints__WEBPACK_IMPORTED_MODULE_7__["default"][x];
    breakPointList.push({
      label: breakPointItem.name,
      icon: breakPointItem.icon,
      value: breakPointItem.id
    });
  }
  var postTypes = [];
  const postTypesData = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_1__.store).getPostTypes({
    per_page: -1
  }), []);
  postTypesData !== null && postTypesData.map(x => {
    postTypes.push({
      value: x.slug,
      label: x.name
    });
  });
  useEffect(() => {
    if (Object.entries(styleObj).length > 0) {
      onChangeStyleObj(styleObj);
    }

    //console.log(styleObj);
  }, [styleObj]);
  useEffect(() => {
    var styles = generateStyleObj();
    setstyleObj(styles);
  }, [PostGridData]);
  useEffect(() => {
    if (customerData.isPro) {
      setisProFeature(false);
    }
  }, [props.customerData]);
  useEffect(() => {
    onChange(PostGridData);
  }, [PostGridData]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.globalOptions = globalOptions;
    setPostGridData(PostGridDataX);
  }, [globalOptions]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.itemQueryArgs = itemQueryArgs;
    setPostGridData(PostGridDataX);
  }, [itemQueryArgs]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.sliderOptions = sliderOptions;
    setPostGridData(PostGridDataX);
  }, [sliderOptions]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.items = items;
    setPostGridData(PostGridDataX);
  }, [items]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.wrapper = wrapper;
    setPostGridData(PostGridDataX);
  }, [wrapper]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.navsWrap = navsWrap;
    setPostGridData(PostGridDataX);
  }, [navsWrap]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.navItem = navItem;
    setPostGridData(PostGridDataX);
  }, [navItem]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.loopLayout = loopLayout;
    setPostGridData(PostGridDataX);
  }, [loopLayout]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.itemsWrap = itemsWrap;
    setPostGridData(PostGridDataX);
  }, [itemsWrap]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.itemWrap = itemWrap;
    setPostGridData(PostGridDataX);
  }, [itemWrap]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.next = next;
    setPostGridData(PostGridDataX);
  }, [next]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.nextIcon = nextIcon;
    setPostGridData(PostGridDataX);
  }, [nextIcon]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.prev = prev;
    setPostGridData(PostGridDataX);
  }, [prev]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.prevIcon = prevIcon;
    setPostGridData(PostGridDataX);
  }, [prevIcon]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.paginationItem = paginationItem;
    setPostGridData(PostGridDataX);
  }, [paginationItem]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.paginationWrap = paginationWrap;
    setPostGridData(PostGridDataX);
  }, [paginationWrap]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.paginationItemActive = paginationItemActive;
    setPostGridData(PostGridDataX);
  }, [paginationItemActive]);
  function generateStyleObj() {
    var styleObjX = {};

    // wrapper
    var wrapperX = {
      ...PostGridData.wrapper
    };
    var wrapperStyles = myStore.deletePropertyDeep(wrapperX, ['options']);
    styleObjX[wrapperSelector] = wrapperStyles;
    var itemsWrapX = {
      ...PostGridData.itemsWrap
    };
    var itemsWrapStyles = myStore.deletePropertyDeep(itemsWrapX, ['options']);
    styleObjX[itemsWrapSelector] = itemsWrapStyles;
    var itemWrapX = {
      ...PostGridData.itemWrap
    };
    var itemWrapStyles = myStore.deletePropertyDeep(itemWrapX, ['options']);
    styleObjX[itemWrapSelector] = itemWrapStyles;
    var navsWrapX = {
      ...PostGridData.navsWrap
    };
    var navsWrapStyles = myStore.deletePropertyDeep(navsWrapX, ['options']);
    styleObjX[navsWrapSelector] = navsWrapStyles;
    var navItemX = {
      ...PostGridData.navItem
    };
    var navItemStyles = myStore.deletePropertyDeep(navItemX, ['options']);
    styleObjX[navItemSelector] = navItemStyles;
    var prevX = {
      ...PostGridData.prev
    };
    var prevStyles = myStore.deletePropertyDeep(prevX, ['options']);
    styleObjX[prevSelector] = prevStyles;
    var prevIconX = {
      ...PostGridData.prevIcon
    };
    var prevIconStyles = myStore.deletePropertyDeep(prevIconX, ['options']);
    styleObjX[prevIconSelector] = prevIconStyles;
    var nextX = {
      ...PostGridData.next
    };
    var nextStyles = myStore.deletePropertyDeep(nextX, ['options']);
    styleObjX[nextSelector] = nextStyles;
    var nextIconX = {
      ...PostGridData.nextIcon
    };
    var nextIconStyles = myStore.deletePropertyDeep(nextIconX, ['options']);
    styleObjX[nextIconSelector] = nextIconStyles;
    var paginationWrapX = {
      ...PostGridData.paginationWrap
    };
    var paginationWrapStyles = myStore.deletePropertyDeep(paginationWrapX, ['options']);
    styleObjX[paginationWrapSelector] = paginationWrapStyles;
    var paginationItemX = {
      ...PostGridData.paginationItem
    };
    var paginationItemStyles = myStore.deletePropertyDeep(paginationItemX, ['options']);
    styleObjX[paginationItemSelector] = paginationItemStyles;
    var paginationItemActiveX = {
      ...PostGridData.paginationItemActive
    };
    var paginationItemActiveStyles = myStore.deletePropertyDeep(paginationItemActiveX, ['options']);
    styleObjX[paginationItemActiveSelector] = paginationItemActiveStyles;
    var loopLayoutFlatArry = myStore.flattenObject(PostGridData.loopLayout);
    loopLayoutFlatArry.map(element => {
      var elementId = element.id;
      var elementHdnle = "#element-" + elementId;
      var cssSelectors = element.cssSelectors;
      if (cssSelectors != undefined) {
        Object.entries(cssSelectors).map(args => {
          var elementSubIndex = args[0];
          var elementStylesObj = args[1];
          var itemhdnle = elementStylesObj?.handle == undefined ? elementHdnle : elementStylesObj?.handle;
          if (itemhdnle.length == 0) {
            var elementSubHdnle = wrapperSelector + ' ' + elementHdnle;
          } else {
            var elementSubHdnle = wrapperSelector + ' ' + elementHdnle + ' ' + itemhdnle;
          }
          var elementStylesObjX = {
            ...elementStylesObj
          };
          delete elementStylesObjX.handle;
          delete elementStylesObjX.label;
          styleObjX[elementSubHdnle] = elementStylesObjX;
        });
      }
    });

    //console.log(styleObjX);

    return styleObjX;
    //setstyleObj(styleObjX)
  }
  var RemoveSliderArg = function ({
    index
  }) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
      className: "cursor-pointer hover:bg-red-500 hover:text-white ",
      onClick: ev => {
        var sliderOptionsX = {
          ...sliderOptions
        };
        delete sliderOptionsX[index];
        setsliderOptions(sliderOptionsX);
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.Icon, {
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"]
      })
    });
  };
  const ALLOWED_MEDIA_TYPES = ["image"];
  var videoType = {
    choose: {
      label: "Choose",
      value: ""
    },
    youtube: {
      label: "YouTube",
      value: "youtube"
    }
  };
  function onChangeStyle(sudoScource, newVal, attr, propertyType, setProperty) {
    var path = [sudoScource, attr, breakPointX];
    let obj = {
      ...propertyType
    };
    const object = myStore.updatePropertyDeep(obj, path, newVal);
    setProperty(object);
  }
  function onAddStyle(sudoScource, key, propertyType, setProperty) {
    var path = [sudoScource, key, breakPointX];
    let obj = {
      ...propertyType
    };
    const object = myStore.addPropertyDeep(obj, path, "");
    setProperty(object);
  }
  function onResetStyle(sudoSources, propertyType, setProperty) {
    let obj = Object.assign({}, propertyType);
    Object.entries(sudoSources).map(args => {
      var sudoScource = args[0];
      if (obj[sudoScource] == undefined) {} else {
        obj[sudoScource] = {};
        // var elementSelector = myStore.getElementSelector(
        // 	sudoScource,
        // 	contentSelector // Replace this selector if needed
        // );
      }
    });
    setProperty(obj);
  }
  function onRemoveStyle(sudoScource, key, propertyType, setProperty) {
    let obj = {
      ...propertyType
    };
    var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
    var isEmpty = Object.entries(object[sudoScource][key]).length === 0 ? true : false;
    var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
    setProperty(objectX);
  }
  function onBulkAddStyle(sudoSource, cssObj, propertyType, setProperty) {
    let obj = {
      ...propertyType
    };
    obj[sudoSource] = cssObj;
    setProperty(obj);
  }
  var sliderOptionsArgs = {
    autoplay: {
      label: "Auto play",
      value: 1
    },
    interval: {
      label: "Interval",
      value: "500"
    },
    pauseOnHover: {
      label: "Pause On Hover",
      value: 1
    },
    pauseOnFocus: {
      label: "Pause On Focus",
      value: 1
    },
    lazyLoad: {
      label: "Lazy Load",
      value: 1
    },
    preloadPages: {
      label: "Preload Pages",
      value: 1
    },
    keyboard: {
      label: "Keyboard",
      value: 1
    },
    wheel: {
      label: "Wheel",
      value: 1
    },
    releaseWheel: {
      label: "Release Wheel",
      value: 1
    },
    direction: {
      label: "Direction",
      value: "ltr"
    },
    cover: {
      label: "Cover",
      value: 0
    },
    rewind: {
      label: "Rewind",
      value: 0
    },
    speed: {
      label: "Speed",
      value: 400
    },
    rewindSpeed: {
      label: "Rewind Speed",
      value: 400
    },
    rewindByDrag: {
      label: "Rewind By Drag",
      value: 0
    },
    type: {
      label: "Slider Type",
      value: "slide"
    },
    width: {
      label: "Width",
      value: ""
    },
    height: {
      label: "Height",
      value: ""
    },
    fixedWidth: {
      label: "Fixed Width",
      value: ""
    },
    fixedHeight: {
      label: "Fixed Height",
      value: ""
    },
    heightRatio: {
      label: "Height Ratio",
      value: ""
    },
    autoWidth: {
      label: "Auto Width",
      value: 0
    },
    autoHeight: {
      label: "Auto Height",
      value: 0
    },
    start: {
      label: "Start",
      value: 0
    },
    perPage: {
      label: "Per Page",
      value: 3
    },
    perMove: {
      label: "Per Move",
      value: 3
    },
    focus: {
      label: "Focus",
      value: "center"
    },
    gap: {
      label: "Gap",
      value: "1em",
      unit: "em",
      number: "1"
    },
    padding: {
      label: "Padding",
      value: ""
    },
    arrows: {
      label: "Arrows",
      value: 1
    },
    pagination: {
      label: "Pagination",
      value: 1
    },
    //easing: { label: 'Easing', value: 'cubic-bezier(0.25, 1, 0.5, 1)' },
    paginationKeyboard: {
      label: "Pagination Keyboard",
      value: 1
    },
    paginationDirection: {
      label: "Pagination Direction",
      value: "paginationDirectltrion"
    },
    drag: {
      label: "Drag",
      value: 1
    },
    noDrag: {
      label: "No Drag",
      value: "input, textarea, .rich-text"
    },
    snap: {
      label: "Snap",
      value: 1
    },
    mediaQuery: {
      label: "Media Query",
      value: "max"
    }
  };
  var itemSources = {
    manual: {
      label: "Manual",
      value: "manual"
    },
    posts: {
      label: "Posts",
      value: "posts",
      isPro: customerData.isPro ? false : true
    }
  };
  var sliderOptionsArgsRes = {
    rewind: {
      label: "Rewind",
      value: 0
    },
    speed: {
      label: "Speed",
      value: 400
    },
    rewindSpeed: {
      label: "Rewind Speed",
      value: 400
    },
    rewindByDrag: {
      label: "Rewind By Drag",
      value: 0
    },
    width: {
      label: "Width",
      value: ""
    },
    height: {
      label: "Height",
      value: ""
    },
    fixedWidth: {
      label: "Fixed Width",
      value: ""
    },
    fixedHeight: {
      label: "Fixed Height",
      value: ""
    },
    heightRatio: {
      label: "Height Ratio",
      value: ""
    },
    perPage: {
      label: "Per Page",
      value: 3
    },
    perMove: {
      label: "Per Move",
      value: 3
    },
    focus: {
      label: "Focus",
      value: "center"
    },
    gap: {
      label: "Gap",
      value: "1em",
      unit: "em",
      number: "1"
    },
    padding: {
      label: "Padding",
      value: ""
    },
    arrows: {
      label: "Arrows",
      value: 1
    },
    pagination: {
      label: "Pagination",
      value: 1
    },
    paginationKeyboard: {
      label: "Pagination Keyboard",
      value: 1
    },
    paginationDirection: {
      label: "Pagination Direction",
      value: "paginationDirectltrion"
    },
    drag: {
      label: "Drag",
      value: 1
    },
    snap: {
      label: "Snap",
      value: 1
    },
    keyboard: {
      label: "Keyboard",
      value: 1
    },
    direction: {
      label: "Direction",
      value: "ltr"
    },
    easing: {
      label: "Easing",
      value: "cubic-bezier(0.25, 1, 0.5, 1)"
    }
  };
  var RemoveSliderArgRes = function ({
    index
  }) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
      className: "cursor-pointer hover:bg-red-500 hover:text-white ",
      onClick: ev => {
        var sliderOptionsResX = {
          ...sliderOptionsRes
        };
        delete sliderOptionsResX[index];
        setAttributes({
          sliderOptionsRes: sliderOptionsResX
        });
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.Icon, {
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"]
      })
    });
  };
  function generate3Digit() {
    return Math.floor(100 + Math.random() * 900);
  }
  const handleDelete = id => {
    // Filter out the item with the specified id
    const updatedItems = Object.fromEntries(Object.entries(itemQueryArgs).filter(([key, item]) => item.id !== id));
    setitemQueryArgs(updatedItems);
  };
  const copyData = data => {
    navigator.clipboard.writeText(data).then(() => {
      addNotifications({
        title: "Copied to clipboard!",
        content: "Use the shortcode in page or post conent where you want to display.",
        type: "success"
      });
    }).catch(err => {});
  };
  function escapeHTML(str) {
    const map = {
      "&": "&amp;",
      "<": "&lt;",
      ">": "&gt;",
      '"': "&quot;",
      "'": "&#039;"
    };
    return str.replace(/[&<>"']/g, function (match) {
      return map[match];
    });
  }
  function unescapeHTML(str) {
    const map = {
      "&amp;": "&",
      "&lt;": "<",
      "&gt;": ">",
      "&quot;": '"',
      "&#039;": "'"
    };
    return str.replace(/&amp;|&lt;|&gt;|&quot;|&#039;/g, function (match) {
      return map[match];
    });
  }
  function onChangeBreakPoint(x, _index) {
    var asdsdsd = wp.data.dispatch("PostGridStore").setBreakPoint(x.value);
    asdsdsd.then(res => {
      setBreakPointX(res.breakpoint);
      myStore.generateBlockCss(blockCssY.items, blockId);
    });
    const {
      getPreviewDeviceType
    } = select("core/editor");
    const gutenbergDeviceType = getPreviewDeviceType;
  }
  function onChangeLayouts(loopLayout) {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.loopLayout = loopLayout;
    setPostGridData(PostGridDataX);
    setloopLayout(loopLayout);
  }
  // console.log(itemQueryArgs)

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
    className: "",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("div", {
      className: "hidden",
      onClick: () => {
        var str = `{
						
thumb:"",
data:{
				"navsWrap":${JSON.stringify(navsWrap)},
				"navItem":${JSON.stringify(navItem)},
				"prev":${JSON.stringify(prev)},
				"prevIcon":${JSON.stringify(prevIcon)},
				"next":${JSON.stringify(next)},
				"nextIcon":${JSON.stringify(nextIcon)},
}
				}`;
        copyData(str);
        addNotifications({
          title: "Copied to clipboard!",
          content: "Use the shortcode in page or post conent where you want to display.",
          type: "success"
        });
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
        className: "p-3",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("div", {
          children: `{`
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
          children: [`"navsWrap":${JSON.stringify(navsWrap)}`, ","]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
          children: [`"navItem":${JSON.stringify(navItem)}`, ","]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
          children: [`"prev":${JSON.stringify(prev)}`, ","]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
          children: [`"next":${JSON.stringify(next)}`, ","]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
          children: [`"nextIcon":${JSON.stringify(nextIcon)}`, ","]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("div", {
          children: `}`
        })]
      })
    }), props.postData.post_content != null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_items__WEBPACK_IMPORTED_MODULE_21__["default"], {
        itemsState: {
          items,
          setitems
        },
        globalOptionsState: {
          globalOptions,
          setglobalOptions
        },
        itemQueryState: {
          itemQueryArgs,
          setitemQueryArgs
        },
        customerData: customerData,
        setHelp: setHelp,
        addNotifications: addNotifications
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Settings",
        initialOpen: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("div", {
          className: "py-3",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("label", {
              htmlFor: "",
              className: "flex gap-2 items-center",
              children: ["Lazyload", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                className: "cursor-pointer",
                title: "Click to know more",
                onClick: () => {
                  setHelp({
                    id: "lazyloadSetting",
                    enable: true
                  });
                },
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.Icon, {
                  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"]
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_input_toggle__WEBPACK_IMPORTED_MODULE_14__["default"], {
              value: globalOptions?.lazyLoad,
              onChange: newVal => {
                var globalOptionsX = {
                  ...globalOptions
                };
                globalOptionsX.lazyLoad = newVal;
                setglobalOptions(globalOptionsX);
              }
            })]
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Slider Options", "woocommerce-products-slider"),
        initialOpen: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
          activeTab: "normal",
          orientation: "horizontal",
          activeClass: "active-tab",
          onSelect: tabName => {},
          tabs: [{
            name: "normal",
            title: "Normal",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
            className: "tab-normal"
          }, {
            name: "responsive",
            title: "Responsive",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
            className: "tab-responsive"
          }],
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
            name: "normal",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
              className: "flex gap-4 mb-3",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_dropdown__WEBPACK_IMPORTED_MODULE_10__["default"], {
                position: "bottom right",
                variant: "secondary",
                buttonTitle: "Add Options",
                options: sliderOptionsArgs,
                onChange: (option, index) => {
                  var sliderOptionsX = {
                    ...sliderOptions
                  };
                  sliderOptionsX[index] = option.value;
                  setsliderOptions(sliderOptionsX);
                },
                values: ""
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("button", {
                onClick: () => {
                  var str = JSON.stringify(sliderOptions);
                  copyData(str);
                },
                className: "pg-font flex gap-2 justify-center  cursor-pointer py-2 px-4 capitalize  !bg-gray-700 !text-white font-medium !rounded hover:bg-gray-600 hover:text-white focus:outline-none focus:bg-gray-600",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.Icon, {
                  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"],
                  className: "fill-white ",
                  size: 14
                }), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Copy", "woocommerce-products-slider")]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("button", {
                onClick: async () => {
                  try {
                    var data = await navigator.clipboard.readText();
                    data = JSON.parse(data);
                    setsliderOptions(data);
                    addNotifications({
                      title: "Paste Done!",
                      content: "Paste successful.",
                      type: "success"
                    });
                  } catch (e) {
                    //console.log(e);
                  }
                },
                className: "pg-font flex gap-2 justify-center  cursor-pointer py-2 px-4 capitalize  !bg-gray-700 !text-white font-medium !rounded hover:bg-gray-600 hover:text-white focus:outline-none focus:bg-gray-600",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.Icon, {
                  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_30__["default"],
                  className: "fill-white ",
                  size: 14
                }), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Paste", "woocommerce-products-slider")]
              })]
            }), Object.entries(sliderOptions).map((item, index) => {
              var id = item[0];
              var value = item[1];
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                children: [id == "autoplay" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Autoplay?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex gap-2 items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.ToggleControl, {
                      className: "!mb-0",
                      checked: value ? true : false,
                      onChange: newVal => {
                        var sliderOptionsX = {
                          ...sliderOptions
                        };
                        sliderOptionsX[id] = newVal;
                        setsliderOptions(sliderOptionsX);
                      }
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: value ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Enabled", "woocommerce-products-slider") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Disabled.", "woocommerce-products-slider")
                    })]
                  })]
                }), id == "rewind" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Rewind?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value,
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }],
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "type" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Slider Type?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value,
                    options: [{
                      label: "Slide",
                      value: "slide"
                    }, {
                      label: "Loop",
                      value: "loop"
                    }, {
                      label: "Fade",
                      value: "fade"
                    }],
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "interval" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Interval?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value,
                    type: "number",
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "speed" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Speed?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value,
                    type: "number",
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "rewindSpeed" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Rewind Speed?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value,
                    type: "number",
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "start" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Start?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value,
                    type: "number",
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "perPage" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Per Page?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value,
                    type: "number",
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "perMove" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Per Move?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value,
                    type: "number",
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "gap" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Gap?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center gap-1 ",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("input", {
                      type: "number",
                      value: number,
                      className: "w-[100px]",
                      onChange: e => {
                        const newNumber = e.target.value;
                        setNumber(newNumber);
                        var sliderOptionsX = {
                          ...sliderOptions
                        };
                        sliderOptionsX[id] = `${newNumber}${unit}`;
                        setsliderOptions(sliderOptionsX);
                      }
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("select", {
                      value: unit,
                      onChange: e => {
                        const newUnit = e.target.value;
                        setUnit(newUnit);
                        var sliderOptionsX = {
                          ...sliderOptions
                        };
                        sliderOptionsX[id] = `${number}${newUnit}`;
                        setsliderOptions(sliderOptionsX);
                      },
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("option", {
                        value: "px",
                        children: "px"
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("option", {
                        value: "em",
                        children: "em"
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("option", {
                        value: "rem",
                        children: "rem"
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("option", {
                        value: "%",
                        children: "%"
                      })]
                    })]
                  })]
                }), id == "padding" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Padding?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value,
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "focus" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Focus?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value,
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "width" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Width?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value,
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "height" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Height?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value,
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "fixedWidth" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Fixed Width?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value,
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "fixedHeight" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Fixed Height?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value,
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "heightRatio" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Height Ratio?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value,
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "easing" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Easing?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value,
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "pauseOnHover" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Pause On Hover?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex gap-2 items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.ToggleControl, {
                      className: "!mb-0",
                      checked: value ? true : false,
                      onChange: newVal => {
                        var sliderOptionsX = {
                          ...sliderOptions
                        };
                        sliderOptionsX[id] = newVal;
                        setsliderOptions(sliderOptionsX);
                      }
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: value ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Enabled", "woocommerce-products-slider") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Disabled.", "woocommerce-products-slider")
                    })]
                  })]
                }), id == "pauseOnFocus" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Pause On Focus?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("label", {
                    for: "",
                    className: "font-medium text-slate-900 ",
                    children: "?"
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex gap-2 items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.ToggleControl, {
                      className: "!mb-0",
                      checked: value ? true : false,
                      onChange: newVal => {
                        var sliderOptionsX = {
                          ...sliderOptions
                        };
                        sliderOptionsX[id] = newVal;
                        setsliderOptions(sliderOptionsX);
                      }
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: value ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Enabled", "woocommerce-products-slider") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Disabled.", "woocommerce-products-slider")
                    })]
                  })]
                }), id == "rewindByDrag" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Rewind By Drag?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex gap-2 items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.ToggleControl, {
                      className: "!mb-0",
                      checked: value ? true : false,
                      onChange: newVal => {
                        var sliderOptionsX = {
                          ...sliderOptions
                        };
                        sliderOptionsX[id] = newVal;
                        setsliderOptions(sliderOptionsX);
                      }
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: value ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Enabled", "woocommerce-products-slider") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Disabled.", "woocommerce-products-slider")
                    })]
                  })]
                }), id == "autoWidth" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Auto Width?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex gap-2 items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.ToggleControl, {
                      className: "!mb-0",
                      checked: value ? true : false,
                      onChange: newVal => {
                        var sliderOptionsX = {
                          ...sliderOptions
                        };
                        sliderOptionsX[id] = newVal;
                        setsliderOptions(sliderOptionsX);
                      }
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: value ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Enabled", "woocommerce-products-slider") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Disabled.", "woocommerce-products-slider")
                    })]
                  })]
                }), id == "autoHeight" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Auto Height?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex gap-2 items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.ToggleControl, {
                      className: "!mb-0",
                      checked: value ? true : false,
                      onChange: newVal => {
                        var sliderOptionsX = {
                          ...sliderOptions
                        };
                        sliderOptionsX[id] = newVal;
                        setsliderOptions(sliderOptionsX);
                      }
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: value ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Enabled", "woocommerce-products-slider") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Disabled.", "woocommerce-products-slider")
                    })]
                  })]
                }), id == "arrows" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Navigation?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex gap-2 items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.ToggleControl, {
                      className: "!mb-0",
                      checked: value ? true : false,
                      onChange: newVal => {
                        var sliderOptionsX = {
                          ...sliderOptions
                        };
                        sliderOptionsX[id] = newVal;
                        setsliderOptions(sliderOptionsX);
                      }
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: value ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Enabled", "woocommerce-products-slider") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Disabled.", "woocommerce-products-slider")
                    })]
                  })]
                }), id == "pagination" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Pagination?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex gap-2 items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.ToggleControl, {
                      className: "!mb-0",
                      checked: value ? true : false,
                      onChange: newVal => {
                        var sliderOptionsX = {
                          ...sliderOptions
                        };
                        sliderOptionsX[id] = newVal;
                        setsliderOptions(sliderOptionsX);
                      }
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: value ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Enabled", "woocommerce-products-slider") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Disabled.", "woocommerce-products-slider")
                    })]
                  })]
                }), id == "paginationKeyboard" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Pagination Keyboard?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex gap-2 items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.ToggleControl, {
                      className: "!mb-0",
                      checked: value ? true : false,
                      onChange: newVal => {
                        var sliderOptionsX = {
                          ...sliderOptions
                        };
                        sliderOptionsX[id] = newVal;
                        setsliderOptions(sliderOptionsX);
                      }
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: value ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Enabled", "woocommerce-products-slider") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Disabled.", "woocommerce-products-slider")
                    })]
                  })]
                }), id == "drag" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Drag?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex gap-2 items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.ToggleControl, {
                      className: "!mb-0",
                      checked: value ? true : false,
                      onChange: newVal => {
                        var sliderOptionsX = {
                          ...sliderOptions
                        };
                        sliderOptionsX[id] = newVal;
                        setsliderOptions(sliderOptionsX);
                      }
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: value ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Enabled", "woocommerce-products-slider") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Disabled.", "woocommerce-products-slider")
                    })]
                  })]
                }), id == "snap" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Snap?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex gap-2 items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.ToggleControl, {
                      className: "!mb-0",
                      checked: value ? true : false,
                      onChange: newVal => {
                        var sliderOptionsX = {
                          ...sliderOptions
                        };
                        sliderOptionsX[id] = newVal;
                        setsliderOptions(sliderOptionsX);
                      }
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: value ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Enabled", "woocommerce-products-slider") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Disabled.", "woocommerce-products-slider")
                    })]
                  })]
                }), id == "noDrag" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("noDrag?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value,
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "paginationDirection" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Pagination Direction?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value,
                    options: [{
                      label: "ltr",
                      value: "ltr"
                    }, {
                      label: "rtl",
                      value: "rtl"
                    }, {
                      label: "ttb",
                      value: "ttb"
                    }],
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "direction" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Direction?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value,
                    options: [{
                      label: "ltr",
                      value: "ltr"
                    }, {
                      label: "rtl",
                      value: "rtl"
                    }, {
                      label: "ttb",
                      value: "ttb"
                    }],
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "lazyLoad" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("LazyLoad?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value,
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Nearby", "woocommerce-products-slider"),
                      value: "nearby"
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Sequential", "woocommerce-products-slider"),
                      value: "sequential"
                    }],
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "keyboard" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Keyboard?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value,
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Global", "woocommerce-products-slider"),
                      value: "global"
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Focused", "woocommerce-products-slider"),
                      value: "focused"
                    }],
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "mediaQuery" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Media Query?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value,
                    options: [{
                      label: "min",
                      value: "min"
                    }, {
                      label: "max",
                      value: "max"
                    }],
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "wheel" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Wheel?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value,
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }],
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                }), id == "cover" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArg, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Cover?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value,
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }],
                    onChange: newVal => {
                      var sliderOptionsX = {
                        ...sliderOptions
                      };
                      sliderOptionsX[id] = newVal;
                      setsliderOptions(sliderOptionsX);
                    }
                  })]
                })]
              }, index);
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
            name: "responsive",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
              className: "my-3",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("label", {
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Slider Options", "woocommerce-products-slider")
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_dropdown__WEBPACK_IMPORTED_MODULE_10__["default"], {
                position: "bottom right",
                variant: "secondary",
                buttonTitle: "Choose",
                options: sliderOptionsArgsRes,
                onChange: (option, index) => {
                  var sliderOptionsResX = {
                    ...sliderOptionsRes
                  };
                  if (sliderOptionsResX[index] == undefined) {
                    sliderOptionsResX[index] = {};
                  }
                  if (sliderOptionsResX[index][breakPointX] == undefined) {
                    sliderOptionsResX[index][breakPointX] = option.value;
                  }
                  setsliderOptionsRes(sliderOptionsResX);
                },
                values: ""
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_icon_toggle__WEBPACK_IMPORTED_MODULE_19__["default"], {
                position: "bottom",
                variant: "secondary",
                iconList: breakPointList,
                buttonTitle: "Break Point Switch",
                onChange: onChangeBreakPoint,
                activeIcon: _breakpoints__WEBPACK_IMPORTED_MODULE_7__["default"][breakPointX].icon,
                value: breakPointX
              })]
            }), Object.entries(sliderOptionsRes).map((item, index) => {
              var id = item[0];
              var value = item[1];
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                children: [id == "autoplay" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Autoplay?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "rewind" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Rewind?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "interval" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Interval?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    type: "number",
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "speed" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Speed?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    type: "number",
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "rewindSpeed" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Rewind Speed?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    type: "number",
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "start" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Start?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    type: "number",
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "perPage" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: "Per Page?"
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    type: "number",
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "perMove" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Per Move?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    type: "number",
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "gap" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Gap?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "padding" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Padding?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "focus" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Focus?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "width" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Width?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "height" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Height?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "fixedWidth" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Fixed Width?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "fixedHeight" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Fixed Height?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "heightRatio" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Height Ratio?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "pauseOnHover" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Pause On Hover?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "pauseOnFocus" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Pause On Focus?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("label", {
                    for: "",
                    className: "font-medium text-slate-900 ",
                    children: "?"
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "rewindByDrag" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Rewind By Drag?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "autoWidth" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Auto Width?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "autoHeight" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Auto Height?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "arrows" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Navigation?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "pagination" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Pagination?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "paginationKeyboard" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Pagination Keyboard?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "drag" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Drag?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "snap" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Snap?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "noDrag" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("No Drag?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "paginationDirection" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Pagination Direction?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    options: [{
                      label: "ltr",
                      value: "ltr"
                    }, {
                      label: "rtl",
                      value: "rtl"
                    }, {
                      label: "ttb",
                      value: "ttb"
                    }],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "direction" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Direction?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    options: [{
                      label: "ltr",
                      value: "ltr"
                    }, {
                      label: "rtl",
                      value: "rtl"
                    }, {
                      label: "ttb",
                      value: "ttb"
                    }],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "lazyLoad" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("LazyLoad?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Nearby", "woocommerce-products-slider"),
                      value: "nearby"
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Sequential", "woocommerce-products-slider"),
                      value: "sequential"
                    }],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "keyboard" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Keyboard?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Global", "woocommerce-products-slider"),
                      value: "global"
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Focused", "woocommerce-products-slider"),
                      value: "focused"
                    }],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "mediaQuery" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Media Query?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    options: [{
                      label: "min",
                      value: "min"
                    }, {
                      label: "max",
                      value: "max"
                    }],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "wheel" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Wheel?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                }), id == "cover" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                    className: "flex items-center",
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(RemoveSliderArgRes, {
                      index: id
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Cover?", "woocommerce-products-slider")
                    })]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                    label: "",
                    value: value[breakPointX] == undefined ? "" : value[breakPointX],
                    options: [{
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
                      value: 1
                    }, {
                      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("False", "woocommerce-products-slider"),
                      value: 0
                    }],
                    onChange: newVal => {
                      var sliderOptionsResX = {
                        ...sliderOptionsRes
                      };
                      if (sliderOptionsResX[id][breakPointX] == undefined) {
                        sliderOptionsResX[id][breakPointX] = "";
                      }
                      sliderOptionsResX[id][breakPointX] = newVal;
                      setsliderOptionsRes(sliderOptionsResX);
                    }
                  })]
                })]
              }, index);
            })]
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Layouts",
        initialOpen: false,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
          className: "flex items-center justify-between",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("div", {
            className: "bg-slate-700 inline-block text-white px-5 py-2 rounded-sm cursor-pointer hover:bg-slate-600",
            onClick: ev => {
              seteditLayouts(!editLayouts);
            },
            children: "Customize Layouts"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
            className: "bg-slate-700 text-white px-5 py-2 rounded-sm cursor-pointer hover:bg-slate-600 flex items-center gap-1",
            onClick: () => {
              navigator.clipboard.writeText(JSON.stringify(PostGridData.loopLayout)).then(() => {
                addNotifications({
                  title: "Copied to clipboard!",
                  content: "Layout Copied!",
                  type: "success"
                });
              });
            },
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.Icon, {
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"],
              size: 14,
              fill: "#fff"
            }), "Copy"]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
            className: "bg-slate-700 text-white px-5 py-2 rounded-sm cursor-pointer hover:bg-slate-600 flex items-center gap-1",
            onClick: async () => {
              try {
                var data = await navigator.clipboard.readText();
                data = JSON.parse(data);
                onChangeLayouts(data).then(() => {
                  addNotifications({
                    title: "Layout Pasted!",
                    content: "Layout paste successful.",
                    type: "success"
                  });
                });
              } catch (e) {
                //console.log(e);
              }
            },
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.Icon, {
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_31__["default"],
              size: 14,
              fill: "#fff"
            }), "Paste"]
          }), editLayouts && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("div", {
            className: "fixed h-full top-0 py-10 overflow-y-auto bg-slate-500 bg-opacity-70 left-0 w-full z-50",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
              className: "w-[1400px] mx-auto ",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                className: "flex justify-between bg-gray-700 p-3",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("div", {
                  className: "text-white text-md",
                  children: "Layout Editor"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("div", {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("span", {
                    className: "size-6 bg-red-500 flex items-center justify-center cursor-pointer",
                    onClick: ev => {
                      seteditLayouts(!editLayouts);
                    },
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.Icon, {
                      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
                      fill: "#fff",
                      size: 18
                    })
                  })
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_LayoutGenerator__WEBPACK_IMPORTED_MODULE_20__["default"], {
                postData: postData,
                customerData: customerData,
                addNotifications: addNotifications,
                onChange: onChangeLayouts,
                layouts: PostGridData.loopLayout
              })]
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("div", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_layouts__WEBPACK_IMPORTED_MODULE_22__["default"], {
            postData: postData,
            onChangeLayouts: onChangeLayouts,
            customerData: customerData,
            addNotifications: addNotifications,
            setHelp: setHelp
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Wrapper",
        initialOpen: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
          activeTab: "options",
          orientation: "horizontal",
          activeClass: "active-tab",
          onSelect: tabName => {},
          tabs: [{
            name: "options",
            title: "Options",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
            className: "tab-settings"
          }, {
            name: "styles",
            title: "Styles",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_32__["default"],
            className: "tab-style"
          }],
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
            name: "options",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
              className: "flex  my-5  justify-between items-center",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("label", {
                className: "",
                htmlFor: "",
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_13__["default"], {
                value: wrapper?.options?.class,
                className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                onChange: newVal => {
                  var optionsX = {
                    ...wrapper,
                    options: {
                      ...wrapper?.options,
                      class: newVal
                    }
                  };
                  setwrapper(optionsX);
                }
              })]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
            name: "styles",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_16__["default"], {
              obj: wrapper,
              onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, wrapper, setwrapper),
              onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, wrapper, setwrapper),
              onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, wrapper, setwrapper),
              onReset: sudoSources => onResetStyle(sudoSources, wrapper, setwrapper),
              onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, wrapper, setwrapper)
            })
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Items Wrap",
        initialOpen: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
          activeTab: "options",
          orientation: "horizontal",
          activeClass: "active-tab",
          onSelect: tabName => {},
          tabs: [{
            name: "options",
            title: "Options",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
            className: "tab-settings"
          }, {
            name: "styles",
            title: "Styles",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_32__["default"],
            className: "tab-style"
          }],
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
            name: "options",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
              className: "flex  my-5  justify-between items-center",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("label", {
                className: "",
                htmlFor: "",
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_13__["default"], {
                value: itemsWrap?.options?.class,
                className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                onChange: newVal => {
                  var optionsX = {
                    ...itemsWrap,
                    options: {
                      ...itemsWrap?.options,
                      class: newVal
                    }
                  };
                  setitemsWrap(optionsX);
                }
              })]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
            name: "styles",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_16__["default"], {
              obj: itemsWrap,
              onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, itemsWrap, setitemsWrap),
              onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, itemsWrap, setitemsWrap),
              onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, itemsWrap, setitemsWrap),
              onReset: sudoSources => onResetStyle(sudoSources, itemsWrap, setitemsWrap),
              onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, itemsWrap, setitemsWrap)
            })
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Item",
        initialOpen: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
          activeTab: "options",
          orientation: "horizontal",
          activeClass: "active-tab",
          onSelect: tabName => {},
          tabs: [{
            name: "options",
            title: "Options",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
            className: "tab-settings"
          }, {
            name: "styles",
            title: "Styles",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_32__["default"],
            className: "tab-style"
          }],
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
            name: "options",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
              className: "flex  my-5  justify-between items-center",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("label", {
                className: "",
                htmlFor: "",
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_13__["default"], {
                value: itemWrap?.options?.class,
                className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                onChange: newVal => {
                  var optionsX = {
                    ...itemWrap,
                    options: {
                      ...itemWrap?.options,
                      class: newVal
                    }
                  };
                  setitemWrap(optionsX);
                }
              })]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
            name: "styles",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_16__["default"], {
              obj: itemWrap,
              onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, itemWrap, setitemWrap),
              onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, itemWrap, setitemWrap),
              onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, itemWrap, setitemWrap),
              onReset: sudoSources => onResetStyle(sudoSources, itemWrap, setitemWrap),
              onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, itemWrap, setitemWrap)
            })
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Navigation/Arrows",
        initialOpen: false,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("ul", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("li", {
            onClick: ev => {
              var argData = {
                "navsWrap": {
                  "options": {
                    "class": "nav-wrap"
                  },
                  "styles": {
                    "display": {
                      "Desktop": "flex"
                    },
                    "width": {
                      "Desktop": "100%"
                    },
                    "alignItems": {
                      "Desktop": "center"
                    },
                    "position": {
                      "Desktop": "absolute !important"
                    },
                    "top": {
                      "Desktop": "-50px"
                    },
                    "left": {
                      "Desktop": "20px"
                    },
                    "gap": {
                      "Desktop": "20px"
                    },
                    "justifyContent": {
                      "Desktop": "right"
                    }
                  }
                },
                "navItem": {
                  "options": {
                    "class": "nav-item"
                  },
                  "styles": []
                },
                "prev": {
                  "options": {
                    "text": "Prev",
                    "class": ""
                  },
                  "styles": {
                    "fontSize": {
                      "Desktop": "18px"
                    },
                    "fontStyle": {
                      "Desktop": "normal"
                    },
                    "fontWeight": {
                      "Desktop": "400"
                    },
                    "textAlign": {
                      "Desktop": "left"
                    },
                    "color": {
                      "Desktop": "#ffffff"
                    },
                    "backgroundColor": {
                      "Desktop": "#DFBB9D"
                    },
                    "borderRadius": {
                      "Desktop": "50px"
                    },
                    "padding": {
                      "Desktop": "5px 20px 5px 20px"
                    }
                  }
                },
                "prevIcon": {
                  "options": {
                    "position": "before",
                    "class": "",
                    "library": "fontAwesome",
                    "srcType": "class",
                    "iconSrc": "fas fa-chevron-left"
                  },
                  "styles": {
                    "padding": {
                      "Desktop": "0px 10px 0px 0px"
                    },
                    "fontSize": {
                      "Desktop": "16px"
                    }
                  }
                },
                "next": {
                  "options": {
                    "text": "Next",
                    "class": ""
                  },
                  "styles": {
                    "fontSize": {
                      "Desktop": "18px"
                    },
                    "fontStyle": {
                      "Desktop": "normal"
                    },
                    "fontWeight": {
                      "Desktop": "400"
                    },
                    "textAlign": {
                      "Desktop": "right"
                    },
                    "color": {
                      "Desktop": "#ffffff"
                    },
                    "backgroundColor": {
                      "Desktop": "#DFBB9D"
                    },
                    "borderRadius": {
                      "Desktop": "50px"
                    },
                    "padding": {
                      "Desktop": "5px 20px 5px 20px"
                    }
                  }
                },
                "nextIcon": {
                  "options": {
                    "position": "after",
                    "class": "",
                    "library": "fontAwesome",
                    "srcType": "class",
                    "iconSrc": "fas fa-chevron-right"
                  },
                  "styles": {
                    "padding": {
                      "Desktop": "0px 0px 0px 10px"
                    },
                    "fontSize": {
                      "Desktop": "16px"
                    }
                  }
                }
              };
              var PostGridDataX = {
                ...PostGridData
              };
              PostGridDataX.navsWrap = argData.navsWrap;
              PostGridDataX.navItem = argData.navItem;
              PostGridDataX.prev = argData.prev;
              PostGridDataX.prevIcon = argData.prevIcon;
              PostGridDataX.next = argData.next;
              PostGridDataX.nextIcon = argData.nextIcon;

              //console.log(PostGridDataX);

              onApplyTemplate(PostGridDataX);
            },
            children: "Template 1"
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: "Navs Wrap",
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
            activeTab: "options",
            orientation: "horizontal",
            activeClass: "active-tab",
            onSelect: tabName => {},
            tabs: [{
              name: "options",
              title: "Options",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
              className: "tab-settings"
            }, {
              name: "styles",
              title: "Styles",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_32__["default"],
              className: "tab-style"
            }],
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
              name: "options",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                className: "flex  my-5  justify-between items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("label", {
                  className: "",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_13__["default"], {
                  value: navsWrap?.options?.class,
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                  onChange: newVal => {
                    var optionsX = {
                      ...navsWrap,
                      options: {
                        ...navsWrap?.options,
                        class: newVal
                      }
                    };
                    setnavsWrap(optionsX);
                  }
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
              name: "styles",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_16__["default"], {
                obj: navsWrap,
                onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, navsWrap, setnavsWrap),
                onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, navsWrap, setnavsWrap),
                onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, navsWrap, setnavsWrap),
                onReset: sudoSources => onResetStyle(sudoSources, navsWrap, setnavsWrap),
                onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, navsWrap, setnavsWrap)
              })
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: "Navs Item",
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
            activeTab: "options",
            orientation: "horizontal",
            activeClass: "active-tab",
            onSelect: tabName => {},
            tabs: [{
              name: "options",
              title: "Options",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
              className: "tab-settings"
            }, {
              name: "styles",
              title: "Styles",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_32__["default"],
              className: "tab-style"
            }],
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
              name: "options",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                className: "flex  my-5  justify-between items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("label", {
                  className: "",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_13__["default"], {
                  value: navItem?.options?.class,
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                  onChange: newVal => {
                    var optionsX = {
                      ...navItem,
                      options: {
                        ...navItem?.options,
                        class: newVal
                      }
                    };
                    setnavItem(optionsX);
                  }
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
              name: "styles",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_16__["default"], {
                obj: navItem,
                onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, navItem, setnavItem),
                onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, navItem, setnavItem),
                onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, navItem, setnavItem),
                onReset: sudoSources => onResetStyle(sudoSources, navItem, setnavItem),
                onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, navItem, setnavItem)
              })
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: "Prev",
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
            activeTab: "options",
            orientation: "horizontal",
            activeClass: "active-tab",
            onSelect: tabName => {},
            tabs: [{
              name: "options",
              title: "Options",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
              className: "tab-settings"
            }, {
              name: "styles",
              title: "Styles",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_32__["default"],
              className: "tab-style"
            }],
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
              name: "options",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                className: "flex  my-5  justify-between items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("label", {
                  className: "",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_13__["default"], {
                  value: prev?.options?.class,
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                  onChange: newVal => {
                    var optionsX = {
                      ...prev,
                      options: {
                        ...prev?.options,
                        class: newVal
                      }
                    };
                    setprev(optionsX);
                  }
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
              name: "styles",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_16__["default"], {
                obj: prev,
                onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, prev, setprev),
                onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, prev, setprev),
                onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, prev, setprev),
                onReset: sudoSources => onResetStyle(sudoSources, prev, setprev),
                onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, prev, setprev)
              })
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: "Prev Icon",
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
            activeTab: "options",
            orientation: "horizontal",
            activeClass: "active-tab",
            onSelect: tabName => {},
            tabs: [{
              name: "options",
              title: "Options",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
              className: "tab-settings"
            }, {
              name: "styles",
              title: "Styles",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_32__["default"],
              className: "tab-style"
            }],
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
              name: "options",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                className: "flex  my-5  justify-between items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("label", {
                  className: "",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_13__["default"], {
                  value: prevIcon?.options?.class,
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                  onChange: newVal => {
                    var optionsX = {
                      ...prevIcon,
                      options: {
                        ...prevIcon?.options,
                        class: newVal
                      }
                    };
                    setprevIcon(optionsX);
                  }
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
              name: "styles",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_16__["default"], {
                obj: prevIcon,
                onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, prevIcon, setprevIcon),
                onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, prevIcon, setprevIcon),
                onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, prevIcon, setprevIcon),
                onReset: sudoSources => onResetStyle(sudoSources, prevIcon, setprevIcon),
                onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, prevIcon, setprevIcon)
              })
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: "Next",
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
            activeTab: "options",
            orientation: "horizontal",
            activeClass: "active-tab",
            onSelect: tabName => {},
            tabs: [{
              name: "options",
              title: "Options",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
              className: "tab-settings"
            }, {
              name: "styles",
              title: "Styles",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_32__["default"],
              className: "tab-style"
            }],
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
              name: "options",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                className: "flex  my-5  justify-between items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("label", {
                  className: "",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_13__["default"], {
                  value: next?.options?.class,
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                  onChange: newVal => {
                    var optionsX = {
                      ...next,
                      options: {
                        ...next?.options,
                        class: newVal
                      }
                    };
                    setnext(optionsX);
                  }
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
              name: "styles",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_16__["default"], {
                obj: next,
                onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, next, setnext),
                onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, next, setnext),
                onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, next, setnext),
                onReset: sudoSources => onResetStyle(sudoSources, next, setnext),
                onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, next, setnext)
              })
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: "Next Icon",
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
            activeTab: "options",
            orientation: "horizontal",
            activeClass: "active-tab",
            onSelect: tabName => {},
            tabs: [{
              name: "options",
              title: "Options",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
              className: "tab-settings"
            }, {
              name: "styles",
              title: "Styles",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_32__["default"],
              className: "tab-style"
            }],
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
              name: "options",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                className: "flex  my-5  justify-between items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("label", {
                  className: "",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_13__["default"], {
                  value: nextIcon?.options?.class,
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                  onChange: newVal => {
                    var optionsX = {
                      ...nextIcon,
                      options: {
                        ...nextIcon?.options,
                        class: newVal
                      }
                    };
                    setnextIcon(optionsX);
                  }
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
              name: "styles",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_16__["default"], {
                obj: nextIcon,
                onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, nextIcon, setnextIcon),
                onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, nextIcon, setnextIcon),
                onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, nextIcon, setnextIcon),
                onReset: sudoSources => onResetStyle(sudoSources, nextIcon, setnextIcon),
                onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, nextIcon, setnextIcon)
              })
            })]
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Pagination/Dots",
        initialOpen: false,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: "Pagination Wrap",
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
            activeTab: "options",
            orientation: "horizontal",
            activeClass: "active-tab",
            onSelect: tabName => {},
            tabs: [{
              name: "options",
              title: "Options",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
              className: "tab-settings"
            }, {
              name: "styles",
              title: "Styles",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_32__["default"],
              className: "tab-style"
            }],
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
              name: "options",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                className: "flex  my-5  justify-between items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("label", {
                  className: "",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_13__["default"], {
                  value: paginationWrap?.options?.class,
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                  onChange: newVal => {
                    var optionsX = {
                      ...paginationWrap,
                      options: {
                        ...paginationWrap?.options,
                        class: newVal
                      }
                    };
                    setpaginationWrap(optionsX);
                  }
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
              name: "styles",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_16__["default"], {
                obj: paginationWrap,
                onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, paginationWrap, setpaginationWrap),
                onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, paginationWrap, setpaginationWrap),
                onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, paginationWrap, setpaginationWrap),
                onReset: sudoSources => onResetStyle(sudoSources, paginationWrap, setpaginationWrap),
                onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, paginationWrap, setpaginationWrap)
              })
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: "Pagination Item",
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
            activeTab: "options",
            orientation: "horizontal",
            activeClass: "active-tab",
            onSelect: tabName => {},
            tabs: [{
              name: "options",
              title: "Options",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
              className: "tab-settings"
            }, {
              name: "styles",
              title: "Styles",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_32__["default"],
              className: "tab-style"
            }],
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
              name: "options",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                className: "flex  my-5  justify-between items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("label", {
                  className: "",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_13__["default"], {
                  value: paginationItem?.options?.class,
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                  onChange: newVal => {
                    var optionsX = {
                      ...paginationItem,
                      options: {
                        ...paginationItem?.options,
                        class: newVal
                      }
                    };
                    setpaginationItem(optionsX);
                  }
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
              name: "styles",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_16__["default"], {
                obj: paginationItem,
                onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, paginationItem, setpaginationItem),
                onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, paginationItem, setpaginationItem),
                onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, paginationItem, setpaginationItem),
                onReset: sudoSources => onResetStyle(sudoSources, paginationItem, setpaginationItem),
                onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, paginationItem, setpaginationItem)
              })
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: "pagination Item Active",
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_18__["default"], {
            activeTab: "options",
            orientation: "horizontal",
            activeClass: "active-tab",
            onSelect: tabName => {},
            tabs: [{
              name: "options",
              title: "Options",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
              className: "tab-settings"
            }, {
              name: "styles",
              title: "Styles",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_32__["default"],
              className: "tab-style"
            }],
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
              name: "options",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsxs)("div", {
                className: "flex  my-5  justify-between items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)("label", {
                  className: "",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_13__["default"], {
                  value: paginationItemActive?.options?.class,
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                  onChange: newVal => {
                    var optionsX = {
                      ...paginationItemActive,
                      options: {
                        ...paginationItemActive?.options,
                        class: newVal
                      }
                    };
                    setpaginationItemActive(optionsX);
                  }
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_17__["default"], {
              name: "styles",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_16__["default"], {
                obj: paginationItemActive,
                onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, paginationItemActive, setpaginationItemActive),
                onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, paginationItemActive, setpaginationItemActive),
                onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, paginationItemActive, setpaginationItemActive),
                onReset: sudoSources => onResetStyle(sudoSources, paginationItemActive, setpaginationItemActive),
                onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, paginationItemActive, setpaginationItemActive)
              })
            })]
          })
        })]
      })]
    })]
  });
}
class EditCarousel extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true,
      isLoaded: false
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      onChange,
      onChangeStyleObj,
      postData,
      customerData,
      addNotifications,
      setHelp,
      onApplyTemplate
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_24__.jsx)(Html, {
      onChange: onChange,
      onChangeStyleObj: onChangeStyleObj,
      addNotifications: addNotifications,
      postData: postData,
      customerData: customerData,
      setHelp: setHelp,
      onApplyTemplate: onApplyTemplate,
      warn: this.state.showWarning,
      isLoaded: this.state.isLoaded
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EditCarousel);

/***/ }),

/***/ "./src/components/Builder/edit-filterable.js":
/*!***************************************************!*\
  !*** ./src/components/Builder/edit-filterable.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-sortablejs */ "./node_modules/react-sortablejs/dist/index.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_sortablejs__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/help.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/copy.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/page.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/pages.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/brush.js");
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _inAnimation__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../inAnimation */ "./src/inAnimation.js");
/* harmony import */ var _outAnimation__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../outAnimation */ "./src/outAnimation.js");
/* harmony import */ var _dropdown__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _icon_picker__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _input_select__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../input-select */ "./src/components/input-select/index.js");
/* harmony import */ var _input_text__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../input-text */ "./src/components/input-text/index.js");
/* harmony import */ var _input_toggle__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../input-toggle */ "./src/components/input-toggle/index.js");
/* harmony import */ var _input_wp_editor__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../input-wp-editor */ "./src/components/input-wp-editor/index.js");
/* harmony import */ var _items__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../items */ "./src/components/items/index.js");
/* harmony import */ var _styles__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../styles */ "./src/components/styles/index.js");
/* harmony import */ var _tab__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../tab */ "./src/components/tab/index.js");
/* harmony import */ var _tabs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _layouts__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./layouts */ "./src/components/Builder/layouts.js");
/* harmony import */ var _LayoutGenerator__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../LayoutGenerator */ "./src/components/LayoutGenerator/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;
























var myStore = wp.data.select("PostGridStore");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var onChange = props.onChange;
  var onChangeStyleObj = props.onChangeStyleObj;
  var addNotifications = props.addNotifications;
  var setHelp = props.setHelp;
  var postData = props.postData;
  if (postData.post_content == null) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
      className: "p-3 my-5 bg-orange-400",
      children: "Please choose an WCPS first."
    });
  }
  var breakPointX = "Desktop";
  var [PostGridData, setPostGridData] = useState(postData.post_content);
  var [globalOptions, setglobalOptions] = useState(PostGridData.globalOptions);
  var [itemQueryArgs, setitemQueryArgs] = useState(PostGridData.itemQueryArgs);
  var [loopLayout, setloopLayout] = useState(PostGridData.loopLayout);
  var [wrapper, setwrapper] = useState(PostGridData.wrapper);
  var [items, setitems] = useState(PostGridData.items);
  var [itemsWrap, setitemsWrap] = useState(PostGridData.itemsWrap);
  var [itemWrap, setitemWrap] = useState(PostGridData.itemWrap);
  var [paginationWrap, setpaginationWrap] = useState(PostGridData.paginationWrap);
  var [paginationItem, setpaginationItem] = useState(PostGridData.paginationItem);
  var [paginationItemActive, setpaginationItemActive] = useState(PostGridData.paginationItemActive);
  var [editLayouts, seteditLayouts] = useState(false);
  var [debounce, setDebounce] = useState(null); // Using the hook.

  var [isBusy, setIsBusy] = useState(false);
  const [filterableTerms, setFilterableTerms] = useState([]);
  var [filterItem, setfilterItem] = useState(PostGridData.filterItem);
  var [activeFilter, setactiveFilter] = useState(PostGridData.activeFilter);
  var [filterGroupWrap, setfilterGroupWrap] = useState(PostGridData.filterGroupWrap);
  var [filterGroup, setfilterGroup] = useState(PostGridData.filterGroup);
  var [filterGroupTitle, setfilterGroupTitle] = useState(PostGridData.filterGroupTitle);
  var [topWrap, settopWrap] = useState(PostGridData.topWrap);
  var [activeNavItem, setactiveNavItem] = useState(PostGridData?.activeNavItem);
  var [styleObj, setstyleObj] = useState({});
  var [customerData, setcustomerData] = useState(props.customerData);
  var [isProFeature, setisProFeature] = useState(true);
  var wrapperSelector = "#wcps-" + postData.ID;
  var itemsWrapSelector = wrapperSelector + " > .items";
  var itemWrapSelector = wrapperSelector + " > .items > .item";
  var paginationWrapSelector = wrapperSelector + " > .pagination";
  var paginationItemSelector = wrapperSelector + " > .pagination .page-numbers";
  var paginationItemActiveSelector = wrapperSelector + " > .pagination .page-numbers.mixitup-control-active";
  var filterItemSelector = wrapperSelector + " .pg-filter";
  var activeFilterSelector = wrapperSelector + " .mixitup-control-active ";
  var filterGroupWrapSelector = wrapperSelector + " .filterable-group-wrap";
  var filterGroupSelector = wrapperSelector + " .filterable-group";
  var filterGroupTitleSelector = wrapperSelector + " .filterable-group-title";
  const paginationTypes = {
    none: {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("None", "woocommerce-products-slider"),
      value: "none"
    },
    filterable: {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Filterable", "woocommerce-products-slider"),
      value: "filterable"
    }
  };
  var breakPointList = [{
    label: "Select..",
    icon: "",
    value: ""
  }];
  for (var x in _breakpoints__WEBPACK_IMPORTED_MODULE_7__["default"]) {
    var breakPointItem = _breakpoints__WEBPACK_IMPORTED_MODULE_7__["default"][x];
    breakPointList.push({
      label: breakPointItem.name,
      icon: breakPointItem.icon,
      value: breakPointItem.id
    });
  }
  useEffect(() => {
    if (Object.entries(styleObj).length > 0) {
      onChangeStyleObj(styleObj);
    }
  }, [styleObj]);
  useEffect(() => {
    var styles = generateStyleObj();
    setstyleObj(styles);
  }, [PostGridData]);
  useEffect(() => {
    if (customerData.isPro) {
      setisProFeature(false);
    }
  }, [props.customerData]);
  useEffect(() => {
    onChange(PostGridData);
  }, [PostGridData]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.globalOptions = globalOptions;
    setPostGridData(PostGridDataX);
  }, [globalOptions]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.itemQueryArgs = itemQueryArgs;
    setPostGridData(PostGridDataX);
  }, [itemQueryArgs]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.itemsWrap = itemsWrap;
    setPostGridData(PostGridDataX);
  }, [itemsWrap]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.itemWrap = itemWrap;
    setPostGridData(PostGridDataX);
  }, [itemWrap]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.items = items;
    setPostGridData(PostGridDataX);
  }, [items]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.wrapper = wrapper;
    setPostGridData(PostGridDataX);
  }, [wrapper]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.filterItem = filterItem;
    setPostGridData(PostGridDataX);
  }, [filterItem]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.activeFilter = activeFilter;
    setPostGridData(PostGridDataX);
  }, [activeFilter]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.filterGroupWrap = filterGroupWrap;
    setPostGridData(PostGridDataX);
  }, [filterGroupWrap]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.filterGroup = filterGroup;
    setPostGridData(PostGridDataX);
  }, [filterGroup]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.filterGroupTitle = filterGroupTitle;
    setPostGridData(PostGridDataX);
  }, [filterGroupTitle]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.activeNavItem = activeNavItem;
    setPostGridData(PostGridDataX);
  }, [activeNavItem]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.loopLayout = loopLayout;
    setPostGridData(PostGridDataX);
  }, [loopLayout]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.paginationWrap = paginationWrap;
    setPostGridData(PostGridDataX);
  }, [paginationWrap]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.paginationItem = paginationItem;
    setPostGridData(PostGridDataX);
  }, [paginationItem]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.paginationItemActive = paginationItemActive;
    setPostGridData(PostGridDataX);
  }, [paginationItemActive]);
  function fetchPostTypeTerms(keyword) {
    var postTypes = [];
    var terms = [];
    //setIsBusy(true);
    //setFilterableTerms([]);
    itemQueryArgs.map(x => {
      if (x.id == "postType") {
        postTypes.push(x.val);
      }
    });
    var sss = _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
      path: "/wcps/v2/post_type_objects",
      method: "POST",
      data: {
        postTypes: postTypes[0],
        search: keyword
      }
    }).then(result => {
      //setFilterablTerms(result);
      result.length > 0 && result.map(x => {
        _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
          path: "/wcps/v2/get_tax_terms",
          method: "POST",
          data: {
            taxonomy: x.id,
            search: keyword
          }
        }).then(res => {
          //setFilterablTerms(res);
          res.length > 0 && res.map(y => {
            terms.push(y);
          });
          //setFilterableTerms(terms);
          //setIsBusy(false);
        });
      });
      //return result;
    });
  }
  function generateStyleObj() {
    var styleObjX = {};

    // wrapper
    var wrapperX = {
      ...PostGridData.wrapper
    };
    var wrapperStyles = myStore.deletePropertyDeep(wrapperX, ['options']);
    styleObjX[wrapperSelector] = wrapperStyles;
    var itemsWrapX = {
      ...PostGridData.itemsWrap
    };
    var itemsWrapStyles = myStore.deletePropertyDeep(itemsWrapX, ['options']);
    styleObjX[itemsWrapSelector] = itemsWrapStyles;
    var itemWrapX = {
      ...PostGridData.itemWrap
    };
    var itemWrapStyles = myStore.deletePropertyDeep(itemWrapX, ['options']);
    styleObjX[itemWrapSelector] = itemWrapStyles;
    var filterItemX = {
      ...PostGridData.filterItem
    };
    var filterItemStyles = myStore.deletePropertyDeep(filterItemX, ['options']);
    styleObjX[filterItemSelector] = filterItemStyles;
    var activeFilterX = {
      ...PostGridData.activeFilter
    };
    var activeFilterStyles = myStore.deletePropertyDeep(activeFilterX, ['options']);
    styleObjX[activeFilterSelector] = activeFilterStyles;
    var filterGroupWrapX = {
      ...PostGridData.filterGroupWrap
    };
    var filterGroupWrapStyles = myStore.deletePropertyDeep(filterGroupWrapX, ['options']);
    styleObjX[filterGroupWrapSelector] = filterGroupWrapStyles;
    var filterGroupX = {
      ...PostGridData.filterGroup
    };
    var filterGroupStyles = myStore.deletePropertyDeep(filterGroupX, ['options']);
    styleObjX[filterGroupSelector] = filterGroupStyles;
    var filterGroupTitleX = {
      ...PostGridData.filterGroupTitle
    };
    var filterGroupTitleStyles = myStore.deletePropertyDeep(filterGroupTitleX, ['options']);
    styleObjX[filterGroupTitleSelector] = filterGroupTitleStyles;
    var paginationWrapX = {
      ...PostGridData.paginationWrap
    };
    var paginationWrapStyles = myStore.deletePropertyDeep(paginationWrapX, ['options']);
    styleObjX[paginationWrapSelector] = paginationWrapStyles;
    var paginationItemX = {
      ...PostGridData.paginationItem
    };
    var paginationItemStyles = myStore.deletePropertyDeep(paginationItemX, ['options']);
    styleObjX[paginationItemSelector] = paginationItemStyles;
    var paginationItemActiveX = {
      ...PostGridData.paginationItemActive
    };
    var paginationItemActiveStyles = myStore.deletePropertyDeep(paginationItemActiveX, ['options']);
    styleObjX[paginationItemActiveSelector] = paginationItemActiveStyles;
    var loopLayoutFlatArry = myStore.flattenObject(PostGridData.loopLayout);
    loopLayoutFlatArry.map(element => {
      var elementId = element.id;
      var elementHdnle = "#element-" + elementId;
      var cssSelectors = element.cssSelectors;
      if (cssSelectors != undefined) {
        Object.entries(cssSelectors).map(args => {
          var elementSubIndex = args[0];
          var elementStylesObj = args[1];
          var itemhdnle = elementStylesObj?.handle == undefined ? elementHdnle : elementStylesObj?.handle;
          if (itemhdnle.length == 0) {
            var elementSubHdnle = wrapperSelector + ' ' + elementHdnle;
          } else {
            var elementSubHdnle = wrapperSelector + ' ' + elementHdnle + ' ' + itemhdnle;
          }
          var elementStylesObjX = {
            ...elementStylesObj
          };
          delete elementStylesObjX.handle;
          delete elementStylesObjX.label;
          styleObjX[elementSubHdnle] = elementStylesObjX;
        });
      }
    });
    return styleObjX;
    //setstyleObj(styleObjX)
  }
  function onChangeLayouts(loopLayout) {
    console.log(loopLayout);
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.loopLayout = loopLayout;
    setPostGridData(PostGridDataX);
    setloopLayout(loopLayout);
  }
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.topWrap = topWrap;
    setPostGridData(PostGridDataX);
  }, [topWrap]);
  const pasteData = () => {
    navigator.clipboard.readText().then(text => {
      const parsedData = JSON.parse(text);
      console.log(parsedData);
      var globalOptionsX = {
        ...globalOptions,
        filters: parsedData
      };
      setglobalOptions(globalOptionsX);
    }).catch(err => {});
  };
  const ALLOWED_MEDIA_TYPES = ["image"];
  var videoType = {
    choose: {
      label: "Choose",
      value: ""
    },
    youtube: {
      label: "YouTube",
      value: "youtube"
    }
  };
  function onChangeStyle(sudoScource, newVal, attr, propertyType, setProperty) {
    var path = [sudoScource, attr, breakPointX];
    let obj = {
      ...propertyType
    };
    const object = myStore.updatePropertyDeep(obj, path, newVal);
    setProperty(object);
  }
  function onAddStyle(sudoScource, key, propertyType, setProperty) {
    var path = [sudoScource, key, breakPointX];
    let obj = {
      ...propertyType
    };
    const object = myStore.addPropertyDeep(obj, path, "");
    setProperty(object);
  }
  function onResetStyle(sudoSources, propertyType, setProperty) {
    let obj = Object.assign({}, propertyType);
    Object.entries(sudoSources).map(args => {
      var sudoScource = args[0];
      if (obj[sudoScource] == undefined) {} else {
        obj[sudoScource] = {};
        // var elementSelector = myStore.getElementSelector(
        // 	sudoScource,
        // 	contentSelector // Replace this selector if needed
        // );
      }
    });
    setProperty(obj);
  }
  function onRemoveStyle(sudoScource, key, propertyType, setProperty) {
    let obj = {
      ...propertyType
    };
    var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
    var isEmpty = Object.entries(object[sudoScource][key]).length === 0 ? true : false;
    var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
    setProperty(objectX);
  }
  function onBulkAddStyle(sudoSource, cssObj, propertyType, setProperty) {
    let obj = {
      ...propertyType
    };
    obj[sudoSource] = cssObj;
    setProperty(obj);
  }
  const copyData = data => {
    navigator.clipboard.writeText(data).then(() => {
      addNotifications({
        title: "Copied to clipboard!",
        content: "Use the shortcode in page or post conent where you want to display.",
        type: "success"
      });
    }).catch(err => {});
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
    className: "",
    children: props.postData.post_content != null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_items__WEBPACK_IMPORTED_MODULE_16__["default"], {
        itemsState: {
          items,
          setitems
        },
        globalOptionsState: {
          globalOptions,
          setglobalOptions
        },
        itemQueryState: {
          itemQueryArgs,
          setitemQueryArgs
        },
        customerData: customerData,
        setHelp: setHelp,
        addNotifications: addNotifications
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Settings",
        initialOpen: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
          className: "py-3",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("label", {
              htmlFor: "",
              className: "flex gap-2 items-center",
              children: ["Lazyload", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("span", {
                className: "cursor-pointer",
                title: "Click to know more",
                onClick: () => {
                  setHelp({
                    id: "lazyloadSetting",
                    enable: true
                  });
                },
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.Icon, {
                  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"]
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_toggle__WEBPACK_IMPORTED_MODULE_14__["default"], {
              value: globalOptions?.lazyLoad,
              onChange: newVal => {
                var globalOptionsX = {
                  ...globalOptions
                };
                globalOptionsX.lazyLoad = newVal;
                setglobalOptions(globalOptionsX);
              }
            })]
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Layouts",
        initialOpen: false,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
          className: "flex flex-wrap gap-2 items-center justify-start",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
            className: "bg-slate-700 inline-block text-white px-5 py-2 rounded-sm cursor-pointer hover:bg-slate-600",
            onClick: ev => {
              seteditLayouts(!editLayouts);
            },
            children: "Customize Layouts"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
            className: "bg-slate-700 text-white px-5 py-2 rounded-sm cursor-pointer hover:bg-slate-600 flex items-center gap-1",
            onClick: () => {
              navigator.clipboard.writeText(JSON.stringify(PostGridData.loopLayout)).then(() => {
                addNotifications({
                  title: "Copied to clipboard!",
                  content: "Layout Copied!",
                  type: "success"
                });
              });
            },
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.Icon, {
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
              size: 14,
              fill: "#fff"
            }), "Copy"]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
            className: "bg-slate-700 text-white px-5 py-2 rounded-sm cursor-pointer hover:bg-slate-600 flex items-center gap-1",
            onClick: async () => {
              try {
                var data = await navigator.clipboard.readText();
                var datax = JSON.parse(data);
                onChangeLayouts(datax).then(() => {
                  addNotifications({
                    title: "Layout Pasted!",
                    content: "Layout paste successful.",
                    type: "success"
                  });
                });
              } catch (e) {}
            },
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.Icon, {
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
              size: 14,
              fill: "#fff"
            }), "Paste"]
          }), editLayouts && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
            className: "fixed h-full top-0 py-10 overflow-y-auto bg-slate-500 bg-opacity-70 left-0 w-full z-50",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
              className: "w-[1400px] mx-auto ",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                className: "flex justify-between bg-gray-700 p-3",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
                  className: "text-white text-md",
                  children: "Layout Editor"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("span", {
                    className: "size-6 bg-red-500 flex items-center justify-center cursor-pointer",
                    onClick: ev => {
                      seteditLayouts(!editLayouts);
                    },
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.Icon, {
                      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
                      fill: "#fff",
                      size: 18
                    })
                  })
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_LayoutGenerator__WEBPACK_IMPORTED_MODULE_21__["default"], {
                postData: postData,
                customerData: customerData,
                addNotifications: addNotifications,
                onChange: onChangeLayouts,
                layouts: PostGridData.loopLayout
              })]
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_layouts__WEBPACK_IMPORTED_MODULE_20__["default"], {
            postData: postData,
            onChangeLayouts: onChangeLayouts,
            customerData: customerData,
            addNotifications: addNotifications,
            setHelp: setHelp
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Filters", "woocommerce-products-slider"),
        initialOpen: false,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
            className: "flex items-center justify-center gap-3 mb-4 ",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
              className: "components-button undefined pg-font flex gap-2 justify-center  cursor-pointer py-2 px-4 capitalize  !bg-gray-800 !text-white font-medium !rounded hover:!bg-gray-700 hover:text-white focus:outline-none focus:bg-gray-700",
              onClick: ev => {
                if (!customerData.isPro && globalOptions.filters.length > 1) {
                  addNotifications({
                    title: "Ooops Its Pro!",
                    content: "Adding Multiple group on avilable in pro.",
                    type: "error"
                  });
                  return;
                }
                var filters = globalOptions.filters.concat({
                  groupTitle: "",
                  type: "",
                  logic: "",
                  showPostCount: "",
                  items: []
                });
                var globalOptionsX = {
                  ...globalOptions,
                  filters: filters
                };
                setglobalOptions(globalOptionsX);
              },
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Add Filter Group", "woocommerce-products-slider")
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
              className: " components-button undefined pg-font flex gap-2 justify-center  cursor-pointer py-2 px-4 capitalize  !bg-gray-800 !text-white font-medium !rounded hover:!bg-gray-700 hover:text-white focus:outline-none focus:bg-gray-700 ",
              onClick: () => {
                navigator.clipboard.writeText(JSON.stringify(globalOptions.filters)).then(() => {
                  addNotifications({
                    title: "Copied to clipboard!",
                    content: "Filters Copied!",
                    type: "success"
                  });
                });
              },
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.Icon, {
                icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"],
                className: "fill-white ",
                size: 14
              }), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Copy", "woocommerce-products-slider")]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
              className: " components-button undefined pg-font flex gap-2 justify-center  cursor-pointer py-2 px-4 capitalize  !bg-gray-800 !text-white font-medium !rounded hover:!bg-gray-700 hover:text-white focus:outline-none focus:bg-gray-700 ",
              onClick: () => {
                pasteData();
              }

              // onClick={async () => {
              // 									try {
              // 										var data = await navigator.clipboard.readText();
              // 										var datax = JSON.parse(data);
              // 										onChangeLayouts(datax).then(() => {
              // 											addNotifications({
              // 												title: "Layout Pasted!",
              // 												content: "Layout paste successful.",
              // 												type: "success",
              // 											});
              // 										});
              // 									} catch (e) {
              // 									}
              // 								}}
              ,
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.Icon, {
                icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
                className: "fill-white ",
                size: 14
              }), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Paste", "woocommerce-products-slider")]
            })]
          }), globalOptions?.filters?.map((x, i) => {
            return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
              title: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.Fragment, {
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("span", {
                  onClick: ev => {
                    globalOptions.filters.splice(i, 1);
                    var globalOptionsX = {
                      ...globalOptions,
                      filters: globalOptions.filters
                    };
                    setglobalOptions(globalOptionsX);
                  },
                  className: "hover:bg-red-500 bg-red-400 py-1 px-[10px] text-lg leading-normal cursor-pointer mr-2 ",
                  children: "\xD7"
                }), x.groupTitle ? x.groupTitle : "Filter Group " + i]
              }),
              initialOpen: false,
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                  htmlFor: "",
                  className: "font-medium text-slate-900 ",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Group Title", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                  value: x.groupTitle,
                  onChange: newVal => {
                    globalOptions.filters[i].groupTitle = newVal;
                    var globalOptionsX = {
                      ...globalOptions,
                      filters: globalOptions.filters
                    };
                    setglobalOptions(globalOptionsX);
                  }
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                  htmlFor: "",
                  className: "font-medium text-slate-900 ",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Group Type", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                  value: x.type,
                  options: [{
                    value: "inline",
                    label: "Inline"
                  }, {
                    value: "dropdown",
                    label: "Dropdown"
                  }, {
                    value: "radio",
                    label: "Radio"
                  }, {
                    value: "checkbox",
                    label: "Checkbox"
                  }],
                  onChange: newVal => {
                    globalOptions.filters[i].type = newVal;
                    var globalOptionsX = {
                      ...globalOptions,
                      filters: globalOptions.filters
                    };
                    setglobalOptions(globalOptionsX);
                  }
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                  htmlFor: "",
                  className: "font-medium text-slate-900 ",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Data Logic", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                  value: x.logic,
                  options: [{
                    value: "or",
                    label: "OR"
                  }, {
                    value: "and",
                    label: "AND"
                  }],
                  onChange: newVal => {
                    globalOptions.filters[i].logic = newVal;
                    var globalOptionsX = {
                      ...globalOptions,
                      filters: globalOptions.filters
                    };
                    setglobalOptions(globalOptionsX);
                  }
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                  htmlFor: "",
                  className: "font-medium text-slate-900 ",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Show Post Count", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
                  value: x.showPostCount,
                  options: [{
                    value: "no",
                    label: "No"
                  }, {
                    value: "yes",
                    label: "Yes"
                  }],
                  onChange: newVal => {
                    globalOptions.filters[i].showPostCount = newVal;
                    var globalOptionsX = {
                      ...globalOptions,
                      filters: globalOptions.filters
                    };
                    setglobalOptions(globalOptionsX);
                  }
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                for: "",
                className: "font-medium text-slate-900 my-3 ",
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Search Terms", "woocommerce-products-slider")
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("p", {
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("To add custom filter please use following format and hit Enter", "woocommerce-products-slider")
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("code", {
                children: "Filter Name|filter-slug|15"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
                autoComplete: "off",
                className: "my-3",
                placeholder: "Search Categories or terms",
                value: "",
                onKeyPress: ev => {
                  if (ev.key === "Enter") {
                    var filterParts = ev.target.value.split("|");
                    var ss = globalOptions.filters[i].items.concat({
                      id: 0,
                      slug: filterParts[1],
                      title: filterParts[0],
                      count: filterParts[2]
                    });
                    globalOptions.filters[i].items = ss;
                    var globalOptionsX = {
                      ...globalOptions,
                      filters: globalOptions.filters
                    };
                    setglobalOptions(globalOptionsX);
                  }
                },
                onChange: newVal => {
                  clearTimeout(debounce);
                  debounce = setTimeout(() => {
                    if (newVal.length > 0) {
                      fetchPostTypeTerms(newVal);
                    }
                  }, 2000);
                }
              }), x.items.length == 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
                className: "my-1",
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("No terms added.", "woocommerce-products-slider")
              }), x.items.map((y, j) => {
                return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                  className: "py-2 my-1 border-b border-gray-400 flex justify-between",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
                    children: y.title
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("span", {
                      onClick: ev => {
                        var globalOptionsX = {
                          ...activeFilter.options,
                          slug: activeFilter.options.slug == y.slug ? "" : y.slug
                        };
                        setglobalOptions(globalOptionsX);
                      },
                      className: [activeFilter.options.slug == y.slug ? "bg-gray-700 hover:bg-gray-600 cursor-pointer p-1   text-white  text-sm" : "bg-gray-400 cursor-pointer p-1   text-white  text-sm"],
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("span", {
                        className: "dashicons dashicons-yes-alt"
                      })
                    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("span", {
                      onClick: ev => {
                        globalOptions.filters[i].items.splice(j, 1);
                        var globalOptionsX = {
                          ...globalOptions,
                          filters: globalOptions.filters
                        };
                        setglobalOptions(globalOptionsX);
                      },
                      className: "cursor-pointer p-1  text-white bg-red-600 text-sm",
                      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("span", {
                        className: "dashicon dashicons dashicons-no-alt"
                      })
                    })]
                  })]
                });
              }), isBusy && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
                className: "border-b border-gray-400 my-2 pb-1 bg-gray-200 p-2",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(Spinner, {})
              }), filterableTerms.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
                className: "bg-gray-200 p-2 mt-2",
                children: filterableTerms.map(x => {
                  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                    title: "Click Add terms",
                    className: "border-b border-gray-400 my-2 pb-1 cursor-pointer",
                    onClick: ev => {
                      if (x.slug) {
                        var ss = globalOptions.filters[i].items.concat({
                          id: x.term_id,
                          slug: x.slug,
                          title: x.name,
                          count: x.count
                        });
                        globalOptions.filters[i].items = ss;
                        var globalOptionsX = {
                          ...globalOptions,
                          filters: globalOptions.filters
                        };
                        setglobalOptions(globalOptionsX);
                      }
                    },
                    children: [x.name, " (", x.count, ")"]
                  });
                })
              })]
            });
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            htmlFor: "",
            className: "font-medium text-slate-900 ",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Enable Multifilter", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
            label: "",
            value: globalOptions.multifilter,
            options: [{
              label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("True", "woocommerce-products-slider"),
              value: true
            }, {
              label: "False",
              value: false
            }],
            onChange: newVal => {
              if (!customerData.isPro) {
                addNotifications({
                  title: "Ooops Its Pro!",
                  content: "Multifilter only avilable in pro.",
                  type: "error"
                });
                return;
              }
              var globalOptionsX = {
                ...globalOptions,
                multifilter: newVal
              };
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            htmlFor: "",
            className: "font-medium text-slate-900 ",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Enable Filter Toggle", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
            label: "",
            value: globalOptions.filterToggle,
            options: [{
              label: "Yes",
              value: "yes"
            }, {
              label: "No",
              value: "no"
            }],
            onChange: newVal => {
              if (!customerData.isPro) {
                addNotifications({
                  title: "Ooops Its Pro!",
                  content: "Filter Toggle Only avilable in pro.",
                  type: "error"
                });
                return;
              }
              var globalOptionsX = {
                ...globalOptions,
                filterToggle: newVal
              };
              setglobalOptions(globalOptionsX);
            }
          })]
        }), globalOptions.multifilter && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.Fragment, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
              htmlFor: "",
              className: "font-medium text-slate-900 ",
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Logic Within Group", "woocommerce-products-slider")
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
              label: "",
              value: globalOptions.logicWithinGroup,
              options: [{
                label: "OR",
                value: "or"
              }, {
                label: "AND",
                value: "and"
              }],
              onChange: newVal => {
                if (!customerData.isPro) {
                  addNotifications({
                    title: "Ooops Its Pro!",
                    content: "Multifilter Only avilable in pro.",
                    type: "error"
                  });
                  return;
                }
                var globalOptionsX = {
                  ...globalOptions,
                  logicWithinGroup: newVal
                };
                setglobalOptions(globalOptionsX);
              }
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
              htmlFor: "",
              className: "font-medium text-slate-900 ",
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Logic Between Groups", "woocommerce-products-slider")
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
              label: "",
              value: globalOptions.logicBetweenGroups,
              options: [{
                label: "OR",
                value: "or"
              }, {
                label: "AND",
                value: "and"
              }],
              onChange: newVal => {
                if (!customerData.isPro) {
                  addNotifications({
                    title: "Ooops Its Pro!",
                    content: "Multifilter Only avilable in pro.",
                    type: "error"
                  });
                  return;
                }
                var globalOptionsX = {
                  ...globalOptions,
                  logicBetweenGroups: newVal
                };
                setglobalOptions(globalOptionsX);
              }
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            htmlFor: "",
            className: "font-medium text-slate-900 ",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Show Sort Filter", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
            label: "",
            value: globalOptions.showSort,
            options: [{
              label: "No",
              value: "no"
            }, {
              label: "Yes",
              value: "yes"
            }],
            onChange: newVal => {
              if (!customerData.isPro) {
                addNotifications({
                  title: "Ooops Its Pro!",
                  content: "Multifilter Only avilable in pro.",
                  type: "error"
                });
                return;
              }
              var globalOptionsX = {
                ...globalOptions,
                showSort: newVal
              };
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            htmlFor: "",
            className: "font-medium text-slate-900 ",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Show Random Filter", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
            label: "",
            value: globalOptions.showRandom,
            options: [{
              label: "No",
              value: "no"
            }, {
              label: "Yes",
              value: "yes"
            }],
            onChange: newVal => {
              if (!customerData.isPro) {
                addNotifications({
                  title: "Ooops Its Pro!",
                  content: "Multifilter Only avilable in pro.",
                  type: "error"
                });
                return;
              }
              var globalOptionsX = {
                ...globalOptions,
                showRandom: newVal
              };
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            htmlFor: "",
            className: "font-medium text-slate-900 ",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Show Clear Filter", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
            label: "",
            value: globalOptions.showClear,
            options: [{
              label: "No",
              value: "no"
            }, {
              label: "Yes",
              value: "yes"
            }],
            onChange: newVal => {
              if (!customerData.isPro) {
                addNotifications({
                  title: "Ooops Its Pro!",
                  content: "Multifilter Only avilable in pro.",
                  type: "error"
                });
                return;
              }
              var globalOptionsX = {
                ...globalOptions,
                showClear: newVal
              };
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            htmlFor: "",
            className: "font-medium text-slate-900 ",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Show All Filter", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.SelectControl, {
            label: "",
            value: globalOptions.showAll,
            options: [{
              label: "No",
              value: "no"
            }, {
              label: "Yes",
              value: "yes"
            }],
            onChange: newVal => {
              var globalOptionsX = {
                ...globalOptions,
                showAll: newVal
              };
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Items Per Page", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.__experimentalInputControl, {
            type: "number",
            value: globalOptions.perPage != undefined ? globalOptions.perPage : 6,
            onChange: newVal => {
              var globalOptionsX = {
                ...globalOptions,
                perPage: newVal
              };
              setglobalOptions(globalOptionsX);
            }
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Filters Style", "woocommerce-products-slider"),
        initialOpen: false,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Filter Item", "woocommerce-products-slider"),
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
            obj: filterItem,
            onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, filterItem, setfilterItem),
            onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, filterItem, setfilterItem),
            onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, filterItem, setfilterItem),
            onReset: sudoSources => onResetStyle(sudoSources, filterItem, setfilterItem),
            onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, filterItem, setfilterItem)
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Active Filter", "woocommerce-products-slider"),
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
            obj: activeFilter,
            onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, activeFilter, setactiveFilter),
            onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, activeFilter, setactiveFilter),
            onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, activeFilter, setactiveFilter),
            onReset: sudoSources => onResetStyle(sudoSources, activeFilter, setactiveFilter),
            onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, activeFilter, setactiveFilter)
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Filter Group Wrap", "woocommerce-products-slider"),
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
            obj: filterGroupWrap,
            onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, filterGroupWrap, setfilterGroupWrap),
            onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, filterGroupWrap, setfilterGroupWrap),
            onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, filterGroupWrap, setfilterGroupWrap),
            onReset: sudoSources => onResetStyle(sudoSources, filterGroupWrap, setfilterGroupWrap),
            onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, filterGroupWrap, setfilterGroupWrap)
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Filter Group", "woocommerce-products-slider"),
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
            obj: filterGroup,
            onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, filterGroup, setfilterGroup),
            onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, filterGroup, setfilterGroup),
            onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, filterGroup, setfilterGroup),
            onReset: sudoSources => onResetStyle(sudoSources, filterGroup, setfilterGroup),
            onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, filterGroup, setfilterGroup)
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Filter Group Title", "woocommerce-products-slider"),
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
            obj: filterGroupTitle,
            onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, filterGroupTitle, setfilterGroup),
            onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, filterGroupTitle, setfilterGroup),
            onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, filterGroupTitle, setfilterGroup),
            onReset: sudoSources => onResetStyle(sudoSources, filterGroupTitle, setfilterGroup),
            onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, filterGroupTitle, setfilterGroup)
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Wrapper",
        initialOpen: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_19__["default"], {
          activeTab: "options",
          orientation: "horizontal",
          activeClass: "active-tab",
          onSelect: tabName => {},
          tabs: [{
            name: "options",
            title: "Options",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
            className: "tab-settings"
          }, {
            name: "styles",
            title: "Styles",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"],
            className: "tab-style"
          }],
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
            name: "options",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
              className: "flex  my-5  justify-between items-center",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                className: "",
                htmlFor: "",
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_13__["default"], {
                value: wrapper?.options?.class,
                className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                onChange: newVal => {
                  var optionsX = {
                    ...wrapper,
                    options: {
                      ...wrapper?.options,
                      class: newVal
                    }
                  };
                  setwrapper(optionsX);
                }
              })]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
            name: "styles",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
              obj: wrapper,
              onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, wrapper, setwrapper),
              onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, wrapper, setwrapper),
              onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, wrapper, setwrapper),
              onReset: sudoSources => onResetStyle(sudoSources, wrapper, setwrapper),
              onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, wrapper, setwrapper)
            })
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Items Wrap",
        initialOpen: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_19__["default"], {
          activeTab: "options",
          orientation: "horizontal",
          activeClass: "active-tab",
          onSelect: tabName => {},
          tabs: [{
            name: "options",
            title: "Options",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
            className: "tab-settings"
          }, {
            name: "styles",
            title: "Styles",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"],
            className: "tab-style"
          }],
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
            name: "options",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
              className: "flex  my-5  justify-between items-center",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                className: "",
                htmlFor: "",
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_13__["default"], {
                value: itemsWrap?.options?.class,
                className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                onChange: newVal => {
                  var optionsX = {
                    ...itemsWrap,
                    options: {
                      ...itemsWrap?.options,
                      class: newVal
                    }
                  };
                  setitemsWrap(optionsX);
                }
              })]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
            name: "styles",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
              obj: itemsWrap,
              onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, itemsWrap, setitemsWrap),
              onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, itemsWrap, setitemsWrap),
              onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, itemsWrap, setitemsWrap),
              onReset: sudoSources => onResetStyle(sudoSources, itemsWrap, setitemsWrap),
              onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, itemsWrap, setitemsWrap)
            })
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Item",
        initialOpen: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_19__["default"], {
          activeTab: "options",
          orientation: "horizontal",
          activeClass: "active-tab",
          onSelect: tabName => {},
          tabs: [{
            name: "options",
            title: "Options",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
            className: "tab-settings"
          }, {
            name: "styles",
            title: "Styles",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"],
            className: "tab-style"
          }],
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
            name: "options",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
              className: "flex  my-5  justify-between items-center",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                className: "",
                htmlFor: "",
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_13__["default"], {
                value: itemWrap?.options?.class,
                className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                onChange: newVal => {
                  var optionsX = {
                    ...itemWrap,
                    options: {
                      ...itemWrap?.options,
                      class: newVal
                    }
                  };
                  setitemWrap(optionsX);
                }
              })]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
            name: "styles",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
              obj: itemWrap,
              onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, itemWrap, setitemWrap),
              onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, itemWrap, setitemWrap),
              onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, itemWrap, setitemWrap),
              onReset: sudoSources => onResetStyle(sudoSources, itemWrap, setitemWrap),
              onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, itemWrap, setitemWrap)
            })
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Pagination",
        initialOpen: false,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
          className: "my-4",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            htmlFor: "",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Pagination Type", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_dropdown__WEBPACK_IMPORTED_MODULE_10__["default"], {
            position: "bottom right",
            variant: "secondary",
            options: paginationTypes,
            buttonTitle: paginationTypes[globalOptions?.pagination?.type] != undefined ? paginationTypes[globalOptions.pagination.type].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Choose", "woocommerce-products-slider"),
            onChange: (arg, index) => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.type = arg.value;
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            },
            values: ""
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
          className: "flex  my-5  justify-between items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            className: "",
            htmlFor: "",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Previous Text", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_13__["default"], {
            value: globalOptions?.pagination?.previousText,
            className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
            onChange: newVal => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.previousText = newVal;
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
          className: "flex  my-5  justify-between items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            className: "",
            htmlFor: "",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Next Text", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_13__["default"], {
            value: globalOptions?.pagination?.nextText,
            className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
            onChange: newVal => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.nextText = newVal;
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            htmlFor: "",
            className: "font-medium text-slate-900 ",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Previous Icon", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_icon_picker__WEBPACK_IMPORTED_MODULE_11__["default"], {
            library: globalOptions?.pagination?.previousIcon?.library,
            srcType: globalOptions?.pagination?.previousIcon?.srcType,
            iconSrc: globalOptions?.pagination?.previousIcon?.iconSrc,
            class: globalOptions?.pagination?.previousIcon?.class,
            onChange: arg => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.previousIcon = {
                srcType: arg.srcType,
                library: arg.library,
                iconSrc: arg.iconSrc,
                class: arg.class
              };
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelRow, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            htmlFor: "",
            className: "font-medium text-slate-900 ",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Next Icon", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_icon_picker__WEBPACK_IMPORTED_MODULE_11__["default"], {
            library: globalOptions?.pagination?.nextIcon?.library,
            srcType: globalOptions?.pagination?.nextIcon?.srcType,
            iconSrc: globalOptions?.pagination?.nextIcon?.iconSrc,
            class: globalOptions?.pagination?.nextIcon?.class,
            onChange: arg => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.nextIcon = {
                srcType: arg.srcType,
                library: arg.library,
                iconSrc: arg.iconSrc,
                class: arg.class
              };
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: "Pagination Wrap",
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_19__["default"], {
            activeTab: "options",
            orientation: "horizontal",
            activeClass: "active-tab",
            onSelect: tabName => {},
            tabs: [{
              name: "options",
              title: "Options",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
              className: "tab-settings"
            }, {
              name: "styles",
              title: "Styles",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"],
              className: "tab-style"
            }],
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
              name: "options",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                className: "flex  my-5  justify-between items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                  className: "",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_13__["default"], {
                  value: paginationWrap?.options?.class,
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                  onChange: newVal => {
                    var optionsX = {
                      ...paginationWrap,
                      options: {
                        ...paginationWrap?.options,
                        class: newVal
                      }
                    };
                    setpaginationWrap(optionsX);
                  }
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
              name: "styles",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
                obj: paginationWrap,
                onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, paginationWrap, setpaginationWrap),
                onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, paginationWrap, setpaginationWrap),
                onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, paginationWrap, setpaginationWrap),
                onReset: sudoSources => onResetStyle(sudoSources, paginationWrap, setpaginationWrap),
                onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, paginationWrap, setpaginationWrap)
              })
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: "Pagination Item",
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_19__["default"], {
            activeTab: "options",
            orientation: "horizontal",
            activeClass: "active-tab",
            onSelect: tabName => {},
            tabs: [{
              name: "options",
              title: "Options",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
              className: "tab-settings"
            }, {
              name: "styles",
              title: "Styles",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"],
              className: "tab-style"
            }],
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
              name: "options",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                className: "flex  my-5  justify-between items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                  className: "",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_13__["default"], {
                  value: paginationItem?.options?.class,
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                  onChange: newVal => {
                    var optionsX = {
                      ...paginationItem,
                      options: {
                        ...paginationItem?.options,
                        class: newVal
                      }
                    };
                    setpaginationItem(optionsX);
                  }
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
              name: "styles",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
                obj: paginationItem,
                onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, paginationItem, setpaginationItem),
                onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, paginationItem, setpaginationItem),
                onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, paginationItem, setpaginationItem),
                onReset: sudoSources => onResetStyle(sudoSources, paginationItem, setpaginationItem),
                onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, paginationItem, setpaginationItem)
              })
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: "pagination Item Active",
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_19__["default"], {
            activeTab: "options",
            orientation: "horizontal",
            activeClass: "active-tab",
            onSelect: tabName => {},
            tabs: [{
              name: "options",
              title: "Options",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
              className: "tab-settings"
            }, {
              name: "styles",
              title: "Styles",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"],
              className: "tab-style"
            }],
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
              name: "options",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                className: "flex  my-5  justify-between items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                  className: "",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_13__["default"], {
                  value: paginationItemActive?.options?.class,
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                  onChange: newVal => {
                    var optionsX = {
                      ...paginationItemActive,
                      options: {
                        ...paginationItemActive?.options,
                        class: newVal
                      }
                    };
                    setpaginationItemActive(optionsX);
                  }
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_18__["default"], {
              name: "styles",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_17__["default"], {
                obj: paginationItemActive,
                onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, paginationItemActive, setpaginationItemActive),
                onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, paginationItemActive, setpaginationItemActive),
                onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, paginationItemActive, setpaginationItemActive),
                onReset: sudoSources => onResetStyle(sudoSources, paginationItemActive, setpaginationItemActive),
                onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, paginationItemActive, setpaginationItemActive)
              })
            })]
          })
        })]
      })]
    })
  });
}
class EditFilterable extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true,
      isLoaded: false
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      onChange,
      onChangeStyleObj,
      postData,
      customerData,
      addNotifications,
      setHelp
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(Html, {
      onChange: onChange,
      onChangeStyleObj: onChangeStyleObj,
      addNotifications: addNotifications,
      postData: postData,
      customerData: customerData,
      setHelp: setHelp,
      warn: this.state.showWarning,
      isLoaded: this.state.isLoaded
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EditFilterable);

/***/ }),

/***/ "./src/components/Builder/edit-grid.js":
/*!*********************************************!*\
  !*** ./src/components/Builder/edit-grid.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-sortablejs */ "./node_modules/react-sortablejs/dist/index.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_sortablejs__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/help.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/copy.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/page.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/brush.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/pages.js");
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _dropdown__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _input_select__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../input-select */ "./src/components/input-select/index.js");
/* harmony import */ var _input_text__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../input-text */ "./src/components/input-text/index.js");
/* harmony import */ var _input_toggle__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../input-toggle */ "./src/components/input-toggle/index.js");
/* harmony import */ var _input_wp_editor__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../input-wp-editor */ "./src/components/input-wp-editor/index.js");
/* harmony import */ var _LayoutGenerator__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../LayoutGenerator */ "./src/components/LayoutGenerator/index.js");
/* harmony import */ var _styles__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../styles */ "./src/components/styles/index.js");
/* harmony import */ var _tab__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../tab */ "./src/components/tab/index.js");
/* harmony import */ var _tabs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _items__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../items */ "./src/components/items/index.js");
/* harmony import */ var _layouts__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./layouts */ "./src/components/Builder/layouts.js");
/* harmony import */ var _pagination_types__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./pagination-types */ "./src/components/Builder/pagination-types.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_toggle__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/toggle */ "./src/components/toggle/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;

























var myStore = wp.data.select("PostGridStore");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var onChange = props.onChange;
  var onChangeStyleObj = props.onChangeStyleObj;
  var addNotifications = props.addNotifications;
  var setHelp = props.setHelp;
  var postData = props.postData;
  if (postData.post_content == null) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
      className: "p-3 my-5 bg-orange-400",
      children: "Please choose an WCPS first."
    });
  }
  var breakPointX = "Desktop";
  var [PostGridData, setPostGridData] = useState(postData.post_content);
  var [globalOptions, setglobalOptions] = useState(PostGridData.globalOptions);
  var [itemQueryArgs, setitemQueryArgs] = useState(PostGridData.itemQueryArgs);

  /*Selectors*/
  var [wrapper, setwrapper] = useState(PostGridData.wrapper);
  var [loopLayout, setloopLayout] = useState(PostGridData.loopLayout);
  var [items, setitems] = useState(PostGridData.items);
  var [itemsWrap, setitemsWrap] = useState(PostGridData.itemsWrap);
  var [itemWrap, setitemWrap] = useState(PostGridData.itemWrap);
  var [nthItemStyle, setnthItemStyle] = useState(PostGridData.nthItemStyle);
  var [paginationWrap, setpaginationWrap] = useState(PostGridData.paginationWrap);
  var [paginationItem, setpaginationItem] = useState(PostGridData.paginationItem);
  var [paginationItemActive, setpaginationItemActive] = useState(PostGridData.paginationItemActive);
  var [styleObj, setstyleObj] = useState({});
  var [customerData, setcustomerData] = useState(props.customerData);
  var [isProFeature, setisProFeature] = useState(true);
  var [editLayouts, seteditLayouts] = useState(false);
  var wrapperSelector = "#wcps-" + postData.ID;
  var itemsWrapSelector = wrapperSelector + " > .items";
  var itemWrapSelector = wrapperSelector + " > .items > .item";
  var paginationWrapSelector = wrapperSelector + " > .pagination";
  var paginationItemSelector = wrapperSelector + " > .pagination .page-numbers";
  var paginationItemActiveSelector = wrapperSelector + " > .pagination .page-numbers.current";
  var id = postData.ID;
  var paginationTypesX = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_5__.applyFilters)('PostGridPaginationTypes', _pagination_types__WEBPACK_IMPORTED_MODULE_20__.paginationTypes);
  var breakPointList = [{
    label: "Select..",
    icon: "",
    value: ""
  }];
  for (var x in _breakpoints__WEBPACK_IMPORTED_MODULE_8__["default"]) {
    var breakPointItem = _breakpoints__WEBPACK_IMPORTED_MODULE_8__["default"][x];
    breakPointList.push({
      label: breakPointItem.name,
      icon: breakPointItem.icon,
      value: breakPointItem.id
    });
  }
  useEffect(() => {
    if (customerData.isPro) {
      setisProFeature(false);
    }
  }, [props.customerData]);
  useEffect(() => {
    onChange(PostGridData);
  }, [PostGridData]);
  useEffect(() => {
    if (Object.entries(styleObj).length > 0) {
      onChangeStyleObj(styleObj);
    }
  }, [styleObj]);
  useEffect(() => {
    var styles = generateStyleObj();
    setstyleObj(styles);
  }, [PostGridData]);
  function generateStyleObj() {
    var styleObjX = {};

    // wrapper
    var wrapperX = {
      ...PostGridData.wrapper
    };
    var wrapperStyles = myStore.deletePropertyDeep(wrapperX, ['options']);
    styleObjX[wrapperSelector] = wrapperStyles;
    var itemsWrapX = {
      ...PostGridData.itemsWrap
    };
    var itemsWrapStyles = myStore.deletePropertyDeep(itemsWrapX, ['options']);
    styleObjX[itemsWrapSelector] = itemsWrapStyles;
    var itemWrapX = {
      ...PostGridData.itemWrap
    };
    var itemWrapStyles = myStore.deletePropertyDeep(itemWrapX, ['options']);
    styleObjX[itemWrapSelector] = itemWrapStyles;
    var paginationWrapX = {
      ...PostGridData.paginationWrap
    };
    var paginationWrapStyles = myStore.deletePropertyDeep(paginationWrapX, ['options']);
    styleObjX[paginationWrapSelector] = paginationWrapStyles;
    var paginationItemX = {
      ...PostGridData.paginationItem
    };
    var paginationItemStyles = myStore.deletePropertyDeep(paginationItemX, ['options']);
    styleObjX[paginationItemSelector] = paginationItemStyles;
    var paginationItemActiveX = {
      ...PostGridData.paginationItemActive
    };
    var paginationItemActiveStyles = myStore.deletePropertyDeep(paginationItemActiveX, ['options']);
    styleObjX[paginationItemActiveSelector] = paginationItemActiveStyles;
    var loopLayoutFlatArry = myStore.flattenObject(PostGridData.loopLayout);
    loopLayoutFlatArry.map(element => {
      var elementId = element.id;
      var elementHdnle = "#element-" + elementId;
      var cssSelectors = element.cssSelectors;
      if (cssSelectors != undefined) {
        Object.entries(cssSelectors).map(args => {
          var elementSubIndex = args[0];
          var elementStylesObj = args[1];
          var itemhdnle = elementStylesObj?.handle == undefined ? elementHdnle : elementStylesObj?.handle;
          if (itemhdnle.length == 0) {
            var elementSubHdnle = wrapperSelector + ' ' + elementHdnle;
          } else {
            var elementSubHdnle = wrapperSelector + ' ' + elementHdnle + ' ' + itemhdnle;
          }
          var elementStylesObjX = {
            ...elementStylesObj
          };
          delete elementStylesObjX.handle;
          delete elementStylesObjX.label;
          styleObjX[elementSubHdnle] = elementStylesObjX;
        });
      }
    });

    //nthItemStyle
    nthItemStyle?.map((element, index) => {
      var elementId = element.id;
      var loopItemHdnle = wrapperSelector + ' ' + ".loop-item-" + index;
      styleObjX[loopItemHdnle] = element;

      // if (cssSelectors != undefined) {
      // 	Object.entries(cssSelectors).map(args => {

      // 		var elementSubIndex = args[0];
      // 		var elementStylesObj = args[1];
      // 		var itemhdnle = elementStylesObj?.handle == undefined ? elementHdnle : elementStylesObj?.handle;

      // 		if (itemhdnle.length == 0) {
      // 			var elementSubHdnle = wrapperSelector + ' ' + elementHdnle;
      // 		} else {
      // 			var elementSubHdnle = wrapperSelector + ' ' + elementHdnle + ' ' + itemhdnle;
      // 		}
      // 		var elementStylesObjX = { ...elementStylesObj }
      // 		delete elementStylesObjX.handle
      // 		delete elementStylesObjX.label

      // 		styleObjX[elementSubHdnle] = elementStylesObjX

      // 	})
      // }
    });
    return styleObjX;
    //setstyleObj(styleObjX)
  }
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.globalOptions = globalOptions;
    setPostGridData(PostGridDataX);
  }, [globalOptions]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.itemQueryArgs = itemQueryArgs;
    setPostGridData(PostGridDataX);
  }, [itemQueryArgs]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.itemsWrap = itemsWrap;
    setPostGridData(PostGridDataX);
  }, [itemsWrap]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.itemWrap = itemWrap;
    setPostGridData(PostGridDataX);
  }, [itemWrap]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.items = items;
    setPostGridData(PostGridDataX);
  }, [items]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.wrapper = wrapper;
    setPostGridData(PostGridDataX);
  }, [wrapper]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.loopLayout = loopLayout;
    setPostGridData(PostGridDataX);
  }, [loopLayout]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.nthItemStyle = nthItemStyle;
    setPostGridData(PostGridDataX);
  }, [nthItemStyle]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.paginationWrap = paginationWrap;
    setPostGridData(PostGridDataX);
  }, [paginationWrap]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.paginationItem = paginationItem;
    setPostGridData(PostGridDataX);
  }, [paginationItem]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.paginationItemActive = paginationItemActive;
    setPostGridData(PostGridDataX);
  }, [paginationItemActive]);
  function onChangeLayouts(loopLayout) {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.loopLayout = loopLayout;
    setPostGridData(PostGridDataX);
    setloopLayout(loopLayout);
  }
  function onChangeStyle(sudoScource, newVal, attr, propertyType, setProperty) {
    var path = [sudoScource, attr, breakPointX];
    let obj = {
      ...propertyType
    };
    const object = myStore.updatePropertyDeep(obj, path, newVal);
    setProperty(object);
  }
  function onAddStyle(sudoScource, key, propertyType, setProperty) {
    var path = [sudoScource, key, breakPointX];
    let obj = {
      ...propertyType
    };
    const object = myStore.addPropertyDeep(obj, path, "");
    setProperty(object);
  }
  function onResetStyle(sudoSources, propertyType, setProperty) {
    let obj = Object.assign({}, propertyType);
    Object.entries(sudoSources).map(args => {
      var sudoScource = args[0];
      if (obj[sudoScource] == undefined) {} else {
        obj[sudoScource] = {};
      }
    });
    setProperty(obj);
  }
  function onRemoveStyle(sudoScource, key, propertyType, setProperty) {
    let obj = {
      ...propertyType
    };
    var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
    var isEmpty = Object.entries(object[sudoScource][key]).length === 0 ? true : false;
    var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
    setProperty(objectX);
  }
  function onBulkAddStyle(sudoSource, cssObj, propertyType, setProperty) {
    let obj = {
      ...propertyType
    };
    obj[sudoSource] = cssObj;
    setProperty(obj);
  }

  // nth items CSS

  function onAddStyleNthItem(sudoScource, key, propertyType, extra) {
    var index = extra.index;
    var path = [sudoScource, key, breakPointX];
    let obj = {
      ...propertyType
    };
    const object = myStore.addPropertyDeep(obj, path, "");
    // setProperty(object);
    var nthItemStyleX = [...nthItemStyle];
    nthItemStyleX[index] = object;
    setnthItemStyle(nthItemStyleX);
  }
  function onChangeStyleNthItem(sudoScource, newVal, attr, propertyType, extra) {
    var index = extra.index;
    var path = [sudoScource, attr, breakPointX];
    let obj = {
      ...propertyType
    };
    const object = myStore.updatePropertyDeep(obj, path, newVal);
    // setProperty(object);

    var nthItemStyleX = [...nthItemStyle];
    nthItemStyleX[index] = object;
    setnthItemStyle(nthItemStyleX);
  }
  function onRemoveStyleNthItem(sudoScource, key, propertyType, extra) {
    var index = extra.index;
    let obj = {
      ...propertyType
    };
    var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
    var isEmpty = Object.entries(object[sudoScource][key]).length === 0 ? true : false;
    var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
    // setProperty(objectX);

    var nthItemStyleX = [...nthItemStyle];
    nthItemStyleX[index] = objectX;
    setnthItemStyle(nthItemStyleX);
  }
  function onResetNthItem(sudoSources, propertyType, extra) {
    var index = extra.index;
    let obj = Object.assign({}, propertyType);
    Object.entries(sudoSources).map(args => {
      var sudoScource = args[0];
      if (obj[sudoScource] == undefined) {} else {
        obj[sudoScource] = {};
      }
    });
    // setProperty(obj);

    var nthItemStyleX = [...nthItemStyle];
    nthItemStyleX[index] = obj;
    setnthItemStyle(nthItemStyleX);
  }
  function onBulkAddStyleNthItem(sudoSource, cssObj, propertyType, extra) {
    var index = extra.index;
    let obj = {
      ...propertyType
    };
    obj[sudoSource] = cssObj;
    // setProperty(obj);

    var nthItemStyleX = [...nthItemStyle];
    nthItemStyleX[index] = obj;
    setnthItemStyle(nthItemStyleX);
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
    className: "",
    children: props.postData.post_content != null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_items__WEBPACK_IMPORTED_MODULE_18__["default"], {
        itemsState: {
          items,
          setitems
        },
        globalOptionsState: {
          globalOptions,
          setglobalOptions
        },
        itemQueryState: {
          itemQueryArgs,
          setitemQueryArgs
        },
        customerData: customerData,
        setHelp: setHelp,
        addNotifications: addNotifications
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Settings",
        initialOpen: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
          className: "py-3",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("label", {
              htmlFor: "",
              className: "flex gap-2 items-center",
              children: ["Lazyload", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("span", {
                className: "cursor-pointer",
                title: "Click to know more",
                onClick: () => {
                  setHelp({
                    id: "lazyloadSetting",
                    enable: true
                  });
                },
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Icon, {
                  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"]
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_input_toggle__WEBPACK_IMPORTED_MODULE_12__["default"], {
              value: globalOptions?.lazyLoad,
              onChange: newVal => {
                var globalOptionsX = {
                  ...globalOptions
                };
                globalOptionsX.lazyLoad = newVal;
                setglobalOptions(globalOptionsX);
              }
            })]
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Layouts",
        initialOpen: false,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
          className: "flex flex-wrap gap-2 items-center justify-start",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
            className: "bg-slate-700 inline-block text-white px-3 py-2 rounded-sm cursor-pointer hover:bg-slate-600",
            onClick: ev => {
              seteditLayouts(!editLayouts);
            },
            children: "Customize Layouts"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
            className: "bg-slate-700 text-white px-3 py-2 rounded-sm cursor-pointer hover:bg-slate-600 flex items-center gap-1",
            onClick: () => {
              navigator.clipboard.writeText(JSON.stringify(PostGridData.loopLayout)).then(() => {
                addNotifications({
                  title: "Copied to clipboard!",
                  content: "Layout Copied!",
                  type: "success"
                });
              });
            },
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Icon, {
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
              size: 14,
              fill: "#fff"
            }), "Copy"]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
            className: "bg-slate-700 text-white px-3 py-2 rounded-sm cursor-pointer hover:bg-slate-600 flex items-center gap-1",
            onClick: async () => {
              try {
                var data = await navigator.clipboard.readText();
                var datax = JSON.parse(data);
                onChangeLayouts(datax).then(() => {
                  addNotifications({
                    title: "Layout Pasted!",
                    content: "Layout paste successful.",
                    type: "success"
                  });
                });
              } catch (e) {}
            },
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Icon, {
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
              size: 14,
              fill: "#fff"
            }), "Paste"]
          }), editLayouts && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
            className: "fixed h-full top-0 py-10 overflow-y-auto bg-slate-500 bg-opacity-70 left-0 w-full z-50",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
              className: "w-[1400px] mx-auto ",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
                className: "flex justify-between bg-gray-700 p-3",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
                  className: "text-white text-md",
                  children: "Layout Editor"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("span", {
                    className: "size-6 bg-red-500 flex items-center justify-center cursor-pointer",
                    onClick: ev => {
                      seteditLayouts(!editLayouts);
                    },
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Icon, {
                      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
                      fill: "#fff",
                      size: 18
                    })
                  })
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_LayoutGenerator__WEBPACK_IMPORTED_MODULE_14__["default"], {
                postData: postData,
                customerData: customerData,
                addNotifications: addNotifications,
                onChange: onChangeLayouts,
                layouts: PostGridData.loopLayout
              })]
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_layouts__WEBPACK_IMPORTED_MODULE_19__["default"], {
            postData: postData,
            onChangeLayouts: onChangeLayouts,
            customerData: customerData,
            addNotifications: addNotifications,
            setHelp: setHelp
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Wrapper",
        initialOpen: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
          activeTab: "options",
          orientation: "horizontal",
          activeClass: "active-tab",
          onSelect: tabName => {},
          tabs: [{
            name: "options",
            title: "Options",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
            className: "tab-settings"
          }, {
            name: "styles",
            title: "Styles",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"],
            className: "tab-style"
          }],
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
            name: "options",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
              className: "flex  my-5  justify-between items-center",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("label", {
                className: "",
                htmlFor: "",
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
                value: wrapper?.options?.class,
                className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                onChange: newVal => {
                  var optionsX = {
                    ...wrapper,
                    options: {
                      ...wrapper?.options,
                      class: newVal
                    }
                  };
                  setwrapper(optionsX);
                }
              })]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
            name: "styles",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_15__["default"], {
              obj: wrapper,
              onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, wrapper, setwrapper),
              onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, wrapper, setwrapper),
              onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, wrapper, setwrapper),
              onReset: sudoSources => onResetStyle(sudoSources, wrapper, setwrapper),
              onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, wrapper, setwrapper)
            })
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody
      // title="N'th Item CSS"
      , {
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("N'th Item CSS", "woocommerce-products-slider"),
        initialOpen: false,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
          className: "justify-start gap-2 mb-3",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("button", {
            onClick: ev => {
              if (!customerData.isPro) {
                addNotifications({
                  title: "Opps its pro!",
                  content: "This feature is avilable in pro.",
                  type: "error"
                });
                return;
              }
              var nthItemStyleX = [...nthItemStyle];
              nthItemStyleX.push({});
              // setAttributes({ nthItemStyle: nthItemStyleX });

              setnthItemStyle(nthItemStyleX);
            },
            className: " flex gap-2 justify-center items-center cursor-pointer py-2 px-3 capitalize  !bg-gray-700 !text-white font-medium !rounded hover:bg-gray-600 hover:text-white focus:outline-none focus:bg-gray-600",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Add", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("button", {
            onClick: () => {
              navigator.clipboard.writeText(JSON.stringify(nthItemStyle)).then(() => {
                addNotifications({
                  title: "Copied to clipboard!",
                  content: "Nth Styles Copied!",
                  type: "success"
                });
              });
            },
            className: " flex gap-2 justify-center items-center cursor-pointer py-2 px-3 capitalize  !bg-gray-700 !text-white font-medium !rounded hover:bg-gray-600 hover:text-white focus:outline-none focus:bg-gray-600",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Icon, {
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
              className: "fill-white ",
              size: 14
            }), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Copy", "woocommerce-products-slider")]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("button", {
            onClick: async () => {
              try {
                var data = await navigator.clipboard.readText();
                var datax = JSON.parse(data);
                setnthItemStyle(datax);
                addNotifications({
                  title: "Layout Pasted!",
                  content: "Layout paste successful.",
                  type: "success"
                });
              } catch (e) {}
            },
            className: " flex gap-2 justify-center items-center cursor-pointer py-2 px-3 capitalize  !bg-gray-700 !text-white font-medium !rounded hover:bg-gray-600 hover:text-white focus:outline-none focus:bg-gray-600",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Icon, {
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_30__["default"],
              className: "fill-white ",
              size: 14
            }), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Paste", "woocommerce-products-slider")]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("button", {
            onClick: ev => {
              var nthItemStyleX = [...nthItemStyle];
              setnthItemStyle([]);
            },
            className: " flex gap-2 justify-center items-center cursor-pointer py-2 px-3 capitalize  !bg-gray-700 !text-white font-medium !rounded hover:bg-gray-600 hover:text-white focus:outline-none focus:bg-gray-600",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Clear", "woocommerce-products-slider")
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(react_sortablejs__WEBPACK_IMPORTED_MODULE_4__.ReactSortable, {
          list: nthItemStyle,
          handle: ".handle",
          setList: item => {
            // var nthItemStyleX = [...nthItemStyle];
            // setAttributes({ nthItemStyle: { ...nthItemStyle, nthItemStyle: item } });
          },
          children: nthItemStyle != undefined && nthItemStyle?.map((item, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
            className: "",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
              title: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.Fragment, {
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("span", {
                  className: "cursor-pointer hover:bg-red-500 hover:text-white px-1 py-1",
                  onClick: ev => {
                    var nthItemStyleX = [...nthItemStyle];
                    nthItemStyleX.splice(index, 1);
                    setnthItemStyle(nthItemStyleX);
                  },
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Icon, {
                    icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"]
                  })
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("span", {
                  className: "mx-2",
                  children: index + 1
                })]
              }),
              initialOpen: false,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_15__["default"], {
                obj: item,
                extra: {
                  index: index
                },
                onAdd: (sudoScource, key) => onAddStyleNthItem(sudoScource, key, item, {
                  index: index
                }),
                onChange: (sudoScource, newVal, attr) => onChangeStyleNthItem(sudoScource, newVal, attr, item, {
                  index: index
                })

                // onRemove={onRemoveStyleNthItem}
                // onBulkAdd={onBulkAddNthItem}
                // onReset={onResetNthItem}
                ,

                onRemove: (sudoScource, key) => onRemoveStyleNthItem(sudoScource, key, item, {
                  index: index
                }),
                onReset: sudoSources => onResetNthItem(sudoSources, item, {
                  index: index
                }),
                onBulkAdd: (sudoSource, cssObj) => onBulkAddStyleNthItem(sudoSource, cssObj, item, {
                  index: index
                })
              })
            })
          }, item.id))
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Items Wrap",
        initialOpen: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
          activeTab: "options",
          orientation: "horizontal",
          activeClass: "active-tab",
          onSelect: tabName => {},
          tabs: [{
            name: "options",
            title: "Options",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
            className: "tab-settings"
          }, {
            name: "styles",
            title: "Styles",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"],
            className: "tab-style"
          }],
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
            name: "options",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
              className: "flex  my-5  justify-between items-center",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("label", {
                className: "",
                htmlFor: "",
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
                value: itemsWrap?.options?.class,
                className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                onChange: newVal => {
                  var optionsX = {
                    ...itemsWrap,
                    options: {
                      ...itemsWrap?.options,
                      class: newVal
                    }
                  };
                  setitemsWrap(optionsX);
                }
              })]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
            name: "styles",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_15__["default"], {
              obj: itemsWrap,
              onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, itemsWrap, setitemsWrap),
              onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, itemsWrap, setitemsWrap),
              onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, itemsWrap, setitemsWrap),
              onReset: sudoSources => onResetStyle(sudoSources, itemsWrap, setitemsWrap),
              onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, itemsWrap, setitemsWrap)
            })
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Item",
        initialOpen: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
          activeTab: "options",
          orientation: "horizontal",
          activeClass: "active-tab",
          onSelect: tabName => {},
          tabs: [{
            name: "options",
            title: "Options",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
            className: "tab-settings"
          }, {
            name: "styles",
            title: "Styles",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"],
            className: "tab-style"
          }],
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
            name: "options",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
              className: "flex  my-5  justify-between items-center",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("label", {
                className: "",
                htmlFor: "",
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
                value: itemWrap?.options?.class,
                className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                onChange: newVal => {
                  var optionsX = {
                    ...itemWrap,
                    options: {
                      ...itemWrap?.options,
                      class: newVal
                    }
                  };
                  setitemWrap(optionsX);
                }
              })]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
            name: "styles",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_15__["default"], {
              obj: itemWrap,
              onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, itemWrap, setitemWrap),
              onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, itemWrap, setitemWrap),
              onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, itemWrap, setitemWrap),
              onReset: sudoSources => onResetStyle(sudoSources, itemWrap, setitemWrap),
              onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, itemWrap, setitemWrap)
            })
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Pagination",
        initialOpen: false,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
          className: "my-4",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("label", {
            htmlFor: "",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Pagination Type", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_dropdown__WEBPACK_IMPORTED_MODULE_9__["default"], {
            position: "bottom right",
            variant: "secondary",
            options: paginationTypesX,
            buttonTitle: paginationTypesX[globalOptions?.pagination?.type] != undefined ? paginationTypesX[globalOptions.pagination.type].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Choose", "woocommerce-products-slider"),
            onChange: (arg, index) => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.type = arg.value;
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            },
            values: ""
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
          className: "flex  my-5  justify-between items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("label", {
            className: "",
            htmlFor: "",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Previous Text", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
            value: globalOptions?.pagination?.previousText,
            className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
            onChange: newVal => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.previousText = newVal;
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
          className: "flex  my-5  justify-between items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("label", {
            className: "",
            htmlFor: "",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Next Text", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
            value: globalOptions?.pagination?.nextText,
            className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
            onChange: newVal => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.nextText = newVal;
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
          className: "flex  my-5  justify-between items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("label", {
            className: "",
            htmlFor: "",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Load More Text", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
            value: globalOptions?.pagination?.loadMoreText,
            className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
            onChange: newVal => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.loadMoreText = newVal;
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
          className: "flex  my-5  justify-between items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("label", {
            className: "",
            htmlFor: "",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Loading Text", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
            value: globalOptions?.pagination?.loadingText,
            className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
            onChange: newVal => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.loadingText = newVal;
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
          className: "flex  my-5  justify-between items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("label", {
            className: "",
            htmlFor: "",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("No Post Text", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
            value: globalOptions?.pagination?.noPostText,
            className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
            onChange: newVal => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.noPostText = newVal;
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("label", {
            htmlFor: "",
            className: "font-medium text-slate-900 ",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Loading Icon", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_21__["default"], {
            library: globalOptions?.pagination?.loadingIcon?.library,
            srcType: globalOptions?.pagination?.loadingIcon?.srcType,
            iconSrc: globalOptions?.pagination?.loadingIcon?.iconSrc,
            class: globalOptions?.pagination?.loadingIcon?.class,
            onChange: arg => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.loadingIcon = {
                srcType: arg.srcType,
                library: arg.library,
                iconSrc: arg.iconSrc,
                class: arg.class
              };
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("label", {
            htmlFor: "",
            className: "font-medium text-slate-900 ",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Load More Icon", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_21__["default"], {
            library: globalOptions?.pagination?.loadMoreIcon?.library,
            srcType: globalOptions?.pagination?.loadMoreIcon?.srcType,
            iconSrc: globalOptions?.pagination?.loadMoreIcon?.iconSrc,
            class: globalOptions?.pagination?.loadMoreIcon?.class,
            onChange: arg => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.loadMoreIcon = {
                srcType: arg.srcType,
                library: arg.library,
                iconSrc: arg.iconSrc,
                class: arg.class
              };
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("label", {
            htmlFor: "",
            className: "font-medium text-slate-900 ",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Previous Icon", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_21__["default"], {
            library: globalOptions?.pagination?.previousIcon?.library,
            srcType: globalOptions?.pagination?.previousIcon?.srcType,
            iconSrc: globalOptions?.pagination?.previousIcon?.iconSrc,
            class: globalOptions?.pagination?.previousIcon?.class,
            onChange: arg => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.previousIcon = {
                srcType: arg.srcType,
                library: arg.library,
                iconSrc: arg.iconSrc,
                class: arg.class
              };
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("label", {
            htmlFor: "",
            className: "font-medium text-slate-900 ",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Next Icon", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_21__["default"], {
            library: globalOptions?.pagination?.nextIcon?.library,
            srcType: globalOptions?.pagination?.nextIcon?.srcType,
            iconSrc: globalOptions?.pagination?.nextIcon?.iconSrc,
            class: globalOptions?.pagination?.nextIcon?.class,
            onChange: arg => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.nextIcon = {
                srcType: arg.srcType,
                library: arg.library,
                iconSrc: arg.iconSrc,
                class: arg.class
              };
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: "Pagination Wrap",
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
            activeTab: "options",
            orientation: "horizontal",
            activeClass: "active-tab",
            onSelect: tabName => {},
            tabs: [{
              name: "options",
              title: "Options",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
              className: "tab-settings"
            }, {
              name: "styles",
              title: "Styles",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"],
              className: "tab-style"
            }],
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
              name: "options",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
                className: "flex  my-5  justify-between items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("label", {
                  className: "",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
                  value: paginationWrap?.options?.class,
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                  onChange: newVal => {
                    var optionsX = {
                      ...paginationWrap,
                      options: {
                        ...paginationWrap?.options,
                        class: newVal
                      }
                    };
                    setpaginationWrap(optionsX);
                  }
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
              name: "styles",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_15__["default"], {
                obj: paginationWrap,
                onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, paginationWrap, setpaginationWrap),
                onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, paginationWrap, setpaginationWrap),
                onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, paginationWrap, setpaginationWrap),
                onReset: sudoSources => onResetStyle(sudoSources, paginationWrap, setpaginationWrap),
                onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, paginationWrap, setpaginationWrap)
              })
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: "Pagination Item",
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
            activeTab: "options",
            orientation: "horizontal",
            activeClass: "active-tab",
            onSelect: tabName => {},
            tabs: [{
              name: "options",
              title: "Options",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
              className: "tab-settings"
            }, {
              name: "styles",
              title: "Styles",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"],
              className: "tab-style"
            }],
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
              name: "options",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
                className: "flex  my-5  justify-between items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("label", {
                  className: "",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
                  value: paginationItem?.options?.class,
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                  onChange: newVal => {
                    var optionsX = {
                      ...paginationItem,
                      options: {
                        ...paginationItem?.options,
                        class: newVal
                      }
                    };
                    setpaginationItem(optionsX);
                  }
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
              name: "styles",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_15__["default"], {
                obj: paginationItem,
                onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, paginationItem, setpaginationItem),
                onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, paginationItem, setpaginationItem),
                onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, paginationItem, setpaginationItem),
                onReset: sudoSources => onResetStyle(sudoSources, paginationItem, setpaginationItem),
                onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, paginationItem, setpaginationItem)
              })
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: "pagination Item Active",
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
            activeTab: "options",
            orientation: "horizontal",
            activeClass: "active-tab",
            onSelect: tabName => {},
            tabs: [{
              name: "options",
              title: "Options",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
              className: "tab-settings"
            }, {
              name: "styles",
              title: "Styles",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"],
              className: "tab-style"
            }],
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
              name: "options",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
                className: "flex  my-5  justify-between items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("label", {
                  className: "",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
                  value: paginationItemActive?.options?.class,
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                  onChange: newVal => {
                    var optionsX = {
                      ...paginationItemActive,
                      options: {
                        ...paginationItemActive?.options,
                        class: newVal
                      }
                    };
                    setpaginationItemActive(optionsX);
                  }
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
              name: "styles",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_15__["default"], {
                obj: paginationItemActive,
                onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, paginationItemActive, setpaginationItemActive),
                onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, paginationItemActive, setpaginationItemActive),
                onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, paginationItemActive, setpaginationItemActive),
                onReset: sudoSources => onResetStyle(sudoSources, paginationItemActive, setpaginationItemActive),
                onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, paginationItemActive, setpaginationItemActive)
              })
            })]
          })
        })]
      })]
    })
  });
}
class EditGrid extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true,
      isLoaded: false
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      onChange,
      onChangeStyleObj,
      postData,
      customerData,
      addNotifications,
      setHelp
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(Html, {
      onChange: onChange,
      onChangeStyleObj: onChangeStyleObj,
      addNotifications: addNotifications,
      postData: postData,
      customerData: customerData,
      setHelp: setHelp,
      warn: this.state.showWarning,
      isLoaded: this.state.isLoaded
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EditGrid);

/***/ }),

/***/ "./src/components/Builder/edit-masonry.js":
/*!************************************************!*\
  !*** ./src/components/Builder/edit-masonry.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/core-data */ "@wordpress/core-data");
/* harmony import */ var _wordpress_core_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-sortablejs */ "./node_modules/react-sortablejs/dist/index.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_sortablejs__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/help.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/copy.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/page.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/settings.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/brush.js");
/* harmony import */ var _breakpoints__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../breakpoints */ "./src/breakpoints.js");
/* harmony import */ var _dropdown__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _input_select__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../input-select */ "./src/components/input-select/index.js");
/* harmony import */ var _input_text__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../input-text */ "./src/components/input-text/index.js");
/* harmony import */ var _input_toggle__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../input-toggle */ "./src/components/input-toggle/index.js");
/* harmony import */ var _input_wp_editor__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../input-wp-editor */ "./src/components/input-wp-editor/index.js");
/* harmony import */ var _LayoutGenerator__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../LayoutGenerator */ "./src/components/LayoutGenerator/index.js");
/* harmony import */ var _styles__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../styles */ "./src/components/styles/index.js");
/* harmony import */ var _tab__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../tab */ "./src/components/tab/index.js");
/* harmony import */ var _tabs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _items__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../items */ "./src/components/items/index.js");
/* harmony import */ var _layouts__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./layouts */ "./src/components/Builder/layouts.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _pagination_types__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./pagination-types */ "./src/components/Builder/pagination-types.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;
























var myStore = wp.data.select("PostGridStore");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var onChange = props.onChange;
  var onChangeStyleObj = props.onChangeStyleObj;
  var addNotifications = props.addNotifications;
  var setHelp = props.setHelp;
  var postData = props.postData;
  if (postData.post_content == null) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
      className: "p-3 my-5 bg-orange-400",
      children: "Please choose an WCPS first."
    });
  }
  var breakPointX = "Desktop";
  var [PostGridData, setPostGridData] = useState(postData.post_content);
  var [globalOptions, setglobalOptions] = useState(PostGridData.globalOptions);
  var [itemQueryArgs, setitemQueryArgs] = useState(PostGridData.itemQueryArgs);
  var [wrapper, setwrapper] = useState(PostGridData.wrapper);
  var [items, setitems] = useState(PostGridData.items);
  var [itemsWrap, setitemsWrap] = useState(PostGridData.itemsWrap);
  var [itemWrap, setitemWrap] = useState(PostGridData.itemWrap);
  var [paginationWrap, setpaginationWrap] = useState(PostGridData.paginationWrap);
  var [paginationItem, setpaginationItem] = useState(PostGridData.paginationItem);
  var [paginationItemActive, setpaginationItemActive] = useState(PostGridData.paginationItemActive);
  var [icon, seticon] = useState(PostGridData.icon);
  var [iconToggle, seticonToggle] = useState(PostGridData.iconToggle);
  var [masonryOptions, setmasonryOptions] = useState(PostGridData.masonryOptions);
  var [prev, setprev] = useState(PostGridData?.prev);
  var [prevIcon, setprevIcon] = useState(PostGridData?.prevIcon);
  var [next, setnext] = useState(PostGridData?.next);
  var [nextIcon, setnextIcon] = useState(PostGridData?.nextIcon);
  var [sliderOptions, setsliderOptions] = useState(PostGridData?.sliderOptions);
  var [sliderOptionsRes, setsliderOptionsRes] = useState(PostGridData?.sliderOptionsRes);
  var [topWrap, settopWrap] = useState(PostGridData.topWrap);
  var [styleObj, setstyleObj] = useState({});
  const [taxonomiesObjects, setTaxonomiesObjects] = useState([]);
  var [customerData, setcustomerData] = useState(props.customerData);
  var [datePicker, setdatePicker] = useState(9999999);
  var [isProFeature, setisProFeature] = useState(true);
  var [editLayouts, seteditLayouts] = useState(false);
  var [loopLayout, setloopLayout] = useState(PostGridData.loopLayout);
  var wrapperSelector = "#wcps-" + postData.ID;
  var itemsWrapSelector = wrapperSelector + " > .items";
  var itemWrapSelector = wrapperSelector + " > .items > .item";
  var paginationWrapSelector = wrapperSelector + " > .pagination";
  var paginationItemSelector = wrapperSelector + " > .pagination .page-numbers";
  var paginationItemActiveSelector = wrapperSelector + " > .pagination .page-numbers.current";
  var paginationTypesX = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_5__.applyFilters)('PostGridPaginationTypes', _pagination_types__WEBPACK_IMPORTED_MODULE_21__.paginationTypes);
  var breakPointList = [{
    label: "Select..",
    icon: "",
    value: ""
  }];
  for (var x in _breakpoints__WEBPACK_IMPORTED_MODULE_8__["default"]) {
    var breakPointItem = _breakpoints__WEBPACK_IMPORTED_MODULE_8__["default"][x];
    breakPointList.push({
      label: breakPointItem.name,
      icon: breakPointItem.icon,
      value: breakPointItem.id
    });
  }
  var postTypes = [];
  const postTypesData = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_wordpress_core_data__WEBPACK_IMPORTED_MODULE_1__.store).getPostTypes({
    per_page: -1
  }), []);
  postTypesData !== null && postTypesData.map(x => {
    postTypes.push({
      value: x.slug,
      label: x.name
    });
  });
  useEffect(() => {
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
      path: "/wcps/v2/post_type_objects",
      method: "POST",
      data: {
        postTypes: []
      }
    }).then(res => {
      var taxonomies = [];
      res.map(item => {
        taxonomies.push({
          label: item.label,
          value: item.id
        });
      });
      setTaxonomiesObjects(taxonomies);
    });
  }, []);
  useEffect(() => {
    if (customerData.isPro) {
      setisProFeature(false);
    }
  }, [props.customerData]);
  useEffect(() => {
    onChange(PostGridData);
  }, [PostGridData]);
  useEffect(() => {
    if (Object.entries(styleObj).length > 0) {
      onChangeStyleObj(styleObj);
    }
  }, [styleObj]);
  useEffect(() => {
    var styles = generateStyleObj();
    setstyleObj(styles);
  }, [PostGridData]);
  function generateStyleObj() {
    var styleObjX = {};

    // wrapper
    var wrapperX = {
      ...PostGridData.wrapper
    };
    var wrapperStyles = myStore.deletePropertyDeep(wrapperX, ['options']);
    styleObjX[wrapperSelector] = wrapperStyles;
    var itemsWrapX = {
      ...PostGridData.itemsWrap
    };
    var itemsWrapStyles = myStore.deletePropertyDeep(itemsWrapX, ['options']);
    styleObjX[itemsWrapSelector] = itemsWrapStyles;
    var itemWrapX = {
      ...PostGridData.itemWrap
    };
    var itemWrapStyles = myStore.deletePropertyDeep(itemWrapX, ['options']);
    styleObjX[itemWrapSelector] = itemWrapStyles;
    var paginationWrapX = {
      ...PostGridData.paginationWrap
    };
    var paginationWrapStyles = myStore.deletePropertyDeep(paginationWrapX, ['options']);
    styleObjX[paginationWrapSelector] = paginationWrapStyles;
    var paginationItemX = {
      ...PostGridData.paginationItem
    };
    var paginationItemStyles = myStore.deletePropertyDeep(paginationItemX, ['options']);
    styleObjX[paginationItemSelector] = paginationItemStyles;
    var paginationItemActiveX = {
      ...PostGridData.paginationItemActive
    };
    var paginationItemActiveStyles = myStore.deletePropertyDeep(paginationItemActiveX, ['options']);
    styleObjX[paginationItemActiveSelector] = paginationItemActiveStyles;
    var loopLayoutFlatArry = myStore.flattenObject(PostGridData.loopLayout);
    loopLayoutFlatArry.map(element => {
      var elementId = element.id;
      var elementHdnle = "#element-" + elementId;
      var cssSelectors = element.cssSelectors;
      if (cssSelectors != undefined) {
        Object.entries(cssSelectors).map(args => {
          var elementSubIndex = args[0];
          var elementStylesObj = args[1];
          var itemhdnle = elementStylesObj?.handle == undefined ? elementHdnle : elementStylesObj?.handle;
          if (itemhdnle.length == 0) {
            var elementSubHdnle = wrapperSelector + ' ' + elementHdnle;
          } else {
            var elementSubHdnle = wrapperSelector + ' ' + elementHdnle + ' ' + itemhdnle;
          }
          var elementStylesObjX = {
            ...elementStylesObj
          };
          delete elementStylesObjX.handle;
          delete elementStylesObjX.label;
          styleObjX[elementSubHdnle] = elementStylesObjX;
        });
      }
    });
    return styleObjX;
    //setstyleObj(styleObjX)
  }
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.globalOptions = globalOptions;
    setPostGridData(PostGridDataX);
  }, [globalOptions]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.items = items;
    setPostGridData(PostGridDataX);
  }, [items]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.itemsWrap = itemsWrap;
    setPostGridData(PostGridDataX);
  }, [itemsWrap]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.itemWrap = itemWrap;
    setPostGridData(PostGridDataX);
  }, [itemWrap]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.itemQueryArgs = itemQueryArgs;
    setPostGridData(PostGridDataX);
  }, [itemQueryArgs]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.masonryOptions = masonryOptions;
    setPostGridData(PostGridDataX);
  }, [masonryOptions]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.paginationWrap = paginationWrap;
    setPostGridData(PostGridDataX);
  }, [paginationWrap]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.paginationItem = paginationItem;
    setPostGridData(PostGridDataX);
  }, [paginationItem]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.paginationItemActive = paginationItemActive;
    setPostGridData(PostGridDataX);
  }, [paginationItemActive]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.wrapper = wrapper;
    setPostGridData(PostGridDataX);
  }, [wrapper]);
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.loopLayout = loopLayout;
    setPostGridData(PostGridDataX);
  }, [loopLayout]);
  var RemoveMasonryArg = function ({
    index
  }) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("span", {
      className: "cursor-pointer hover:bg-red-500 hover:text-white ",
      onClick: ev => {
        var masonryOptionsX = {
          ...masonryOptions
        };
        delete masonryOptionsX[index];
        setmasonryOptions(masonryOptionsX);
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Icon, {
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"]
      })
    });
  };
  useEffect(() => {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.topWrap = topWrap;
    setPostGridData(PostGridDataX);
  }, [topWrap]);
  const ALLOWED_MEDIA_TYPES = ["image"];
  var videoType = {
    choose: {
      label: "Choose",
      value: ""
    },
    youtube: {
      label: "YouTube",
      value: "youtube"
    }
  };
  function onChangeStyle(sudoScource, newVal, attr, propertyType, setProperty) {
    var path = [sudoScource, attr, breakPointX];
    let obj = {
      ...propertyType
    };
    const object = myStore.updatePropertyDeep(obj, path, newVal);
    setProperty(object);
  }
  function onAddStyle(sudoScource, key, propertyType, setProperty) {
    var path = [sudoScource, key, breakPointX];
    let obj = {
      ...propertyType
    };
    const object = myStore.addPropertyDeep(obj, path, "");
    setProperty(object);
  }
  function onResetStyle(sudoSources, propertyType, setProperty) {
    let obj = Object.assign({}, propertyType);
    Object.entries(sudoSources).map(args => {
      var sudoScource = args[0];
      if (obj[sudoScource] == undefined) {} else {
        obj[sudoScource] = {};
        // var elementSelector = myStore.getElementSelector(
        // 	sudoScource,
        // 	contentSelector // Replace this selector if needed
        // );
      }
    });
    setProperty(obj);
  }
  function onRemoveStyle(sudoScource, key, propertyType, setProperty) {
    let obj = {
      ...propertyType
    };
    var object = myStore.deletePropertyDeep(obj, [sudoScource, key, breakPointX]);
    var isEmpty = Object.entries(object[sudoScource][key]).length === 0 ? true : false;
    var objectX = isEmpty ? myStore.deletePropertyDeep(object, [sudoScource, key]) : object;
    setProperty(objectX);
  }
  function onBulkAddStyle(sudoSource, cssObj, propertyType, setProperty) {
    let obj = {
      ...propertyType
    };
    obj[sudoSource] = cssObj;
    setProperty(obj);
  }

  // useEffect(() => {
  // 	var numberOfColumns = masonryOptions.numberOfColumns;
  // 	var gutter =
  // 		parseInt(masonryOptions.gutter) * (parseInt(numberOfColumns) - 1);
  // 	var calc = "calc((100% - " + gutter + "px)/" + numberOfColumns + ")";
  // 	console.log(calc, itemWrap.styles)
  // 	var itemWrapX = {
  // 		...itemWrap,
  // 		styles: { ...itemWrap.styles, width: { Desktop: calc } },
  // 	};
  // 	setitemWrap(itemWrapX);
  // 	// onChangeStyleItem("styles", clac, "width");
  // }, [masonryOptions.numberOfColumns]);
  // useEffect(() => {
  // 	var gutter = parseInt(masonryOptions.gutter);
  // 	var itemWrapX = {
  // 		...itemWrap,
  // 		styles: { ...itemWrap.styles, marginBottom: { Desktop: `${gutter}px` } },
  // 	};
  // 	setitemWrap(itemWrapX);
  // 	// onChangeStyleItem("styles", clac, "width");
  // }, [masonryOptions.gutter]);

  useEffect(() => {
    var numberOfColumns = masonryOptions.numberOfColumns;
    var gutter = parseInt(masonryOptions.gutter);
    var totalGutter = gutter * (parseInt(numberOfColumns) - 1);
    var calc = `calc((100% - ${totalGutter}px) / ${numberOfColumns})`;
    console.log(gutter, calc);
    var itemWrapX = {
      ...itemWrap,
      styles: {
        ...itemWrap.styles,
        width: {
          Desktop: calc
        },
        marginBottom: {
          Desktop: `${gutter}px`
        }
      }
    };
    setitemWrap(itemWrapX);
  }, [masonryOptions.numberOfColumns, masonryOptions.gutter]);
  // console.log(itemWrap)

  var itemSources = {
    manual: {
      label: "Manual",
      value: "manual"
    },
    posts: {
      label: "Posts",
      value: "posts",
      isPro: customerData.isPro ? false : true
    }
    // terms: {
    // 	label: "Terms",
    // 	value: "terms",
    // 	isPro: customerData.isPro ? false : true,
    // },
  };
  function generate3Digit() {
    return Math.floor(100 + Math.random() * 900);
  }
  const copyData = data => {
    navigator.clipboard.writeText(data).then(() => {
      addNotifications({
        title: "Copied to clipboard!",
        content: "Use the shortcode in page or post conent where you want to display.",
        type: "success"
      });
    }).catch(err => {});
  };
  function escapeHTML(str) {
    const map = {
      "&": "&amp;",
      "<": "&lt;",
      ">": "&gt;",
      '"': "&quot;",
      "'": "&#039;"
    };
    return str.replace(/[&<>"']/g, function (match) {
      return map[match];
    });
  }
  function unescapeHTML(str) {
    const map = {
      "&amp;": "&",
      "&lt;": "<",
      "&gt;": ">",
      "&quot;": '"',
      "&#039;": "'"
    };
    return str.replace(/&amp;|&lt;|&gt;|&quot;|&#039;/g, function (match) {
      return map[match];
    });
  }
  const handleDelete = id => {
    // Filter out the item with the specified id
    const updatedItems = Object.fromEntries(Object.entries(itemQueryArgs).filter(([key, item]) => item.id !== id));
    setitemQueryArgs(updatedItems);
  };
  var masonryOptionsArgs = {
    numberOfColumns: {
      label: "Number Of Columns",
      value: 3
    },
    gutter: {
      label: "Gutter",
      value: 15
    },
    itemSelector: {
      label: "Item Selector",
      value: ".item"
    },
    columnWidth: {
      label: "Column Width",
      value: ".item"
    },
    percentPosition: {
      label: "Percent Position",
      value: true
    },
    horizontalOrder: {
      label: "Horizontal Order",
      value: true
    },
    stamp: {
      label: "Stamp",
      value: ".stamp"
    },
    fitWidth: {
      label: "Fit Width",
      value: true
    },
    originLeft: {
      label: "Origin Left",
      value: true
    },
    originTop: {
      label: "Origin Top",
      value: true
    },
    stagger: {
      label: "Stagger",
      value: 30
    },
    resize: {
      label: "Resize",
      value: true
    }
  };
  function onChangeLayouts(loopLayout) {
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.loopLayout = loopLayout;
    setPostGridData(PostGridDataX);
    setloopLayout(loopLayout);
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
    className: "",
    children: props.postData.post_content != null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_items__WEBPACK_IMPORTED_MODULE_18__["default"], {
        itemsState: {
          items,
          setitems
        },
        globalOptionsState: {
          globalOptions,
          setglobalOptions
        },
        itemQueryState: {
          itemQueryArgs,
          setitemQueryArgs
        },
        customerData: customerData,
        setHelp: setHelp,
        addNotifications: addNotifications
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Settings",
        initialOpen: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
          className: "py-3",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("label", {
              htmlFor: "",
              className: "flex gap-2 items-center",
              children: ["Lazyload", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("span", {
                className: "cursor-pointer",
                title: "Click to know more",
                onClick: () => {
                  setHelp({
                    id: "lazyloadSetting",
                    enable: true
                  });
                },
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Icon, {
                  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"]
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_toggle__WEBPACK_IMPORTED_MODULE_12__["default"], {
              value: globalOptions?.lazyLoad,
              onChange: newVal => {
                var globalOptionsX = {
                  ...globalOptions
                };
                globalOptionsX.lazyLoad = newVal;
                setglobalOptions(globalOptionsX);
              }
            })]
          })
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Layouts",
        initialOpen: false,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
          className: "flex items-center justify-between",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
            className: "bg-slate-700 inline-block text-white px-5 py-2 rounded-sm cursor-pointer hover:bg-slate-600",
            onClick: ev => {
              seteditLayouts(!editLayouts);
            },
            children: "Customize Layouts"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
            className: "bg-slate-700 text-white px-5 py-2 rounded-sm cursor-pointer hover:bg-slate-600 flex items-center gap-1",
            onClick: () => {
              navigator.clipboard.writeText(JSON.stringify(PostGridData.loopLayout)).then(() => {
                addNotifications({
                  title: "Copied to clipboard!",
                  content: "Layout Copied!",
                  type: "success"
                });
              });
            },
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Icon, {
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"],
              size: 14,
              fill: "#fff"
            }), "Copy"]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
            className: "bg-slate-700 text-white px-5 py-2 rounded-sm cursor-pointer hover:bg-slate-600 flex items-center gap-1",
            onClick: async () => {
              try {
                var data = await navigator.clipboard.readText();
                data = JSON.parse(data);
                onChangeLayouts(data).then(() => {
                  addNotifications({
                    title: "Layout Pasted!",
                    content: "Layout paste successful.",
                    type: "success"
                  });
                });
              } catch (e) {
                console.log(e);
              }
            },
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Icon, {
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"],
              size: 14,
              fill: "#fff"
            }), "Paste"]
          }), editLayouts && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
            className: "fixed h-full top-0 py-10 overflow-y-auto bg-slate-500 bg-opacity-70 left-0 w-full z-50",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
              className: "w-[1400px] mx-auto ",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                className: "flex justify-between bg-gray-700 p-3",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
                  className: "text-white text-md",
                  children: "Layout Editor"
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("span", {
                    className: "size-6 bg-red-500 flex items-center justify-center cursor-pointer",
                    onClick: ev => {
                      seteditLayouts(!editLayouts);
                    },
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.Icon, {
                      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_23__["default"],
                      fill: "#fff",
                      size: 18
                    })
                  })
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_LayoutGenerator__WEBPACK_IMPORTED_MODULE_14__["default"], {
                postData: postData,
                customerData: customerData,
                addNotifications: addNotifications,
                onChange: onChangeLayouts,
                layouts: PostGridData.loopLayout
              })]
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("div", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_layouts__WEBPACK_IMPORTED_MODULE_19__["default"], {
            postData: postData,
            onChangeLayouts: onChangeLayouts,
            customerData: customerData,
            addNotifications: addNotifications,
            setHelp: setHelp
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Masonry", "woocommerce-products-slider"),
        initialOpen: true,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
          className: "my-3",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_dropdown__WEBPACK_IMPORTED_MODULE_9__["default"], {
            position: "bottom right",
            variant: "secondary",
            buttonTitle: "Choose",
            options: masonryOptionsArgs
            // onChange={(option, index) => {
            // 	var masonryOptionsX = { ...masonryOptions };
            // 	masonryOptionsX[index] = option.value;
            // 	setAttributes({ masonryOptions: masonryOptionsX });
            // }}
            ,
            onChange: (newVal, index) => {
              var masonryOptionsX = {
                ...masonryOptions
              };
              masonryOptionsX[index] = newVal.value;
              setmasonryOptions(masonryOptionsX);
            },
            values: ""
          })
        }), Object.entries(masonryOptions).map((item, index) => {
          var id = item[0];
          var value = item[1];
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
            children: [id == "itemSelector" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                className: "flex items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(RemoveMasonryArg, {
                  index: id
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                  htmlFor: "",
                  className: "font-medium text-slate-900 ",
                  children: "Item Selector"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
                value: masonryOptions.itemSelector,
                onChange: newVal => {
                  setmasonryOptions({
                    ...masonryOptions,
                    itemSelector: newVal
                  });
                }
              })]
            }), id == "gutter" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                className: "flex items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(RemoveMasonryArg, {
                  index: id
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                  htmlFor: "",
                  className: "font-medium text-slate-900 ",
                  children: "Gutter"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
                type: "number",
                value: masonryOptions.gutter,
                onChange: newVal => {
                  setmasonryOptions({
                    ...masonryOptions,
                    gutter: parseInt(newVal)
                  });
                  // onChangeStyleItem(
                  // 	"styles",
                  // 	parseInt(newVal) + "px",
                  // 	"marginBottom"
                  // );
                }
              })]
            }), id == "columnWidth" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                className: "flex items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(RemoveMasonryArg, {
                  index: id
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                  htmlFor: "",
                  className: "font-medium text-slate-900 ",
                  children: "Column width"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
                value: masonryOptions.columnWidth,
                onChange: newVal => {
                  setmasonryOptions({
                    ...masonryOptions,
                    columnWidth: newVal
                  });
                }
              })]
            }), id == "numberOfColumns" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                className: "flex items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(RemoveMasonryArg, {
                  index: id
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                  htmlFor: "",
                  className: "font-medium text-slate-900 ",
                  children: "Number Of Columns"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.__experimentalInputControl, {
                type: "number",
                value: masonryOptions.numberOfColumns,
                onChange: newVal => {
                  setmasonryOptions({
                    ...masonryOptions,
                    numberOfColumns: parseInt(newVal)
                  });
                }
              })]
            }), id == "horizontalOrder" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                className: "flex items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(RemoveMasonryArg, {
                  index: id
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
                  label: "Horizontal Order?",
                  help: masonryOptions.horizontalOrder ? "Horizontal Order Enabled" : "Horizontal Order Disabled",
                  checked: masonryOptions.horizontalOrder,
                  onChange: newHorizontalOrder => {
                    const updatedMasonryOptions = {
                      ...masonryOptions,
                      horizontalOrder: newHorizontalOrder
                    };
                    setmasonryOptions(updatedMasonryOptions);
                  }
                })]
              })
            }), id == "percentPosition" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                className: "flex items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(RemoveMasonryArg, {
                  index: id
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
                  label: "Percent Position?",
                  help: masonryOptions.percentPosition ? "Percent Position Enabled" : "Percent Position Disabled",
                  checked: masonryOptions.percentPosition,
                  onChange: newPercentPosition => {
                    const updatedMasonryOptions = {
                      ...masonryOptions,
                      percentPosition: newPercentPosition
                    };
                    setmasonryOptions(updatedMasonryOptions);
                  }
                })]
              })
            }), id == "stamp" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                className: "flex items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(RemoveMasonryArg, {
                  index: id
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                  htmlFor: "",
                  className: "font-medium text-slate-900 ",
                  children: "Stamp"
                })]
              })
            }), id == "fitWidth" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                className: "flex items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(RemoveMasonryArg, {
                  index: id
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
                  label: "Fit Width?",
                  help: masonryOptions.fitWidth ? "Fit Width Enabled" : "Fit Width Disabled.",
                  checked: masonryOptions.fitWidth,
                  onChange: fitWidth => {
                    const updatedMasonryOptions = {
                      ...masonryOptions,
                      fitWidth: fitWidth
                    };
                    setmasonryOptions(updatedMasonryOptions);
                  }
                })]
              })
            }), id == "originLeft" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                className: "flex items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(RemoveMasonryArg, {
                  index: id
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
                  label: "Origin Left?",
                  help: masonryOptions.originLeft ? "Origin Left Enabled" : "Origin Left Disabled.",
                  checked: masonryOptions.originLeft,
                  onChange: originLeft => {
                    const updatedMasonryOptions = {
                      ...masonryOptions,
                      originLeft: originLeft
                    };
                    setmasonryOptions(updatedMasonryOptions);
                  }
                })]
              })
            }), id == "originTop" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                className: "flex items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(RemoveMasonryArg, {
                  index: id
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
                  label: "Origin Top?",
                  help: masonryOptions.originTop ? "Origin Top Enabled" : "Origin Top Disabled.",
                  checked: masonryOptions.originTop,
                  onChange: originTop => {
                    const updatedMasonryOptions = {
                      ...masonryOptions,
                      originTop: originTop
                    };
                    setmasonryOptions(updatedMasonryOptions);
                  }
                })]
              })
            }), id == "stagger" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                className: "flex items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(RemoveMasonryArg, {
                  index: id
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
                  label: "Stagger?",
                  help: masonryOptions.stagger ? "Stagger Enabled" : "Stagger Disabled.",
                  checked: masonryOptions.stagger,
                  onChange: stagger => {
                    const updatedMasonryOptions = {
                      ...masonryOptions,
                      stagger: stagger
                    };
                    setmasonryOptions(updatedMasonryOptions);
                  }
                })]
              })
            }), id == "resize" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                className: "flex items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(RemoveMasonryArg, {
                  index: id
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.ToggleControl, {
                  label: "Resize?",
                  help: masonryOptions.resize ? "Resize Enabled" : "Resize Disabled.",
                  checked: masonryOptions.resize,
                  onChange: resize => {
                    const updatedMasonryOptions = {
                      ...masonryOptions,
                      resize: resize
                    };
                    setmasonryOptions(updatedMasonryOptions);
                  }
                })]
              })
            })]
          }, index);
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Wrapper",
        initialOpen: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
          activeTab: "options",
          orientation: "horizontal",
          activeClass: "active-tab",
          onSelect: tabName => {},
          tabs: [{
            name: "options",
            title: "Options",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
            className: "tab-settings"
          }, {
            name: "styles",
            title: "Styles",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
            className: "tab-style"
          }],
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
            name: "options",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
              className: "flex  my-5  justify-between items-center",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                className: "",
                htmlFor: "",
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
                value: wrapper?.options?.class,
                className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                onChange: newVal => {
                  var optionsX = {
                    ...wrapper,
                    options: {
                      ...wrapper?.options,
                      class: newVal
                    }
                  };
                  setwrapper(optionsX);
                }
              })]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
            name: "styles",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_15__["default"], {
              obj: wrapper,
              onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, wrapper, setwrapper),
              onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, wrapper, setwrapper),
              onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, wrapper, setwrapper),
              onReset: sudoSources => onResetStyle(sudoSources, wrapper, setwrapper),
              onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, wrapper, setwrapper)
            })
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Items Wrap",
        initialOpen: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
          activeTab: "options",
          orientation: "horizontal",
          activeClass: "active-tab",
          onSelect: tabName => {},
          tabs: [{
            name: "options",
            title: "Options",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
            className: "tab-settings"
          }, {
            name: "styles",
            title: "Styles",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
            className: "tab-style"
          }],
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
            name: "options",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
              className: "flex  my-5  justify-between items-center",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                className: "",
                htmlFor: "",
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
                value: itemsWrap?.options?.class,
                className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                onChange: newVal => {
                  var optionsX = {
                    ...itemsWrap,
                    options: {
                      ...itemsWrap?.options,
                      class: newVal
                    }
                  };
                  setitemsWrap(optionsX);
                }
              })]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
            name: "styles",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_15__["default"], {
              obj: itemsWrap,
              onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, itemsWrap, setitemsWrap),
              onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, itemsWrap, setitemsWrap),
              onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, itemsWrap, setitemsWrap),
              onReset: sudoSources => onResetStyle(sudoSources, itemsWrap, setitemsWrap),
              onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, itemsWrap, setitemsWrap)
            })
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Item",
        initialOpen: false,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
          activeTab: "options",
          orientation: "horizontal",
          activeClass: "active-tab",
          onSelect: tabName => {},
          tabs: [{
            name: "options",
            title: "Options",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
            className: "tab-settings"
          }, {
            name: "styles",
            title: "Styles",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
            className: "tab-style"
          }],
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
            name: "options",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
              className: "flex  my-5  justify-between items-center",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                className: "",
                htmlFor: "",
                children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
                value: itemWrap?.options?.class,
                className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                onChange: newVal => {
                  var optionsX = {
                    ...itemWrap,
                    options: {
                      ...itemWrap?.options,
                      class: newVal
                    }
                  };
                  setitemWrap(optionsX);
                }
              })]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
            name: "styles",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_15__["default"], {
              obj: itemWrap,
              onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, itemWrap, setitemWrap),
              onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, itemWrap, setitemWrap),
              onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, itemWrap, setitemWrap),
              onReset: sudoSources => onResetStyle(sudoSources, itemWrap, setitemWrap),
              onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, itemWrap, setitemWrap)
            })
          })]
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
        className: "font-medium text-slate-900 ",
        title: "Pagination",
        initialOpen: false,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
          className: "my-4",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            htmlFor: "",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Pagination Type", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_dropdown__WEBPACK_IMPORTED_MODULE_9__["default"], {
            position: "bottom right",
            variant: "secondary",
            options: paginationTypesX,
            buttonTitle: paginationTypesX[globalOptions?.pagination?.type] != undefined ? paginationTypesX[globalOptions.pagination.type].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Choose", "woocommerce-products-slider"),
            onChange: (arg, index) => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.type = arg.value;
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            },
            values: ""
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
          className: "flex  my-5  justify-between items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            className: "",
            htmlFor: "",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Previous Text", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
            value: globalOptions?.pagination?.previousText,
            className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
            onChange: newVal => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.previousText = newVal;
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
          className: "flex  my-5  justify-between items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            className: "",
            htmlFor: "",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Next Text", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
            value: globalOptions?.pagination?.nextText,
            className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
            onChange: newVal => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.nextText = newVal;
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
          className: "flex  my-5  justify-between items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            className: "",
            htmlFor: "",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Load More Text", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
            value: globalOptions?.pagination?.loadMoreText,
            className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
            onChange: newVal => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.loadMoreText = newVal;
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
          className: "flex  my-5  justify-between items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            className: "",
            htmlFor: "",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Loading Text", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
            value: globalOptions?.pagination?.loadingText,
            className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
            onChange: newVal => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.loadingText = newVal;
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
          className: "flex  my-5  justify-between items-center",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            className: "",
            htmlFor: "",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("No Post Text", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
            value: globalOptions?.pagination?.noPostText,
            className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
            onChange: newVal => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.noPostText = newVal;
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            htmlFor: "",
            className: "font-medium text-slate-900 ",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Loading Icon", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_20__["default"], {
            library: globalOptions?.pagination?.loadingIcon?.library,
            srcType: globalOptions?.pagination?.loadingIcon?.srcType,
            iconSrc: globalOptions?.pagination?.loadingIcon?.iconSrc,
            class: globalOptions?.pagination?.loadingIcon?.class,
            onChange: arg => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.loadingIcon = {
                srcType: arg.srcType,
                library: arg.library,
                iconSrc: arg.iconSrc,
                class: arg.class
              };
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            htmlFor: "",
            className: "font-medium text-slate-900 ",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Load More Icon", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_20__["default"], {
            library: globalOptions?.pagination?.loadMoreIcon?.library,
            srcType: globalOptions?.pagination?.loadMoreIcon?.srcType,
            iconSrc: globalOptions?.pagination?.loadMoreIcon?.iconSrc,
            class: globalOptions?.pagination?.loadMoreIcon?.class,
            onChange: arg => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.loadMoreIcon = {
                srcType: arg.srcType,
                library: arg.library,
                iconSrc: arg.iconSrc,
                class: arg.class
              };
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            htmlFor: "",
            className: "font-medium text-slate-900 ",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Previous Icon", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_20__["default"], {
            library: globalOptions?.pagination?.previousIcon?.library,
            srcType: globalOptions?.pagination?.previousIcon?.srcType,
            iconSrc: globalOptions?.pagination?.previousIcon?.iconSrc,
            class: globalOptions?.pagination?.previousIcon?.class,
            onChange: arg => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.previousIcon = {
                srcType: arg.srcType,
                library: arg.library,
                iconSrc: arg.iconSrc,
                class: arg.class
              };
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelRow, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
            htmlFor: "",
            className: "font-medium text-slate-900 ",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Next Icon", "woocommerce-products-slider")
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_components_icon_picker__WEBPACK_IMPORTED_MODULE_20__["default"], {
            library: globalOptions?.pagination?.nextIcon?.library,
            srcType: globalOptions?.pagination?.nextIcon?.srcType,
            iconSrc: globalOptions?.pagination?.nextIcon?.iconSrc,
            class: globalOptions?.pagination?.nextIcon?.class,
            onChange: arg => {
              var globalOptionsX = {
                ...globalOptions
              };
              var paginationX = {
                ...globalOptionsX.pagination
              };
              paginationX.nextIcon = {
                srcType: arg.srcType,
                library: arg.library,
                iconSrc: arg.iconSrc,
                class: arg.class
              };
              globalOptionsX.pagination = paginationX;
              setglobalOptions(globalOptionsX);
            }
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: "Pagination Wrap",
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
            activeTab: "options",
            orientation: "horizontal",
            activeClass: "active-tab",
            onSelect: tabName => {},
            tabs: [{
              name: "options",
              title: "Options",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
              className: "tab-settings"
            }, {
              name: "styles",
              title: "Styles",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
              className: "tab-style"
            }],
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
              name: "options",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                className: "flex  my-5  justify-between items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                  className: "",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
                  value: paginationWrap?.options?.class,
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                  onChange: newVal => {
                    var optionsX = {
                      ...paginationWrap,
                      options: {
                        ...paginationWrap?.options,
                        class: newVal
                      }
                    };
                    setpaginationWrap(optionsX);
                  }
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
              name: "styles",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_15__["default"], {
                obj: paginationWrap,
                onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, paginationWrap, setpaginationWrap),
                onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, paginationWrap, setpaginationWrap),
                onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, paginationWrap, setpaginationWrap),
                onReset: sudoSources => onResetStyle(sudoSources, paginationWrap, setpaginationWrap),
                onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, paginationWrap, setpaginationWrap)
              })
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: "Pagination Item",
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
            activeTab: "options",
            orientation: "horizontal",
            activeClass: "active-tab",
            onSelect: tabName => {},
            tabs: [{
              name: "options",
              title: "Options",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
              className: "tab-settings"
            }, {
              name: "styles",
              title: "Styles",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
              className: "tab-style"
            }],
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
              name: "options",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                className: "flex  my-5  justify-between items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                  className: "",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
                  value: paginationItem?.options?.class,
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                  onChange: newVal => {
                    var optionsX = {
                      ...paginationItem,
                      options: {
                        ...paginationItem?.options,
                        class: newVal
                      }
                    };
                    setpaginationItem(optionsX);
                  }
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
              name: "styles",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_15__["default"], {
                obj: paginationItem,
                onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, paginationItem, setpaginationItem),
                onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, paginationItem, setpaginationItem),
                onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, paginationItem, setpaginationItem),
                onReset: sudoSources => onResetStyle(sudoSources, paginationItem, setpaginationItem),
                onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, paginationItem, setpaginationItem)
              })
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_7__.PanelBody, {
          className: "font-medium text-slate-900 ",
          title: "pagination Item Active",
          initialOpen: false,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_tabs__WEBPACK_IMPORTED_MODULE_17__["default"], {
            activeTab: "options",
            orientation: "horizontal",
            activeClass: "active-tab",
            onSelect: tabName => {},
            tabs: [{
              name: "options",
              title: "Options",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
              className: "tab-settings"
            }, {
              name: "styles",
              title: "Styles",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
              className: "tab-style"
            }],
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
              name: "options",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                className: "flex  my-5  justify-between items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)("label", {
                  className: "",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Class", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_11__["default"], {
                  value: paginationItemActive?.options?.class,
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[210px]",
                  onChange: newVal => {
                    var optionsX = {
                      ...paginationItemActive,
                      options: {
                        ...paginationItemActive?.options,
                        class: newVal
                      }
                    };
                    setpaginationItemActive(optionsX);
                  }
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_tab__WEBPACK_IMPORTED_MODULE_16__["default"], {
              name: "styles",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(_styles__WEBPACK_IMPORTED_MODULE_15__["default"], {
                obj: paginationItemActive,
                onChange: (sudoScource, newVal, attr) => onChangeStyle(sudoScource, newVal, attr, paginationItemActive, setpaginationItemActive),
                onAdd: (sudoScource, key) => onAddStyle(sudoScource, key, paginationItemActive, setpaginationItemActive),
                onRemove: (sudoScource, key) => onRemoveStyle(sudoScource, key, paginationItemActive, setpaginationItemActive),
                onReset: sudoSources => onResetStyle(sudoSources, paginationItemActive, setpaginationItemActive),
                onBulkAdd: (sudoSource, cssObj) => onBulkAddStyle(sudoSource, cssObj, paginationItemActive, setpaginationItemActive)
              })
            })]
          })
        })]
      })]
    })
  });
}
class EditMasonry extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true,
      isLoaded: false
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      onChange,
      onChangeStyleObj,
      postData,
      customerData,
      addNotifications,
      setHelp
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx)(Html, {
      onChange: onChange,
      onChangeStyleObj: onChangeStyleObj,
      addNotifications: addNotifications,
      postData: postData,
      customerData: customerData,
      setHelp: setHelp,
      warn: this.state.showWarning,
      isLoaded: this.state.isLoaded
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EditMasonry);

/***/ }),

/***/ "./src/components/Builder/generate-css.js":
/*!************************************************!*\
  !*** ./src/components/Builder/generate-css.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-sortablejs */ "./node_modules/react-sortablejs/dist/index.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_sortablejs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _splidejs_react_splide__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @splidejs/react-splide */ "./node_modules/@splidejs/react-splide/dist/js/react-splide.esm.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
const {
  Component,
  RawHTML,
  useState,
  useEffect,
  useMemo
} = wp.element;








var myStore = wp.data.select("PostGridStore");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var onGenerateCss = props.onGenerateCss;
  var styleObj = props.styleObj;
  var reponsiveCss = props.reponsiveCss == undefined ? "" : props.reponsiveCss;

  // if (styleObj) {
  // 	return null;
  // }

  console.log(styleObj);
  useEffect(() => {
    if (Object.entries(styleObj).length == 0) {
      return;
    }
    var reponsiveCss = convertStyleobjToCss(styleObj);
    onGenerateCss(reponsiveCss);
    var wpfooter = document.getElementById("wpfooter");
    var csswrappg = document.getElementById("wcps-builder-styles");
    if (csswrappg == null) {
      var divWrap = '<style id="wcps-builder-styles">' + reponsiveCss + '</style>';
      wpfooter.insertAdjacentHTML("beforeend", divWrap);
      var csswrappg = document.getElementById("wcps-builder-styles");
      csswrappg.innerHtml = reponsiveCss;
    } else {
      csswrappg.innerHTML = reponsiveCss;
    }
  }, [styleObj]);
  useEffect(() => {
    if (reponsiveCss.length == 0) {
      return;
    }
    reponsiveCss = unescapeHTML(reponsiveCss);
    var wpfooter = document.getElementById("wpfooter");
    var csswrappg = document.getElementById("wcps-builder-styles");
    if (csswrappg == null) {
      var divWrap = '<style id="wcps-builder-styles">' + reponsiveCss + '</style>';
      wpfooter.insertAdjacentHTML("beforeend", divWrap);
      var csswrappg = document.getElementById("wcps-builder-styles");
      csswrappg.innerHtml = reponsiveCss;
    } else {
      csswrappg.innerHTML = reponsiveCss;
    }
  }, [reponsiveCss]);
  function unescapeHTML(str) {
    const map = {
      "&amp;": "&",
      "&lt;": "<",
      "&gt;": ">",
      "&quot;": '"',
      "&#039;": "'"
    };
    return str.replace(/&amp;|&lt;|&gt;|&quot;|&#039;/g, function (match) {
      return map[match];
    });
  }
  function getElementSelector(sudoScource, mainSelector) {
    var elementSelector = mainSelector;
    if (sudoScource == "styles") {
      elementSelector = mainSelector;
    } else if (sudoScource == "hover") {
      elementSelector = mainSelector + ":hover";
    } else if (sudoScource == "after") {
      elementSelector = mainSelector + "::after";
    } else if (sudoScource == "before") {
      elementSelector = mainSelector + "::before";
    } else if (sudoScource == "first-child") {
      elementSelector = mainSelector + ":first-child";
    } else if (sudoScource == "last-child") {
      elementSelector = mainSelector + ":last-child";
    } else if (sudoScource == "visited") {
      elementSelector = mainSelector + ":visited";
    } else if (sudoScource == "selection") {
      elementSelector = mainSelector + "::selection";
    } else if (sudoScource == "first-letter") {
      elementSelector = mainSelector + "::first-letter";
    } else if (sudoScource == "first-line") {
      elementSelector = mainSelector + "::first-line";
    } else {
      elementSelector = mainSelector + ":" + sudoScource;
    }
    return elementSelector;
  }
  function cssAttrParse(key) {
    var cssProp = "";
    if (key == "alignContent") {
      cssProp = "align-content";
    } else if (key == "alignItems") {
      cssProp = "align-items";
    } else if (key == "animationName") {
      cssProp = "animation-name";
    } else if (key == "alignSelf") {
      cssProp = "align-self";
    } else if (key == "aspectRatio") {
      cssProp = "aspect-ratio";
    } else if (key == "backfaceVisibility") {
      cssProp = "backface-visibility";
    } else if (key == "backgroundAttachment") {
      cssProp = "background-attachment";
    } else if (key == "backgroundBlendMode") {
      cssProp = "background-blend-mode";
    } else if (key == "backgroundClip") {
      cssProp = "background-clip";
    } else if (key == "bgColor") {
      cssProp = "background-color";
    } else if (key == "backgroundColor") {
      cssProp = "background-color";
    } else if (key == "backgroundOrigin") {
      cssProp = "background-origin";
    } else if (key == "backgroundRepeat") {
      cssProp = "background-repeat";
    } else if (key == "backgroundSize") {
      cssProp = "background-size";
    } else if (key == "backgroundPosition") {
      cssProp = "background-position";
    } else if (key == "backgroundImage") {
      cssProp = "background-image";
    } else if (key == "border") {
      cssProp = "border";
    } else if (key == "borderTop") {
      cssProp = "border-top";
    } else if (key == "borderRight") {
      cssProp = "border-right";
    } else if (key == "borderBottom") {
      cssProp = "border-bottom";
    } else if (key == "borderLeft") {
      cssProp = "border-left";
    } else if (key == "borderRadius") {
      cssProp = "border-radius";
    } else if (key == "borderCollapse") {
      cssProp = "border-collapse";
    } else if (key == "borderSpacing") {
      cssProp = "border-spacing";
    } else if (key == "borderImage") {
      cssProp = "border-image";
    } else if (key == "boxShadow") {
      cssProp = "box-shadow";
    } else if (key == "backdropFilter") {
      cssProp = "backdrop-filter";
    } else if (key == "bottom" || key == "top" || key == "left" || key == "right" || key == "clear" || key == "color" || key == "filter" || key == "float") {
      cssProp = key;
    } else if (key == "boxSizing") {
      cssProp = "box-sizing";
    } else if (key == "cursor") {
      cssProp = "cursor";
    } else if (key == "content") {
      cssProp = "content";
    } else if (key == "counterIncrement") {
      cssProp = "counter-increment";
    } else if (key == "counterReset") {
      cssProp = "counter-reset";
    } else if (key == "counterSet") {
      cssProp = "counter-set";
    } else if (key == "columnCount") {
      cssProp = "column-count";
    } else if (key == "columnRule") {
      cssProp = "column-rule";
    } else if (key == "direction") {
      cssProp = "direction";
    } else if (key == "fontFamily") {
      cssProp = "font-family";
    } else if (key == "fontSize") {
      cssProp = "font-size";
    } else if (key == "fontStyle") {
      cssProp = "font-style";
    } else if (key == "fontStretch") {
      cssProp = "font-stretch";
    } else if (key == "fontWeight") {
      cssProp = "font-weight";
    } else if (key == "fontVariantCaps") {
      cssProp = "font-variant-caps";
    } else if (key == "flexWrap") {
      cssProp = "flex-wrap";
    } else if (key == "flexDirection") {
      cssProp = "flex-direction";
    } else if (key == "flexGrow") {
      cssProp = "flex-grow";
    } else if (key == "flexShrink") {
      cssProp = "flex-shrink";
    } else if (key == "flexBasis") {
      cssProp = "flex-basis";
    } else if (key == "flexFlow") {
      cssProp = "flex-flow";
    } else if (key == "letterSpacing") {
      cssProp = "letter-spacing";
    } else if (key == "gridAutoFlow") {
      cssProp = "grid-auto-flow";
    } else if (key == "gridColumnEnd") {
      cssProp = "grid-column-end";
    } else if (key == "gridColumnStart") {
      cssProp = "grid-column-start";
    } else if (key == "gridRowEnd") {
      cssProp = "grid-row-end";
    } else if (key == "gridRowStart") {
      cssProp = "grid-row-start";
    } else if (key == "gridTemplateColumns") {
      cssProp = "grid-template-columns";
    } else if (key == "gridTemplateRows") {
      cssProp = "grid-template-rows";
    } else if (key == "listStyle") {
      cssProp = "list-style";
    } else if (key == "lineHeight") {
      cssProp = "line-height";
    } else if (key == "justifyContent") {
      cssProp = "justify-content";
    } else if (key == "maskImage") {
      cssProp = "mask-image";
    } else if (key == "objectFit") {
      cssProp = "object-fit";
    } else if (key == "opacity") {
      cssProp = "opacity";
    } else if (key == "outline") {
      cssProp = "outline";
    } else if (key == "order") {
      cssProp = "order";
    } else if (key == "outlineOffset") {
      cssProp = "outline-offset";
    } else if (key == "position") {
      cssProp = "position";
    } else if (key == "textIndent") {
      cssProp = "text-indent";
    } else if (key == "textJustify") {
      cssProp = "text-justify";
    } else if (key == "textTransform") {
      cssProp = "text-transform";
    } else if (key == "textDecoration") {
      cssProp = "text-decoration";
    } else if (key == "textOverflow") {
      cssProp = "text-overflow";
    } else if (key == "textShadow") {
      cssProp = "text-shadow";
    } else if (key == "textAlign") {
      cssProp = "text-align";
    } else if (key == "visibility") {
      cssProp = "visibility";
    } else if (key == "wordBreak") {
      cssProp = "word-break";
    } else if (key == "wordSpacing") {
      cssProp = "word-spacing";
    } else if (key == "zIndex") {
      cssProp = "z-index";
    } else if (key == "padding") {
      cssProp = "padding";
    } else if (key == "paddingTop") {
      cssProp = "padding-top";
    } else if (key == "paddingRight") {
      cssProp = "padding-right";
    } else if (key == "paddingBottom") {
      cssProp = "padding-bottom";
    } else if (key == "paddingLeft") {
      cssProp = "padding-left";
    } else if (key == "placeItems") {
      cssProp = "place-items";
    } else if (key == "margin") {
      cssProp = "margin";
    } else if (key == "marginTop") {
      cssProp = "margin-top";
    } else if (key == "marginRight") {
      cssProp = "margin-right";
    } else if (key == "marginBottom") {
      cssProp = "margin-bottom";
    } else if (key == "marginLeft") {
      cssProp = "margin-left";
    } else if (key == "display") {
      cssProp = "display";
    } else if (key == "width") {
      cssProp = "width";
    } else if (key == "height") {
      cssProp = "height";
    } else if (key == "verticalAlign") {
      cssProp = "vertical-align";
    } else if (key == "overflow") {
      cssProp = "overflow";
    } else if (key == "overflowX") {
      cssProp = "overflow-x";
    } else if (key == "overflowY") {
      cssProp = "overflow-y";
    } else if (key == "writingMode") {
      cssProp = "writing-mode";
    } else if (key == "wordWrap") {
      cssProp = "word-wrap";
    } else if (key == "perspective") {
      cssProp = "perspective";
    } else if (key == "minWidth") {
      cssProp = "min-width";
    } else if (key == "minHeight") {
      cssProp = "min-height";
    } else if (key == "maxHeight") {
      cssProp = "max-height";
    } else if (key == "maxWidth") {
      cssProp = "max-width";
    } else if (key == "transition") {
      cssProp = "transition";
    } else if (key == "transform") {
      cssProp = "transform";
    } else if (key == "transformOrigin") {
      cssProp = "transform-origin";
    } else if (key == "transformStyle") {
      cssProp = "transform-style";
    } else if (key == "tableLayout") {
      cssProp = "table-layout";
    } else if (key == "emptyCells") {
      cssProp = "empty-cells";
    } else if (key == "captionSide") {
      cssProp = "caption-side";
    } else if (key == "gap") {
      cssProp = "gap";
    } else if (key == "rowGap") {
      cssProp = "row-gap";
    } else if (key == "columnGap") {
      cssProp = "column-gap";
    } else if (key == "userSelect") {
      cssProp = "user-select";
    } else if (key == "-webkit-text-fill-color") {
      cssProp = "-webkit-text-fill-color";
    } else {
      cssProp = key;
    }
    return cssProp;
  }
  function convertStyleobjToCss(items) {
    var reponsiveCssGroups = {};
    for (var selector in items) {
      var sudoArgs = items[selector];
      for (var sudoSrc in sudoArgs) {
        var selectorHandl = getElementSelector(sudoSrc, selector);
        var sudoPrams = sudoArgs[sudoSrc];
        for (var attr in sudoPrams) {
          var breakpoints = sudoPrams[attr];
          for (var device in breakpoints) {
            var attrValue = breakpoints[device];
            if (reponsiveCssGroups[device] == undefined) {
              reponsiveCssGroups[device] = [];
            }
            if (reponsiveCssGroups[device] == undefined) {
              reponsiveCssGroups[device] = [];
            }
            if (reponsiveCssGroups[device][selectorHandl] == undefined) {
              reponsiveCssGroups[device][selectorHandl] = [];
            }
            if (typeof attrValue == "string") {
              attrValue = attrValue.replaceAll("u0022", '"');
              attr = cssAttrParse(attr);
              reponsiveCssGroups[device][selectorHandl][attr] = attrValue;
            }
          }
        }
      }
    }
    var reponsiveCssDesktop = "";
    if (reponsiveCssGroups["Desktop"] != undefined) {
      for (var selector in reponsiveCssGroups["Desktop"]) {
        var attrs = reponsiveCssGroups["Desktop"][selector];
        reponsiveCssDesktop += selector + "{";
        for (var attrName in attrs) {
          var attrValue = attrs[attrName];
          // var attrName = attr.attr;
          // var attrValue = attr.val;
          reponsiveCssDesktop += attrName + ":" + attrValue + ";";
        }
        reponsiveCssDesktop += "}";
      }
    }
    var reponsiveCssTablet = "";
    if (reponsiveCssGroups["Tablet"] != undefined) {
      reponsiveCssTablet += "@media(max-width: 991px){";
      for (var selector in reponsiveCssGroups["Tablet"]) {
        var attrs = reponsiveCssGroups["Tablet"][selector];
        reponsiveCssTablet += selector + "{";
        for (var index in attrs) {
          var attr = attrs[index];
          var attrName = attr.attr;
          var attrValue = attr.val;
          reponsiveCssTablet += attrName + ":" + attrValue + ";";
        }
        reponsiveCssTablet += "}";
      }
      reponsiveCssTablet += "}";
    }
    var reponsiveCssMobile = "";
    if (reponsiveCssGroups["Mobile"] != undefined) {
      reponsiveCssMobile += "@media(max-width:767px){";
      for (var selector in reponsiveCssGroups["Mobile"]) {
        var attrs = reponsiveCssGroups["Mobile"][selector];
        reponsiveCssMobile += selector + "{";
        for (var index in attrs) {
          var attr = attrs[index];
          var attrName = attr.attr;
          var attrValue = attr.val;
          reponsiveCssMobile += attrName + ":" + attrValue + ";";
        }
        reponsiveCssMobile += "}";
      }
      reponsiveCssMobile += "}";
    }
    var reponsiveCss = reponsiveCssDesktop + reponsiveCssTablet + reponsiveCssMobile;
    return reponsiveCss;
  }
  return;
}
class GenerateCss extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      onGenerateCss,
      styleObj,
      reponsiveCss
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(Html, {
      onGenerateCss: onGenerateCss,
      styleObj: styleObj,
      reponsiveCss: reponsiveCss,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (GenerateCss);

/***/ }),

/***/ "./src/components/Builder/help.js":
/*!****************************************!*\
  !*** ./src/components/Builder/help.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
const {
  Component,
  useState,
  useEffect
} = wp.element;


function Html(props) {
  if (!props.warn) {
    return null;
  }
  var [help, sethelp] = useState(props.help);
  useEffect(() => {
    sethelp(props.help);
  }, [props.help]);
  var helpPrams = {
    createPostGrid: {
      title: "How to create WCPS",
      content: `, 
`,
      video: "",
      docsUrl: "#"
    },
    useShortcodes: {
      title: "How to create WCPS",
      content: ` 
`,
      video: "",
      docsUrl: "#"
    },
    urlHash: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    addPostQuery: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    lazyloadSetting: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    autoembedSetting: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    shortcodesSetting: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    wpautopSetting: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    schemaSetting: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    toggleTextSetting: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    expandCollapseSetting: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    enableSearchSetting: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    statsSetting: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    scrollToTopSetting: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    animationSetting: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    },
    templatesHelp: {
      title: "",
      content: ``,
      video: "",
      docsUrl: ""
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
    className: `${help.enable ? "" : "hidden"} z-[99999] top-0 left-0 fixed w-full h-full bg-slate-600 bg-opacity-90   `,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
      className: " bg-white my-[100px] p-5 relative w-[800px] h-[600px] overflow-y-scroll mx-auto rounded-md overflow-hidden",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
        className: "cursor-pointer px-2 py-1 bg-red-500 hover:bg-red-700 hover:text-white absolute top-0 right-0",
        onClick: ev => {
          var helpX = {
            ...help
          };
          helpX.enable = false;
          sethelp(helpX);
        },
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_1__["default"], {
          fill: "#fff",
          icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_2__["default"]
        })
      }), !helpPrams[help?.id]?.video && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
        children: "Coming Soon"
      }), helpPrams[help?.id]?.video && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
          className: "flex items-center  gap-2 align-middle"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
          className: "my-4 text-base",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("iframe", {
            width: "100%",
            height: "450",
            src: `https://www.youtube.com/embed/${helpPrams[help?.id]?.video}`,
            title: "YouTube video player",
            frameborder: "0",
            allow: "accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share",
            referrerpolicy: "strict-origin-when-cross-origin",
            allowfullscreen: true
          })
        })]
      })]
    })
  });
}
class Help extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      help
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Html, {
      help: help,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Help);

/***/ }),

/***/ "./src/components/Builder/index.js":
/*!*****************************************!*\
  !*** ./src/components/Builder/index.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/cog.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/columns.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/brush.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/category.js");
/* harmony import */ var _dropdown__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _input_select__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../input-select */ "./src/components/input-select/index.js");
/* harmony import */ var _input_text__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../input-text */ "./src/components/input-text/index.js");
/* harmony import */ var _components_BuilderView__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../components/BuilderView */ "./src/components/BuilderView/index.js");
/* harmony import */ var _components_BuilderWelcome__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../components/BuilderWelcome */ "./src/components/BuilderWelcome/index.js");
/* harmony import */ var _components_tabs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../components/tabs */ "./src/components/tabs/index.js");
/* harmony import */ var _components_tab__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../components/tab */ "./src/components/tab/index.js");
/* harmony import */ var _wcps_list__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./wcps-list */ "./src/components/Builder/wcps-list.js");
/* harmony import */ var _generate_css__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./generate-css */ "./src/components/Builder/generate-css.js");
/* harmony import */ var _help__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./help */ "./src/components/Builder/help.js");
/* harmony import */ var _notify__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./notify */ "./src/components/Builder/notify.js");
/* harmony import */ var _templates__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./templates */ "./src/components/Builder/templates.js");
/* harmony import */ var _default_data_carousel__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./default-data-carousel */ "./src/components/Builder/default-data-carousel.js");
/* harmony import */ var _default_data_fliterable__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./default-data-fliterable */ "./src/components/Builder/default-data-fliterable.js");
/* harmony import */ var _default_data_grid__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./default-data-grid */ "./src/components/Builder/default-data-grid.js");
/* harmony import */ var _default_data_masonry__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./default-data-masonry */ "./src/components/Builder/default-data-masonry.js");
/* harmony import */ var _edit_grid__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./edit-grid */ "./src/components/Builder/edit-grid.js");
/* harmony import */ var _edit_filterable__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./edit-filterable */ "./src/components/Builder/edit-filterable.js");
/* harmony import */ var _edit_masonry__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./edit-masonry */ "./src/components/Builder/edit-masonry.js");
/* harmony import */ var _edit_carousel__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./edit-carousel */ "./src/components/Builder/edit-carousel.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__);
const {
  Component,
  useState,
  useEffect
} = wp.element;

























var myStore = wp.data.select('PostGridStore');
function Html(props) {
  var _optionData$user_role, _optionData$font_aw_v, _optionData$wcps_prev, _optionData$license_k;
  if (!props.warn) {
    return null;
  }
  var appData = props.appData;
  var [activePostGrid, setactivePostGrid] = useState(null);
  var [postData, setpostData] = useState({
    ID: null,
    post_content: {},
    post_title: ""
  });
  var [PostGridData, setPostGridData] = useState(postData?.post_content);
  var [globalOptions, setglobalOptions] = useState(PostGridData.globalOptions);
  var [isLoading, setisLoading] = useState(false);
  var [pleaseUpdate, setpleaseUpdate] = useState(false);
  const [optionData, setoptionData] = useState({});
  const [roles, setroles] = useState([]);
  var [needSave, setneedSave] = useState(false);
  var [toggleSettings, settoggleSettings] = useState(false);
  var [listQueryPrams, setlistQueryPrams] = useState({
    page: 1,
    search: ""
  }); // Using the hook.

  var [styleObj, setstyleObj] = useState({});
  var [notifications, setnotifications] = useState([]);
  var [help, sethelp] = useState({
    id: "",
    enable: false
  });
  var [customerData, setcustomerData] = useState({
    id: "",
    isPro: false
  });
  var [isProFeature, setisProFeature] = useState(true);
  var viewTypeArgs = {
    viewGrid: {
      label: "Grid",
      value: "viewGrid"
    },
    viewSlider: {
      label: "Slider/Carousel",
      value: "viewSlider"
    },
    viewFilterable: {
      label: "Filterable",
      value: "viewFilterable"
      //isPro: true
    },
    viewMasonry: {
      label: "Masonry",
      value: "viewMasonry"
      // isPro: true
    }
    // viewTimeline: {
    // 	label: "Post Timeline",
    // 	value: "viewTimeline",
    // 	// isPro: true
    // },
    // viewTicker: {
    // 	label: "Post Ticker",
    // 	value: "viewTicker",
    // 	// isPro: true
    // },
  };
  function onChangeStyleObj(styleObjPrams) {
    setstyleObj(styleObjPrams);
  }
  useEffect(() => {}, [styleObj]);
  function escapeHTML(str) {
    const map = {
      "&": "&amp;",
      "<": "&lt;",
      ">": "&gt;",
      '"': "&quot;",
      "'": "&#039;"
    };
    return str.replace(/[&<>"']/g, function (match) {
      return map[match];
    });
  }
  useEffect(() => {
    setPostGridData(postData.post_content);
  }, [postData]);
  useEffect(() => {
    if (globalOptions?.viewType == "viewGrid") {
      setpostData({
        ...postData,
        post_content: _default_data_grid__WEBPACK_IMPORTED_MODULE_17__["default"]
      });
    }
    if (globalOptions?.viewType == "viewSlider") {
      setpostData({
        ...postData,
        post_content: _default_data_carousel__WEBPACK_IMPORTED_MODULE_15__["default"]
      });
    }
    if (globalOptions?.viewType == "viewMasonry") {
      setpostData({
        ...postData,
        post_content: _default_data_masonry__WEBPACK_IMPORTED_MODULE_18__["default"]
      });
    }
    if (globalOptions?.viewType == "viewFilterable") {
      setpostData({
        ...postData,
        post_content: _default_data_fliterable__WEBPACK_IMPORTED_MODULE_16__["default"]
      });
    }
  }, [globalOptions]);
  useEffect(() => {
    setisLoading(true);
    if (activePostGrid == null) return;
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
      path: "/wcps/v2/wcps_data",
      method: "POST",
      data: {
        postId: activePostGrid,
        _wpnonce: wcps_builder_js._wpnonce
      }
    }).then(res => {
      setisLoading(false);
      if (res.post_content == null) {
        res.post_content = _default_data_grid__WEBPACK_IMPORTED_MODULE_17__["default"];
      }
      setpostData(res);
    });
  }, [activePostGrid]);
  useEffect(() => {
    setnotifications(notifications);
    const timer = setTimeout(() => {
      setnotifications([]); // Update the debounced value after delay
    }, 5000); // 300ms debounce delay

    return () => clearTimeout(timer); // Cleanup timer on value change or unmount
  }, [notifications]);
  useEffect(() => {
    if (customerData.isPro) {
      setisProFeature(false);
    }
  }, [customerData]);
  function handleAlertConfirmation() {
    if (confirm("Are you sure you want to reset the option data?")) {
      resetOptionData();
    }
  }
  function resetOptionData() {
    setoptionData(optionDataDefault);
  }
  function addNotifications(notification) {
    var notificationsX = [...notifications];
    notificationsX.push(notification);
    setnotifications(notificationsX);
  }
  function setHelp(helpX) {
    sethelp(helpX);
  }
  function selectPostGrid(args) {
    setactivePostGrid(args);
  }
  function onChangePostGrid(args) {
    var postDataX = {
      ...postData
    };
    postDataX.post_content = args;
    setpostData(postDataX);
    setPostGridData(args);
    setpleaseUpdate(true);
  }
  function onApplyTemplate(args) {
    console.log(args);
    var postDataX = {
      ...postData
    };
    postDataX.post_content = args;
    setpostData(postDataX);
    setPostGridData(args);
    setpleaseUpdate(true);
  }
  function updateOption() {
    setisLoading(true);
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
      path: "/wcps/v2/update_options",
      method: "POST",
      data: {
        name: "wcps_settings",
        value: optionData
      }
    }).then(res => {
      setisLoading(false);
      if (res.status) {
        setneedSave(false);
        addNotifications({
          title: "Data Saved!",
          content: "You change successfully saved!.",
          type: "success"
        });
      }
    });
  }
  function onSavePostGrid() {
    setisLoading(true);
    var content = PostGridData;
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
      path: "/wcps/v2/update_post_data",
      method: "POST",
      data: {
        postId: activePostGrid,
        content: content,
        _wpnonce: wcps_builder_js._wpnonce
      }
    }).then(res => {
      setisLoading(false);
      setpleaseUpdate(false);
      addNotifications({
        title: "Data Saved!",
        content: "You change successfully saved!.",
        type: "success"
      });
    });
  }
  useEffect(() => {
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
      path: "/wcps/v2/user_roles_list",
      method: "POST",
      data: {}
    }).then(res => {
      var rolesX = [];
      Object.entries(res?.roles).map(role => {
        var index = role[0];
        var val = role[1];
        rolesX.push({
          label: val,
          value: index
        });
      });
      setroles(rolesX);
    });
  }, []);
  useEffect(() => {
    setisLoading(true);
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0___default()({
      path: "/wcps/v2/get_options",
      method: "POST",
      data: {
        option: "wcps_settings"
      }
    }).then(res => {
      if (res.length != 0) {
        var resX = {
          ...res
        };
        if (resX?.license_key?.length > 0) {
          setcustomerData({
            ...customerData,
            isPro: true
          });
        }
        setoptionData(resX);
      }
      setisLoading(false);
    });
  }, []);
  function onGenerateCss(css) {
    if (css.length == 0) return;
    var PostGridDataX = {
      ...PostGridData
    };
    PostGridDataX.reponsiveCss = escapeHTML(css);
    setPostGridData(PostGridDataX);
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
    className: "pg-setting-input-text pg-dashboard",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
      className: "flex",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
        className: "basis-[380px] w-[380px] h-screen overflow-y-scroll light-scrollbar flex-shrink-0",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
          className: "flex items-center justify-between bg-blue-700 py-3 px-3",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
              className: "flex items-center align-middle gap-3",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
                className: "text-xl text-white",
                children: "WCPS Builder"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
                className: "text-xs text-white flex items-center gap-2"
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
              className: "text-sm text-white",
              children: "By PickPlugins"
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
              className: `py-1 px-2 cursor-pointer  capitalize  text-white font-medium rounded hover:bg-gray-700 focus:outline-none focus:bg-gray-700 ${toggleSettings ? "bg-gray-800" : "bg-gray-500"}`,
              onClick: ev => {
                settoggleSettings(!toggleSettings);
              },
              children: [isLoading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.Spinner, {}), !isLoading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.Fragment, {
                children: [toggleSettings && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"], {
                  fill: "#fff",
                  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_25__["default"]
                }), !toggleSettings && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_24__["default"], {
                  fill: "#fff",
                  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_26__["default"]
                })]
              })]
            })
          })]
        }), toggleSettings && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.Fragment, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
            className: "relative bg-white",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
              className: "px-4 py-2 bg-slate-400 text-white  ",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
                className: "text-xl text-white mb-4",
                children: "WCPS Settings"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
                className: "flex gap-2 items-center",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
                  className: "bg-amber-500 rounded-sm text-md p-2 px-4 cursor-pointer pg-font text-white ",
                  onClick: ev => {
                    handleAlertConfirmation();
                  },
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Reset", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
                  className: "bg-green-700 rounded-sm text-md p-2 px-4 cursor-pointer pg-font text-white flex items-center",
                  onClick: ev => {
                    updateOption();
                  },
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("span", {
                    children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Save", "woocommerce-products-slider")
                  }), needSave && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("span", {
                    className: "w-5 inline-block h-5 ml-3 rounded-xl text-center bg-red-500",
                    children: "!"
                  })]
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
              className: "p-3",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
                className: "my-5",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("label", {
                  className: " text-base",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Allow access by roles", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_input_select__WEBPACK_IMPORTED_MODULE_4__["default"], {
                  val: (_optionData$user_role = optionData?.user_roles) !== null && _optionData$user_role !== void 0 ? _optionData$user_role : [],
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[250px]",
                  options: roles,
                  onChange: newVal => {
                    var optionsX = {
                      ...optionData,
                      user_roles: newVal
                    };
                    setoptionData(optionsX);
                  },
                  multiple: true
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
                className: "my-5",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("label", {
                  className: "text-base",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Font-awesome version", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_input_select__WEBPACK_IMPORTED_MODULE_4__["default"], {
                  val: (_optionData$font_aw_v = optionData?.font_aw_version) !== null && _optionData$font_aw_v !== void 0 ? _optionData$font_aw_v : "none",
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[250px]",
                  options: [{
                    label: "None",
                    value: "none"
                  }, {
                    label: "Version 4+",
                    value: "v_4"
                  }, {
                    label: "Version 5+",
                    value: "v_5"
                  }],
                  onChange: newVal => {
                    var optionsX = {
                      ...optionData,
                      font_aw_version: newVal
                    };
                    setoptionData(optionsX);
                  },
                  multiple: false
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
                className: "my-5",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("label", {
                  className: "text-base",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Enable WCPS preview", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_input_select__WEBPACK_IMPORTED_MODULE_4__["default"], {
                  val: (_optionData$wcps_prev = optionData?.wcps_preview) !== null && _optionData$wcps_prev !== void 0 ? _optionData$wcps_prev : "no",
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[250px]",
                  options: [{
                    label: "No",
                    value: "no"
                  }, {
                    label: "Yes",
                    value: "yes"
                  }],
                  onChange: newVal => {
                    var optionsX = {
                      ...optionData,
                      wcps_preview: newVal
                    };
                    setoptionData(optionsX);
                  },
                  multiple: false
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
                className: "my-5",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
                  className: "text-base",
                  htmlFor: "",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("License Key", "woocommerce-products-slider")
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_5__["default"], {
                  label: "",
                  className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[250px]",
                  value: (_optionData$license_k = optionData?.license_key) !== null && _optionData$license_k !== void 0 ? _optionData$license_k : "",
                  onChange: newVal => {
                    var optionsX = {
                      ...optionData,
                      license_key: newVal
                    };
                    setoptionData(optionsX);
                  }
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
                className: "my-3 flex gap-2"
              })]
            })]
          })
        }), !toggleSettings && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.Fragment, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(_components_tabs__WEBPACK_IMPORTED_MODULE_8__["default"], {
            activeTab: "woocommerce-products-slider",
            orientation: "",
            stickyNavs: true,
            contentClass: " bg-white w-full",
            navItemsWrapClass: "justify-center  ",
            navItemClass: "bg-gray-200 justify-center px-5 py-3 gap-2 grow ",
            navItemLabelClass: "flex-col ",
            navItemSelectedClass: "!bg-white",
            activeClass: "active-tab",
            onSelect: tabName => {},
            tabs: [{
              name: "woocommerce-products-slider",
              title: "WCPS",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_27__["default"],
              className: "tab-disable-blocks"
            }, {
              name: "edit",
              title: "Edit",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_28__["default"],
              className: "tab-disable-blocks"
            }, {
              name: "templates",
              title: "Templates",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_29__["default"],
              className: "tab-disable-blocks"
            }],
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_components_tab__WEBPACK_IMPORTED_MODULE_9__["default"], {
              name: "woocommerce-products-slider",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
                className: "relative p-3",
                children: [postData?.post_content == null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
                  className: "p-3 my-5 bg-orange-400",
                  children: "Please choose an WCPS first."
                }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_wcps_list__WEBPACK_IMPORTED_MODULE_10__["default"], {
                  addNotifications: addNotifications,
                  selectPostGrid: selectPostGrid,
                  activePostGrid: activePostGrid,
                  setHelp: setHelp,
                  listQueryPrams: listQueryPrams,
                  setlistQueryPrams: setlistQueryPrams
                })]
              })
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(_components_tab__WEBPACK_IMPORTED_MODULE_9__["default"], {
              name: "edit",
              children: [postData?.ID == null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
                className: "py-3",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
                  className: "my-3 bg-orange-400 p-3  text-white  text-center animate__animated animate__flash animate__repeat-2",
                  children: "Please select post from list."
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
                className: " ",
                children: postData?.ID != null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.Fragment, {
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
                    className: "my-4 p-3",
                    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.PanelRow, {
                      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("label", {
                        htmlFor: "",
                        children: "View Type?"
                      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_dropdown__WEBPACK_IMPORTED_MODULE_3__["default"], {
                        position: "bottom right",
                        variant: "secondary",
                        buttonTitle: postData?.post_content?.globalOptions?.viewType ? viewTypeArgs[postData?.post_content?.globalOptions?.viewType]?.label : "Choose",
                        options: viewTypeArgs,
                        onChange: (option, index) => {
                          if (confirm("Data will reset, Please confirm?")) {
                            if (option.value == "viewGrid") {
                              setpostData({
                                ...postData,
                                post_content: _default_data_grid__WEBPACK_IMPORTED_MODULE_17__["default"]
                              });
                            }
                            if (option.value == "viewSlider") {
                              setpostData({
                                ...postData,
                                post_content: _default_data_carousel__WEBPACK_IMPORTED_MODULE_15__["default"]
                              });
                            }
                            if (option.value == "viewFilterable") {
                              setpostData({
                                ...postData,
                                post_content: _default_data_fliterable__WEBPACK_IMPORTED_MODULE_16__["default"]
                              });
                            }
                            if (option.value == "viewMasonry") {
                              setpostData({
                                ...postData,
                                post_content: _default_data_masonry__WEBPACK_IMPORTED_MODULE_18__["default"]
                              });
                            }
                          }
                        },
                        values: ""
                      })]
                    })
                  }), postData.post_content.globalOptions?.viewType == "viewGrid" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_edit_grid__WEBPACK_IMPORTED_MODULE_19__["default"], {
                    onChange: onChangePostGrid,
                    addNotifications: addNotifications,
                    postData: postData,
                    customerData: customerData,
                    setHelp: setHelp,
                    onChangeStyleObj: onChangeStyleObj
                  }), postData.post_content.globalOptions?.viewType == "viewSlider" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_edit_carousel__WEBPACK_IMPORTED_MODULE_22__["default"], {
                    onChange: onChangePostGrid,
                    addNotifications: addNotifications,
                    postData: postData,
                    customerData: customerData,
                    setHelp: setHelp,
                    onChangeStyleObj: onChangeStyleObj,
                    onApplyTemplate: onApplyTemplate
                  }), postData.post_content.globalOptions?.viewType == "viewMasonry" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_edit_masonry__WEBPACK_IMPORTED_MODULE_21__["default"], {
                    onChange: onChangePostGrid,
                    addNotifications: addNotifications,
                    postData: postData,
                    customerData: customerData,
                    setHelp: setHelp,
                    onChangeStyleObj: onChangeStyleObj
                  }), postData.post_content.globalOptions?.viewType == "viewFilterable" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_edit_filterable__WEBPACK_IMPORTED_MODULE_20__["default"], {
                    onChange: onChangePostGrid,
                    addNotifications: addNotifications,
                    postData: postData,
                    customerData: customerData,
                    setHelp: setHelp,
                    onChangeStyleObj: onChangeStyleObj
                  })]
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)(_components_tab__WEBPACK_IMPORTED_MODULE_9__["default"], {
              name: "templates",
              children: [postData?.ID == null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
                className: "py-3",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
                  className: "my-3 bg-orange-400 p-3  text-white  text-center animate__animated animate__flash animate__repeat-2",
                  children: "Please select post from list."
                })
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_templates__WEBPACK_IMPORTED_MODULE_14__["default"], {
                onChange: onChangePostGrid,
                onApplyTemplate: onApplyTemplate,
                addNotifications: addNotifications,
                postData: postData,
                customerData: customerData,
                setHelp: setHelp
              })]
            })]
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
        className: "w-full  top-0 overflow-y-scroll",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
          className: "  relative",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
            className: "my-3 hidden bg-orange-400 p-3 ml-5 text-white  text-center animate__animated animate__flash animate__repeat-2",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsxs)("div", {
              className: "text-xl",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("i", {
                class: "fa-solid fa-triangle-exclamation"
              }), " Please test the WCPS Builder and", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("span", {
                className: "font-bold cursor-pointer underline",
                onClick: ev => {
                  settoggleSettings(!toggleSettings);
                },
                children: "send us feedbacks."
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)("div", {
              children: "Please do not use for old WCPS, we will add migration later."
            })]
          }), (postData?.ID == null || toggleSettings) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_components_BuilderWelcome__WEBPACK_IMPORTED_MODULE_7__["default"], {
            appData: appData,
            addNotifications: addNotifications,
            customerData: customerData
          }), !toggleSettings && postData?.ID != null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_components_BuilderView__WEBPACK_IMPORTED_MODULE_6__["default"], {
            pleaseUpdate: pleaseUpdate,
            onSavePostGrid: onSavePostGrid,
            isLoading: isLoading,
            onChangePostGrid: onChangePostGrid,
            postData: postData,
            id: activePostGrid,
            settoggleSettings: settoggleSettings,
            customerData: customerData,
            addNotifications: addNotifications,
            setHelp: setHelp
          })]
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_notify__WEBPACK_IMPORTED_MODULE_13__["default"], {
      notifications: notifications
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_help__WEBPACK_IMPORTED_MODULE_12__["default"], {
      help: help
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(_generate_css__WEBPACK_IMPORTED_MODULE_11__["default"], {
      styleObj: styleObj,
      onGenerateCss: onGenerateCss,
      reponsiveCss: PostGridData.reponsiveCss
    })]
  });
}
class Builder extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      onChange,
      appData
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_23__.jsx)(Html, {
      appData: appData,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Builder);

/***/ }),

/***/ "./src/components/Builder/layouts.js":
/*!*******************************************!*\
  !*** ./src/components/Builder/layouts.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/help.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-sortablejs */ "./node_modules/react-sortablejs/dist/index.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_sortablejs__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _splidejs_react_splide__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @splidejs/react-splide */ "./node_modules/@splidejs/react-splide/dist/js/react-splide.esm.js");
/* harmony import */ var _input_text__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../input-text */ "./src/components/input-text/index.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;










var myStore = wp.data.select("PostGridStore");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var addNotifications = props.addNotifications;
  if (!props?.postData?.post_content?.globalOptions?.viewType) {
    addNotifications({
      title: "Opps item missing",
      content: "Please select post first.",
      type: "error"
    });
    return null;
  }
  var onChangeLayouts = props.onChangeLayouts;
  var setHelp = props.setHelp;
  var [postData, setpostData] = useState(props.postData);
  var [PostGridData, setPostGridData] = useState(postData.post_content);
  var [isLoading, setisLoading] = useState(false);
  var [isProFeature, setisProFeature] = useState(true);
  var [customerData, setcustomerData] = useState(props.customerData);
  var postId = postData.ID;
  var [templates, settemplates] = useState([]);
  const [queryLayouts, setqueryLayouts] = useState({
    keyword: "",
    price: "",
    viewType: postData.post_content.globalOptions.viewType == undefined ? "viewGrid" : postData.post_content.globalOptions.viewType,
    page: 1
  });
  useEffect(() => {
    if (customerData.isPro) {
      setisProFeature(false);
    }
  }, [props.customerData]);
  useEffect(() => {
    setisLoading(true);
    var requestData = {
      keyword: queryLayouts.keyword,
      page: queryLayouts.page,
      price: queryLayouts.price,
      viewType: queryLayouts.viewType
    };
    requestData = JSON.stringify(requestData);
    fetch("https://demo.pickplugins.com/woocommerce-products-slider/wp-json/wcps/v2/get_posts_wcps",
    // "http://localhost/wp/wp-json/wcps/v2/get_posts_wcps",
    {
      method: "POST",
      headers: {
        "Content-Type": "application/json;charset=utf-8"
      },
      body: requestData
    }).then(response => {
      if (response.ok && response.status < 400) {
        response.json().then(data => {
          var posts = data?.posts;
          var postsX = [];
          posts.map(item => {
            postsX.push({
              label: item.post_title,
              thumb: item.thumb,
              isPro: item?.is_pro == "yes" ? true : false,
              data: item.post_content
            });
            settemplates(postsX);
          });
          setisLoading(false);
        });
      }
    }).catch(_error => {
      //this.saveAsStatus = 'error';
      // handle the error
    });
  }, []);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
    className: "max-h-screen overflow-y-scroll",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
      className: "p-3",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("p", {
        className: "flex items-center gap-2",
        children: ["How layouts work.", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("span", {
          className: "cursor-pointer",
          title: "Click to know more",
          onClick: () => {
            setHelp({
              id: "templatesHelp",
              enable: true
            });
          },
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_9__["default"], {
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_10__["default"]
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
        className: "my-4  items-center hidden gap-3",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_6__["default"], {
          value: queryLayouts.keyword,
          placeholder: "Search...",
          className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[200px]",
          onChange: newVal => {
            var queryLayoutsX = {
              ...queryLayouts
            };
            queryLayoutsX.keyword = newVal;
            setqueryLayouts(queryLayoutsX);
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.SelectControl, {
          label: "",
          value: queryLayouts.price,
          options: [{
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Free/Pro", "woocommerce-products-slider"),
            value: ""
          }, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Free", "woocommerce-products-slider"),
            value: "free"
          }, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Pro", "woocommerce-products-slider"),
            value: "pro"
          }],
          onChange: newVal => {
            var queryLayoutsX = {
              ...queryLayouts
            };
            queryLayoutsX.keyword = newVal;
            setqueryLayouts(queryLayoutsX);
          }
        })]
      }), isLoading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
        className: "text-center py-3",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Spinner, {})
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.Fragment, {
        children: templates.map((preset, index) => {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
            className: "my-5 bg-slate-400 hover:bg-slate-500 p-3 rounded-sm cursor-pointer",
            title: "Click To Apply",
            onClick: ev => {
              if (preset.isPro) {
                if (isProFeature) {
                  addNotifications({
                    title: "Opps its pro!",
                    content: "This feature only avilable in premium version",
                    type: "error"
                  });
                  return;
                }
              }
              addNotifications({
                title: "Preset Applied",
                content: "WOW, Your WCPS just got new look!",
                type: "success"
              });
              var presetData = preset.data;
              presetData = JSON.parse(presetData);
              var presetId = presetData.postId;
              var loopLayout = presetData.loopLayout == undefined ? [] : presetData.loopLayout;
              var nthItemStyle = presetData.nthItemStyle == undefined ? [] : presetData.nthItemStyle;
              onChangeLayouts(loopLayout);
              addNotifications({
                title: "Layout Applied",
                content: "WOW, Your WCPS just got new look!",
                type: "success"
              });
            },
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("img", {
              className: "w-full",
              src: preset.thumb,
              alt: ""
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
              className: "mt-3 flex justify-between  items-center",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("span", {
                className: "text-lg  text-white ",
                children: preset.label
              }), preset.isPro && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.Fragment, {
                children: isProFeature && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("span", {
                  className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white ",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Pro", "woocommerce-products-slider")
                })
              })]
            })]
          }, index);
        })
      })]
    })
  });
}
class Layouts extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      postData,
      onChangeLayouts,
      customerData,
      addNotifications,
      setHelp
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(Html, {
      postData: postData,
      onChangeLayouts: onChangeLayouts,
      customerData: customerData,
      addNotifications: addNotifications,
      setHelp: setHelp,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Layouts);

/***/ }),

/***/ "./src/components/Builder/notify.js":
/*!******************************************!*\
  !*** ./src/components/Builder/notify.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/check.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
const {
  Component,
  useState,
  useEffect
} = wp.element;


function Html(props) {
  if (!props.warn) {
    return null;
  }
  var [notifications, setnotifications] = useState(props.notifications);
  useEffect(() => {
    var slicedArray = props.notifications.slice(-1);
    setnotifications(slicedArray);
    //setnotifications(props.notifications)
  }, [props.notifications]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
    className: `${notifications.length > 0 ? "" : "hidden"} fixed right-6 bottom-6 z-50 `,
    children: notifications?.map((item, index) => {
      var type = item.type;
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: `max-w-72 min-w-64 mb-2 animate__animated animate__backInRight overflow-hidden relative rounded-sm shadow-md bg-white p-3 border-l-4 border-0 ${type == 'success' ? "   border-l-green-700 border-solid " : ""} ${type == 'error' ? "   border-l-red-700 border-solid" : ""} ${type == 'warnning' ? "  border-l-yellow-500 border-solid" : ""}`,
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
          className: "cursor-pointer px-1 bg-red-500 hover:bg-red-700 hover:text-white absolute top-0 right-0",
          onClick: ev => {
            var notificationsX = [...notifications];
            notificationsX.splice(index, 1);
            setnotifications(notificationsX);
          },
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_1__["default"], {
            fill: "#fff",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_2__["default"]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
          className: "flex items-center gap-3 ",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
            children: [type == "warnning" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_1__["default"], {
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_2__["default"]
            }), type == "error" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_1__["default"], {
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_2__["default"]
            }), type == "success" && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_1__["default"], {
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_3__["default"]
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
            className: "text-base mb-2",
            children: item?.title
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
          className: "text-xs",
          children: item?.content
        })]
      }, index);
    })
  });
}
class Notify extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      notifications
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Html, {
      notifications: notifications,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Notify);

/***/ }),

/***/ "./src/components/Builder/pagination-types.js":
/*!****************************************************!*\
  !*** ./src/components/Builder/pagination-types.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   paginationTypes: () => (/* binding */ paginationTypes)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);

const paginationTypes = {
  none: {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("None", "woocommerce-products-slider"),
    value: "none"
  },
  normal: {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Normal Pagination", "woocommerce-products-slider"),
    value: "normal"
  },
  ajax: {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Ajax Pagination", "woocommerce-products-slider"),
    value: "ajax",
    isPro: true
  },
  next_previous: {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Next-Previous", "woocommerce-products-slider"),
    value: "next_previous",
    isPro: true
  },
  loadmore: {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Load More", "woocommerce-products-slider"),
    value: "loadmore",
    isPro: true
  },
  infinite: {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)("Infinite Load", "woocommerce-products-slider"),
    value: "infinite",
    isPro: true
  }
  // filterable: {
  // 	label: __("Filterable", "woocommerce-products-slider"),
  // 	value: "filterable"
  // },
};

/***/ }),

/***/ "./src/components/Builder/templates.js":
/*!*********************************************!*\
  !*** ./src/components/Builder/templates.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/help.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-sortablejs */ "./node_modules/react-sortablejs/dist/index.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_sortablejs__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _splidejs_react_splide__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @splidejs/react-splide */ "./node_modules/@splidejs/react-splide/dist/js/react-splide.esm.js");
/* harmony import */ var _input_text__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../input-text */ "./src/components/input-text/index.js");
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;










var myStore = wp.data.select("PostGridStore");
function Html(props) {
  if (!props.warn) {
    return null;
  }
  var addNotifications = props.addNotifications;
  if (!props?.postData?.post_content?.globalOptions?.viewType) {
    addNotifications({
      title: "Opps item missing",
      content: "Please select post first.",
      type: "error"
    });
    return null;
  }
  var onApplyTemplate = props.onApplyTemplate;
  var setHelp = props.setHelp;
  var [postData, setpostData] = useState(props.postData);
  var [PostGridData, setPostGridData] = useState(postData.post_content);
  var [isLoading, setisLoading] = useState(false);
  var [isProFeature, setisProFeature] = useState(true);
  var [customerData, setcustomerData] = useState(props.customerData);
  var postId = postData.ID;
  var [templates, settemplates] = useState([]);
  const [queryLayouts, setqueryLayouts] = useState({
    keyword: "",
    price: "",
    viewType: postData?.post_content?.globalOptions?.viewType == undefined ? "" : postData?.post_content?.globalOptions?.viewType,
    page: 1
  });
  useEffect(() => {
    if (customerData.isPro) {
      setisProFeature(false);
    }
  }, [props.customerData]);
  useEffect(() => {
    setisLoading(true);
    var requestData = {
      keyword: queryLayouts.keyword,
      page: queryLayouts.page,
      price: queryLayouts.price,
      viewType: queryLayouts.viewType
    };
    requestData = JSON.stringify(requestData);
    console.log(requestData);
    fetch("https://demo.pickplugins.com/woocommerce-products-slider/wp-json/wcps/v2/get_posts_wcps",
    // "http://localhost/wp/wp-json/wcps/v2/get_posts_wcps",
    {
      method: "POST",
      headers: {
        "Content-Type": "application/json;charset=utf-8"
      },
      body: requestData
    }).then(response => {
      if (response.ok && response.status < 400) {
        response.json().then(data => {
          var posts = data?.posts;
          console.log(posts);
          var postsX = [];
          posts.map(item => {
            postsX.push({
              label: item.post_title,
              thumb: item.thumb,
              isPro: item?.is_pro == "yes" ? true : false,
              data: item.post_content
            });
            settemplates(postsX);
          });
          setisLoading(false);
        });
      }
    }).catch(_error => {
      //this.saveAsStatus = 'error';
      // handle the error
    });
  }, []);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
    className: "max-h-screen overflow-y-scroll",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
      className: "p-3",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("p", {
        className: "flex items-center gap-2",
        children: ["How templates work.", /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("span", {
          className: "cursor-pointer",
          title: "Click to know more",
          onClick: () => {
            setHelp({
              id: "templatesHelp",
              enable: true
            });
          },
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_9__["default"], {
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_10__["default"]
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
        className: "my-4  items-center hidden gap-3",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_6__["default"], {
          value: queryLayouts.keyword,
          placeholder: "Search...",
          className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[200px]",
          onChange: newVal => {
            var queryLayoutsX = {
              ...queryLayouts
            };
            queryLayoutsX.keyword = newVal;
            setqueryLayouts(queryLayoutsX);
          }
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.SelectControl, {
          label: "",
          value: queryLayouts.price,
          options: [{
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Free/Pro", "woocommerce-products-slider"),
            value: ""
          }, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Free", "woocommerce-products-slider"),
            value: "free"
          }, {
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Pro", "woocommerce-products-slider"),
            value: "pro"
          }],
          onChange: newVal => {
            var queryLayoutsX = {
              ...queryLayouts
            };
            queryLayoutsX.keyword = newVal;
            setqueryLayouts(queryLayoutsX);
          }
        })]
      }), isLoading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
        className: "text-center py-3",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__.Spinner, {})
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.Fragment, {
        children: templates.map((preset, index) => {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
            className: "my-5 bg-slate-400 hover:bg-slate-500 p-3 rounded-sm cursor-pointer",
            title: "Click To Apply",
            onClick: ev => {
              if (preset.isPro) {
                if (isProFeature) {
                  addNotifications({
                    title: "Opps its pro!",
                    content: "This feature only avilable in premium version",
                    type: "error"
                  });
                  return;
                }
              }
              addNotifications({
                title: "Preset Applied",
                content: "WOW, Your WCPS just got new look!",
                type: "success"
              });
              var presetData = preset.data;
              presetData = JSON.parse(presetData);
              var presetId = presetData.postId;
              var presetClean = {};
              Object.entries(presetData).map(item => {
                var itemIndex = item[0];
                var itemArg = item[1];
                if (itemArg.options != undefined) {
                  delete itemArg.options;
                }
                if (PostGridData[itemIndex]) {
                  delete PostGridData[itemIndex]?.styles;
                  delete PostGridData[itemIndex]?.hover;
                  delete PostGridData[itemIndex]?.after;
                  delete PostGridData[itemIndex]?.before;
                  delete PostGridData[itemIndex]?.active;
                  delete PostGridData[itemIndex]?.focus;
                  delete PostGridData[itemIndex]?.target;
                  delete PostGridData[itemIndex]?.visited;
                }
                if (itemIndex == 'loopLayout') {
                  presetClean[itemIndex] = itemArg;
                } else {
                  presetClean[itemIndex] = {
                    ...PostGridData[itemIndex],
                    ...itemArg
                  };
                }
              });
              var PostGridDataX = {
                ...PostGridData,
                ...presetClean
              };

              //	var reponsiveCss = Array.isArray(PostGridDataX.reponsiveCss) ? Object.values(PostGridDataX.reponsiveCss).join("") : PostGridDataX.reponsiveCss;

              var reponsiveCss = Object.values(PostGridDataX.reponsiveCss).join("");
              var reponsiveCss = reponsiveCss.replaceAll(presetId, postId);
              PostGridDataX.reponsiveCss = reponsiveCss;
              if (PostGridDataX.nthItemStyle != undefined) {
                var nthItemStyle = [];
                Object.entries(PostGridDataX.nthItemStyle).map(item => {
                  console.log(item[1]);
                  nthItemStyle.push(item[1]);
                });
                PostGridDataX.nthItemStyle = nthItemStyle;
              }
              onApplyTemplate(PostGridDataX);
              addNotifications({
                title: "Preset Applied",
                content: "WOW, Your WCPS just got new look!",
                type: "success"
              });
            },
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("img", {
              className: "w-full",
              src: preset.thumb,
              alt: ""
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
              className: "mt-3 flex justify-between  items-center",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("span", {
                className: "text-lg  text-white ",
                children: preset.label
              }), preset.isPro && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.Fragment, {
                children: isProFeature && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("span", {
                  className: "bg-amber-500 px-2 py-1  no-underline rounded-sm  cursor-pointer text-white ",
                  children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Pro", "woocommerce-products-slider")
                })
              })]
            })]
          }, index);
        })
      })]
    })
  });
}
class Templates extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      postData,
      onApplyTemplate,
      customerData,
      addNotifications,
      setHelp
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(Html, {
      postData: postData,
      onApplyTemplate: onApplyTemplate,
      customerData: customerData,
      addNotifications: addNotifications,
      setHelp: setHelp,
      warn: this.state.showWarning
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Templates);

/***/ }),

/***/ "./src/components/Builder/wcps-list.js":
/*!*********************************************!*\
  !*** ./src/components/Builder/wcps-list.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react-sortablejs */ "./node_modules/react-sortablejs/dist/index.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_sortablejs__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/api-fetch */ "@wordpress/api-fetch");
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/add-card.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/help.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/check.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/copy-small.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/trash.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/pencil.js");
/* harmony import */ var _input_text__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../input-text */ "./src/components/input-text/index.js");
/* harmony import */ var _dropdown__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _default_data_carousel__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./default-data-carousel */ "./src/components/Builder/default-data-carousel.js");
/* harmony import */ var _default_data_fliterable__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./default-data-fliterable */ "./src/components/Builder/default-data-fliterable.js");
/* harmony import */ var _default_data_grid__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./default-data-grid */ "./src/components/Builder/default-data-grid.js");
/* harmony import */ var _default_data_masonry__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./default-data-masonry */ "./src/components/Builder/default-data-masonry.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__);
const {
  Component,
  RawHTML,
  useState,
  useEffect
} = wp.element;




var myStore = wp.data.select('PostGridStore');







function Html(props) {
  if (!props.warn) {
    return null;
  }
  var isLoaded = props.isLoaded;
  var selectPostGrid = props.selectPostGrid;
  var activePostGrid = props.activePostGrid;
  var addNotifications = props.addNotifications;
  var setHelp = props.setHelp;
  var listQueryPrams = props.listQueryPrams;
  var setlistQueryPrams = props.setlistQueryPrams;
  var [searchPrams, setsearchPrams] = useState(listQueryPrams);
  var [posts, setPosts] = useState(null);
  var [pagination, setPagination] = useState({
    currentPage: listQueryPrams.page
  });
  var [dataLoaded, setdataLoaded] = useState(false);
  var [isLoading, setisLoading] = useState(false);
  var [deleteConfirm, setdeleteConfirm] = useState({
    id: "",
    confirm: false
  });
  var [rename, setrename] = useState({
    id: "",
    confirm: false
  });
  var [addNew, setaddNew] = useState({
    enable: false,
    title: ''
  });
  const copyData = data => {
    navigator.clipboard.writeText(data).then(() => {
      addNotifications({
        title: "Copied to clipboard!",
        content: "Use the shortcode in page or post conent where you want to display.",
        type: "success"
      });
    }).catch(err => {});
  };
  var queryArgs = [{
    "id": "postType",
    "val": ["wcps"]
  }, {
    "id": "postStatus",
    "val": ["publish"]
  }, {
    "id": "s",
    "val": ""
  }, {
    "id": "order",
    "val": "DESC"
  }, {
    "id": "orderby",
    "val": ["date"]
  }, {
    "id": "postsPerPage",
    "val": "20"
  }, {
    "id": "paged",
    "val": "1"
  }];
  var viewTypeArgs = {
    viewGrid: {
      label: "Grid",
      value: "viewGrid"
    },
    viewSlider: {
      label: "Slider/Carousel",
      value: "viewSlider"
    },
    viewFilterable: {
      label: "Filterable",
      value: "viewFilterable"
      //isPro: true
    },
    viewMasonry: {
      label: "Masonry",
      value: "viewMasonry"
      // isPro: true
    }
    // viewTimeline: {
    // 	label: "Post Timeline",
    // 	value: "viewTimeline",
    // 	// isPro: true
    // },
    // viewTicker: {
    // 	label: "Post Ticker",
    // 	value: "viewTicker",
    // 	// isPro: true
    // },
  };
  useEffect(() => {
    setisLoading(true);
    queryArgs.map(item => {
      var id = item.id;
      if (id == "paged") {
        item.val = pagination.currentPage;
      }
      if (id == "s") {
        item.val = searchPrams.search;
      }
    });
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default()({
      path: "/wcps/v2/post_list",
      method: "POST",
      data: {
        queryArgs: queryArgs,
        _wpnonce: wcps_builder_js._wpnonce
      }
    }).then(res => {
      setisLoading(false);
      if (res.posts == undefined) {
        setPosts([]);
        addNotifications({
          title: "No Items Found",
          content: "It seems there is no items in the list.",
          type: "success"
        });
      } else {
        setPosts(res.posts);
        addNotifications({
          title: "WCPS Loaded",
          content: "All WCPS loaded, Now click to pick one to edit.",
          type: "success"
        });
      }
    });
  }, [isLoaded, pagination.currentPage, searchPrams.search]);
  function create_post() {
    setisLoading(true);
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default()({
      path: "/wcps/v2/create_post",
      method: "POST",
      data: {
        postTitle: addNew.title,
        content: JSON.stringify(addNew.content)
      }
    }).then(res => {
      if (res.error) {
        addNotifications({
          title: "There is an Error!",
          content: res.errorMessage,
          type: "error"
        });
      }
      if (res.success) {
        var postsX = [...posts];
        postsX.unshift({
          ID: res.id,
          post_content: "",
          post_author: 0,
          post_title: addNew.title
        });
        setPosts(postsX);
        addNotifications({
          title: "WCPS Created! ",
          content: res.successMessage,
          type: "success"
        });
      }
      setisLoading(false);
      if (res.status) {}
      var addNewX = {
        ...addNew
      };
      addNewX.enable = !addNew.enable;
      setaddNew(addNewX);
    });
  }
  function update_post_title(newValue, postId) {
    setisLoading(true);
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default()({
      path: "/wcps/v2/update_post_title",
      method: "POST",
      data: {
        postTitle: newValue,
        postId: postId
      }
    }).then(res => {
      // console.log(res);

      if (res.error) {
        addNotifications({
          title: "There is an Error!",
          content: res.errorMessage,
          type: "error"
        });
      }
      if (res.success) {
        //var postsX = [...posts];

        //postsX.unshift({ ID: res.id, post_content: "", post_author: 0, post_title: searchPrams.search });

        //setPosts(postsX)

        addNotifications({
          title: "WCPS Title Updated!",
          content: res.successMessage,
          type: "success"
        });
      }
      setisLoading(false);
      if (res.status) {}
    });
  }
  function duplicate_post(postId) {
    setisLoading(true);
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default()({
      path: "/wcps/v2/duplicate_post",
      method: "POST",
      data: {
        postId: postId
      }
    }).then(res => {
      if (res.error) {
        addNotifications({
          title: "There is an Error!",
          content: res.errorMessage,
          type: "error"
        });
      }
      if (res.success) {
        var postsX = [...posts];
        postsX.unshift({
          ID: res.id,
          post_title: res.post_title
        });
        setPosts(postsX);
        addNotifications({
          title: "WCPS duplicated!",
          content: res.successMessage,
          type: "success"
        });
      }
      setisLoading(false);
      if (res.status) {}
    });
  }
  function delete_post(postId, index) {
    if (!deleteConfirm) {
      return;
    }
    setisLoading(true);
    _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2___default()({
      path: "/wcps/v2/delete_post",
      method: "POST",
      data: {
        postId: postId
      }
    }).then(res => {
      if (res.error) {
        addNotifications({
          title: "There is an Error!",
          content: res.errorMessage,
          type: "error"
        });
      }
      if (res.success) {
        var postsX = [...posts];
        postsX.splice(index, 1);
        setPosts(postsX);
        //posts.unshift({ ID: res.id, post_title: res.post_title });

        addNotifications({
          title: "WCPS deleted!",
          content: res.successMessage,
          type: "success"
        });
        setdeleteConfirm({
          id: "",
          confirm: false
        });
      }
      setisLoading(false);
      if (res.status) {}
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
    className: "",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
      className: "my-4 flex items-center gap-3",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_3__["default"], {
        value: searchPrams.search,
        placeholder: "Search.../Add New...",
        className: "!py-1 px-2 !border-2 !border-[#8c8f94] !border-solid w-[200px]",
        onChange: newVal => {
          var searchPramsX = {
            ...searchPrams
          };
          searchPramsX.search = newVal;
          setsearchPrams(searchPramsX);
          const timer = setTimeout(() => {
            // Update the debounced value after delay
          }, 3000); // 300ms debounce delay
          return () => clearTimeout(timer); // Cleanup timer on value change or unmount
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
        className: "flex items-center  gap-2 py-2 px-3 cursor-pointer  capitalize bg-gray-700 text-white font-medium rounded hover:bg-gray-600 focus:outline-none focus:bg-gray-600",
        onClick: ev => {
          var addNewX = {
            ...addNew
          };
          addNewX.enable = !addNew.enable;
          setaddNew(addNewX);
        },
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_10__["default"], {
          fill: "#fff",
          icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_11__["default"]
        })
      }), addNew.enable && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Popover, {
        position: "bottom right",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
          className: "p-2 flex flex-col gap-2 ",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_3__["default"], {
            value: addNew.title,
            placeholder: "Give a name",
            className: "!py-1 px-2 mb-3 !border-2 !border-[#8c8f94] !border-solid w-[200px]",
            onChange: newVal => {
              var addNewX = {
                ...addNew
              };
              addNewX.title = newVal;
              setaddNew(addNewX);
              const timer = setTimeout(() => {
                // Update the debounced value after delay
              }, 3000); // 300ms debounce delay
              return () => clearTimeout(timer); // Cleanup timer on value change or unmount
            }
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
            className: " ",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("label", {
                htmlFor: "",
                children: "View Type?"
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_dropdown__WEBPACK_IMPORTED_MODULE_4__["default"], {
                position: "bottom right",
                variant: "secondary",
                buttonTitle: addNew?.viewType ? viewTypeArgs[addNew?.viewType]?.label : "Choose",
                options: viewTypeArgs,
                onChange: (option, index) => {
                  var addNewX = {
                    ...addNew
                  };
                  addNewX.viewType = option.value;
                  if (option.value == "viewGrid") {
                    addNewX.content = _default_data_grid__WEBPACK_IMPORTED_MODULE_7__["default"];
                  }
                  if (option.value == "viewSlider") {
                    addNewX.content = _default_data_carousel__WEBPACK_IMPORTED_MODULE_5__["default"];
                  }
                  if (option.value == "viewFilterable") {
                    addNewX.content = _default_data_fliterable__WEBPACK_IMPORTED_MODULE_6__["default"];
                  }
                  if (option.value == "viewMasonry") {
                    addNewX.content = _default_data_masonry__WEBPACK_IMPORTED_MODULE_8__["default"];
                  }
                  setaddNew(addNewX);
                },
                values: ""
              })]
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
            className: "flex items-center  gap-2 py-2 px-3 cursor-pointer  capitalize bg-gray-700 text-white font-medium rounded hover:bg-gray-600 focus:outline-none focus:bg-gray-600",
            onClick: ev => {
              create_post();
            },
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_10__["default"], {
              fill: "#fff",
              icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_11__["default"]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("span", {
              children: "Create"
            })]
          })]
        })
      }), !isLoading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("span", {
        className: "cursor-pointer",
        title: "Click to know more",
        onClick: () => {
          setHelp({
            id: "createPostGrid",
            enable: true
          });
        },
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_10__["default"], {
          icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_12__["default"]
        })
      }), isLoading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Spinner, {})
      })]
    }), !isLoading && posts == null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
      className: "p-3 my-5 bg-orange-400 ",
      children: "No Items, Please Create First One!"
    }), posts != null && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
      children: posts.map((item, index) => {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
          className: "border-0 border-b border-solid border-[#ddd]",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
            className: "flex justify-between align-middle items-center p-3  hover:bg-slate-300 cursor-pointer",
            onClick: ev => {
              selectPostGrid(item.ID);
              addNotifications({
                title: "Ready to Edit",
                content: "Now go to Edit panel to customize WCPS.",
                type: "success"
              });
            },
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
              className: "flex  align-middle items-center gap-2  ",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
                className: "text-base mb-2",
                children: item.post_title
              })
            }), activePostGrid == item.ID && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("span", {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_10__["default"], {
                icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_13__["default"]
              })
            })]
          }, index), activePostGrid == item.ID && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
              className: " px-3 flex flex-wrap align-middle items-center text-xs gap-3 my-2",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
                className: "",
                children: ["#", item.ID]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
                className: "cursor-pointer flex items-center",
                onClick: ev => {
                  duplicate_post(item.ID);
                },
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_10__["default"], {
                  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_14__["default"],
                  size: "20"
                }), "Duplicate"]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
                className: "cursor-pointer text-red-700 flex items-center",
                title: "Delete Post",
                onClick: ev => {
                  setdeleteConfirm({
                    id: item.ID,
                    confirm: true
                  });
                  if (deleteConfirm.confirm) {
                    delete_post(item.ID, index);
                  }
                },
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_10__["default"], {
                  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_15__["default"],
                  size: "20"
                }), deleteConfirm.id == item.ID && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
                  children: deleteConfirm && "Confirm"
                }), deleteConfirm.id != item.ID && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
                  children: deleteConfirm && "Delete"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
                className: "cursor-pointer flex items-center",
                title: "Copy Shortcodes",
                onClick: () => {
                  var str = `[wcps_builder id="${item.ID}"]`;
                  copyData(str);
                },
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_10__["default"], {
                  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_14__["default"],
                  size: "20"
                }), " Shortcode"]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
                className: "cursor-pointer flex items-center",
                title: "Rename",
                onClick: () => {
                  if (rename.id.length == 0) {
                    setrename({
                      id: item.ID,
                      confirm: false
                    });
                  } else {
                    setrename({
                      id: "",
                      confirm: false
                    });
                  }
                },
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_10__["default"], {
                  icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_16__["default"],
                  size: "20"
                }), " Rename"]
              })]
            }), rename.id == item.ID && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
              className: "my-4 flex items-center justify-between gap-3",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_input_text__WEBPACK_IMPORTED_MODULE_3__["default"], {
                placeholder: item.post_title,
                value: item.post_title,
                className: " px-2 !rounded-none border !border-[#8c8f94] !border-solid w-full",
                onChange: newVal => {
                  var postsX = [...posts];
                  postsX[index].post_title = newVal;
                  setPosts(postsX);
                  const timer = setTimeout(() => {
                    // Update the debounced value after delay
                    update_post_title(newVal, item.ID);
                  }, 3000); // 300ms debounce delay
                  return () => clearTimeout(timer); // Cleanup timer on value change or unmount
                }
              })
            })]
          })]
        });
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
      className: "flex py-5 justify-between px-2",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
        className: "bg-slate-700 text-white px-5 py-2 rounded-sm cursor-pointer hover:bg-slate-600",
        onClick: ev => {
          if (pagination.currentPage > 1) {
            var currentPage = pagination.currentPage - 1;
            setPagination({
              currentPage: currentPage
            });
            setlistQueryPrams({
              ...listQueryPrams,
              page: currentPage
            });
          }
        },
        children: "Prev"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
        className: "bg-slate-700 text-white px-5 py-2 rounded-sm cursor-pointer hover:bg-slate-600",
        onClick: ev => {
          var currentPage = pagination.currentPage + 1;
          setPagination({
            currentPage: currentPage
          });
          setlistQueryPrams({
            ...listQueryPrams,
            page: currentPage
          });
        },
        children: "Next"
      })]
    })]
  });
}
class PostGridList extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showWarning: true,
      isLoaded: false
    };
    this.handleToggleClick = this.handleToggleClick.bind(this);
  }
  componentDidMount() {
    setTimeout(() => {
      this.setState(state => ({
        isLoaded: !state.isLoaded
      }));
    }, 1000);
  }
  handleToggleClick() {
    this.setState(state => ({
      showWarning: !state.showWarning
    }));
  }
  render() {
    var {
      selectPostGrid,
      activePostGrid,
      setHelp,
      listQueryPrams,
      setlistQueryPrams,
      addNotifications
    } = this.props;
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(Html, {
      selectPostGrid: selectPostGrid,
      activePostGrid: activePostGrid,
      warn: this.state.showWarning,
      isLoaded: this.state.isLoaded,
      setHelp: setHelp,
      listQueryPrams: listQueryPrams,
      setlistQueryPrams: setlistQueryPrams,
      addNotifications: addNotifications
    });
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PostGridList);

/***/ }),

/***/ "./src/components/LayoutGenerator/TreeView.jsx":
/*!*****************************************************!*\
  !*** ./src/components/LayoutGenerator/TreeView.jsx ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/@wordpress/icons/build-module/library/pages.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-sortablejs */ "./node_modules/react-sortablejs/dist/index.js");
/* harmony import */ var react_sortablejs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_sortablejs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _elements__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./elements */ "./src/components/LayoutGenerator/elements.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);





const sortableOptions = {
  animation: 150,
  fallbackOnBody: true,
  swapThreshold: 0.65,
  ghostClass: "ghost",
  group: "shared",
  filter: ".no-drag",
  preventOnFilter: false
};
const TreeView = ({
  blocks,
  setBlocks,
  selected,
  setSelected
}) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "flex items-center justify-between bg-slate-400 px-3 py-2",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "text-[20px] font-bold",
        children: "Tree View"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
        className: "hover:bg-red-500 bg-slate-700 text-white px-5 py-2 rounded-sm cursor-pointer ",
        onClick: () => setBlocks([{
          id: 1,
          type: "root",
          children: [],
          parent_id: null,
          styles: {}
        }]),
        children: "Remove All  "
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "p-2",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_sortablejs__WEBPACK_IMPORTED_MODULE_1__.ReactSortable, {
        list: blocks,
        setList: setBlocks,
        ...sortableOptions,
        children: blocks.map((block, blockIndex) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(BlockWrapper, {
          block: block,
          blockIndex: [blockIndex],
          setBlocks: setBlocks,
          selected: selected,
          setSelected: setSelected
        }, block.id))
      })
    })]
  });
};
function Container({
  block,
  blockIndex,
  setBlocks,
  selected,
  setSelected
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(react_sortablejs__WEBPACK_IMPORTED_MODULE_1__.ReactSortable, {
      list: block.children,
      setList: currentList => {
        setBlocks(sourceList => {
          const tempList = [...sourceList];
          const _blockIndex = [...blockIndex];
          const lastIndex = _blockIndex.pop();
          const lastArr = _blockIndex.reduce((arr, i) => arr[i]["children"], tempList);
          lastArr[lastIndex]["children"] = currentList;
          return tempList;
        });
      },
      ...sortableOptions,
      children: block.children && block.children.map((childBlock, index) => {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(BlockWrapper, {
          block: childBlock,
          blockIndex: [...blockIndex, index],
          setBlocks: setBlocks,
          selected: selected,
          setSelected: setSelected
        }, childBlock.id);
      })
    }, block.id)
  });
}
function BlockWrapper({
  block,
  blockIndex,
  setBlocks,
  selected,
  setSelected
}) {
  if (!block) return null;
  const handleRemove = () => {
    if (block.type == "root") {
      return;
    }
    setBlocks(prev => {
      const updatedBlocks = [...prev];
      removeNestedBlock(updatedBlocks, blockIndex);
      return updatedBlocks;
    });
  };
  const handleDuplicate = () => {
    setBlocks(prev => {
      const updatedBlocks = [...prev];
      const duplicateBlock = block => {
        // Create a deep clone of the block with a new ID
        const newBlock = {
          ...block,
          id: Math.random(),
          // Ensure a unique ID
          children: block.children ? block.children.map(duplicateBlock) : [] // Recursively duplicate children
        };
        return newBlock;
      };
      const parentBlock = getNestedBlock(updatedBlocks, blockIndex.slice(0, -1));
      const newBlock = duplicateBlock(block);
      if (blockIndex.length === 1) {
        // If the block is at the root level
        updatedBlocks.splice(blockIndex[0] + 1, 0, newBlock);
      } else {
        // If the block is nested
        parentBlock.children.splice(blockIndex[blockIndex.length - 1] + 1, 0, newBlock);
      }
      return updatedBlocks;
    });
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: `block ${block.type == "root" ? "no-drag " : ""} ${block.type == "container" || block.type == "layer" ? "border-0 border-l border-solid" : ""} relative my-2 pl-2`,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: `flex items-center  border border-solid px-2 py-1 cursor-pointer hover:bg-gray-300 ${block.id == selected ? "bg-gray-300" : ""} `,
      onClick: () => {
        setSelected(block.id);
      },
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
        className: "flex-1 overflow-hidden truncate text-md",
        children: _elements__WEBPACK_IMPORTED_MODULE_2__["default"][block.type] != undefined ? _elements__WEBPACK_IMPORTED_MODULE_2__["default"][block.type]?.label : block.type
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
        className: "flex items-center gap-2",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
          className: "size-6 bg-red-500 flex items-center justify-center cursor-pointer",
          onClick: handleRemove,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_4__["default"], {
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__["default"],
            fill: "#fff",
            size: 18
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
          className: "size-6 bg-blue-500 flex items-center justify-center cursor-pointer",
          onClick: handleDuplicate,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_4__["default"], {
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__["default"],
            fill: "#fff",
            size: 18
          })
        })]
      })]
    }), ["root", "container", 'layer'].includes(block.type) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Container, {
      block: block,
      setBlocks: setBlocks,
      blockIndex: blockIndex,
      selected: selected,
      setSelected: setSelected
    })]
  });
}
function getNestedBlock(blocks, indices) {
  return indices.reduce((block, index) => block.children[index], {
    children: blocks
  });
}
function removeNestedBlock(blocks, indices) {
  if (indices.length === 1) {
    blocks.splice(indices[0], 1);
  } else {
    const parentBlock = getNestedBlock(blocks, indices.slice(0, -1));
    parentBlock.children.splice(indices[indices.length - 1], 1);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TreeView);

/***/ }),

/***/ "./src/components/LayoutGenerator/elements-options.js":
/*!************************************************************!*\
  !*** ./src/components/LayoutGenerator/elements-options.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/block-editor */ "@wordpress/block-editor");
/* harmony import */ var _wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _components_dropdown__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../components/dropdown */ "./src/components/dropdown/index.js");
/* harmony import */ var _components_icon_picker__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../components/icon-picker */ "./src/components/icon-picker/index.js");
/* harmony import */ var _components_radio_control__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../components/radio-control */ "./src/components/radio-control/index.js");
/* harmony import */ var _components_animate_on__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../components/animate-on */ "./src/components/animate-on/index.js");
/* harmony import */ var _postMetaPrams__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./postMetaPrams */ "./src/components/LayoutGenerator/postMetaPrams.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__);
const {
  Component
} = wp.element;












const ALLOWED_MEDIA_TYPES = ["image"];
var thumbnailSizeArgs = {
  full: {
    label: "Full",
    value: "full",
    height: "",
    width: "",
    crop: false
  },
  thumbnail: {
    label: "thumbnail(150*150)",
    value: "thumbnail",
    height: 150,
    width: 150
  },
  medium: {
    label: "medium(300*300)",
    value: "medium",
    height: 300,
    width: 300
  },
  medium_large: {
    label: "medium large(768*0)",
    value: "medium_large",
    height: 0,
    width: 768
  },
  large: {
    label: "large(1024*1024)",
    value: "large",
    height: 1024,
    width: 1024
  },
  "1536x1536": {
    label: "1536x1536(1536*1536)",
    value: "1536x1536",
    height: 1536,
    width: 1536
  },
  "2048x2048": {
    label: "2048x2048(2048*2048)",
    value: "2048x2048",
    height: 2048,
    width: 2048
  },
  woocommerce_archive_thumbnail: {
    label: "woocommerce archive thumbnail(500*500)",
    value: "woocommerce_archive_thumbnail",
    height: 500,
    width: 500
  },
  woocommerce_thumbnail: {
    label: "woocommerce thumbnail(300*300)",
    value: "woocommerce_thumbnail",
    height: 300,
    width: 300
  },
  woocommerce_single: {
    label: "woocommerce single(600*0)",
    value: "woocommerce_single",
    height: 0,
    width: 600
  },
  woocommerce_gallery_thumbnail: {
    label: "woocommerce gallery thumbnail(100*100)",
    value: "woocommerce_gallery_thumbnail",
    height: 100,
    width: 100
  }
};
var LinkToArgs = {
  none: {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider"),
    value: ""
  },
  postUrl: {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Post URL", "woocommerce-products-slider"),
    value: "postUrl"
  },
  homeUrl: {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Home URL", "woocommerce-products-slider"),
    value: "homeUrl"
  },
  authorUrl: {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Author URL", "woocommerce-products-slider"),
    value: "authorUrl"
  },
  authorLink: {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Author Link", "woocommerce-products-slider"),
    value: "authorLink"
  },
  authorMail: {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Author Mail", "woocommerce-products-slider"),
    value: "authorMail",
    isPro: true
  },
  authorMeta: {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Author Meta", "woocommerce-products-slider"),
    value: "authorMeta",
    isPro: true
  },
  customField: {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Custom Field", "woocommerce-products-slider"),
    value: "customField",
    isPro: true
  },
  customUrl: {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Custom URL", "woocommerce-products-slider"),
    value: "customUrl",
    isPro: true
  }
};
var linkTargetArgs = {
  _self: {
    label: "_self",
    value: "_self"
  },
  _blank: {
    label: "_blank",
    value: "_blank"
  },
  _parent: {
    label: "_parent",
    value: "_parent"
  },
  _top: {
    label: "_top",
    value: "_top"
  }
};
var limitByArgs = {
  words: {
    label: "words",
    value: "words"
  },
  characters: {
    label: "characters",
    value: "characters"
  }
};
var dateFormats = {
  "Y-M-d": {
    label: "2022-Feb-25",
    value: "Y-M-d"
  },
  "Y-m-d": {
    label: "2022-05-25",
    value: "Y-m-d"
  },
  "d-m-y": {
    label: "25-05-2022",
    value: "d-m-y"
  },
  "d/m/y": {
    label: "25/05/2022",
    value: "d/m/y"
  },
  "y-m-d": {
    label: "2022-05-25",
    value: "y-m-d"
  },
  "y/m/d": {
    label: "2022/05/25",
    value: "y/m/d"
  },
  "D M y": {
    label: "Sun Feb 2022",
    value: "D M y"
  },
  "D M d, y": {
    label: "Sun Feb 11, 2022",
    value: "D M d, y"
  },
  "M D d, y": {
    label: "Feb Sun 11, 2022",
    value: "M D d, y"
  },
  "M d, y": {
    label: "Feb 11, 2022",
    value: "M d, y"
  },
  "F d, y": {
    label: "February 11, 2022",
    value: "F d, y"
  },
  "d M y": {
    label: "25 Feb 2022",
    value: "d M y"
  }
};
var numberFormats = {
  "decimal": {
    label: "Decimal",
    value: "decimal"
  },
  "wordForm": {
    label: "Word Form",
    value: "wordForm"
  },
  "scientificNotation": {
    label: "Scientific Notation",
    value: "scientificNotation"
  },
  "binaryBase2": {
    label: "Binary (Base 2)",
    value: "binaryBase2"
  },
  "octalBase8": {
    label: "Octal (Base 8)",
    value: "octalBase8"
  },
  "hexadecimalBase16": {
    label: "2022/05/25",
    value: "hexadecimalBase16"
  },
  "roman": {
    label: "Roman",
    value: "roman"
  },
  "engineeringNotation": {
    label: "Engineering Notation",
    value: "engineeringNotation"
  },
  "compactNumber": {
    label: "Feb Sun 11, 2022",
    value: "compactNumber"
  }
};
var tagsPrams = {
  "ul": {
    label: "UL",
    value: "ul"
  },
  "li": {
    label: "LI",
    value: "li"
  },
  "div": {
    label: "DIV",
    value: "div"
  },
  "span": {
    label: "SPAN",
    value: "span"
  },
  "p": {
    label: "P",
    value: "p"
  },
  "h1": {
    label: "H1",
    value: "h1"
  },
  "h2": {
    label: "H2",
    value: "h2"
  },
  "h3": {
    label: "H3",
    value: "h3"
  },
  "h4": {
    label: "H4",
    value: "h4"
  },
  "h5": {
    label: "H5",
    value: "h5"
  },
  "h6": {
    label: "H6",
    value: "h6"
  }
};
var customFieldSrcPrams = {
  "acf": {
    label: "ACF",
    value: "acf"
  },
  "none": {
    label: "Default",
    value: ""
  }
};

/*postTitle*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementOptionspostTitle', 'wcps/element', PostGridElementOptionspostTitle, 10);
function PostGridElementOptionspostTitle(html, selectedElement, handleChange) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Class", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.class,
        onChange: newVal => {
          handleChange("class", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Link To", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"], {
        position: "bottom right",
        options: LinkToArgs,
        buttonTitle: selectedElement?.options?.linkTo == undefined || selectedElement?.options?.linkTo.length == 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : LinkToArgs[selectedElement?.options?.linkTo] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : LinkToArgs[selectedElement?.options?.linkTo].label,
        onChange: option => {
          handleChange("linkTo", option.value);
        },
        values: []
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Link Target", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"], {
        position: "bottom right",
        options: linkTargetArgs,
        buttonTitle: selectedElement?.options?.target == undefined || selectedElement?.options?.target.length == 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : linkTargetArgs[selectedElement?.options?.target] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : linkTargetArgs[selectedElement?.options?.target].label,
        onChange: option => {
          handleChange("target", option.value);
        },
        values: []
      })]
    })]
  });
}

/*postThumbnail*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementOptionspostThumbnail', 'wcps/element', PostGridElementOptionspostThumbnail, 10);
function PostGridElementOptionspostThumbnail(html, selectedElement, handleChange) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Class", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.class,
        onChange: newVal => {
          handleChange("class", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Link To", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"], {
        position: "bottom right",
        options: LinkToArgs,
        buttonTitle: selectedElement?.options?.linkTo == undefined || selectedElement?.options?.linkTo.length == 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : LinkToArgs[selectedElement?.options?.linkTo] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : LinkToArgs[selectedElement?.options?.linkTo].label,
        onChange: option => {
          handleChange("linkTo", option.value);
        },
        values: []
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Link Target", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"], {
        position: "bottom right",
        options: linkTargetArgs,
        buttonTitle: selectedElement?.options?.target == undefined || selectedElement?.options?.target.length == 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : linkTargetArgs[selectedElement?.options?.target] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : linkTargetArgs[selectedElement?.options?.target].label,
        onChange: option => {
          handleChange("target", option.value);
        },
        values: []
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Thumbnail Size", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"], {
        position: "bottom right",
        options: thumbnailSizeArgs,
        buttonTitle: selectedElement?.options?.size == undefined || selectedElement?.options?.size.length == 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : thumbnailSizeArgs[selectedElement?.options?.size] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : thumbnailSizeArgs[selectedElement?.options?.size].label,
        onChange: option => {
          handleChange("size", option.value);
        },
        values: []
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Default Thumbnail", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_block_editor__WEBPACK_IMPORTED_MODULE_3__.MediaUpload, {
          className: "bg-gray-700 hover:bg-gray-600",
          onSelect: media => {
            // media.id

            handleChange("defaultSrcId", media.id);
            handleChange("defaultSrcUrl", media.url);
          },
          onClose: () => {},
          allowedTypes: ALLOWED_MEDIA_TYPES,
          value: selectedElement.options.defaultSrcId,
          render: ({
            open
          }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
            className: "flex w-full justify-center items-center bg-gray-300/30 min-h-[200px] rounded-md border border-solid border-slate-400 hover:border-black transition-all duration-300 ease-in-out cursor-pointer mt-2 ",
            onClick: open,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("img", {
              // src={MyLazy}
              src: selectedElement.options.defaultSrcUrl,
              alt: "",
              className: " "
            })
          })
        })
      })]
    })]
  });
}

/*postExcerpt*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementOptionspostExcerpt', 'wcps/element', PostGridElementOptionspostExcerpt, 10);
function PostGridElementOptionspostExcerpt(html, selectedElement, handleChange) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Class", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.class,
        onChange: newVal => {
          handleChange("class", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Limit By", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"], {
        position: "bottom right",
        options: limitByArgs,
        buttonTitle: selectedElement?.options?.limitBy == undefined || selectedElement?.options?.limitBy.length == 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : limitByArgs[selectedElement?.options?.limitBy] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : limitByArgs[selectedElement?.options?.limitBy].label,
        onChange: option => {
          handleChange("limitBy", option.value);
        },
        values: []
      })]
    }), selectedElement?.options?.limitBy.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Limit Count", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.limitCount,
        onChange: newVal => {
          handleChange("limitCount", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Read More Text", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.readMoreText,
        onChange: newVal => {
          handleChange("readMoreText", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Link Target", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"], {
        position: "bottom right",
        options: linkTargetArgs,
        buttonTitle: selectedElement?.options?.target == undefined || selectedElement?.options?.target.length == 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : linkTargetArgs[selectedElement?.options?.target] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : linkTargetArgs[selectedElement?.options?.target].label,
        onChange: option => {
          handleChange("target", option.value);
        },
        values: []
      })]
    })]
  });
}

/*readMore*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementOptionsreadMore', 'wcps/element', PostGridElementOptionsreadMore, 10);
function PostGridElementOptionsreadMore(html, selectedElement, handleChange) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Class", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.class,
        onChange: newVal => {
          handleChange("class", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Read More Text", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.readMoreText,
        onChange: newVal => {
          handleChange("readMoreText", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Link Target", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"], {
        position: "bottom right",
        options: linkTargetArgs,
        buttonTitle: selectedElement?.options?.target == undefined || selectedElement?.options?.target.length == 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : linkTargetArgs[selectedElement?.options?.target] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : linkTargetArgs[selectedElement?.options?.target].label,
        onChange: option => {
          handleChange("target", option.value);
        },
        values: []
      })]
    })]
  });
}

/*customText*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementOptionscustomText', 'wcps/element', PostGridElementOptionscustomText, 10);
function PostGridElementOptionscustomText(html, selectedElement, handleChange) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Class", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.class,
        onChange: newVal => {
          handleChange("class", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Wrapper Tag", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.SelectControl, {
        label: "",
        value: selectedElement.options.customTag,
        options: [{
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider"),
          value: ""
        }, {
          label: "a",
          value: "a"
        }, {
          label: "H1",
          value: "h1"
        }, {
          label: "H2",
          value: "h2"
        }, {
          label: "H3",
          value: "h3"
        }, {
          label: "H4",
          value: "h4"
        }, {
          label: "H5",
          value: "h5"
        }, {
          label: "H6",
          value: "h6"
        }, {
          label: "SPAN",
          value: "span"
        }, {
          label: "DIV",
          value: "div"
        }, {
          label: "P",
          value: "p"
        }],
        onChange: newVal => {
          handleChange("customTag", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Custom Text", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.content,
        onChange: newVal => {
          handleChange("content", newVal);
        }
      })]
    })]
  });
}

/*container*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementOptionscontainer', 'wcps/element', PostGridElementOptionscontainer, 10);
function PostGridElementOptionscontainer(html, selectedElement, handleChange) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Class", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.class,
        onChange: newVal => {
          handleChange("class", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Animate On", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_components_animate_on__WEBPACK_IMPORTED_MODULE_8__["default"], {
        animateOn: selectedElement.options?.animateOn,
        onChange: prams => {
          handleChange("animateOn", prams);

          //setAttributes({ animateOn: prams });
        }
      })]
    })]
  });
}

/*layer*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementOptionslayer', 'wcps/element', PostGridElementOptionslayer, 10);
function PostGridElementOptionslayer(html, selectedElement, handleChange) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Class", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.class,
        onChange: newVal => {
          handleChange("class", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Animate On", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_components_animate_on__WEBPACK_IMPORTED_MODULE_8__["default"], {
        animateOn: selectedElement.options?.animateOn,
        onChange: prams => {
          handleChange("animateOn", prams);

          //setAttributes({ animateOn: prams });
        }
      })]
    })]
  });
}

/*postDate*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementOptionspostDate', 'wcps/element', PostGridElementOptionspostDate, 10);
function PostGridElementOptionspostDate(html, selectedElement, handleChange) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Class", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.class,
        onChange: newVal => {
          handleChange("class", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      className: "mb-4",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Date Format", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"], {
        position: "bottom right",
        variant: "secondary",
        options: dateFormats
        // buttonTitle="Choose"
        ,
        buttonTitle: dateFormats[selectedElement.options.format] != undefined ? dateFormats[selectedElement.options.format].label : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider"),
        onChange: option => {
          handleChange("format", option.value);
        },
        values: ""
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      className: "mb-4",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Custom Format", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        className: "mr-2",
        value: selectedElement.options.format,
        onChange: newVal => {
          handleChange("format", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Prefix Text", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.prefixText,
        onChange: newVal => {
          handleChange("prefixText", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Postfix Text", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.postfixText,
        onChange: newVal => {
          handleChange("postfixText", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Link To", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"], {
        position: "bottom right",
        options: LinkToArgs,
        buttonTitle: selectedElement?.options?.linkTo == undefined || selectedElement?.options?.linkTo.length == 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : LinkToArgs[selectedElement?.options?.linkTo] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : LinkToArgs[selectedElement?.options?.linkTo].label,
        onChange: option => {
          handleChange("linkTo", option.value);
        },
        values: []
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Link Target", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"], {
        position: "bottom right",
        options: linkTargetArgs,
        buttonTitle: selectedElement?.options?.target == undefined || selectedElement?.options?.target.length == 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : linkTargetArgs[selectedElement?.options?.target] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : linkTargetArgs[selectedElement?.options?.target].label,
        onChange: option => {
          handleChange("target", option.value);
        },
        values: []
      })]
    })]
  });
}

/*postAuthor*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementOptionspostAuthor', 'wcps/element', PostGridElementOptionspostAuthor, 10);
function PostGridElementOptionspostAuthor(html, selectedElement, handleChange) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Class", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.class,
        onChange: newVal => {
          handleChange("class", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Prefix Text", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.prefixText,
        onChange: newVal => {
          handleChange("prefixText", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Postfix Text", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.postfixText,
        onChange: newVal => {
          handleChange("postfixText", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Link To", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"], {
        position: "bottom right",
        options: LinkToArgs,
        buttonTitle: selectedElement?.options?.linkTo == undefined || selectedElement?.options?.linkTo.length == 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : LinkToArgs[selectedElement?.options?.linkTo] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : LinkToArgs[selectedElement?.options?.linkTo].label,
        onChange: option => {
          handleChange("linkTo", option.value);
        },
        values: []
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Link Target", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"], {
        position: "bottom right",
        options: linkTargetArgs,
        buttonTitle: selectedElement?.options?.target == undefined || selectedElement?.options?.target.length == 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : linkTargetArgs[selectedElement?.options?.target] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : linkTargetArgs[selectedElement?.options?.target].label,
        onChange: option => {
          handleChange("target", option.value);
        },
        values: []
      })]
    })]
  });
}

/*postAuthorAvatar*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementOptionspostAuthorAvatar', 'wcps/element', PostGridElementOptionspostAuthorAvatar, 10);
function PostGridElementOptionspostAuthorAvatar(html, selectedElement, handleChange) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Class", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.class,
        onChange: newVal => {
          handleChange("class", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Prefix Text", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.prefixText,
        onChange: newVal => {
          handleChange("prefixText", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Postfix Text", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.postfixText,
        onChange: newVal => {
          handleChange("postfixText", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Link To", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"], {
        position: "bottom right",
        options: LinkToArgs,
        buttonTitle: selectedElement?.options?.linkTo == undefined || selectedElement?.options?.linkTo.length == 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : LinkToArgs[selectedElement?.options?.linkTo] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : LinkToArgs[selectedElement?.options?.linkTo].label,
        onChange: option => {
          handleChange("linkTo", option.value);
        },
        values: []
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Link Target", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"], {
        position: "bottom right",
        options: linkTargetArgs,
        buttonTitle: selectedElement?.options?.target == undefined || selectedElement?.options?.target.length == 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : linkTargetArgs[selectedElement?.options?.target] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : linkTargetArgs[selectedElement?.options?.target].label,
        onChange: option => {
          handleChange("target", option.value);
        },
        values: []
      })]
    })]
  });
}

/*postCategories*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementOptionspostCategories', 'wcps/element', PostGridElementOptionspostCategories, 10);
function PostGridElementOptionspostCategories(html, selectedElement, handleChange) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Class", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.class,
        onChange: newVal => {
          handleChange("class", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Max Count", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.maxCount,
        onChange: newVal => {
          handleChange("maxCount", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Separator", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.separator,
        onChange: newVal => {
          handleChange("separator", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
      className: "gap-2 justify-between items-center flex",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
        className: "font-medium text-slate-900",
        children: "Enable Post Count?"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.ToggleControl, {
        className: "flex items-center gap-2 py-2",
        help: selectedElement?.options?.postCount ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Enabled", "woocommerce-products-slider") : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Disabled.", "woocommerce-products-slider"),
        checked: selectedElement?.options?.postCount ? true : false,
        onChange: newVal => {
          handleChange("postCount", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Prefix Text", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.prefixText,
        onChange: newVal => {
          handleChange("prefixText", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Postfix Text", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.postfixText,
        onChange: newVal => {
          handleChange("postfixText", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Link To", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"], {
        position: "bottom right",
        options: LinkToArgs,
        buttonTitle: selectedElement?.options?.linkTo == undefined || selectedElement?.options?.linkTo.length == 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : LinkToArgs[selectedElement?.options?.linkTo] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : LinkToArgs[selectedElement?.options?.linkTo].label,
        onChange: option => {
          handleChange("linkTo", option.value);
        },
        values: []
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Link Target", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_components_dropdown__WEBPACK_IMPORTED_MODULE_5__["default"], {
        position: "bottom right",
        options: linkTargetArgs,
        buttonTitle: selectedElement?.options?.target == undefined || selectedElement?.options?.target.length == 0 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : linkTargetArgs[selectedElement?.options?.target] == undefined ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Choose", "woocommerce-products-slider") : linkTargetArgs[selectedElement?.options?.target].label,
        onChange: option => {
          handleChange("target", option.value);
        },
        values: []
      })]
    })]
  });
}

/*postTags*/
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_2__.addFilter)('PostGridElementOptionspostTags', 'wcps/element', PostGridElementOptionspostTags, 10);
function PostGridElementOptionspostTags(html, selectedElement, handleChange) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Class", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.class,
        onChange: newVal => {
          handleChange("class", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Max Count", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.maxCount,
        onChange: newVal => {
          handleChange("maxCount", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.PanelRow, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("label", {
        htmlFor: "",
        className: "font-medium text-slate-900 ",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)("Separator", "woocommerce-products-slider")
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__.__experimentalInputControl, {
        value: selectedElement?.options?.separator,
        onChange: newVal => {
          handleChange("separator", newVal);
        }
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
      